/*
 * Decompiled with CFR 0.152.
 */
package org.fest.assertions.api.android.view;

import android.view.KeyCharacterMap;
import org.fest.assertions.api.AbstractAssert;
import org.fest.assertions.api.Assertions;
import org.fest.assertions.api.IntegerAssert;

public class KeyCharacterMapAssert
extends AbstractAssert<KeyCharacterMapAssert, KeyCharacterMap> {
    public KeyCharacterMapAssert(KeyCharacterMap actual) {
        super((Object)actual, KeyCharacterMapAssert.class);
    }

    public KeyCharacterMapAssert hasKeyboardType(int type) {
        this.isNotNull();
        int actualType = ((KeyCharacterMap)this.actual).getKeyboardType();
        ((IntegerAssert)Assertions.assertThat((int)actualType).overridingErrorMessage("Expected keyboard type <%s> but was <%s>.", new Object[]{KeyCharacterMapAssert.keyboardTypeToString(type), KeyCharacterMapAssert.keyboardTypeToString(actualType)})).isEqualTo(type);
        return this;
    }

    public KeyCharacterMapAssert hasModifierBehavior(int value) {
        this.isNotNull();
        int actualValue = ((KeyCharacterMap)this.actual).getModifierBehavior();
        ((IntegerAssert)Assertions.assertThat((int)actualValue).overridingErrorMessage("Expected modifier behavior <%s> but was <%s>.", new Object[]{value, actualValue})).isEqualTo(value);
        return this;
    }

    private static String keyboardTypeToString(int type) {
        switch (type) {
            case 1: {
                return "numeric";
            }
            case 2: {
                return "predictive";
            }
            case 3: {
                return "alpha";
            }
            case 4: {
                return "full";
            }
            case 5: {
                return "specialFunction";
            }
        }
        throw new IllegalArgumentException("Unknown keyboard type: " + type);
    }
}

