/*
 * Decompiled with CFR 0.152.
 */
package org.fest.assertions.api.android.view.accessibility;

import android.view.accessibility.AccessibilityEvent;
import org.fest.assertions.api.Assertions;
import org.fest.assertions.api.IntegerAssert;
import org.fest.assertions.api.LongAssert;
import org.fest.assertions.api.ObjectAssert;
import org.fest.assertions.api.android.view.accessibility.AbstractAccessibilityRecordAssert;

public class AccessibilityEventAssert
extends AbstractAccessibilityRecordAssert<AccessibilityEventAssert, AccessibilityEvent> {
    public AccessibilityEventAssert(AccessibilityEvent actual) {
        super(actual, AccessibilityEventAssert.class);
    }

    public AccessibilityEventAssert hasAction(int action) {
        this.isNotNull();
        int actualAction = ((AccessibilityEvent)this.actual).getAction();
        ((IntegerAssert)Assertions.assertThat((int)actualAction).overridingErrorMessage("Expected action <%s> but was <%s>.", new Object[]{action, actualAction})).isEqualTo(action);
        return this;
    }

    public AccessibilityEventAssert hasEventTime(long time) {
        this.isNotNull();
        long actualTime = ((AccessibilityEvent)this.actual).getEventTime();
        ((LongAssert)Assertions.assertThat((long)actualTime).overridingErrorMessage("Expected event time <%s> but was <%s>.", new Object[]{time, actualTime})).isEqualTo(time);
        return this;
    }

    public AccessibilityEventAssert hasEventType(int type) {
        this.isNotNull();
        int actualType = ((AccessibilityEvent)this.actual).getEventType();
        ((IntegerAssert)Assertions.assertThat((int)actualType).overridingErrorMessage("Expected event type <%s> but was <%s>.", new Object[]{type, actualType})).isEqualTo(type);
        return this;
    }

    public AccessibilityEventAssert hasMovementGranularity(int granularity) {
        this.isNotNull();
        int actualGranularity = ((AccessibilityEvent)this.actual).getMovementGranularity();
        ((IntegerAssert)Assertions.assertThat((int)actualGranularity).overridingErrorMessage("Expected movement granularity <%s> but was <%s>.", new Object[]{granularity, actualGranularity})).isEqualTo(granularity);
        return this;
    }

    public AccessibilityEventAssert hasPackageName(CharSequence name) {
        this.isNotNull();
        CharSequence actualName = ((AccessibilityEvent)this.actual).getPackageName();
        ((ObjectAssert)Assertions.assertThat((Object)actualName).overridingErrorMessage("Expected package name <%s> but was <%s>.", new Object[]{name, actualName})).isEqualTo((Object)name);
        return this;
    }
}

