/*
 * Decompiled with CFR 0.152.
 */
package org.fest.assertions.api.android.animation;

import android.animation.Animator;
import java.util.List;
import org.fest.assertions.api.AbstractAssert;
import org.fest.assertions.api.Assertions;
import org.fest.assertions.api.BooleanAssert;
import org.fest.assertions.api.ListAssert;
import org.fest.assertions.api.LongAssert;

public abstract class AbstractAnimatorAssert<S extends AbstractAnimatorAssert<S, A>, A extends Animator>
extends AbstractAssert<S, A> {
    protected AbstractAnimatorAssert(A actual, Class<S> selfType) {
        super(actual, selfType);
    }

    public S hasDuration(long duration) {
        this.isNotNull();
        long actualDuration = ((Animator)this.actual).getDuration();
        ((LongAssert)Assertions.assertThat((long)actualDuration).overridingErrorMessage("Expected duration <%s> but was <%s>.", new Object[]{duration, actualDuration})).isEqualTo(duration);
        return (S)((Object)((AbstractAnimatorAssert)this.myself));
    }

    public S hasListener(Animator.AnimatorListener listener) {
        this.isNotNull();
        ((ListAssert)Assertions.assertThat((List)((Animator)this.actual).getListeners()).overridingErrorMessage("Expected listener <%s> but was not present.", new Object[0])).contains((Object[])new Animator.AnimatorListener[]{listener});
        return (S)((Object)((AbstractAnimatorAssert)this.myself));
    }

    public S hasStartDelay(long delay) {
        this.isNotNull();
        long actualDelay = ((Animator)this.actual).getStartDelay();
        ((LongAssert)Assertions.assertThat((long)actualDelay).overridingErrorMessage("Expected start delay <%s> but was <%s>.", new Object[]{delay, actualDelay})).isEqualTo(delay);
        return (S)((Object)((AbstractAnimatorAssert)this.myself));
    }

    public S isRunning() {
        this.isNotNull();
        ((BooleanAssert)Assertions.assertThat((boolean)((Animator)this.actual).isRunning()).overridingErrorMessage("Expected to be running but was not.", new Object[0])).isTrue();
        return (S)((Object)((AbstractAnimatorAssert)this.myself));
    }

    public S isNotRunning() {
        this.isNotNull();
        ((BooleanAssert)Assertions.assertThat((boolean)((Animator)this.actual).isRunning()).overridingErrorMessage("Expected to not be running but was.", new Object[0])).isFalse();
        return (S)((Object)((AbstractAnimatorAssert)this.myself));
    }

    public S isStarted() {
        this.isNotNull();
        ((BooleanAssert)Assertions.assertThat((boolean)((Animator)this.actual).isStarted()).overridingErrorMessage("Expected to be started but was not.", new Object[0])).isTrue();
        return (S)((Object)((AbstractAnimatorAssert)this.myself));
    }

    public S isNotStarted() {
        this.isNotNull();
        ((BooleanAssert)Assertions.assertThat((boolean)((Animator)this.actual).isStarted()).overridingErrorMessage("Expected to not be started but was.", new Object[0])).isFalse();
        return (S)((Object)((AbstractAnimatorAssert)this.myself));
    }
}

