/*
 * Decompiled with CFR 0.152.
 */
package org.fest.assertions.api.android.graphics;

import android.graphics.Bitmap;
import org.fest.assertions.api.AbstractAssert;
import org.fest.assertions.api.Assertions;
import org.fest.assertions.api.BooleanAssert;
import org.fest.assertions.api.IntegerAssert;

public class BitmapAssert
extends AbstractAssert<BitmapAssert, Bitmap> {
    public BitmapAssert(Bitmap actual) {
        super((Object)actual, BitmapAssert.class);
    }

    public BitmapAssert isRecycled() {
        this.isNotNull();
        ((BooleanAssert)Assertions.assertThat((boolean)((Bitmap)this.actual).isRecycled()).overridingErrorMessage("Expected to be recycled but was not recycled.", new Object[0])).isTrue();
        return this;
    }

    public BitmapAssert isNotRecycled() {
        this.isNotNull();
        ((BooleanAssert)Assertions.assertThat((boolean)((Bitmap)this.actual).isRecycled()).overridingErrorMessage("Expected to not be recycled but was recycled.", new Object[0])).isFalse();
        return this;
    }

    public BitmapAssert isMutable() {
        this.isNotNull();
        ((BooleanAssert)Assertions.assertThat((boolean)((Bitmap)this.actual).isMutable()).overridingErrorMessage("Expected to be mutable but was not mutable.", new Object[0])).isTrue();
        return this;
    }

    public BitmapAssert isNotMutable() {
        this.isNotNull();
        ((BooleanAssert)Assertions.assertThat((boolean)((Bitmap)this.actual).isMutable()).overridingErrorMessage("Expected to not be mutable but was mutable.", new Object[0])).isFalse();
        return this;
    }

    public BitmapAssert hasByteCount(int count) {
        this.isNotNull();
        int actualCount = ((Bitmap)this.actual).getByteCount();
        ((IntegerAssert)Assertions.assertThat((int)actualCount).overridingErrorMessage("Expected byte count <%s> but was <%s>.", new Object[]{count, actualCount})).isEqualTo(count);
        return this;
    }

    public BitmapAssert hasDensity(int density) {
        this.isNotNull();
        int actualDensity = ((Bitmap)this.actual).getDensity();
        ((IntegerAssert)Assertions.assertThat((int)actualDensity).overridingErrorMessage("Expected density <%s> but was <%s>.", new Object[]{density, actualDensity})).isEqualTo(density);
        return this;
    }

    public BitmapAssert hasWidth(int width) {
        this.isNotNull();
        int actualWidth = ((Bitmap)this.actual).getWidth();
        ((IntegerAssert)Assertions.assertThat((int)actualWidth).overridingErrorMessage("Expected width <%s> but was <%s>.", new Object[]{width, actualWidth})).isEqualTo(width);
        return this;
    }

    public BitmapAssert hasHeight(int height) {
        this.isNotNull();
        int actualHeight = ((Bitmap)this.actual).getHeight();
        ((IntegerAssert)Assertions.assertThat((int)actualHeight).overridingErrorMessage("Expected height <%s> but was <%s>.", new Object[]{height, actualHeight})).isEqualTo(height);
        return this;
    }

    public BitmapAssert hasAlphaSupport() {
        this.isNotNull();
        ((BooleanAssert)Assertions.assertThat((boolean)((Bitmap)this.actual).hasAlpha()).overridingErrorMessage("Expected to have alpha support but did not have it.", new Object[0])).isTrue();
        return this;
    }

    public BitmapAssert hasNoAlphaSupport() {
        this.isNotNull();
        ((BooleanAssert)Assertions.assertThat((boolean)((Bitmap)this.actual).hasAlpha()).overridingErrorMessage("Expected to not have alpha support but had it.", new Object[0])).isFalse();
        return this;
    }
}

