/*
 * Decompiled with CFR 0.152.
 */
package org.fest.assertions.api.android.graphics;

import android.graphics.YuvImage;
import org.fest.assertions.api.AbstractAssert;
import org.fest.assertions.api.Assertions;
import org.fest.assertions.api.IntegerAssert;

public class YuvImageAssert
extends AbstractAssert<YuvImageAssert, YuvImage> {
    public YuvImageAssert(YuvImage actual) {
        super((Object)actual, YuvImageAssert.class);
    }

    public YuvImageAssert hasHeight(int height) {
        this.isNotNull();
        int actualHeight = ((YuvImage)this.actual).getHeight();
        ((IntegerAssert)Assertions.assertThat((int)actualHeight).overridingErrorMessage("Expected height <%s> but was <%s>.", new Object[]{height, actualHeight})).isEqualTo(height);
        return this;
    }

    public YuvImageAssert hasWidth(int width) {
        this.isNotNull();
        int actualWidth = ((YuvImage)this.actual).getWidth();
        ((IntegerAssert)Assertions.assertThat((int)actualWidth).overridingErrorMessage("Expected width <%s> but was <%s>.", new Object[]{width, actualWidth})).isEqualTo(width);
        return this;
    }

    public YuvImageAssert hasYuvFormat(int format) {
        this.isNotNull();
        int actualFormat = ((YuvImage)this.actual).getYuvFormat();
        ((IntegerAssert)Assertions.assertThat((int)actualFormat).overridingErrorMessage("Expected YUV format <%s> but was <%s>.", new Object[]{format, actualFormat})).isEqualTo(format);
        return this;
    }
}

