/*
 * Decompiled with CFR 0.152.
 */
package org.fest.assertions.api.android.graphics.drawable;

import android.graphics.Rect;
import android.graphics.drawable.Drawable;
import org.fest.assertions.api.AbstractAssert;
import org.fest.assertions.api.Assertions;
import org.fest.assertions.api.BooleanAssert;
import org.fest.assertions.api.IntegerAssert;
import org.fest.assertions.api.ObjectAssert;

public abstract class AbstractDrawableAssert<S extends AbstractDrawableAssert<S, A>, A extends Drawable>
extends AbstractAssert<S, A> {
    protected AbstractDrawableAssert(A actual, Class<S> selfType) {
        super(actual, selfType);
    }

    public S hasBounds(Rect bounds) {
        this.isNotNull();
        Rect actualBounds = ((Drawable)this.actual).getBounds();
        ((ObjectAssert)Assertions.assertThat((Object)actualBounds).overridingErrorMessage("Expected bounds <%s> but was <%s>.", new Object[]{bounds, actualBounds})).isEqualTo((Object)bounds);
        return (S)((Object)((AbstractDrawableAssert)this.myself));
    }

    public S hasCallback(Drawable.Callback callback) {
        this.isNotNull();
        Drawable.Callback actualCallback = ((Drawable)this.actual).getCallback();
        ((ObjectAssert)Assertions.assertThat((Object)actualCallback).overridingErrorMessage("Expected callback <%s> but was <%s>.", new Object[]{callback, actualCallback})).isSameAs((Object)callback);
        return (S)((Object)((AbstractDrawableAssert)this.myself));
    }

    public S hasChangingConfigurations(int mask) {
        this.isNotNull();
        int actualMask = ((Drawable)this.actual).getChangingConfigurations();
        ((IntegerAssert)Assertions.assertThat((int)actualMask).overridingErrorMessage("Expected changing configurations <%s> but was <%s>.", new Object[]{mask, actualMask})).isEqualTo(mask);
        return (S)((Object)((AbstractDrawableAssert)this.myself));
    }

    public S hasConstantState(Drawable.ConstantState state) {
        this.isNotNull();
        Drawable.ConstantState actualState = ((Drawable)this.actual).getConstantState();
        ((ObjectAssert)Assertions.assertThat((Object)actualState).overridingErrorMessage("Expected constant state <%s> but was <%s>.", new Object[]{state, actualState})).isEqualTo((Object)state);
        return (S)((Object)((AbstractDrawableAssert)this.myself));
    }

    public S hasIntrinsicHeight(int height) {
        this.isNotNull();
        int actualHeight = ((Drawable)this.actual).getIntrinsicHeight();
        ((IntegerAssert)Assertions.assertThat((int)actualHeight).overridingErrorMessage("Expected intrinsic height <%s> but was <%s>.", new Object[]{height, actualHeight})).isEqualTo(height);
        return (S)((Object)((AbstractDrawableAssert)this.myself));
    }

    public S hasIntrinsicWidth(int width) {
        this.isNotNull();
        int actualWidth = ((Drawable)this.actual).getIntrinsicWidth();
        ((IntegerAssert)Assertions.assertThat((int)actualWidth).overridingErrorMessage("Expected intrinsic width <%s> but was <%s>.", new Object[]{width, actualWidth})).isEqualTo(width);
        return (S)((Object)((AbstractDrawableAssert)this.myself));
    }

    public S hasLevel(int level) {
        this.isNotNull();
        int actualLevel = ((Drawable)this.actual).getLevel();
        ((IntegerAssert)Assertions.assertThat((int)actualLevel).overridingErrorMessage("Expected level <%s> but was <%s>.", new Object[]{level, actualLevel})).isEqualTo(level);
        return (S)((Object)((AbstractDrawableAssert)this.myself));
    }

    public S hasMinimumHeight(int height) {
        this.isNotNull();
        int actualHeight = ((Drawable)this.actual).getMinimumHeight();
        ((IntegerAssert)Assertions.assertThat((int)actualHeight).overridingErrorMessage("Expected minimum height <%s> but was <%s>.", new Object[]{height, actualHeight})).isEqualTo(height);
        return (S)((Object)((AbstractDrawableAssert)this.myself));
    }

    public S hasMinimumWidth(int width) {
        this.isNotNull();
        int actualHeight = ((Drawable)this.actual).getMinimumWidth();
        ((IntegerAssert)Assertions.assertThat((int)actualHeight).overridingErrorMessage("Expected minimum width <%s> but was <%s>.", new Object[]{width, actualHeight})).isEqualTo(width);
        return (S)((Object)((AbstractDrawableAssert)this.myself));
    }

    public S hasOpacity(int opacity) {
        this.isNotNull();
        int actualOpacity = ((Drawable)this.actual).getOpacity();
        ((IntegerAssert)Assertions.assertThat((int)actualOpacity).overridingErrorMessage("Expected opacity <%s> but was <%s>.", new Object[]{opacity, actualOpacity})).isEqualTo(opacity);
        return (S)((Object)((AbstractDrawableAssert)this.myself));
    }

    public S isStateful() {
        this.isNotNull();
        ((BooleanAssert)Assertions.assertThat((boolean)((Drawable)this.actual).isStateful()).overridingErrorMessage("Expected to be stateful but was not.", new Object[0])).isTrue();
        return (S)((Object)((AbstractDrawableAssert)this.myself));
    }

    public S isNotStateful() {
        this.isNotNull();
        ((BooleanAssert)Assertions.assertThat((boolean)((Drawable)this.actual).isStateful()).overridingErrorMessage("Expected to not be stateful but was.", new Object[0])).isFalse();
        return (S)((Object)((AbstractDrawableAssert)this.myself));
    }

    public S isVisible() {
        this.isNotNull();
        ((BooleanAssert)Assertions.assertThat((boolean)((Drawable)this.actual).isVisible()).overridingErrorMessage("Expected to be visible but was not.", new Object[0])).isTrue();
        return (S)((Object)((AbstractDrawableAssert)this.myself));
    }

    public S isNotVisible() {
        this.isNotNull();
        ((BooleanAssert)Assertions.assertThat((boolean)((Drawable)this.actual).isVisible()).overridingErrorMessage("Expected to not be visible but was.", new Object[0])).isFalse();
        return (S)((Object)((AbstractDrawableAssert)this.myself));
    }
}

