/*
 * Decompiled with CFR 0.152.
 */
package org.fest.assertions.api.android.graphics.drawable;

import android.graphics.drawable.AnimationDrawable;
import org.fest.assertions.api.Assertions;
import org.fest.assertions.api.BooleanAssert;
import org.fest.assertions.api.IntegerAssert;
import org.fest.assertions.api.android.graphics.drawable.AbstractDrawableAssert;

public class AnimationDrawableAssert
extends AbstractDrawableAssert<AnimationDrawableAssert, AnimationDrawable> {
    public AnimationDrawableAssert(AnimationDrawable actual) {
        super(actual, AnimationDrawableAssert.class);
    }

    public AnimationDrawableAssert hasFrameCount(int count) {
        this.isNotNull();
        int actualCount = ((AnimationDrawable)this.actual).getNumberOfFrames();
        ((IntegerAssert)Assertions.assertThat((int)actualCount).overridingErrorMessage("Expected frame count <%s> but was <%s>.", new Object[]{count, actualCount})).isEqualTo(count);
        return this;
    }

    public AnimationDrawableAssert isOneShot() {
        this.isNotNull();
        ((BooleanAssert)Assertions.assertThat((boolean)((AnimationDrawable)this.actual).isOneShot()).overridingErrorMessage("Expected to be one-short but was not.", new Object[0])).isTrue();
        return this;
    }

    public AnimationDrawableAssert isNotOneShot() {
        this.isNotNull();
        ((BooleanAssert)Assertions.assertThat((boolean)((AnimationDrawable)this.actual).isOneShot()).overridingErrorMessage("Expected to not be one-shot but was.", new Object[0])).isFalse();
        return this;
    }

    public AnimationDrawableAssert isRunning() {
        this.isNotNull();
        ((BooleanAssert)Assertions.assertThat((boolean)((AnimationDrawable)this.actual).isRunning()).overridingErrorMessage("Expected to be running but was not.", new Object[0])).isTrue();
        return this;
    }

    public AnimationDrawableAssert isNotRunning() {
        this.isNotNull();
        ((BooleanAssert)Assertions.assertThat((boolean)((AnimationDrawable)this.actual).isRunning()).overridingErrorMessage("Expected to not be running but was.", new Object[0])).isFalse();
        return this;
    }
}

