/*
 * Decompiled with CFR 0.152.
 */
package org.fest.assertions.api.android.hardware;

import android.hardware.SensorEvent;
import org.fest.assertions.api.AbstractAssert;
import org.fest.assertions.api.Assertions;
import org.fest.assertions.api.FloatArrayAssert;
import org.fest.assertions.api.IntegerAssert;
import org.fest.assertions.api.LongAssert;

public class SensorEventAssert
extends AbstractAssert<SensorEventAssert, SensorEvent> {
    public SensorEventAssert(SensorEvent actual) {
        super((Object)actual, SensorEventAssert.class);
    }

    public SensorEventAssert hasAccuracy(int accuracy) {
        this.isNotNull();
        int actualAccuracy = ((SensorEvent)this.actual).accuracy;
        ((IntegerAssert)Assertions.assertThat((int)actualAccuracy).overridingErrorMessage("Expected accuracy <%s> but was <%s>.", new Object[]{accuracy, actualAccuracy})).isEqualTo(accuracy);
        return this;
    }

    public SensorEventAssert hasTimestamp(long timestamp) {
        this.isNotNull();
        long actualTimestamp = ((SensorEvent)this.actual).timestamp;
        ((LongAssert)Assertions.assertThat((long)actualTimestamp).overridingErrorMessage("Expected timestamp <%s> but was <%s>.", new Object[]{timestamp, actualTimestamp})).isEqualTo(timestamp);
        return this;
    }

    public SensorEventAssert hasValues(float[] values) {
        this.isNotNull();
        float[] actualValues = ((SensorEvent)this.actual).values;
        ((FloatArrayAssert)Assertions.assertThat((float[])actualValues).overridingErrorMessage("Expected values <%s> but was <%s>.", new Object[]{values, actualValues})).isEqualTo((Object)values);
        return this;
    }
}

