/*
 * Decompiled with CFR 0.152.
 */
package org.fest.assertions.api.android.preference;

import android.app.Dialog;
import android.graphics.drawable.Drawable;
import android.preference.DialogPreference;
import org.fest.assertions.api.Assertions;
import org.fest.assertions.api.IntegerAssert;
import org.fest.assertions.api.ObjectAssert;
import org.fest.assertions.api.android.preference.AbstractPreferenceAssert;

public abstract class AbstractDialogPreferenceAssert<S extends AbstractDialogPreferenceAssert<S, A>, A extends DialogPreference>
extends AbstractPreferenceAssert<S, A> {
    protected AbstractDialogPreferenceAssert(A actual, Class<S> selfType) {
        super(actual, selfType);
    }

    public S hasDialog(Dialog dialog) {
        this.isNotNull();
        Dialog actualDialog = ((DialogPreference)this.actual).getDialog();
        ((ObjectAssert)Assertions.assertThat((Object)actualDialog).overridingErrorMessage("Expected dialog <%s> but was <%s>.", new Object[]{dialog, actualDialog})).isSameAs((Object)dialog);
        return (S)((Object)((AbstractDialogPreferenceAssert)this.myself));
    }

    public S hasDialogIcon(Drawable icon) {
        this.isNotNull();
        Drawable actualIcon = ((DialogPreference)this.actual).getIcon();
        ((ObjectAssert)Assertions.assertThat((Object)actualIcon).overridingErrorMessage("Expected dialog icon <%s> but was <%s>.", new Object[]{icon, actualIcon})).isSameAs((Object)icon);
        return (S)((Object)((AbstractDialogPreferenceAssert)this.myself));
    }

    public S hasDialogLayoutResource(int resource) {
        this.isNotNull();
        int actualResource = ((DialogPreference)this.actual).getDialogLayoutResource();
        ((IntegerAssert)Assertions.assertThat((int)actualResource).overridingErrorMessage("Expected dialog layout resource <%s> but was <%s>.", new Object[]{resource, actualResource})).isEqualTo(resource);
        return (S)((Object)((AbstractDialogPreferenceAssert)this.myself));
    }

    public S hasDialogMessage(CharSequence message) {
        this.isNotNull();
        CharSequence actualMessage = ((DialogPreference)this.actual).getDialogMessage();
        ((ObjectAssert)Assertions.assertThat((Object)actualMessage).overridingErrorMessage("Expected dialog message <%s> but was <%s>.", new Object[]{message, actualMessage})).isEqualTo((Object)message);
        return (S)((Object)((AbstractDialogPreferenceAssert)this.myself));
    }

    public S hasDialogMessage(int resId) {
        this.isNotNull();
        return this.hasDialogMessage(((DialogPreference)this.actual).getContext().getString(resId));
    }

    public S hasDialogTitle(CharSequence title) {
        this.isNotNull();
        CharSequence actualTitle = ((DialogPreference)this.actual).getDialogTitle();
        ((ObjectAssert)Assertions.assertThat((Object)actualTitle).overridingErrorMessage("Expected dialog title <%s> but was <%s>.", new Object[]{title, actualTitle})).isEqualTo((Object)title);
        return (S)((Object)((AbstractDialogPreferenceAssert)this.myself));
    }

    public S hasDialogTitle(int resId) {
        this.isNotNull();
        return this.hasDialogTitle(((DialogPreference)this.actual).getContext().getString(resId));
    }

    public S hasNegativeButtonText(CharSequence text) {
        this.isNotNull();
        CharSequence actualText = ((DialogPreference)this.actual).getNegativeButtonText();
        ((ObjectAssert)Assertions.assertThat((Object)actualText).overridingErrorMessage("Expected negative button text <%s> but was <%s>.", new Object[]{text, actualText})).isEqualTo((Object)text);
        return (S)((Object)((AbstractDialogPreferenceAssert)this.myself));
    }

    public S hasNegativeButtonText(int resId) {
        this.isNotNull();
        return this.hasNegativeButtonText(((DialogPreference)this.actual).getContext().getString(resId));
    }

    public S hasPositiveButtonText(CharSequence text) {
        this.isNotNull();
        CharSequence actualText = ((DialogPreference)this.actual).getPositiveButtonText();
        ((ObjectAssert)Assertions.assertThat((Object)actualText).overridingErrorMessage("Expected positive button text <%s> but was <%s>.", new Object[]{text, actualText})).isEqualTo((Object)text);
        return (S)((Object)((AbstractDialogPreferenceAssert)this.myself));
    }

    public S hasPositiveButtonText(int resId) {
        this.isNotNull();
        return this.hasPositiveButtonText(((DialogPreference)this.actual).getContext().getString(resId));
    }
}

