/*
 * Decompiled with CFR 0.152.
 */
package org.fest.assertions.api.android.support.v4.app;

import android.support.v4.app.FragmentManager;
import org.fest.assertions.api.AbstractAssert;
import org.fest.assertions.api.Assertions;
import org.fest.assertions.api.IntegerAssert;
import org.fest.assertions.api.ObjectAssert;

public class FragmentManagerAssert
extends AbstractAssert<FragmentManagerAssert, FragmentManager> {
    public FragmentManagerAssert(FragmentManager actual) {
        super((Object)actual, FragmentManagerAssert.class);
    }

    public FragmentManagerAssert hasFragmentWithId(int id) {
        this.isNotNull();
        ((ObjectAssert)Assertions.assertThat((Object)((FragmentManager)this.actual).findFragmentById(id)).overridingErrorMessage("Expected fragment with ID <%d> but was not found.", new Object[]{id})).isNotNull();
        return this;
    }

    public FragmentManagerAssert hasFragmentWithTag(String tag) {
        this.isNotNull();
        ((ObjectAssert)Assertions.assertThat((Object)((FragmentManager)this.actual).findFragmentByTag(tag)).overridingErrorMessage("Expected fragment with tag <%s> but was not found.", new Object[]{tag})).isNotNull();
        return this;
    }

    public FragmentManagerAssert hasBackStackEntryCount(int count) {
        this.isNotNull();
        int actualCount = ((FragmentManager)this.actual).getBackStackEntryCount();
        ((IntegerAssert)Assertions.assertThat((int)actualCount).overridingErrorMessage("Expected back stack entry count <%s> but was <%s>.", new Object[]{count, actualCount})).isEqualTo(count);
        return this;
    }
}

