/*
 * Decompiled with CFR 0.152.
 */
package org.fest.assertions.api.android.util;

import java.util.LinkedHashSet;
import java.util.Set;

public class BitMaskStringBuilder {
    private final int flags;
    private final Set<String> parts = new LinkedHashSet<String>();

    public BitMaskStringBuilder(int flags) {
        this.flags = flags;
    }

    public BitMaskStringBuilder flag(int flag, String flagName) {
        if ((this.flags & flag) != 0) {
            this.parts.add(flagName);
        }
        return this;
    }

    public String get() {
        if (this.flags == 0) {
            return "none";
        }
        StringBuilder result = new StringBuilder();
        for (String part : this.parts) {
            if (result.length() > 0) {
                result.append(", ");
            }
            result.append(part);
        }
        return result.toString();
    }
}

