/*
 * Decompiled with CFR 0.152.
 */
package org.fest.assertions.api.android.view.animation;

import android.view.animation.Animation;
import android.view.animation.Interpolator;
import android.view.animation.LayoutAnimationController;
import org.fest.assertions.api.AbstractAssert;
import org.fest.assertions.api.Assertions;
import org.fest.assertions.api.BooleanAssert;
import org.fest.assertions.api.FloatAssert;
import org.fest.assertions.api.IntegerAssert;
import org.fest.assertions.api.ObjectAssert;

public abstract class AbstractLayoutAnimationControllerAssert<S extends AbstractLayoutAnimationControllerAssert<S, A>, A extends LayoutAnimationController>
extends AbstractAssert<S, A> {
    protected AbstractLayoutAnimationControllerAssert(A actual, Class<S> selfType) {
        super(actual, selfType);
    }

    public S hasAnimation(Animation animation) {
        this.isNotNull();
        Animation actualAnimation = ((LayoutAnimationController)this.actual).getAnimation();
        ((ObjectAssert)Assertions.assertThat((Object)actualAnimation).overridingErrorMessage("Expected animation <%s> but was <%s>.", new Object[]{animation, actualAnimation})).isSameAs((Object)animation);
        return (S)((Object)((AbstractLayoutAnimationControllerAssert)this.myself));
    }

    public S hasDelay(float delay) {
        this.isNotNull();
        float actualDelay = ((LayoutAnimationController)this.actual).getDelay();
        ((FloatAssert)Assertions.assertThat((float)actualDelay).overridingErrorMessage("Expected delay <%s> but was <%s>.", new Object[]{Float.valueOf(delay), Float.valueOf(actualDelay)})).isEqualTo(delay);
        return (S)((Object)((AbstractLayoutAnimationControllerAssert)this.myself));
    }

    public S hasInterpolator(Interpolator interpolator) {
        this.isNotNull();
        Interpolator actualInterpolator = ((LayoutAnimationController)this.actual).getInterpolator();
        ((ObjectAssert)Assertions.assertThat((Object)actualInterpolator).overridingErrorMessage("Expected interpolator <%s> but was <%s>.", new Object[]{interpolator, actualInterpolator})).isSameAs((Object)interpolator);
        return (S)((Object)((AbstractLayoutAnimationControllerAssert)this.myself));
    }

    public S hasOrder(int order) {
        this.isNotNull();
        int actualOrder = ((LayoutAnimationController)this.actual).getOrder();
        ((IntegerAssert)Assertions.assertThat((int)actualOrder).overridingErrorMessage("Expected order <%s> but was <%s>.", new Object[]{order, actualOrder})).isEqualTo(order);
        return (S)((Object)((AbstractLayoutAnimationControllerAssert)this.myself));
    }

    public S isDone() {
        this.isNotNull();
        ((BooleanAssert)Assertions.assertThat((boolean)((LayoutAnimationController)this.actual).isDone()).overridingErrorMessage("Expected to be done but was not.", new Object[0])).isTrue();
        return (S)((Object)((AbstractLayoutAnimationControllerAssert)this.myself));
    }

    public S isNotDone() {
        this.isNotNull();
        ((BooleanAssert)Assertions.assertThat((boolean)((LayoutAnimationController)this.actual).isDone()).overridingErrorMessage("Expected to not be done but was.", new Object[0])).isFalse();
        return (S)((Object)((AbstractLayoutAnimationControllerAssert)this.myself));
    }

    public S isOverlapping() {
        this.isNotNull();
        ((BooleanAssert)Assertions.assertThat((boolean)((LayoutAnimationController)this.actual).willOverlap()).overridingErrorMessage("Expected to be overlapping but was not.", new Object[0])).isTrue();
        return (S)((Object)((AbstractLayoutAnimationControllerAssert)this.myself));
    }

    public S isNotOverlapping() {
        this.isNotNull();
        ((BooleanAssert)Assertions.assertThat((boolean)((LayoutAnimationController)this.actual).willOverlap()).overridingErrorMessage("Expected to not be overlapping but was.", new Object[0])).isFalse();
        return (S)((Object)((AbstractLayoutAnimationControllerAssert)this.myself));
    }
}

