/*
 * Decompiled with CFR 0.152.
 */
package org.fest.assertions.api.android.widget;

import android.graphics.drawable.Drawable;
import android.view.View;
import android.widget.PopupWindow;
import org.fest.assertions.api.AbstractAssert;
import org.fest.assertions.api.Assertions;
import org.fest.assertions.api.BooleanAssert;
import org.fest.assertions.api.IntegerAssert;
import org.fest.assertions.api.ObjectAssert;

public class PopupWindowAssert
extends AbstractAssert<PopupWindowAssert, PopupWindow> {
    public PopupWindowAssert(PopupWindow actual) {
        super((Object)actual, PopupWindowAssert.class);
    }

    public PopupWindowAssert hasAnimationStyle(int style) {
        this.isNotNull();
        int actualStyle = ((PopupWindow)this.actual).getAnimationStyle();
        ((IntegerAssert)Assertions.assertThat((int)actualStyle).overridingErrorMessage("Expected animation style <%s> but was <%s>.", new Object[]{style, actualStyle})).isEqualTo(style);
        return this;
    }

    public PopupWindowAssert hasBackground(Drawable background) {
        this.isNotNull();
        Drawable actualBackground = ((PopupWindow)this.actual).getBackground();
        ((ObjectAssert)Assertions.assertThat((Object)actualBackground).overridingErrorMessage("Expected background <%s> but was <%s>.", new Object[]{background, actualBackground})).isSameAs((Object)background);
        return this;
    }

    public PopupWindowAssert hasContentView(View view) {
        this.isNotNull();
        View actualView = ((PopupWindow)this.actual).getContentView();
        ((ObjectAssert)Assertions.assertThat((Object)actualView).overridingErrorMessage("Expected content view <%s> but was <%s>.", new Object[]{view, actualView})).isSameAs((Object)view);
        return this;
    }

    public PopupWindowAssert hasHeight(int height) {
        this.isNotNull();
        int actualHeight = ((PopupWindow)this.actual).getHeight();
        ((IntegerAssert)Assertions.assertThat((int)actualHeight).overridingErrorMessage("Expected height <%s> but was <%s>.", new Object[]{height, actualHeight})).isEqualTo(height);
        return this;
    }

    public PopupWindowAssert hasInputMethodMode(int mode) {
        this.isNotNull();
        int actualMode = ((PopupWindow)this.actual).getInputMethodMode();
        ((IntegerAssert)Assertions.assertThat((int)actualMode).overridingErrorMessage("Expected input method mode <%s> but was <%s>.", new Object[]{PopupWindowAssert.inputMethodModeToString(mode), PopupWindowAssert.inputMethodModeToString(actualMode)})).isEqualTo(mode);
        return this;
    }

    public PopupWindowAssert hasSoftInputMode(int mode) {
        this.isNotNull();
        int actualMode = ((PopupWindow)this.actual).getSoftInputMode();
        ((IntegerAssert)Assertions.assertThat((int)actualMode).overridingErrorMessage("Expected soft input mode <%s> but was <%s>.", new Object[]{mode, actualMode})).isEqualTo(mode);
        return this;
    }

    public PopupWindowAssert hasWidth(int width) {
        this.isNotNull();
        int actualWidth = ((PopupWindow)this.actual).getWidth();
        ((IntegerAssert)Assertions.assertThat((int)actualWidth).overridingErrorMessage("Expected width <%s> but was <%s>.", new Object[]{width, actualWidth})).isEqualTo(width);
        return this;
    }

    public PopupWindowAssert isAboveAnchor() {
        this.isNotNull();
        ((BooleanAssert)Assertions.assertThat((boolean)((PopupWindow)this.actual).isAboveAnchor()).overridingErrorMessage("Expected to be above anchor but was not.", new Object[0])).isTrue();
        return this;
    }

    public PopupWindowAssert isNotAboveAnchor() {
        this.isNotNull();
        ((BooleanAssert)Assertions.assertThat((boolean)((PopupWindow)this.actual).isAboveAnchor()).overridingErrorMessage("Expected to not be above anchor but was.", new Object[0])).isFalse();
        return this;
    }

    public PopupWindowAssert isClippingEnabled() {
        this.isNotNull();
        ((BooleanAssert)Assertions.assertThat((boolean)((PopupWindow)this.actual).isClippingEnabled()).overridingErrorMessage("Expected clipping to be enabled but was disabled.", new Object[0])).isTrue();
        return this;
    }

    public PopupWindowAssert isClippingDisabled() {
        this.isNotNull();
        ((BooleanAssert)Assertions.assertThat((boolean)((PopupWindow)this.actual).isClippingEnabled()).overridingErrorMessage("Expected clipping to be disabled but was enabled.", new Object[0])).isFalse();
        return this;
    }

    public PopupWindowAssert isFocusable() {
        this.isNotNull();
        ((BooleanAssert)Assertions.assertThat((boolean)((PopupWindow)this.actual).isFocusable()).overridingErrorMessage("Expected to be focusable but was not.", new Object[0])).isTrue();
        return this;
    }

    public PopupWindowAssert isNotFocusable() {
        this.isNotNull();
        ((BooleanAssert)Assertions.assertThat((boolean)((PopupWindow)this.actual).isFocusable()).overridingErrorMessage("Expected to not be focusable but was.", new Object[0])).isFalse();
        return this;
    }

    public PopupWindowAssert isTouchableOutside() {
        this.isNotNull();
        ((BooleanAssert)Assertions.assertThat((boolean)((PopupWindow)this.actual).isOutsideTouchable()).overridingErrorMessage("Expected to be touchable outside but was not.", new Object[0])).isTrue();
        return this;
    }

    public PopupWindowAssert isNotTouchableOutside() {
        this.isNotNull();
        ((BooleanAssert)Assertions.assertThat((boolean)((PopupWindow)this.actual).isOutsideTouchable()).overridingErrorMessage("Expected to not be touchable outside but was.", new Object[0])).isTrue();
        return this;
    }

    public PopupWindowAssert isShowing() {
        this.isNotNull();
        ((BooleanAssert)Assertions.assertThat((boolean)((PopupWindow)this.actual).isShowing()).overridingErrorMessage("Expected to be showing but was not.", new Object[0])).isTrue();
        return this;
    }

    public PopupWindowAssert isNotShowing() {
        this.isNotNull();
        ((BooleanAssert)Assertions.assertThat((boolean)((PopupWindow)this.actual).isShowing()).overridingErrorMessage("Expected to not be showing but was.", new Object[0])).isFalse();
        return this;
    }

    public PopupWindowAssert isSplitTouchEnabled() {
        this.isNotNull();
        ((BooleanAssert)Assertions.assertThat((boolean)((PopupWindow)this.actual).isSplitTouchEnabled()).overridingErrorMessage("Expected split touch to be enabled but was disabled.", new Object[0])).isTrue();
        return this;
    }

    public PopupWindowAssert isSplitTouchDisabled() {
        this.isNotNull();
        ((BooleanAssert)Assertions.assertThat((boolean)((PopupWindow)this.actual).isSplitTouchEnabled()).overridingErrorMessage("Expected split touch to be disabled but was enabled.", new Object[0])).isFalse();
        return this;
    }

    public PopupWindowAssert isTouchable() {
        this.isNotNull();
        ((BooleanAssert)Assertions.assertThat((boolean)((PopupWindow)this.actual).isTouchable()).overridingErrorMessage("Expected to be touchable but was not.", new Object[0])).isTrue();
        return this;
    }

    public PopupWindowAssert isNotTouchable() {
        this.isNotNull();
        ((BooleanAssert)Assertions.assertThat((boolean)((PopupWindow)this.actual).isTouchable()).overridingErrorMessage("Expected to not be touchable but was.", new Object[0])).isFalse();
        return this;
    }

    private static String inputMethodModeToString(int mode) {
        switch (mode) {
            case 0: {
                return "fromFocusable";
            }
            case 1: {
                return "needed";
            }
            case 2: {
                return "notNeeded";
            }
        }
        throw new IllegalArgumentException("Unknown input method mode: " + mode);
    }
}

