/*
 * Decompiled with CFR 0.152.
 */
package org.fest.assertions.api.android.widget;

import android.widget.RatingBar;
import org.fest.assertions.api.Assertions;
import org.fest.assertions.api.BooleanAssert;
import org.fest.assertions.api.FloatAssert;
import org.fest.assertions.api.IntegerAssert;
import org.fest.assertions.api.android.widget.AbstractAbsSeekBarAssert;

public class RatingBarAssert
extends AbstractAbsSeekBarAssert<RatingBarAssert, RatingBar> {
    public RatingBarAssert(RatingBar actual) {
        super(actual, RatingBarAssert.class);
    }

    public RatingBarAssert hasStarCount(int count) {
        this.isNotNull();
        int actualCount = ((RatingBar)this.actual).getNumStars();
        ((IntegerAssert)Assertions.assertThat((int)actualCount).overridingErrorMessage("Expected star count <%s> but was <%s>.", new Object[]{count, actualCount})).isEqualTo(count);
        return this;
    }

    public RatingBarAssert hasRating(float rating) {
        this.isNotNull();
        float actualRating = ((RatingBar)this.actual).getRating();
        ((FloatAssert)Assertions.assertThat((float)actualRating).overridingErrorMessage("Expected rating <%s> but was <%s>.", new Object[]{Float.valueOf(rating), Float.valueOf(actualRating)})).isEqualTo(rating);
        return this;
    }

    public RatingBarAssert hasStepSize(float size) {
        this.isNotNull();
        float actualSize = ((RatingBar)this.actual).getStepSize();
        ((FloatAssert)Assertions.assertThat((float)actualSize).overridingErrorMessage("Expected step size <%s> but was <%s>.", new Object[]{Float.valueOf(size), Float.valueOf(actualSize)})).isEqualTo(size);
        return this;
    }

    public RatingBarAssert isIndicator() {
        this.isNotNull();
        ((BooleanAssert)Assertions.assertThat((boolean)((RatingBar)this.actual).isIndicator()).overridingErrorMessage("Expected to be indicator but was not.", new Object[0])).isTrue();
        return this;
    }

    public RatingBarAssert isNotIndicator() {
        this.isNotNull();
        ((BooleanAssert)Assertions.assertThat((boolean)((RatingBar)this.actual).isIndicator()).overridingErrorMessage("Expected to not be indicator but was.", new Object[0])).isFalse();
        return this;
    }
}

