/*
 * Decompiled with CFR 0.152.
 */
package org.fest.assertions.api.android.app;

import android.app.Activity;
import org.fest.assertions.api.Assertions;
import org.fest.assertions.api.BooleanAssert;
import org.fest.assertions.api.IntegerAssert;
import org.fest.assertions.api.ObjectAssert;
import org.fest.assertions.api.android.content.AbstractContextAssert;

public abstract class AbstractActivityAssert<S extends AbstractActivityAssert<S, A>, A extends Activity>
extends AbstractContextAssert<S, A> {
    public AbstractActivityAssert(A actual, Class<S> selfType) {
        super(actual, selfType);
    }

    protected S hasRequestedOrientation(int orientation) {
        this.isNotNull();
        int actualOrientation = ((Activity)this.actual).getRequestedOrientation();
        ((IntegerAssert)Assertions.assertThat((int)actualOrientation).overridingErrorMessage("Expected orientation <%s> but was <%s>.", new Object[]{orientation, actualOrientation})).isEqualTo(orientation);
        return (S)((Object)((AbstractActivityAssert)this.myself));
    }

    public S hasTitle(CharSequence title) {
        this.isNotNull();
        CharSequence actualTitle = ((Activity)this.actual).getTitle();
        ((ObjectAssert)Assertions.assertThat((Object)actualTitle).overridingErrorMessage("Expected title <%s> but was <%s>.", new Object[]{title, actualTitle})).isEqualTo((Object)title);
        return (S)((Object)((AbstractActivityAssert)this.myself));
    }

    public S hasTitle(int resId) {
        this.isNotNull();
        return this.hasTitle(((Activity)this.actual).getString(resId));
    }

    public S hasTitleColor(int color) {
        this.isNotNull();
        int actualColor = ((Activity)this.actual).getTitleColor();
        ((IntegerAssert)Assertions.assertThat((int)actualColor).overridingErrorMessage("Expected title color <%s> but was <%s>.", new Object[]{Integer.toHexString(color), Integer.toHexString(actualColor)})).isEqualTo(color);
        return (S)((Object)((AbstractActivityAssert)this.myself));
    }

    public S hasWindowFocus() {
        this.isNotNull();
        ((BooleanAssert)Assertions.assertThat((boolean)((Activity)this.actual).hasWindowFocus()).overridingErrorMessage("Expected to have focus but was not focused.", new Object[0])).isTrue();
        return (S)((Object)((AbstractActivityAssert)this.myself));
    }

    public S isChangingConfigurations() {
        this.isNotNull();
        ((BooleanAssert)Assertions.assertThat((boolean)((Activity)this.actual).isChangingConfigurations()).overridingErrorMessage("Expected changing configurations but was not changing.", new Object[0])).isTrue();
        return (S)((Object)((AbstractActivityAssert)this.myself));
    }

    public S isNotChangingConfigurations() {
        this.isNotNull();
        ((BooleanAssert)Assertions.assertThat((boolean)((Activity)this.actual).isChangingConfigurations()).overridingErrorMessage("Expected not to be changing configurations but was changing.", new Object[0])).isFalse();
        return (S)((Object)((AbstractActivityAssert)this.myself));
    }

    public S isChild() {
        this.isNotNull();
        ((BooleanAssert)Assertions.assertThat((boolean)((Activity)this.actual).isChild()).overridingErrorMessage("Expected to be a child but was not a child.", new Object[0])).isTrue();
        return (S)((Object)((AbstractActivityAssert)this.myself));
    }

    public S isNotChild() {
        this.isNotNull();
        ((BooleanAssert)Assertions.assertThat((boolean)((Activity)this.actual).isChild()).overridingErrorMessage("Expected not to be a child but was a child.", new Object[0])).isFalse();
        return (S)((Object)((AbstractActivityAssert)this.myself));
    }

    public S isFinishing() {
        this.isNotNull();
        ((BooleanAssert)Assertions.assertThat((boolean)((Activity)this.actual).isFinishing()).overridingErrorMessage("Expected to be finishing but was not finishing.", new Object[0])).isTrue();
        return (S)((Object)((AbstractActivityAssert)this.myself));
    }

    public S isNotFinishing() {
        this.isNotNull();
        ((BooleanAssert)Assertions.assertThat((boolean)((Activity)this.actual).isFinishing()).overridingErrorMessage("Expected to not be finishing but was finishing.", new Object[0])).isFalse();
        return (S)((Object)((AbstractActivityAssert)this.myself));
    }

    public S isTaskRoot() {
        this.isNotNull();
        ((BooleanAssert)Assertions.assertThat((boolean)((Activity)this.actual).isTaskRoot()).overridingErrorMessage("Expected to be task root but was not task root.", new Object[0])).isTrue();
        return (S)((Object)((AbstractActivityAssert)this.myself));
    }

    public S isNotTaskRoot() {
        this.isNotNull();
        ((BooleanAssert)Assertions.assertThat((boolean)((Activity)this.actual).isTaskRoot()).overridingErrorMessage("Expected not to be task root but was task root.", new Object[0])).isFalse();
        return (S)((Object)((AbstractActivityAssert)this.myself));
    }
}

