/*
 * Decompiled with CFR 0.152.
 */
package org.fest.assertions.api.android.hardware.usb;

import android.hardware.usb.UsbDevice;
import org.fest.assertions.api.AbstractAssert;
import org.fest.assertions.api.Assertions;
import org.fest.assertions.api.IntegerAssert;
import org.fest.assertions.api.StringAssert;

public class UsbDeviceAssert
extends AbstractAssert<UsbDeviceAssert, UsbDevice> {
    public UsbDeviceAssert(UsbDevice actual) {
        super((Object)actual, UsbDeviceAssert.class);
    }

    public UsbDeviceAssert hasDeviceClass(int value) {
        this.isNotNull();
        int actualValue = ((UsbDevice)this.actual).getDeviceClass();
        ((IntegerAssert)Assertions.assertThat((int)actualValue).overridingErrorMessage("Expected device class <%s> but was <%s>.", new Object[]{value, actualValue})).isEqualTo(value);
        return this;
    }

    public UsbDeviceAssert hasDeviceId(int id) {
        this.isNotNull();
        int actualId = ((UsbDevice)this.actual).getDeviceId();
        ((IntegerAssert)Assertions.assertThat((int)actualId).overridingErrorMessage("Expected device id <%s> but was <%s>.", new Object[]{id, actualId})).isEqualTo(id);
        return this;
    }

    public UsbDeviceAssert hasDeviceName(String name) {
        this.isNotNull();
        String actualName = ((UsbDevice)this.actual).getDeviceName();
        ((StringAssert)Assertions.assertThat((String)actualName).overridingErrorMessage("Expected device name <%s> but was <%s>.", new Object[]{name, actualName})).isEqualTo((Object)name);
        return this;
    }

    public UsbDeviceAssert hasDeviceProtocol(int protocol) {
        this.isNotNull();
        int actualProtocol = ((UsbDevice)this.actual).getDeviceProtocol();
        ((IntegerAssert)Assertions.assertThat((int)actualProtocol).overridingErrorMessage("Expected device protocol <%s> but was <%s>.", new Object[]{protocol, actualProtocol})).isEqualTo(protocol);
        return this;
    }

    public UsbDeviceAssert hasDeviceSubclass(int subclass) {
        this.isNotNull();
        int actualSubclass = ((UsbDevice)this.actual).getDeviceSubclass();
        ((IntegerAssert)Assertions.assertThat((int)actualSubclass).overridingErrorMessage("Expected device subclass <%s> but was <%s>.", new Object[]{subclass, actualSubclass})).isEqualTo(subclass);
        return this;
    }

    public UsbDeviceAssert hasInterfaceCount(int count) {
        this.isNotNull();
        int actualCount = ((UsbDevice)this.actual).getInterfaceCount();
        ((IntegerAssert)Assertions.assertThat((int)actualCount).overridingErrorMessage("Expected interface count <%s> but was <%s>.", new Object[]{count, actualCount})).isEqualTo(count);
        return this;
    }

    public UsbDeviceAssert hasProductId(int id) {
        this.isNotNull();
        int actualId = ((UsbDevice)this.actual).getProductId();
        ((IntegerAssert)Assertions.assertThat((int)actualId).overridingErrorMessage("Expected product ID <%s> but was <%s>.", new Object[]{id, actualId})).isEqualTo(id);
        return this;
    }

    public UsbDeviceAssert hasVendorId(int id) {
        this.isNotNull();
        int actualId = ((UsbDevice)this.actual).getVendorId();
        ((IntegerAssert)Assertions.assertThat((int)actualId).overridingErrorMessage("Expected vendor ID <%s> but was <%s>.", new Object[]{id, actualId})).isEqualTo(id);
        return this;
    }
}

