/*
 * Decompiled with CFR 0.152.
 */
package org.fest.assertions.api.android.location;

import android.location.LocationProvider;
import org.fest.assertions.api.AbstractAssert;
import org.fest.assertions.api.Assertions;
import org.fest.assertions.api.BooleanAssert;
import org.fest.assertions.api.IntegerAssert;
import org.fest.assertions.api.StringAssert;
import org.fest.assertions.api.android.location.CriteriaAssert;

public class LocationProviderAssert
extends AbstractAssert<LocationProviderAssert, LocationProvider> {
    public LocationProviderAssert(LocationProvider actual) {
        super((Object)actual, LocationProviderAssert.class);
    }

    public LocationProviderAssert hasAccuracy(int accuracy) {
        this.isNotNull();
        int actualAccuracy = ((LocationProvider)this.actual).getAccuracy();
        ((IntegerAssert)Assertions.assertThat((int)actualAccuracy).overridingErrorMessage("Expected accuracy <%s> but was <%s>.", new Object[]{CriteriaAssert.accuracyRequirementToString(accuracy), CriteriaAssert.accuracyRequirementToString(actualAccuracy)})).isEqualTo(accuracy);
        return this;
    }

    public LocationProviderAssert hasName(String name) {
        this.isNotNull();
        String actualName = ((LocationProvider)this.actual).getName();
        ((StringAssert)Assertions.assertThat((String)actualName).overridingErrorMessage("Expected name <%s> but was <%s>.", new Object[]{name, actualName})).isEqualTo((Object)name);
        return this;
    }

    public LocationProviderAssert hasPowerRequirement(int requirement) {
        this.isNotNull();
        int actualRequirement = ((LocationProvider)this.actual).getPowerRequirement();
        ((IntegerAssert)Assertions.assertThat((int)actualRequirement).overridingErrorMessage("Expected power requirement <%s> but was <%s>.", new Object[]{CriteriaAssert.powerRequirementToString(requirement), CriteriaAssert.powerRequirementToString(actualRequirement)})).isEqualTo(requirement);
        return this;
    }

    public LocationProviderAssert hasMonetaryCost() {
        this.isNotNull();
        ((BooleanAssert)Assertions.assertThat((boolean)((LocationProvider)this.actual).hasMonetaryCost()).overridingErrorMessage("Expected to have monetary cost but did not.", new Object[0])).isTrue();
        return this;
    }

    public LocationProviderAssert hasNoMonetaryCost() {
        this.isNotNull();
        ((BooleanAssert)Assertions.assertThat((boolean)((LocationProvider)this.actual).hasMonetaryCost()).overridingErrorMessage("Expected to not have monetary cost but did.", new Object[0])).isFalse();
        return this;
    }

    public LocationProviderAssert hasCellRequirement() {
        this.isNotNull();
        ((BooleanAssert)Assertions.assertThat((boolean)((LocationProvider)this.actual).requiresCell()).overridingErrorMessage("Expected to require cell network but did not.", new Object[0])).isTrue();
        return this;
    }

    public LocationProviderAssert hasNoCellRequirement() {
        this.isNotNull();
        ((BooleanAssert)Assertions.assertThat((boolean)((LocationProvider)this.actual).requiresCell()).overridingErrorMessage("Expected to not require cell network but did.", new Object[0])).isFalse();
        return this;
    }

    public LocationProviderAssert hasNetworkRequirement() {
        this.isNotNull();
        ((BooleanAssert)Assertions.assertThat((boolean)((LocationProvider)this.actual).requiresNetwork()).overridingErrorMessage("Expected to require network but did not.", new Object[0])).isTrue();
        return this;
    }

    public LocationProviderAssert hasNoNetworkRequirement() {
        this.isNotNull();
        ((BooleanAssert)Assertions.assertThat((boolean)((LocationProvider)this.actual).requiresNetwork()).overridingErrorMessage("Expected to not require network but did.", new Object[0])).isFalse();
        return this;
    }

    public LocationProviderAssert hasSatelliteRequirement() {
        this.isNotNull();
        ((BooleanAssert)Assertions.assertThat((boolean)((LocationProvider)this.actual).requiresSatellite()).overridingErrorMessage("Expected to require satellites but did not.", new Object[0])).isTrue();
        return this;
    }

    public LocationProviderAssert hasNoSatelliteRequirement() {
        this.isNotNull();
        ((BooleanAssert)Assertions.assertThat((boolean)((LocationProvider)this.actual).requiresSatellite()).overridingErrorMessage("Expected to not require satellites but did.", new Object[0])).isFalse();
        return this;
    }

    public LocationProviderAssert hasAltitudeSupport() {
        this.isNotNull();
        ((BooleanAssert)Assertions.assertThat((boolean)((LocationProvider)this.actual).supportsAltitude()).overridingErrorMessage("Expected to support altitude but did not.", new Object[0])).isTrue();
        return this;
    }

    public LocationProviderAssert hasNoAltitudeSupport() {
        this.isNotNull();
        ((BooleanAssert)Assertions.assertThat((boolean)((LocationProvider)this.actual).supportsAltitude()).overridingErrorMessage("Expected to not support altitude but did.", new Object[0])).isFalse();
        return this;
    }

    public LocationProviderAssert hasBearingSupport() {
        this.isNotNull();
        ((BooleanAssert)Assertions.assertThat((boolean)((LocationProvider)this.actual).supportsBearing()).overridingErrorMessage("Expected to support bearing but did not.", new Object[0])).isTrue();
        return this;
    }

    public LocationProviderAssert hasNoBearingSupport() {
        this.isNotNull();
        ((BooleanAssert)Assertions.assertThat((boolean)((LocationProvider)this.actual).supportsBearing()).overridingErrorMessage("Expected to not support bearing but did.", new Object[0])).isFalse();
        return this;
    }

    public LocationProviderAssert hasSpeedSupport() {
        this.isNotNull();
        ((BooleanAssert)Assertions.assertThat((boolean)((LocationProvider)this.actual).supportsSpeed()).overridingErrorMessage("Expected to support speed but did not.", new Object[0])).isTrue();
        return this;
    }

    public LocationProviderAssert hasNoSpeedSupport() {
        this.isNotNull();
        ((BooleanAssert)Assertions.assertThat((boolean)((LocationProvider)this.actual).supportsSpeed()).overridingErrorMessage("Expected to not support speed but did.", new Object[0])).isFalse();
        return this;
    }
}

