/*
 * Decompiled with CFR 0.152.
 */
package org.fest.assertions.api.android.view;

import android.graphics.drawable.Drawable;
import android.view.View;
import android.view.ViewParent;
import android.view.animation.Animation;
import org.fest.assertions.api.AbstractAssert;
import org.fest.assertions.api.Assertions;
import org.fest.assertions.api.BooleanAssert;
import org.fest.assertions.api.FloatAssert;
import org.fest.assertions.api.IntegerAssert;
import org.fest.assertions.api.ObjectAssert;

public abstract class AbstractViewAssert<S extends AbstractViewAssert<S, A>, A extends View>
extends AbstractAssert<S, A> {
    protected AbstractViewAssert(A actual, Class<S> selfType) {
        super(actual, selfType);
    }

    public S hasAlpha(float alpha) {
        this.isNotNull();
        float actualAlpha = ((View)this.actual).getAlpha();
        ((FloatAssert)Assertions.assertThat((float)actualAlpha).overridingErrorMessage("Expected alpha <%s> but was <%s>", new Object[]{Float.valueOf(alpha), Float.valueOf(actualAlpha)})).isEqualTo(alpha);
        return (S)((Object)((AbstractViewAssert)this.myself));
    }

    public S hasAnimation(Animation animation) {
        this.isNotNull();
        Animation actualAnimation = ((View)this.actual).getAnimation();
        ((ObjectAssert)Assertions.assertThat((Object)actualAnimation).overridingErrorMessage("Expected animation <%s> but was <%s>", new Object[]{animation, actualAnimation})).isSameAs((Object)animation);
        return (S)((Object)((AbstractViewAssert)this.myself));
    }

    public S hasBackground(Drawable background) {
        this.isNotNull();
        Drawable actualDrawable = ((View)this.actual).getBackground();
        ((ObjectAssert)Assertions.assertThat((Object)actualDrawable).overridingErrorMessage("Expected background <%s> but was <%s>", new Object[]{background, actualDrawable})).isSameAs((Object)background);
        return (S)((Object)((AbstractViewAssert)this.myself));
    }

    public S hasBaseline(int baseline) {
        this.isNotNull();
        int actualBaseline = ((View)this.actual).getBaseline();
        ((IntegerAssert)Assertions.assertThat((int)actualBaseline).overridingErrorMessage("Expected baseline <%s> but was <%s>", new Object[]{baseline, actualBaseline})).isEqualTo(baseline);
        return (S)((Object)((AbstractViewAssert)this.myself));
    }

    public S hasBottom(int bottom) {
        this.isNotNull();
        int actualBottom = ((View)this.actual).getBottom();
        ((IntegerAssert)Assertions.assertThat((int)actualBottom).overridingErrorMessage("Expected bottom <%s> but was <%s>", new Object[]{bottom, actualBottom})).isEqualTo(bottom);
        return (S)((Object)((AbstractViewAssert)this.myself));
    }

    public S hasContentDescription(CharSequence contentDescription) {
        this.isNotNull();
        CharSequence actualContentDescription = ((View)this.actual).getContentDescription();
        ((ObjectAssert)Assertions.assertThat((Object)actualContentDescription).overridingErrorMessage("Expected content description <%s> but was <%s>", new Object[]{contentDescription, actualContentDescription})).isEqualTo((Object)contentDescription);
        return (S)((Object)((AbstractViewAssert)this.myself));
    }

    public S hasContentDescription(int resId) {
        this.isNotNull();
        return this.hasContentDescription(((View)this.actual).getContext().getString(resId));
    }

    public S hasDrawingCacheBackgroundColor(int color) {
        this.isNotNull();
        int actualColor = ((View)this.actual).getDrawingCacheBackgroundColor();
        ((IntegerAssert)Assertions.assertThat((int)actualColor).overridingErrorMessage("Expected drawing cache background color <%s> but was <%s>", new Object[]{Integer.toHexString(color), Integer.toHexString(actualColor)})).isEqualTo(color);
        return (S)((Object)((AbstractViewAssert)this.myself));
    }

    public S hasDrawingCacheQuality(int quality) {
        this.isNotNull();
        int actualQuality = ((View)this.actual).getDrawingCacheQuality();
        ((IntegerAssert)Assertions.assertThat((int)actualQuality).overridingErrorMessage("Expected drawing cache quality <%s> but was <%s>", new Object[]{quality, actualQuality})).isEqualTo(quality);
        return (S)((Object)((AbstractViewAssert)this.myself));
    }

    public S hasHeight(int height) {
        this.isNotNull();
        int actualHeight = ((View)this.actual).getHeight();
        ((IntegerAssert)Assertions.assertThat((int)actualHeight).overridingErrorMessage("Expected height <%s> but was <%s>", new Object[]{height, actualHeight})).isEqualTo(height);
        return (S)((Object)((AbstractViewAssert)this.myself));
    }

    public S hasHorizontalFadingEdgeLength(int length) {
        this.isNotNull();
        int actualLength = ((View)this.actual).getHorizontalFadingEdgeLength();
        ((IntegerAssert)Assertions.assertThat((int)actualLength).overridingErrorMessage("Expected horizontal fading edge length <%s> but was <%s>", new Object[]{length, actualLength})).isEqualTo(length);
        return (S)((Object)((AbstractViewAssert)this.myself));
    }

    public S hasId(int id) {
        this.isNotNull();
        int actualId = ((View)this.actual).getId();
        ((IntegerAssert)Assertions.assertThat((int)actualId).overridingErrorMessage("Expected ID <%s> but was <%s>", new Object[]{Integer.toHexString(id), Integer.toHexString(actualId)})).isEqualTo(id);
        return (S)((Object)((AbstractViewAssert)this.myself));
    }

    public S isKeepingScreenOn() {
        this.isNotNull();
        ((BooleanAssert)Assertions.assertThat((boolean)((View)this.actual).getKeepScreenOn()).overridingErrorMessage("Expected to be keeping screen on but was not", new Object[0])).isTrue();
        return (S)((Object)((AbstractViewAssert)this.myself));
    }

    public S isNotKeepingScreenOn() {
        this.isNotNull();
        ((BooleanAssert)Assertions.assertThat((boolean)((View)this.actual).getKeepScreenOn()).overridingErrorMessage("Expected to not be keeping screen on but was", new Object[0])).isFalse();
        return (S)((Object)((AbstractViewAssert)this.myself));
    }

    public S hasLayerType(int type) {
        this.isNotNull();
        int actualType = ((View)this.actual).getLayerType();
        ((IntegerAssert)Assertions.assertThat((int)actualType).overridingErrorMessage("Expected layer type <%s> but was <%s>", new Object[]{AbstractViewAssert.layerTypeToString(type), AbstractViewAssert.layerTypeToString(actualType)})).isEqualTo(type);
        return (S)((Object)((AbstractViewAssert)this.myself));
    }

    public S hasLeft(int left) {
        this.isNotNull();
        int actualLeft = ((View)this.actual).getLeft();
        ((IntegerAssert)Assertions.assertThat((int)actualLeft).overridingErrorMessage("Expected left <%s> but was <%s>", new Object[]{left, actualLeft})).isEqualTo(left);
        return (S)((Object)((AbstractViewAssert)this.myself));
    }

    public S hasMeasuredHeight(int height) {
        this.isNotNull();
        int actualHeight = ((View)this.actual).getMeasuredHeight();
        ((IntegerAssert)Assertions.assertThat((int)actualHeight).overridingErrorMessage("Expected measured height <%s> but was <%s>", new Object[]{height, actualHeight})).isEqualTo(height);
        return (S)((Object)((AbstractViewAssert)this.myself));
    }

    public S hasMeasuredHeightAndState(int heightAndState) {
        this.isNotNull();
        int actualHeightAndState = ((View)this.actual).getMeasuredHeightAndState();
        ((IntegerAssert)Assertions.assertThat((int)actualHeightAndState).overridingErrorMessage("Expected measured height and state <%s> but was <%s>", new Object[]{heightAndState, actualHeightAndState})).isEqualTo(heightAndState);
        return (S)((Object)((AbstractViewAssert)this.myself));
    }

    public S hasMeasuredState(int state) {
        this.isNotNull();
        int actualState = ((View)this.actual).getMeasuredState();
        ((IntegerAssert)Assertions.assertThat((int)actualState).overridingErrorMessage("Expected measured state <%s> but was <%s>", new Object[]{state, actualState})).isEqualTo(state);
        return (S)((Object)((AbstractViewAssert)this.myself));
    }

    public S hasMeasuredWidth(int width) {
        this.isNotNull();
        int actualWidth = ((View)this.actual).getMeasuredWidth();
        ((IntegerAssert)Assertions.assertThat((int)actualWidth).overridingErrorMessage("Expected measured width <%s> but was <%s>", new Object[]{width, actualWidth})).isEqualTo(width);
        return (S)((Object)((AbstractViewAssert)this.myself));
    }

    public S hasMeasuredWidthAndState(int widthAndState) {
        this.isNotNull();
        int actualWidthAndState = ((View)this.actual).getMeasuredWidthAndState();
        ((IntegerAssert)Assertions.assertThat((int)actualWidthAndState).overridingErrorMessage("Expected measured width and state <%s> but was <%s>", new Object[]{widthAndState, actualWidthAndState})).isEqualTo(widthAndState);
        return (S)((Object)((AbstractViewAssert)this.myself));
    }

    public S hasMinimumHeight(int height) {
        this.isNotNull();
        int actualHeight = ((View)this.actual).getMinimumHeight();
        ((IntegerAssert)Assertions.assertThat((int)actualHeight).overridingErrorMessage("Expected minimum height <%s> but was <%s>", new Object[]{height, actualHeight})).isEqualTo(height);
        return (S)((Object)((AbstractViewAssert)this.myself));
    }

    public S hasMinimumWidth(int width) {
        this.isNotNull();
        int actualWidth = ((View)this.actual).getMinimumWidth();
        ((IntegerAssert)Assertions.assertThat((int)actualWidth).overridingErrorMessage("Expected minimum width <%s> but was <%s>", new Object[]{width, actualWidth})).isEqualTo(width);
        return (S)((Object)((AbstractViewAssert)this.myself));
    }

    public S hasNextFocusDownId(int id) {
        this.isNotNull();
        int actualId = ((View)this.actual).getNextFocusDownId();
        ((IntegerAssert)Assertions.assertThat((int)actualId).overridingErrorMessage("Expected next focus down ID <%s> but was <%s>", new Object[]{id, actualId})).isEqualTo(id);
        return (S)((Object)((AbstractViewAssert)this.myself));
    }

    public S hasNextFocusForwardId(int id) {
        this.isNotNull();
        int actualId = ((View)this.actual).getNextFocusForwardId();
        ((IntegerAssert)Assertions.assertThat((int)actualId).overridingErrorMessage("Expected next focus forward ID <%s> but was <%s>", new Object[]{id, actualId})).isEqualTo(id);
        return (S)((Object)((AbstractViewAssert)this.myself));
    }

    public S hasNextFocusLeftId(int id) {
        this.isNotNull();
        int actualId = ((View)this.actual).getNextFocusLeftId();
        ((IntegerAssert)Assertions.assertThat((int)actualId).overridingErrorMessage("Expected next focus left ID <%s> but was <%s>", new Object[]{id, actualId})).isEqualTo(id);
        return (S)((Object)((AbstractViewAssert)this.myself));
    }

    public S hasNextFocusRightId(int id) {
        this.isNotNull();
        int actualId = ((View)this.actual).getNextFocusRightId();
        ((IntegerAssert)Assertions.assertThat((int)actualId).overridingErrorMessage("Expected next focus right ID <%s> but was <%s>", new Object[]{id, actualId})).isEqualTo(id);
        return (S)((Object)((AbstractViewAssert)this.myself));
    }

    public S hasNextFocusUpId(int id) {
        this.isNotNull();
        int actualId = ((View)this.actual).getNextFocusUpId();
        ((IntegerAssert)Assertions.assertThat((int)actualId).overridingErrorMessage("Expected next focus up ID <%s> but was <%s>", new Object[]{id, actualId})).isEqualTo(id);
        return (S)((Object)((AbstractViewAssert)this.myself));
    }

    public S hasOverScrollMode(int mode) {
        this.isNotNull();
        int actualMode = ((View)this.actual).getOverScrollMode();
        ((IntegerAssert)Assertions.assertThat((int)actualMode).overridingErrorMessage("Expected over scroll mode <%s> but was <%s>", new Object[]{AbstractViewAssert.overScrollModeToString(mode), AbstractViewAssert.overScrollModeToString(actualMode)})).isEqualTo(mode);
        return (S)((Object)((AbstractViewAssert)this.myself));
    }

    public S hasPaddingBottom(int padding) {
        this.isNotNull();
        int actualPadding = ((View)this.actual).getPaddingBottom();
        ((IntegerAssert)Assertions.assertThat((int)actualPadding).overridingErrorMessage("Expected padding bottom <%s> but was <%s>", new Object[]{padding, actualPadding})).isEqualTo(padding);
        return (S)((Object)((AbstractViewAssert)this.myself));
    }

    public S hasPaddingLeft(int padding) {
        this.isNotNull();
        int actualPadding = ((View)this.actual).getPaddingLeft();
        ((IntegerAssert)Assertions.assertThat((int)actualPadding).overridingErrorMessage("Expected padding left <%s> but was <%s>", new Object[]{padding, actualPadding})).isEqualTo(padding);
        return (S)((Object)((AbstractViewAssert)this.myself));
    }

    public S hasPaddingRight(int padding) {
        this.isNotNull();
        int actualPadding = ((View)this.actual).getPaddingRight();
        ((IntegerAssert)Assertions.assertThat((int)actualPadding).overridingErrorMessage("Expected padding right <%s> but was <%s>", new Object[]{padding, actualPadding})).isEqualTo(padding);
        return (S)((Object)((AbstractViewAssert)this.myself));
    }

    public S hasPaddingTop(int padding) {
        this.isNotNull();
        int actualPadding = ((View)this.actual).getPaddingTop();
        ((IntegerAssert)Assertions.assertThat((int)actualPadding).overridingErrorMessage("Expected padding top <%s> but was <%s>", new Object[]{padding, actualPadding})).isEqualTo(padding);
        return (S)((Object)((AbstractViewAssert)this.myself));
    }

    public S hasParent(ViewParent parent) {
        this.isNotNull();
        ViewParent actualParent = ((View)this.actual).getParent();
        ((ObjectAssert)Assertions.assertThat((Object)actualParent).overridingErrorMessage("Expected parent <%s> but was <%s>", new Object[]{parent, actualParent})).isSameAs((Object)parent);
        return (S)((Object)((AbstractViewAssert)this.myself));
    }

    public S hasParentForAccessibility(ViewParent parent) {
        this.isNotNull();
        ViewParent actualParent = ((View)this.actual).getParentForAccessibility();
        ((ObjectAssert)Assertions.assertThat((Object)actualParent).overridingErrorMessage("Expected parent for accessibility <%s> but was <%s>", new Object[]{parent, actualParent})).isSameAs((Object)parent);
        return (S)((Object)((AbstractViewAssert)this.myself));
    }

    public S hasPivotX(float pivotX) {
        this.isNotNull();
        float actualPivotX = ((View)this.actual).getPivotX();
        ((FloatAssert)Assertions.assertThat((float)actualPivotX).overridingErrorMessage("Expected x pivot <%s> but was <%s>", new Object[]{Float.valueOf(pivotX), Float.valueOf(actualPivotX)})).isEqualTo(pivotX);
        return (S)((Object)((AbstractViewAssert)this.myself));
    }

    public S hasPivotY(float pivotY) {
        this.isNotNull();
        float actualPivotY = ((View)this.actual).getPivotY();
        ((FloatAssert)Assertions.assertThat((float)actualPivotY).overridingErrorMessage("Expected y pivot <s> but was <%s>", new Object[]{Float.valueOf(pivotY), Float.valueOf(actualPivotY)})).isEqualTo(pivotY);
        return (S)((Object)((AbstractViewAssert)this.myself));
    }

    public S hasRight(int right) {
        this.isNotNull();
        int actualRight = ((View)this.actual).getRight();
        ((IntegerAssert)Assertions.assertThat((int)actualRight).overridingErrorMessage("Expected right <%s> but was <%s>", new Object[]{right, actualRight})).isEqualTo(right);
        return (S)((Object)((AbstractViewAssert)this.myself));
    }

    public S hasRootView(View view) {
        this.isNotNull();
        View actualView = ((View)this.actual).getRootView();
        ((ObjectAssert)Assertions.assertThat((Object)actualView).overridingErrorMessage("Expected root view <%s> but was <%s>", new Object[]{view, actualView})).isSameAs((Object)view);
        return (S)((Object)((AbstractViewAssert)this.myself));
    }

    public S hasRotation(float rotation) {
        this.isNotNull();
        float actualRotation = ((View)this.actual).getRotation();
        ((FloatAssert)Assertions.assertThat((float)actualRotation).overridingErrorMessage("Expected rotation <%s> but was <%s>", new Object[]{Float.valueOf(rotation), Float.valueOf(actualRotation)})).isSameAs((Object)Float.valueOf(rotation));
        return (S)((Object)((AbstractViewAssert)this.myself));
    }

    public S hasRotationX(float rotation) {
        this.isNotNull();
        float actualRotation = ((View)this.actual).getRotationX();
        ((FloatAssert)Assertions.assertThat((float)actualRotation).overridingErrorMessage("Expected x rotation <%s> but was <%s>", new Object[]{Float.valueOf(rotation), Float.valueOf(actualRotation)})).isSameAs((Object)Float.valueOf(rotation));
        return (S)((Object)((AbstractViewAssert)this.myself));
    }

    public S hasRotationY(float rotation) {
        this.isNotNull();
        float actualRotation = ((View)this.actual).getRotationY();
        ((FloatAssert)Assertions.assertThat((float)actualRotation).overridingErrorMessage("Expected y rotation <%s> but was <%s>", new Object[]{Float.valueOf(rotation), Float.valueOf(actualRotation)})).isSameAs((Object)Float.valueOf(rotation));
        return (S)((Object)((AbstractViewAssert)this.myself));
    }

    public S hasScaleX(float scale) {
        this.isNotNull();
        float actualScale = ((View)this.actual).getScaleX();
        ((FloatAssert)Assertions.assertThat((float)actualScale).overridingErrorMessage("Expected x scale <%s> but was <%s>", new Object[]{Float.valueOf(scale), Float.valueOf(actualScale)})).isSameAs((Object)Float.valueOf(scale));
        return (S)((Object)((AbstractViewAssert)this.myself));
    }

    public S hasScaleY(float scale) {
        this.isNotNull();
        float actualScale = ((View)this.actual).getScaleY();
        ((FloatAssert)Assertions.assertThat((float)actualScale).overridingErrorMessage("Expected y scale <%s> but was <%s>", new Object[]{Float.valueOf(scale), Float.valueOf(actualScale)})).isSameAs((Object)Float.valueOf(scale));
        return (S)((Object)((AbstractViewAssert)this.myself));
    }

    public S hasScrollBarDefaultDelayBeforeFade(int fade) {
        this.isNotNull();
        int actualFade = ((View)this.actual).getScrollBarDefaultDelayBeforeFade();
        ((IntegerAssert)Assertions.assertThat((int)actualFade).overridingErrorMessage("Expected scroll bar default delay before fade <%s> but was <%s>", new Object[]{fade, actualFade})).isEqualTo(fade);
        return (S)((Object)((AbstractViewAssert)this.myself));
    }

    public S hasScrollBarFadeDuration(int fade) {
        this.isNotNull();
        int actualFade = ((View)this.actual).getScrollBarFadeDuration();
        ((IntegerAssert)Assertions.assertThat((int)actualFade).overridingErrorMessage("Expected scroll bar fade duration <%s> but was <%s>", new Object[]{fade, actualFade})).isEqualTo(fade);
        return (S)((Object)((AbstractViewAssert)this.myself));
    }

    public S hasScrollBarSize(int size) {
        this.isNotNull();
        int actualSize = ((View)this.actual).getScrollBarSize();
        ((IntegerAssert)Assertions.assertThat((int)actualSize).overridingErrorMessage("Expected scroll bar size <%s> but was <%s>", new Object[]{size, actualSize})).isEqualTo(size);
        return (S)((Object)((AbstractViewAssert)this.myself));
    }

    public S hasScrollBarStyle(int style) {
        this.isNotNull();
        int actualStyle = ((View)this.actual).getScrollBarStyle();
        ((IntegerAssert)Assertions.assertThat((int)actualStyle).overridingErrorMessage("Expected scroll bar style <%s> but was <%s>", new Object[]{AbstractViewAssert.scrollBarStyleToString(style), AbstractViewAssert.scrollBarStyleToString(actualStyle)})).isEqualTo(style);
        return (S)((Object)((AbstractViewAssert)this.myself));
    }

    public S hasScrollX(int scroll) {
        this.isNotNull();
        int actualScroll = ((View)this.actual).getScrollX();
        ((IntegerAssert)Assertions.assertThat((int)actualScroll).overridingErrorMessage("Expected x scroll <%s> but was <%s>", new Object[]{scroll, actualScroll})).isEqualTo(scroll);
        return (S)((Object)((AbstractViewAssert)this.myself));
    }

    public S hasScrollY(int scroll) {
        this.isNotNull();
        int actualScroll = ((View)this.actual).getScrollY();
        ((IntegerAssert)Assertions.assertThat((int)actualScroll).overridingErrorMessage("Expected y scroll <%s> but was <%s>", new Object[]{scroll, actualScroll})).isEqualTo(scroll);
        return (S)((Object)((AbstractViewAssert)this.myself));
    }

    public S hasSolidColor(int color) {
        this.isNotNull();
        int actualColor = ((View)this.actual).getSolidColor();
        ((IntegerAssert)Assertions.assertThat((int)actualColor).overridingErrorMessage("Expected solid color <%s> but was <%s>", new Object[]{Integer.toHexString(color), Integer.toHexString(actualColor)})).isEqualTo(color);
        return (S)((Object)((AbstractViewAssert)this.myself));
    }

    public S hasSystemUiVisibility(int visibility) {
        this.isNotNull();
        int actualVisibility = ((View)this.actual).getSystemUiVisibility();
        ((IntegerAssert)Assertions.assertThat((int)actualVisibility).overridingErrorMessage("Expected system UI visibility <%s> but was <%s>", new Object[]{visibility, actualVisibility})).isEqualTo(visibility);
        return (S)((Object)((AbstractViewAssert)this.myself));
    }

    public S hasTag(int key, Object tag) {
        this.isNotNull();
        Object actualTag = ((View)this.actual).getTag(key);
        ((ObjectAssert)Assertions.assertThat((Object)actualTag).overridingErrorMessage("Expected tag <%s> at key %s but was <%s>", new Object[]{tag, key, actualTag})).isSameAs(tag);
        return (S)((Object)((AbstractViewAssert)this.myself));
    }

    public S hasTag(Object tag) {
        this.isNotNull();
        Object actualTag = ((View)this.actual).getTag();
        ((ObjectAssert)Assertions.assertThat((Object)actualTag).overridingErrorMessage("Expected tag <%s> but was <%s>", new Object[]{tag, actualTag})).isSameAs(tag);
        return (S)((Object)((AbstractViewAssert)this.myself));
    }

    public S hasTop(int top) {
        this.isNotNull();
        int actualTop = ((View)this.actual).getTop();
        ((IntegerAssert)Assertions.assertThat((int)actualTop).overridingErrorMessage("Expected top <%s> but was <%s>", new Object[]{top, actualTop})).isEqualTo(top);
        return (S)((Object)((AbstractViewAssert)this.myself));
    }

    public S hasTranslationX(float translation) {
        this.isNotNull();
        float actualTranslation = ((View)this.actual).getTranslationX();
        ((FloatAssert)Assertions.assertThat((float)actualTranslation).overridingErrorMessage("Expected x translation <%s> but was <%s>", new Object[]{Float.valueOf(translation), Float.valueOf(actualTranslation)})).isEqualTo(translation);
        return (S)((Object)((AbstractViewAssert)this.myself));
    }

    public S hasTranslationY(float translation) {
        this.isNotNull();
        float actualTranslation = ((View)this.actual).getTranslationY();
        ((FloatAssert)Assertions.assertThat((float)actualTranslation).overridingErrorMessage("Expected y translation <%s> but was <%s>", new Object[]{Float.valueOf(translation), Float.valueOf(actualTranslation)})).isEqualTo(translation);
        return (S)((Object)((AbstractViewAssert)this.myself));
    }

    public S hasVerticalFadingEdgeLength(int length) {
        this.isNotNull();
        int actualLength = ((View)this.actual).getVerticalFadingEdgeLength();
        ((IntegerAssert)Assertions.assertThat((int)actualLength).overridingErrorMessage("Expected vertical fading edge length <%s> but was <%s>", new Object[]{length, actualLength})).isEqualTo(length);
        return (S)((Object)((AbstractViewAssert)this.myself));
    }

    public S hasVerticalScrollbarPosition(int position) {
        this.isNotNull();
        int actualPosition = ((View)this.actual).getVerticalScrollbarPosition();
        ((IntegerAssert)Assertions.assertThat((int)actualPosition).overridingErrorMessage("Expected vertical scroll bar position <%s> but was <%s>", new Object[]{AbstractViewAssert.verticalScrollBarPositionToString(position), AbstractViewAssert.verticalScrollBarPositionToString(actualPosition)})).isEqualTo(position);
        return (S)((Object)((AbstractViewAssert)this.myself));
    }

    public S hasVerticalScrollbarWidth(int width) {
        this.isNotNull();
        int actualWidth = ((View)this.actual).getVerticalScrollbarWidth();
        ((IntegerAssert)Assertions.assertThat((int)actualWidth).overridingErrorMessage("Expected vertical scroll bar width <%s> but was <%s>", new Object[]{width, actualWidth})).isEqualTo(width);
        return (S)((Object)((AbstractViewAssert)this.myself));
    }

    public S hasVisibility(int visibility) {
        this.isNotNull();
        int actualVisibility = ((View)this.actual).getVisibility();
        ((IntegerAssert)Assertions.assertThat((int)actualVisibility).overridingErrorMessage("Expected visibility <%s> but was <%s>.", new Object[]{AbstractViewAssert.visibilityToString(visibility), AbstractViewAssert.visibilityToString(actualVisibility)})).isEqualTo(visibility);
        return (S)((Object)((AbstractViewAssert)this.myself));
    }

    public S isVisible() {
        this.isNotNull();
        int actualVisibility = ((View)this.actual).getVisibility();
        ((IntegerAssert)Assertions.assertThat((int)actualVisibility).overridingErrorMessage("Expected to be visible but was %s", new Object[]{AbstractViewAssert.visibilityToString(actualVisibility)})).isEqualTo(0);
        return (S)((Object)((AbstractViewAssert)this.myself));
    }

    public S isNotVisible() {
        this.isNotNull();
        int actualVisibility = ((View)this.actual).getVisibility();
        ((IntegerAssert)Assertions.assertThat((int)actualVisibility).overridingErrorMessage("Expected to be not visible but was visible", new Object[0])).isNotEqualTo(0);
        return (S)((Object)((AbstractViewAssert)this.myself));
    }

    public S isInvisible() {
        this.isNotNull();
        int actualVisibility = ((View)this.actual).getVisibility();
        ((IntegerAssert)Assertions.assertThat((int)actualVisibility).overridingErrorMessage("Expected to be invisible but was %s", new Object[]{AbstractViewAssert.visibilityToString(actualVisibility)})).isEqualTo(4);
        return (S)((Object)((AbstractViewAssert)this.myself));
    }

    public S isNotInvisible() {
        this.isNotNull();
        int actualVisibility = ((View)this.actual).getVisibility();
        ((IntegerAssert)Assertions.assertThat((int)actualVisibility).overridingErrorMessage("Expected to be not invisible but was invisible", new Object[0])).isNotEqualTo(4);
        return (S)((Object)((AbstractViewAssert)this.myself));
    }

    public S isGone() {
        this.isNotNull();
        int actualVisibility = ((View)this.actual).getVisibility();
        ((IntegerAssert)Assertions.assertThat((int)actualVisibility).overridingErrorMessage("Expected to be gone but was %s", new Object[]{AbstractViewAssert.visibilityToString(actualVisibility)})).isEqualTo(8);
        return (S)((Object)((AbstractViewAssert)this.myself));
    }

    public S isNotGone() {
        this.isNotNull();
        int actualVisibility = ((View)this.actual).getVisibility();
        ((IntegerAssert)Assertions.assertThat((int)actualVisibility).overridingErrorMessage("Expected to be not gone but was gone", new Object[0])).isNotEqualTo(8);
        return (S)((Object)((AbstractViewAssert)this.myself));
    }

    public S hasWidth(int width) {
        this.isNotNull();
        int actualWidth = ((View)this.actual).getWidth();
        ((IntegerAssert)Assertions.assertThat((int)actualWidth).overridingErrorMessage("Expected width <%s> but was <%s>", new Object[]{width, actualWidth})).isEqualTo(width);
        return (S)((Object)((AbstractViewAssert)this.myself));
    }

    public S hasWindowVisibility(int visibility) {
        this.isNotNull();
        int actualVisibility = ((View)this.actual).getWindowVisibility();
        ((IntegerAssert)Assertions.assertThat((int)actualVisibility).overridingErrorMessage("Expected window visibility <%s> but was <%s>", new Object[]{AbstractViewAssert.visibilityToString(visibility), AbstractViewAssert.visibilityToString(actualVisibility)})).isEqualTo(visibility);
        return (S)((Object)((AbstractViewAssert)this.myself));
    }

    public S hasX(float x) {
        this.isNotNull();
        float actualX = ((View)this.actual).getX();
        ((FloatAssert)Assertions.assertThat((float)actualX).overridingErrorMessage("Expected x <%s> but was <%s>", new Object[]{Float.valueOf(x), Float.valueOf(actualX)})).isEqualTo(x);
        return (S)((Object)((AbstractViewAssert)this.myself));
    }

    public S hasY(float y) {
        this.isNotNull();
        float actualY = ((View)this.actual).getY();
        ((FloatAssert)Assertions.assertThat((float)actualY).overridingErrorMessage("Expected y <%s> but was <%s>", new Object[]{Float.valueOf(y), Float.valueOf(actualY)})).isEqualTo(y);
        return (S)((Object)((AbstractViewAssert)this.myself));
    }

    public S hasFocus() {
        this.isNotNull();
        ((BooleanAssert)Assertions.assertThat((boolean)((View)this.actual).hasFocus()).overridingErrorMessage("Expected to have focus but was not focused", new Object[0])).isTrue();
        return (S)((Object)((AbstractViewAssert)this.myself));
    }

    public S hasNoFocus() {
        this.isNotNull();
        ((BooleanAssert)Assertions.assertThat((boolean)((View)this.actual).hasFocus()).overridingErrorMessage("Expected to not have focus but was focused", new Object[0])).isFalse();
        return (S)((Object)((AbstractViewAssert)this.myself));
    }

    public S hasFocusable() {
        this.isNotNull();
        ((BooleanAssert)Assertions.assertThat((boolean)((View)this.actual).hasFocusable()).overridingErrorMessage("Expected to have focusable but was not", new Object[0])).isTrue();
        return (S)((Object)((AbstractViewAssert)this.myself));
    }

    public S isInFocusedWindow() {
        this.isNotNull();
        ((BooleanAssert)Assertions.assertThat((boolean)((View)this.actual).hasWindowFocus()).overridingErrorMessage("Expected to be in a focused window but was not", new Object[0])).isTrue();
        return (S)((Object)((AbstractViewAssert)this.myself));
    }

    public S isNotInFocusedWindow() {
        this.isNotNull();
        ((BooleanAssert)Assertions.assertThat((boolean)((View)this.actual).hasWindowFocus()).overridingErrorMessage("Expected to not be in a focused window but was", new Object[0])).isFalse();
        return (S)((Object)((AbstractViewAssert)this.myself));
    }

    public S isActivated() {
        this.isNotNull();
        ((BooleanAssert)Assertions.assertThat((boolean)((View)this.actual).isActivated()).overridingErrorMessage("Expected to be activated but was not", new Object[0])).isTrue();
        return (S)((Object)((AbstractViewAssert)this.myself));
    }

    public S isNotActivated() {
        this.isNotNull();
        ((BooleanAssert)Assertions.assertThat((boolean)((View)this.actual).isActivated()).overridingErrorMessage("Expected to not be activated but was", new Object[0])).isFalse();
        return (S)((Object)((AbstractViewAssert)this.myself));
    }

    public S isClickable() {
        this.isNotNull();
        ((BooleanAssert)Assertions.assertThat((boolean)((View)this.actual).isClickable()).overridingErrorMessage("Expected to be clickable but was not", new Object[0])).isTrue();
        return (S)((Object)((AbstractViewAssert)this.myself));
    }

    public S isNotClickable() {
        this.isNotNull();
        ((BooleanAssert)Assertions.assertThat((boolean)((View)this.actual).isClickable()).overridingErrorMessage("Expected to not be clickable but was", new Object[0])).isFalse();
        return (S)((Object)((AbstractViewAssert)this.myself));
    }

    public S isDirty() {
        this.isNotNull();
        ((BooleanAssert)Assertions.assertThat((boolean)((View)this.actual).isDirty()).overridingErrorMessage("Expected to be dirty but was not", new Object[0])).isTrue();
        return (S)((Object)((AbstractViewAssert)this.myself));
    }

    public S isNotDirty() {
        this.isNotNull();
        ((BooleanAssert)Assertions.assertThat((boolean)((View)this.actual).isDirty()).overridingErrorMessage("Expected to not be dirty but was", new Object[0])).isFalse();
        return (S)((Object)((AbstractViewAssert)this.myself));
    }

    public S isUsingDrawingCache() {
        this.isNotNull();
        ((BooleanAssert)Assertions.assertThat((boolean)((View)this.actual).isDrawingCacheEnabled()).overridingErrorMessage("Expected to use drawing cache but was not", new Object[0])).isTrue();
        return (S)((Object)((AbstractViewAssert)this.myself));
    }

    public S isNotUsingDrawingCache() {
        this.isNotNull();
        ((BooleanAssert)Assertions.assertThat((boolean)((View)this.actual).isDrawingCacheEnabled()).overridingErrorMessage("Expected to not be using drawing cache but was", new Object[0])).isFalse();
        return (S)((Object)((AbstractViewAssert)this.myself));
    }

    public S isDuplicatingParentState() {
        this.isNotNull();
        ((BooleanAssert)Assertions.assertThat((boolean)((View)this.actual).isDuplicateParentStateEnabled()).overridingErrorMessage("Expected to be duplicating parent state but was not", new Object[0])).isTrue();
        return (S)((Object)((AbstractViewAssert)this.myself));
    }

    public S isNotDuplicatingParentState() {
        this.isNotNull();
        ((BooleanAssert)Assertions.assertThat((boolean)((View)this.actual).isDuplicateParentStateEnabled()).overridingErrorMessage("Expected to not be duplicated parent state but was", new Object[0])).isFalse();
        return (S)((Object)((AbstractViewAssert)this.myself));
    }

    public S isEnabled() {
        this.isNotNull();
        ((BooleanAssert)Assertions.assertThat((boolean)((View)this.actual).isEnabled()).overridingErrorMessage("Expected to be enabled but was disabled", new Object[0])).isTrue();
        return (S)((Object)((AbstractViewAssert)this.myself));
    }

    public S isDisabled() {
        this.isNotNull();
        ((BooleanAssert)Assertions.assertThat((boolean)((View)this.actual).isEnabled()).overridingErrorMessage("Expected to be disabled but was enabled", new Object[0])).isFalse();
        return (S)((Object)((AbstractViewAssert)this.myself));
    }

    public S isFocusable() {
        this.isNotNull();
        ((BooleanAssert)Assertions.assertThat((boolean)((View)this.actual).isFocusable()).overridingErrorMessage("Expected to be focusable but was not", new Object[0])).isTrue();
        return (S)((Object)((AbstractViewAssert)this.myself));
    }

    public S isNotFocusable() {
        this.isNotNull();
        ((BooleanAssert)Assertions.assertThat((boolean)((View)this.actual).isFocusable()).overridingErrorMessage("Expected to not be focusable but was", new Object[0])).isFalse();
        return (S)((Object)((AbstractViewAssert)this.myself));
    }

    public S isFocusableInTouchMode() {
        this.isNotNull();
        ((BooleanAssert)Assertions.assertThat((boolean)((View)this.actual).isFocusableInTouchMode()).overridingErrorMessage("Expected to be focusable in touch mode but was not", new Object[0])).isTrue();
        return (S)((Object)((AbstractViewAssert)this.myself));
    }

    public S isNotFocusableInTouchMode() {
        this.isNotNull();
        ((BooleanAssert)Assertions.assertThat((boolean)((View)this.actual).isFocusableInTouchMode()).overridingErrorMessage("Expected to not be focusable in touch mode but was", new Object[0])).isFalse();
        return (S)((Object)((AbstractViewAssert)this.myself));
    }

    public S isFocused() {
        this.isNotNull();
        ((BooleanAssert)Assertions.assertThat((boolean)((View)this.actual).isFocused()).overridingErrorMessage("Expected to be focused but was not", new Object[0])).isTrue();
        return (S)((Object)((AbstractViewAssert)this.myself));
    }

    public S isNotFocused() {
        this.isNotNull();
        ((BooleanAssert)Assertions.assertThat((boolean)((View)this.actual).isFocused()).overridingErrorMessage("Expected to not be focused but was", new Object[0])).isFalse();
        return (S)((Object)((AbstractViewAssert)this.myself));
    }

    public S hasHapticFeedbackEnabled() {
        this.isNotNull();
        ((BooleanAssert)Assertions.assertThat((boolean)((View)this.actual).isHapticFeedbackEnabled()).overridingErrorMessage("Expected to have haptic feedback enabled but was disabled", new Object[0])).isTrue();
        return (S)((Object)((AbstractViewAssert)this.myself));
    }

    public S hasHapticFeedbackDisabled() {
        this.isNotNull();
        ((BooleanAssert)Assertions.assertThat((boolean)((View)this.actual).isHapticFeedbackEnabled()).overridingErrorMessage("Expected to have haptic feedback disabled but was enabled", new Object[0])).isFalse();
        return (S)((Object)((AbstractViewAssert)this.myself));
    }

    public S isHardwareAccelerated() {
        this.isNotNull();
        ((BooleanAssert)Assertions.assertThat((boolean)((View)this.actual).isHardwareAccelerated()).overridingErrorMessage("Expected to be hardware accelerated but was not", new Object[0])).isTrue();
        return (S)((Object)((AbstractViewAssert)this.myself));
    }

    public S isNotHardwareAccelerated() {
        this.isNotNull();
        ((BooleanAssert)Assertions.assertThat((boolean)((View)this.actual).isHardwareAccelerated()).overridingErrorMessage("Expected to not be hardware accelerated but was", new Object[0])).isFalse();
        return (S)((Object)((AbstractViewAssert)this.myself));
    }

    public S hasHorizontalFadingEdgesEnabled() {
        this.isNotNull();
        ((BooleanAssert)Assertions.assertThat((boolean)((View)this.actual).isHorizontalFadingEdgeEnabled()).overridingErrorMessage("Expected to be fading horizontal edges but was not", new Object[0])).isTrue();
        return (S)((Object)((AbstractViewAssert)this.myself));
    }

    public S hasHorizontalFadingEdgesDisabled() {
        this.isNotNull();
        ((BooleanAssert)Assertions.assertThat((boolean)((View)this.actual).isHorizontalFadingEdgeEnabled()).overridingErrorMessage("Expected to not be fading horizontal edges but was", new Object[0])).isFalse();
        return (S)((Object)((AbstractViewAssert)this.myself));
    }

    public S hasHorizontalScrollbarEnabled() {
        this.isNotNull();
        ((BooleanAssert)Assertions.assertThat((boolean)((View)this.actual).isHorizontalScrollBarEnabled()).overridingErrorMessage("Expected to have horizontal scroll bar enabled but was disabled", new Object[0])).isTrue();
        return (S)((Object)((AbstractViewAssert)this.myself));
    }

    public S hasHorizontalScrollbarDisabled() {
        this.isNotNull();
        ((BooleanAssert)Assertions.assertThat((boolean)((View)this.actual).isHorizontalScrollBarEnabled()).overridingErrorMessage("Expected to have horizontal scroll bar disabled but was enabled", new Object[0])).isFalse();
        return (S)((Object)((AbstractViewAssert)this.myself));
    }

    public S isHovered() {
        this.isNotNull();
        ((BooleanAssert)Assertions.assertThat((boolean)((View)this.actual).isHovered()).overridingErrorMessage("Expected to be hovered but was not", new Object[0])).isTrue();
        return (S)((Object)((AbstractViewAssert)this.myself));
    }

    public S isNotHovered() {
        this.isNotNull();
        ((BooleanAssert)Assertions.assertThat((boolean)((View)this.actual).isHovered()).overridingErrorMessage("Expected to not be hoevered but was", new Object[0])).isFalse();
        return (S)((Object)((AbstractViewAssert)this.myself));
    }

    public S isInEditMode() {
        this.isNotNull();
        ((BooleanAssert)Assertions.assertThat((boolean)((View)this.actual).isInEditMode()).overridingErrorMessage("Expected to be in edit mode but was not", new Object[0])).isTrue();
        return (S)((Object)((AbstractViewAssert)this.myself));
    }

    public S isNotInEditMode() {
        this.isNotNull();
        ((BooleanAssert)Assertions.assertThat((boolean)((View)this.actual).isInEditMode()).overridingErrorMessage("Expected to not be in edit mode but was", new Object[0])).isFalse();
        return (S)((Object)((AbstractViewAssert)this.myself));
    }

    public S isInTouchMode() {
        this.isNotNull();
        ((BooleanAssert)Assertions.assertThat((boolean)((View)this.actual).isInTouchMode()).overridingErrorMessage("Expected to be in touch mode but was not", new Object[0])).isTrue();
        return (S)((Object)((AbstractViewAssert)this.myself));
    }

    public S isNotInTouchMode() {
        this.isNotNull();
        ((BooleanAssert)Assertions.assertThat((boolean)((View)this.actual).isInTouchMode()).overridingErrorMessage("Expected to not be in touch mode but was", new Object[0])).isFalse();
        return (S)((Object)((AbstractViewAssert)this.myself));
    }

    public S hasLayoutRequested() {
        this.isNotNull();
        ((BooleanAssert)Assertions.assertThat((boolean)((View)this.actual).isLayoutRequested()).overridingErrorMessage("Expected to have layout requested but was not", new Object[0])).isTrue();
        return (S)((Object)((AbstractViewAssert)this.myself));
    }

    public S hasNoLayoutRequested() {
        this.isNotNull();
        ((BooleanAssert)Assertions.assertThat((boolean)((View)this.actual).isLayoutRequested()).overridingErrorMessage("Expected to not have layout requested but had", new Object[0])).isFalse();
        return (S)((Object)((AbstractViewAssert)this.myself));
    }

    public S isLongClickable() {
        this.isNotNull();
        ((BooleanAssert)Assertions.assertThat((boolean)((View)this.actual).isLongClickable()).overridingErrorMessage("Expected to be long-clickable but was not", new Object[0])).isTrue();
        return (S)((Object)((AbstractViewAssert)this.myself));
    }

    public S isNotLongClickable() {
        this.isNotNull();
        ((BooleanAssert)Assertions.assertThat((boolean)((View)this.actual).isLongClickable()).overridingErrorMessage("Expected to not be long-clickable but was", new Object[0])).isFalse();
        return (S)((Object)((AbstractViewAssert)this.myself));
    }

    public S isOpaque() {
        this.isNotNull();
        ((BooleanAssert)Assertions.assertThat((boolean)((View)this.actual).isOpaque()).overridingErrorMessage("Expected to be opaque but was not", new Object[0])).isTrue();
        return (S)((Object)((AbstractViewAssert)this.myself));
    }

    public S isNotOpaque() {
        this.isNotNull();
        ((BooleanAssert)Assertions.assertThat((boolean)((View)this.actual).isOpaque()).overridingErrorMessage("Expected to not be opaque but was", new Object[0])).isFalse();
        return (S)((Object)((AbstractViewAssert)this.myself));
    }

    public S isPressed() {
        this.isNotNull();
        ((BooleanAssert)Assertions.assertThat((boolean)((View)this.actual).isPressed()).overridingErrorMessage("Expected to be pressed but was not", new Object[0])).isTrue();
        return (S)((Object)((AbstractViewAssert)this.myself));
    }

    public S isNotPressed() {
        this.isNotNull();
        ((BooleanAssert)Assertions.assertThat((boolean)((View)this.actual).isPressed()).overridingErrorMessage("Expected to not be pressed but was", new Object[0])).isFalse();
        return (S)((Object)((AbstractViewAssert)this.myself));
    }

    public S hasSaveEnabled() {
        this.isNotNull();
        ((BooleanAssert)Assertions.assertThat((boolean)((View)this.actual).isSaveEnabled()).overridingErrorMessage("Expected to have save enabled but was disabled", new Object[0])).isTrue();
        return (S)((Object)((AbstractViewAssert)this.myself));
    }

    public S hasSaveDisabled() {
        this.isNotNull();
        ((BooleanAssert)Assertions.assertThat((boolean)((View)this.actual).isSaveEnabled()).overridingErrorMessage("Expected to have save disabled but was enabled", new Object[0])).isFalse();
        return (S)((Object)((AbstractViewAssert)this.myself));
    }

    public S hasSaveFromParentEnabled() {
        this.isNotNull();
        ((BooleanAssert)Assertions.assertThat((boolean)((View)this.actual).isSaveFromParentEnabled()).overridingErrorMessage("Expected to have save from parent enabled but was disabled", new Object[0])).isTrue();
        return (S)((Object)((AbstractViewAssert)this.myself));
    }

    public S hasSaveFromParentDisabled() {
        this.isNotNull();
        ((BooleanAssert)Assertions.assertThat((boolean)((View)this.actual).isSaveFromParentEnabled()).overridingErrorMessage("Expected to have save from parent disabled but was enabled", new Object[0])).isFalse();
        return (S)((Object)((AbstractViewAssert)this.myself));
    }

    public S isScrollContainer() {
        this.isNotNull();
        ((BooleanAssert)Assertions.assertThat((boolean)((View)this.actual).isScrollContainer()).overridingErrorMessage("Expected to be a scroll container but was not", new Object[0])).isTrue();
        return (S)((Object)((AbstractViewAssert)this.myself));
    }

    public S isNotScrollContainer() {
        this.isNotNull();
        ((BooleanAssert)Assertions.assertThat((boolean)((View)this.actual).isScrollContainer()).overridingErrorMessage("Expected to not be a scroll container but was", new Object[0])).isFalse();
        return (S)((Object)((AbstractViewAssert)this.myself));
    }

    public S hasScrollbarFadingEnabled() {
        this.isNotNull();
        ((BooleanAssert)Assertions.assertThat((boolean)((View)this.actual).isScrollbarFadingEnabled()).overridingErrorMessage("Expected to have scroll bar fading enabled but was disabled", new Object[0])).isTrue();
        return (S)((Object)((AbstractViewAssert)this.myself));
    }

    public S hasScrollbarFadingDisabled() {
        this.isNotNull();
        ((BooleanAssert)Assertions.assertThat((boolean)((View)this.actual).isScrollbarFadingEnabled()).overridingErrorMessage("Expected to have scroll bar fading disabled but was enabled", new Object[0])).isFalse();
        return (S)((Object)((AbstractViewAssert)this.myself));
    }

    public S isSelected() {
        this.isNotNull();
        ((BooleanAssert)Assertions.assertThat((boolean)((View)this.actual).isSelected()).overridingErrorMessage("Expected to be selected but was not", new Object[0])).isTrue();
        return (S)((Object)((AbstractViewAssert)this.myself));
    }

    public S isNotSelected() {
        this.isNotNull();
        ((BooleanAssert)Assertions.assertThat((boolean)((View)this.actual).isSelected()).overridingErrorMessage("Expected to not be selected but was", new Object[0])).isFalse();
        return (S)((Object)((AbstractViewAssert)this.myself));
    }

    public S isShown() {
        this.isNotNull();
        ((BooleanAssert)Assertions.assertThat((boolean)((View)this.actual).isShown()).overridingErrorMessage("Expected to be shown but was not", new Object[0])).isTrue();
        return (S)((Object)((AbstractViewAssert)this.myself));
    }

    public S isNotShown() {
        this.isNotNull();
        ((BooleanAssert)Assertions.assertThat((boolean)((View)this.actual).isShown()).overridingErrorMessage("Expected to not be shown but was", new Object[0])).isFalse();
        return (S)((Object)((AbstractViewAssert)this.myself));
    }

    public S hasSoundEffectsEnabled() {
        this.isNotNull();
        ((BooleanAssert)Assertions.assertThat((boolean)((View)this.actual).isSoundEffectsEnabled()).overridingErrorMessage("Expected sound effects to be enabled but was disabled", new Object[0])).isTrue();
        return (S)((Object)((AbstractViewAssert)this.myself));
    }

    public S hasSoundEffectsDisabled() {
        this.isNotNull();
        ((BooleanAssert)Assertions.assertThat((boolean)((View)this.actual).isSaveFromParentEnabled()).overridingErrorMessage("Expected sound effects to be disabled but was enabled", new Object[0])).isFalse();
        return (S)((Object)((AbstractViewAssert)this.myself));
    }

    public S hasVerticalFadingEdgeEnabled() {
        this.isNotNull();
        ((BooleanAssert)Assertions.assertThat((boolean)((View)this.actual).isVerticalFadingEdgeEnabled()).overridingErrorMessage("Expected to have vertical fading edge enabled but was disabled", new Object[0])).isTrue();
        return (S)((Object)((AbstractViewAssert)this.myself));
    }

    public S hasVerticalFadingEdgeDisabled() {
        this.isNotNull();
        ((BooleanAssert)Assertions.assertThat((boolean)((View)this.actual).isVerticalFadingEdgeEnabled()).overridingErrorMessage("Expected to have vertical fading edge disabled but was enabled", new Object[0])).isFalse();
        return (S)((Object)((AbstractViewAssert)this.myself));
    }

    public S hasVerticalScrollBarEnabled() {
        this.isNotNull();
        ((BooleanAssert)Assertions.assertThat((boolean)((View)this.actual).isVerticalScrollBarEnabled()).overridingErrorMessage("Expected to have vertical scroll bar enabled but was disabled", new Object[0])).isTrue();
        return (S)((Object)((AbstractViewAssert)this.myself));
    }

    public S hasVerticalScrollBarDisabled() {
        this.isNotNull();
        ((BooleanAssert)Assertions.assertThat((boolean)((View)this.actual).isVerticalScrollBarEnabled()).overridingErrorMessage("Expected to have vertical scroll bar disabled but was enabled", new Object[0])).isFalse();
        return (S)((Object)((AbstractViewAssert)this.myself));
    }

    private static String visibilityToString(int visibility) {
        switch (visibility) {
            case 0: {
                return "visible";
            }
            case 4: {
                return "invisible";
            }
            case 8: {
                return "gone";
            }
        }
        throw new IllegalArgumentException("Unknown view visibility: " + visibility);
    }

    private static String layerTypeToString(int type) {
        switch (type) {
            case 0: {
                return "none";
            }
            case 1: {
                return "software";
            }
            case 2: {
                return "hardware";
            }
        }
        throw new IllegalArgumentException("Unknown layer type: " + type);
    }

    private static String overScrollModeToString(int mode) {
        switch (mode) {
            case 0: {
                return "always";
            }
            case 1: {
                return "ifContentScrolls";
            }
            case 2: {
                return "never";
            }
        }
        throw new IllegalArgumentException("Unknown over scroll mode: " + mode);
    }

    private static String scrollBarStyleToString(int style) {
        switch (style) {
            case 0x1000000: {
                return "insideInset";
            }
            case 0: {
                return "insideOverlay";
            }
            case 0x3000000: {
                return "outsideInset";
            }
            case 0x2000000: {
                return "outsideOverlay";
            }
        }
        throw new IllegalArgumentException("Unknown scroll bar style: " + style);
    }

    private static String verticalScrollBarPositionToString(int position) {
        switch (position) {
            case 0: {
                return "default";
            }
            case 1: {
                return "left";
            }
            case 2: {
                return "right";
            }
        }
        throw new IllegalArgumentException("Unknown vertical scroll bar position: " + position);
    }
}

