/*
 * Decompiled with CFR 0.152.
 */
package org.fest.assertions.api.android.preference;

import android.preference.PreferenceGroup;
import org.fest.assertions.api.Assertions;
import org.fest.assertions.api.BooleanAssert;
import org.fest.assertions.api.IntegerAssert;
import org.fest.assertions.api.android.preference.AbstractPreferenceAssert;

public abstract class AbstractPreferenceGroupAssert<S extends AbstractPreferenceGroupAssert<S, A>, A extends PreferenceGroup>
extends AbstractPreferenceAssert<S, A> {
    protected AbstractPreferenceGroupAssert(A actual, Class<S> selfType) {
        super(actual, selfType);
    }

    public S hasPreferenceCount(int count) {
        this.isNotNull();
        int actualCount = ((PreferenceGroup)this.actual).getPreferenceCount();
        ((IntegerAssert)Assertions.assertThat((int)actualCount).overridingErrorMessage("Expected preference count <%s> but was <%s>.", new Object[]{count, actualCount})).isEqualTo(count);
        return (S)((Object)((AbstractPreferenceGroupAssert)this.myself));
    }

    public S isOrderingAsAdded() {
        this.isNotNull();
        ((BooleanAssert)Assertions.assertThat((boolean)((PreferenceGroup)this.actual).isOrderingAsAdded()).overridingErrorMessage("Expected to be ordering as added but was not.", new Object[0])).isTrue();
        return (S)((Object)((AbstractPreferenceGroupAssert)this.myself));
    }

    public S isNotOrderingAsAdded() {
        this.isNotNull();
        ((BooleanAssert)Assertions.assertThat((boolean)((PreferenceGroup)this.actual).isOrderingAsAdded()).overridingErrorMessage("Expected to not be ordering as added but was.", new Object[0])).isFalse();
        return (S)((Object)((AbstractPreferenceGroupAssert)this.myself));
    }
}

