/*
 * Decompiled with CFR 0.152.
 */
package org.fest.assertions.api.android.widget;

import android.widget.Adapter;
import org.fest.assertions.api.AbstractAssert;
import org.fest.assertions.api.Assertions;
import org.fest.assertions.api.BooleanAssert;
import org.fest.assertions.api.IntegerAssert;
import org.fest.assertions.api.ObjectAssert;

public abstract class AbstractAdapterAssert<S extends AbstractAdapterAssert<S, A>, A extends Adapter>
extends AbstractAssert<S, A> {
    protected AbstractAdapterAssert(A actual, Class<S> selfType) {
        super(actual, selfType);
    }

    public S hasCount(int count) {
        this.isNotNull();
        int actualCount = ((Adapter)this.actual).getCount();
        ((IntegerAssert)Assertions.assertThat((int)actualCount).overridingErrorMessage("Expected count <%s> but was <%s>.", new Object[]{count, actualCount})).isEqualTo(count);
        return (S)((Object)((AbstractAdapterAssert)this.myself));
    }

    public S hasViewTypeCount(int count) {
        this.isNotNull();
        int actualCount = ((Adapter)this.actual).getViewTypeCount();
        ((IntegerAssert)Assertions.assertThat((int)actualCount).overridingErrorMessage("Expected view type count <%s> but was <%s>.", new Object[]{count, actualCount})).isEqualTo(count);
        return (S)((Object)((AbstractAdapterAssert)this.myself));
    }

    public S hasStableIds() {
        this.isNotNull();
        ((BooleanAssert)Assertions.assertThat((boolean)((Adapter)this.actual).hasStableIds()).overridingErrorMessage("Expected to have stable IDs but did not.", new Object[0])).isTrue();
        return (S)((Object)((AbstractAdapterAssert)this.myself));
    }

    public S hasUnstableIds() {
        this.isNotNull();
        ((BooleanAssert)Assertions.assertThat((boolean)((Adapter)this.actual).hasStableIds()).overridingErrorMessage("Expected to not have stable IDs but.", new Object[0])).isFalse();
        return (S)((Object)((AbstractAdapterAssert)this.myself));
    }

    public S isEmpty() {
        this.isNotNull();
        ((BooleanAssert)Assertions.assertThat((boolean)((Adapter)this.actual).isEmpty()).overridingErrorMessage("Expected to be empty but was not.", new Object[0])).isTrue();
        return (S)((Object)((AbstractAdapterAssert)this.myself));
    }

    public S isNotEmpty() {
        this.isNotNull();
        ((BooleanAssert)Assertions.assertThat((boolean)((Adapter)this.actual).isEmpty()).overridingErrorMessage("Expected to not be empty but was.", new Object[0])).isFalse();
        return (S)((Object)((AbstractAdapterAssert)this.myself));
    }

    public S hasItem(Object expected, int index) {
        this.isNotNull();
        ((IntegerAssert)Assertions.assertThat((int)((Adapter)this.actual).getCount()).overridingErrorMessage("Index %s is out of bounds. The adapter holds %s items.", new Object[]{index, ((Adapter)this.actual).getCount()})).isGreaterThan(index);
        Object actualItem = ((Adapter)this.actual).getItem(index);
        ((ObjectAssert)Assertions.assertThat((Object)actualItem).overridingErrorMessage("Expected item at index %s to be <%s> but was <%s>.", new Object[]{index, expected, actualItem})).isEqualTo(expected);
        return (S)((Object)((AbstractAdapterAssert)this.myself));
    }

    public S doesNotHaveItem(Object notExpected, int index) {
        this.isNotNull();
        ((IntegerAssert)Assertions.assertThat((int)((Adapter)this.actual).getCount()).overridingErrorMessage("Index %s is out of bounds. The adapter holds %s items.", new Object[]{index, ((Adapter)this.actual).getCount()})).isGreaterThan(index);
        Object actualItem = ((Adapter)this.actual).getItem(index);
        ((ObjectAssert)Assertions.assertThat((Object)actualItem).overridingErrorMessage("Expected item at index %s not to be <%s> but it was.", new Object[]{index, notExpected, actualItem})).isNotEqualTo(notExpected);
        return (S)((Object)((AbstractAdapterAssert)this.myself));
    }
}

