/*
 * Decompiled with CFR 0.152.
 */
package com.squareup.gifencoder;

import com.squareup.gifencoder.Color;
import com.squareup.gifencoder.ColorQuantizer;
import com.squareup.gifencoder.HashMultiset;
import com.squareup.gifencoder.Multiset;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;

public final class KMeansQuantizer
implements ColorQuantizer {
    public static final KMeansQuantizer INSTANCE = new KMeansQuantizer();

    private KMeansQuantizer() {
    }

    @Override
    public Set<Color> quantize(Multiset<Color> originalColors, int maxColorCount) {
        LinkedHashMap<Color, Multiset<Color>> clustersByCentroid = new LinkedHashMap<Color, Multiset<Color>>();
        Set<Color> centroidsToRecompute = KMeansQuantizer.getInitialCentroids(originalColors, maxColorCount);
        for (Color centroid : centroidsToRecompute) {
            clustersByCentroid.put(centroid, new HashMultiset());
        }
        for (Color color : originalColors.getDistinctElements()) {
            int count = originalColors.count(color);
            ((Multiset)clustersByCentroid.get(color.getNearestColor(centroidsToRecompute))).add(color, count);
        }
        while (!centroidsToRecompute.isEmpty()) {
            KMeansQuantizer.recomputeCentroids(clustersByCentroid, centroidsToRecompute);
            centroidsToRecompute.clear();
            Set<Color> allCentroids = clustersByCentroid.keySet();
            for (Color centroid : clustersByCentroid.keySet()) {
                Multiset cluster = (Multiset)clustersByCentroid.get(centroid);
                for (Color color : new ArrayList(cluster.getDistinctElements())) {
                    Color newCentroid = color.getNearestColor(allCentroids);
                    if (newCentroid == centroid) continue;
                    int count = cluster.count(color);
                    Multiset newCluster = (Multiset)clustersByCentroid.get(newCentroid);
                    cluster.remove(color, count);
                    newCluster.add(color, count);
                    centroidsToRecompute.add(centroid);
                    centroidsToRecompute.add(newCentroid);
                }
            }
        }
        return clustersByCentroid.keySet();
    }

    private static void recomputeCentroids(Map<Color, Multiset<Color>> clustersByCentroid, Set<Color> centroidsToRecompute) {
        for (Color oldCentroid : centroidsToRecompute) {
            Multiset<Color> cluster = clustersByCentroid.get(oldCentroid);
            Color newCentroid = Color.getCentroid(cluster);
            clustersByCentroid.remove(oldCentroid);
            clustersByCentroid.put(newCentroid, cluster);
        }
    }

    private static Set<Color> getInitialCentroids(Multiset<Color> originalColors, int maxColorCount) {
        ArrayList<Color> colorList = new ArrayList<Color>(originalColors.getDistinctElements());
        Collections.shuffle(colorList);
        return new HashSet<Color>(colorList.subList(0, maxColorCount));
    }
}

