/*
 * Decompiled with CFR 0.152.
 */
package com.squareup.gifencoder;

import com.squareup.gifencoder.Multiset;
import java.util.Collection;

public final class Color {
    public static final Color BLACK = new Color(0.0, 0.0, 0.0);
    public static final Color WHITE = new Color(1.0, 1.0, 1.0);
    public static final Color RED = new Color(1.0, 0.0, 0.0);
    public static final Color GREEN = new Color(0.0, 1.0, 0.0);
    public static final Color BLUE = new Color(0.0, 0.0, 1.0);
    private final double red;
    private final double green;
    private final double blue;

    public Color(double red, double green, double blue) {
        this.red = red;
        this.green = green;
        this.blue = blue;
    }

    public static Color fromRgbInt(int rgb) {
        int redComponent = rgb >>> 16 & 0xFF;
        int greenComponent = rgb >>> 8 & 0xFF;
        int blueComponent = rgb & 0xFF;
        return new Color((double)redComponent / 255.0, (double)greenComponent / 255.0, (double)blueComponent / 255.0);
    }

    public static Color getCentroid(Multiset<Color> colors) {
        Color sum = BLACK;
        for (Color color : colors.getDistinctElements()) {
            int weight = colors.count(color);
            sum = sum.plus(color.scaled(weight));
        }
        return sum.scaled(1.0 / (double)colors.size());
    }

    public double getComponent(int index) {
        switch (index) {
            case 0: {
                return this.red;
            }
            case 1: {
                return this.green;
            }
            case 2: {
                return this.blue;
            }
        }
        throw new IllegalArgumentException("Unexpected component index: " + index);
    }

    public Color scaled(double s) {
        return new Color(s * this.red, s * this.green, s * this.blue);
    }

    public Color plus(Color that) {
        return new Color(this.red + that.red, this.green + that.green, this.blue + that.blue);
    }

    public Color minus(Color that) {
        return new Color(this.red - that.red, this.green - that.green, this.blue - that.blue);
    }

    public double getEuclideanDistanceTo(Color that) {
        Color d = this.minus(that);
        double sumOfSquares = d.red * d.red + d.green * d.green + d.blue * d.blue;
        return Math.sqrt(sumOfSquares);
    }

    public Color getNearestColor(Collection<Color> colors) {
        Color nearestCentroid = null;
        double nearestCentroidDistance = Double.POSITIVE_INFINITY;
        for (Color color : colors) {
            double distance = this.getEuclideanDistanceTo(color);
            if (!(distance < nearestCentroidDistance)) continue;
            nearestCentroid = color;
            nearestCentroidDistance = distance;
        }
        return nearestCentroid;
    }

    public int getRgbInt() {
        int redComponent = (int)(this.red * 255.0);
        int greenComponent = (int)(this.green * 255.0);
        int blueComponent = (int)(this.blue * 255.0);
        return redComponent << 16 | greenComponent << 8 | blueComponent;
    }

    public boolean equals(Object o) {
        if (!(o instanceof Color)) {
            return false;
        }
        Color that = (Color)o;
        return this.red == that.red && this.green == that.green && this.blue == that.blue;
    }

    public int hashCode() {
        long temp = Double.doubleToLongBits(this.red);
        int result = (int)(temp ^ temp >>> 32);
        temp = Double.doubleToLongBits(this.green);
        result = 31 * result + (int)(temp ^ temp >>> 32);
        temp = Double.doubleToLongBits(this.blue);
        result = 31 * result + (int)(temp ^ temp >>> 32);
        return result;
    }

    public String toString() {
        return String.format("Color[%f, %f, %f]", this.red, this.green, this.blue);
    }
}

