/*
 * Decompiled with CFR 0.152.
 */
package com.squareup.gifencoder;

import com.squareup.gifencoder.Color;
import com.squareup.gifencoder.Ditherer;
import com.squareup.gifencoder.Image;
import java.util.Set;

public final class FloydSteinbergDitherer
implements Ditherer {
    public static final FloydSteinbergDitherer INSTANCE = new FloydSteinbergDitherer();
    private static final ErrorComponent[] ERROR_DISTRIBUTION = new ErrorComponent[]{new ErrorComponent(1, 0, 0.4375), new ErrorComponent(-1, 1, 0.1875), new ErrorComponent(0, 1, 0.3125), new ErrorComponent(1, 1, 0.0625)};

    private FloydSteinbergDitherer() {
    }

    @Override
    public Image dither(Image image, Set<Color> newColors) {
        int x;
        int y;
        int width = image.getWidth();
        int height = image.getHeight();
        Color[][] colors = new Color[height][width];
        for (y = 0; y < height; ++y) {
            for (x = 0; x < width; ++x) {
                colors[y][x] = image.getColor(x, y);
            }
        }
        for (y = 0; y < height; ++y) {
            for (x = 0; x < width; ++x) {
                Color replacementColor;
                Color originalColor = colors[y][x];
                colors[y][x] = replacementColor = originalColor.getNearestColor(newColors);
                Color error = originalColor.minus(replacementColor);
                for (ErrorComponent component : ERROR_DISTRIBUTION) {
                    int siblingX = x + component.deltaX;
                    int siblingY = y + component.deltaY;
                    if (siblingX < 0 || siblingY < 0 || siblingX >= width || siblingY >= height) continue;
                    Color errorComponent = error.scaled(component.errorFraction);
                    colors[siblingY][siblingX] = colors[siblingY][siblingX].plus(errorComponent);
                }
            }
        }
        return Image.fromColors(colors);
    }

    private static final class ErrorComponent {
        final int deltaX;
        final int deltaY;
        final double errorFraction;

        ErrorComponent(int deltaX, int deltaY, double errorFraction) {
            this.deltaX = deltaX;
            this.deltaY = deltaY;
            this.errorFraction = errorFraction;
        }
    }
}

