/*
 * Decompiled with CFR 0.152.
 */
package com.squareup.gifencoder;

import com.squareup.gifencoder.Color;
import com.squareup.gifencoder.ColorTable;
import com.squareup.gifencoder.GraphicsControlExtensionBlock;
import com.squareup.gifencoder.HeaderBlock;
import com.squareup.gifencoder.Image;
import com.squareup.gifencoder.ImageDataBlock;
import com.squareup.gifencoder.ImageDescriptorBlock;
import com.squareup.gifencoder.ImageOptions;
import com.squareup.gifencoder.LogicalScreenDescriptorBlock;
import com.squareup.gifencoder.LzwEncoder;
import com.squareup.gifencoder.Multiset;
import com.squareup.gifencoder.NetscapeLoopingExtensionBlock;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Set;

public final class GifEncoder {
    private static final int MAX_COLOR_COUNT = 256;
    private final OutputStream outputStream;
    private final int screenWidth;
    private final int screenHeight;

    public GifEncoder(OutputStream outputStream, int screenWidth, int screenHeight, int loopCount) throws IOException {
        this.outputStream = outputStream;
        this.screenWidth = screenWidth;
        this.screenHeight = screenHeight;
        HeaderBlock.write(outputStream);
        LogicalScreenDescriptorBlock.write(outputStream, screenWidth, screenHeight, false, 1, false, 0, 0, 0);
        NetscapeLoopingExtensionBlock.write(outputStream, loopCount);
    }

    public GifEncoder addImage(int[][] rgbData, ImageOptions options) throws IOException {
        this.addImage(Image.fromRgb(rgbData), options);
        return this;
    }

    public GifEncoder addImage(int[] rgbData, int width, ImageOptions options) throws IOException {
        this.addImage(Image.fromRgb(rgbData, width), options);
        return this;
    }

    public synchronized void finishEncoding() throws IOException {
        this.outputStream.write(59);
    }

    public synchronized void addImage(Image image, ImageOptions options) throws IOException {
        if (options.left + image.getWidth() > this.screenWidth || options.top + image.getHeight() > this.screenHeight) {
            throw new IllegalArgumentException("Image does not fit in screen.");
        }
        Multiset<Color> originalColors = image.getColors();
        Set<Color> distinctColors = originalColors.getDistinctElements();
        if (distinctColors.size() > 256) {
            distinctColors = options.quantizer.quantize(originalColors, 256);
            image = options.ditherer.dither(image, distinctColors);
        }
        ColorTable colorTable = ColorTable.fromColors(distinctColors);
        int paddedColorCount = colorTable.paddedSize();
        int[] colorIndices = colorTable.getIndices(image);
        GraphicsControlExtensionBlock.write(this.outputStream, options.disposalMethod, false, false, options.delayCentiseconds, 0);
        ImageDescriptorBlock.write(this.outputStream, options.left, options.top, image.getWidth(), image.getHeight(), true, false, false, GifEncoder.getColorTableSizeField(paddedColorCount));
        colorTable.write(this.outputStream);
        LzwEncoder lzwEncoder = new LzwEncoder(paddedColorCount);
        byte[] lzwData = lzwEncoder.encode(colorIndices);
        ImageDataBlock.write(this.outputStream, lzwEncoder.getMinimumCodeSize(), lzwData);
    }

    private static int getColorTableSizeField(int actualTableSize) {
        int size = 0;
        while (1 << size + 1 < actualTableSize) {
            ++size;
        }
        return size;
    }
}

