/*
 * Decompiled with CFR 0.152.
 */
package com.squareup.gifencoder;

import com.squareup.gifencoder.Color;
import com.squareup.gifencoder.HashMultiset;
import com.squareup.gifencoder.Multiset;

public final class Image {
    private final Color[][] colors;

    private Image(Color[][] colors) {
        this.colors = colors;
    }

    public static Image fromColors(Color[][] colors) {
        return new Image(colors);
    }

    public static Image fromRgb(int[][] rgb) {
        int height = rgb.length;
        int width = rgb[0].length;
        Color[][] colors = new Color[height][width];
        for (int y = 0; y < height; ++y) {
            if (rgb[y].length != width) {
                throw new IllegalArgumentException("rows lengths do not match in RGB array");
            }
            for (int x = 0; x < width; ++x) {
                colors[y][x] = Color.fromRgbInt(rgb[y][x]);
            }
        }
        return new Image(colors);
    }

    public static Image fromRgb(int[] rgb, int width) {
        if (rgb.length % width != 0) {
            throw new IllegalArgumentException("the given width does not divide the number of pixels");
        }
        int height = rgb.length / width;
        Color[][] colors = new Color[height][width];
        for (int y = 0; y < height; ++y) {
            for (int x = 0; x < width; ++x) {
                colors[y][x] = Color.fromRgbInt(rgb[y * width + x]);
            }
        }
        return new Image(colors);
    }

    public Color getColor(int x, int y) {
        return this.colors[y][x];
    }

    public Color getColor(int index) {
        return this.colors[index / this.getWidth()][index % this.getWidth()];
    }

    Multiset<Color> getColors() {
        HashMultiset<Color> colorCounts = new HashMultiset<Color>();
        for (int i = 0; i < this.getNumPixels(); ++i) {
            Color color = this.getColor(i);
            colorCounts.add(color);
        }
        return colorCounts;
    }

    public int getWidth() {
        return this.colors[0].length;
    }

    public int getHeight() {
        return this.colors.length;
    }

    public int getNumPixels() {
        return this.getWidth() * this.getHeight();
    }
}

