/*
 * Decompiled with CFR 0.152.
 */
package com.squareup.gifencoder;

import com.squareup.gifencoder.Color;
import com.squareup.gifencoder.Ditherer;
import com.squareup.gifencoder.Image;
import java.util.Set;

public final class NearestColorDitherer
implements Ditherer {
    public static final NearestColorDitherer INSTANCE = new NearestColorDitherer();

    private NearestColorDitherer() {
    }

    @Override
    public Image dither(Image image, Set<Color> newColors) {
        int width = image.getWidth();
        int height = image.getHeight();
        Color[][] colors = new Color[height][width];
        for (int y = 0; y < height; ++y) {
            for (int x = 0; x < width; ++x) {
                colors[y][x] = image.getColor(x, y).getNearestColor(newColors);
            }
        }
        return Image.fromColors(colors);
    }
}

