/*
 * Decompiled with CFR 0.152.
 */
package com.squareup.gifencoder;

import com.squareup.gifencoder.Color;
import com.squareup.gifencoder.ColorQuantizer;
import com.squareup.gifencoder.Multiset;
import java.util.HashSet;
import java.util.Set;

public final class UniformQuantizer
implements ColorQuantizer {
    public static final UniformQuantizer INSTANCE = new UniformQuantizer();

    private UniformQuantizer() {
    }

    @Override
    public Set<Color> quantize(Multiset<Color> originalColors, int maxColorCount) {
        int blueSegments;
        int greenSegments;
        int baseSegments = (int)Math.pow(maxColorCount, 0.3333333333333333);
        int redSegments = baseSegments;
        if (redSegments * ((greenSegments = baseSegments) + 1) * (blueSegments = baseSegments) <= maxColorCount) {
            ++greenSegments;
        }
        if ((redSegments + 1) * greenSegments * blueSegments <= maxColorCount) {
            ++redSegments;
        }
        HashSet<Color> colors = new HashSet<Color>();
        for (int redSegment = 0; redSegment < redSegments; ++redSegment) {
            for (int greenSegment = 0; greenSegment < greenSegments; ++greenSegment) {
                for (int blueSegment = 0; blueSegment < blueSegments; ++blueSegment) {
                    double r = (double)redSegment / ((double)redSegments - 1.0);
                    double g = (double)greenSegment / ((double)greenSegments - 1.0);
                    double b = (double)blueSegment / ((double)blueSegments - 1.0);
                    colors.add(new Color(r, g, b));
                }
            }
        }
        return colors;
    }
}

