/*
 * Decompiled with CFR 0.152.
 */
package com.squareup.javapoet;

import com.squareup.javapoet.CodeWriter;
import com.squareup.javapoet.FieldSpec;
import com.squareup.javapoet.MethodSpec;
import com.squareup.javapoet.ParameterSpec;
import com.squareup.javapoet.TypeName;
import com.squareup.javapoet.TypeSpec;
import com.squareup.javapoet.Util;
import java.io.IOException;
import java.io.StringWriter;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import javax.lang.model.element.Element;
import javax.lang.model.type.TypeMirror;

public final class CodeBlock {
    final List<String> formatParts;
    final List<Object> args;

    private CodeBlock(Builder builder) {
        this.formatParts = Util.immutableList(builder.formatParts);
        this.args = Util.immutableList(builder.args);
    }

    public boolean isEmpty() {
        return this.formatParts.isEmpty();
    }

    public String toString() {
        StringWriter out = new StringWriter();
        try {
            new CodeWriter(out).emit(this);
            return out.toString();
        }
        catch (IOException e) {
            throw new AssertionError();
        }
    }

    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        Builder builder = new Builder();
        builder.formatParts.addAll(this.formatParts);
        builder.args.addAll(this.args);
        return builder;
    }

    public static final class Builder {
        final List<String> formatParts = new ArrayList<String>();
        final List<Object> args = new ArrayList<Object>();

        private Builder() {
        }

        public Builder add(String format, Object ... args) {
            Iterator<Object> i = Arrays.asList(args).iterator();
            int p = 0;
            while (p < format.length()) {
                int nextP;
                if (format.charAt(p) != '$') {
                    nextP = format.indexOf(36, p + 1);
                    if (nextP == -1) {
                        nextP = format.length();
                    }
                    this.formatParts.add(format.substring(p, nextP));
                } else {
                    Util.checkState(p + 1 < format.length(), "dangling $ in format string %s", format);
                    int countOfIndexCharacters = 0;
                    while (this.isSimpleDigit(format.charAt(p + countOfIndexCharacters + 1))) {
                        Util.checkArgument(format.length() > p + ++countOfIndexCharacters + 1, "Dangling format characters '%s' in format string '%s'", format.substring(p), format);
                    }
                    int argsIndex = -1;
                    if (countOfIndexCharacters != 0) {
                        argsIndex = Integer.parseInt(format.substring(p + 1, p + 1 + countOfIndexCharacters));
                        Util.checkArgument(argsIndex <= args.length, "Argument index %s in '%s' is larger than number of parameters", argsIndex, format);
                        Util.checkArgument(argsIndex > 0, "Argument index %s in '%s' is less than one, the minimum format index", argsIndex, format);
                    }
                    switch (format.charAt(p + countOfIndexCharacters + 1)) {
                        case 'N': {
                            this.args.add(this.argToName(argsIndex == -1 ? i.next() : args[argsIndex - 1]));
                            break;
                        }
                        case 'L': {
                            this.args.add(this.argToLiteral(argsIndex == -1 ? i.next() : args[argsIndex - 1]));
                            break;
                        }
                        case 'S': {
                            this.args.add(this.argToString(argsIndex == -1 ? i.next() : args[argsIndex - 1]));
                            break;
                        }
                        case 'T': {
                            this.args.add(this.argToType(argsIndex == -1 ? i.next() : args[argsIndex - 1]));
                            break;
                        }
                        case '$': 
                        case '<': 
                        case '>': 
                        case '[': 
                        case ']': {
                            Util.checkState(argsIndex == -1, "$$, $>, $<, $[ and $] may not have an index", new Object[0]);
                            break;
                        }
                        default: {
                            throw new IllegalArgumentException("invalid format string: " + format);
                        }
                    }
                    nextP = p + countOfIndexCharacters + 2;
                    this.formatParts.add(String.format("%c%c", Character.valueOf(format.charAt(p)), Character.valueOf(format.charAt(nextP - 1))));
                }
                p = nextP;
            }
            return this;
        }

        private boolean isSimpleDigit(char toCheck) {
            return toCheck >= '0' && toCheck <= '9';
        }

        private String argToName(Object o) {
            if (o instanceof CharSequence) {
                return o.toString();
            }
            if (o instanceof ParameterSpec) {
                return ((ParameterSpec)o).name;
            }
            if (o instanceof FieldSpec) {
                return ((FieldSpec)o).name;
            }
            if (o instanceof MethodSpec) {
                return ((MethodSpec)o).name;
            }
            if (o instanceof TypeSpec) {
                return ((TypeSpec)o).name;
            }
            throw new IllegalArgumentException("expected name but was " + o);
        }

        private Object argToLiteral(Object o) {
            return o;
        }

        private String argToString(Object o) {
            return o != null ? String.valueOf(o) : null;
        }

        private TypeName argToType(Object o) {
            if (o instanceof TypeName) {
                return (TypeName)o;
            }
            if (o instanceof TypeMirror) {
                return TypeName.get((TypeMirror)o);
            }
            if (o instanceof Element) {
                return TypeName.get(((Element)o).asType());
            }
            if (o instanceof Type) {
                return TypeName.get((Type)o);
            }
            throw new IllegalArgumentException("expected type but was " + o);
        }

        public Builder beginControlFlow(String controlFlow, Object ... args) {
            this.add(controlFlow + " {\n", args);
            this.indent();
            return this;
        }

        public Builder nextControlFlow(String controlFlow, Object ... args) {
            this.unindent();
            this.add("} " + controlFlow + " {\n", args);
            this.indent();
            return this;
        }

        public Builder endControlFlow() {
            this.unindent();
            this.add("}\n", new Object[0]);
            return this;
        }

        public Builder endControlFlow(String controlFlow, Object ... args) {
            this.unindent();
            this.add("} " + controlFlow + ";\n", args);
            return this;
        }

        public Builder addStatement(String format, Object ... args) {
            this.add("$[", new Object[0]);
            this.add(format, args);
            this.add(";\n$]", new Object[0]);
            return this;
        }

        public Builder add(CodeBlock codeBlock) {
            this.formatParts.addAll(codeBlock.formatParts);
            this.args.addAll(codeBlock.args);
            return this;
        }

        public Builder indent() {
            this.formatParts.add("$>");
            return this;
        }

        public Builder unindent() {
            this.formatParts.add("$<");
            return this;
        }

        public CodeBlock build() {
            return new CodeBlock(this);
        }
    }
}

