/*
 * Decompiled with CFR 0.152.
 */
package com.squareup.java;

import java.io.Closeable;
import java.io.IOException;
import java.io.Writer;
import java.lang.annotation.Annotation;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeSet;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public final class JavaWriter
implements Closeable {
    private static final Pattern TYPE_PATTERN = Pattern.compile("(?:[\\w$]+\\.)*([\\w$]+)");
    private static final String INDENT = "  ";
    private final Map<String, String> importedTypes = new LinkedHashMap<String, String>();
    private String packagePrefix;
    private final List<Scope> scopes = new ArrayList<Scope>();
    private final Writer out;

    public JavaWriter(Writer out) {
        this.out = out;
    }

    public JavaWriter emitPackage(String packageName) throws IOException {
        if (this.packagePrefix != null) {
            throw new IllegalStateException();
        }
        if (packageName.isEmpty()) {
            this.packagePrefix = "";
        } else {
            this.out.write("package ");
            this.out.write(packageName);
            this.out.write(";\n\n");
            this.packagePrefix = packageName + ".";
        }
        return this;
    }

    public JavaWriter emitImports(String ... types) throws IOException {
        return this.emitImports(Arrays.asList(types));
    }

    public JavaWriter emitImports(Collection<String> types) throws IOException {
        for (String type : new TreeSet<String>(types)) {
            Matcher matcher = TYPE_PATTERN.matcher(type);
            if (!matcher.matches()) {
                throw new IllegalArgumentException(type);
            }
            if (this.importedTypes.put(type, matcher.group(1)) != null) {
                throw new IllegalArgumentException(type);
            }
            this.out.write("import ");
            this.out.write(type);
            this.out.write(";\n");
        }
        return this;
    }

    private JavaWriter emitType(String type) throws IOException {
        this.out.write(this.compressType(type));
        return this;
    }

    public String compressType(String type) {
        StringBuilder sb = new StringBuilder();
        if (this.packagePrefix == null) {
            throw new IllegalStateException();
        }
        Matcher m = TYPE_PATTERN.matcher(type);
        int pos = 0;
        while (true) {
            boolean found;
            int typeStart = (found = m.find(pos)) ? m.start() : type.length();
            sb.append(type, pos, typeStart);
            if (!found) break;
            String name = m.group(0);
            String imported = this.importedTypes.get(name);
            if (imported != null) {
                sb.append(imported);
            } else if (this.isClassInPackage(name)) {
                sb.append(name.substring(this.packagePrefix.length()));
            } else if (name.startsWith("java.lang.")) {
                sb.append(name.substring("java.lang.".length()));
            } else {
                sb.append(name);
            }
            pos = m.end();
        }
        return sb.toString();
    }

    private boolean isClassInPackage(String name) {
        if (name.startsWith(this.packagePrefix)) {
            if (name.indexOf(46, this.packagePrefix.length()) == -1) {
                return true;
            }
            int index = name.indexOf(46);
            if (name.substring(index + 1, index + 2).matches("[A-Z]")) {
                return true;
            }
        }
        return false;
    }

    public JavaWriter beginType(String type, String kind, int modifiers) throws IOException {
        return this.beginType(type, kind, modifiers, null, new String[0]);
    }

    public JavaWriter beginType(String type, String kind, int modifiers, String extendsType, String ... implementsTypes) throws IOException {
        this.indent();
        this.out.write(JavaWriter.modifiers(modifiers));
        this.out.write(kind);
        this.out.write(" ");
        this.emitType(type);
        if (extendsType != null) {
            this.out.write(" extends ");
            this.emitType(extendsType);
        }
        if (implementsTypes.length > 0) {
            this.out.write("\n");
            this.indent();
            this.out.write("    implements ");
            for (int i = 0; i < implementsTypes.length; ++i) {
                if (i != 0) {
                    this.out.write(", ");
                }
                this.emitType(implementsTypes[i]);
            }
        }
        this.out.write(" {\n");
        this.pushScope(Scope.TYPE_DECLARATION);
        return this;
    }

    public JavaWriter endType() throws IOException {
        this.popScope(Scope.TYPE_DECLARATION);
        this.indent();
        this.out.write("}\n");
        return this;
    }

    public JavaWriter emitField(String type, String name, int modifiers) throws IOException {
        return this.emitField(type, name, modifiers, null);
    }

    public JavaWriter emitField(String type, String name, int modifiers, String initialValue) throws IOException {
        this.indent();
        this.out.write(JavaWriter.modifiers(modifiers));
        this.emitType(type);
        this.out.write(" ");
        this.out.write(name);
        if (initialValue != null) {
            this.out.write(" = ");
            this.out.write(initialValue);
        }
        this.out.write(";\n");
        return this;
    }

    public JavaWriter beginMethod(String returnType, String name, int modifiers, String ... parameters) throws IOException {
        this.indent();
        this.out.write(JavaWriter.modifiers(modifiers));
        if (returnType != null) {
            this.emitType(returnType);
            this.out.write(" ");
            this.out.write(name);
        } else {
            this.emitType(name);
        }
        this.out.write("(");
        int p = 0;
        while (p < parameters.length) {
            if (p != 0) {
                this.out.write(", ");
            }
            this.emitType(parameters[p++]);
            this.out.write(" ");
            this.emitType(parameters[p++]);
        }
        this.out.write(")");
        if ((modifiers & 0x400) != 0) {
            this.out.write(";\n");
            this.pushScope(Scope.ABSTRACT_METHOD);
        } else {
            this.out.write(" {\n");
            this.pushScope(Scope.NON_ABSTRACT_METHOD);
        }
        return this;
    }

    public JavaWriter emitJavadoc(String javadoc, Object ... params) throws IOException {
        String formatted = String.format(javadoc, params);
        this.indent();
        this.out.write("/**\n");
        for (String line : formatted.split("\n")) {
            this.indent();
            this.out.write(" * ");
            this.out.write(line);
            this.out.write("\n");
        }
        this.indent();
        this.out.write(" */\n");
        return this;
    }

    public JavaWriter emitEndOfLineComment(String comment, Object ... args) throws IOException {
        this.out.write("// ");
        this.out.write(String.format(comment, args));
        this.out.write("\n");
        return this;
    }

    public JavaWriter emitEmptyLine() throws IOException {
        this.out.write("\n");
        return this;
    }

    public JavaWriter emitEnumValue(String name) throws IOException {
        this.indent();
        this.out.write(name);
        this.out.write(",\n");
        return this;
    }

    public JavaWriter emitAnnotation(String annotation) throws IOException {
        return this.emitAnnotation(annotation, Collections.emptyMap());
    }

    public JavaWriter emitAnnotation(Class<? extends Annotation> annotationType) throws IOException {
        return this.emitAnnotation(JavaWriter.type(annotationType, new String[0]), Collections.emptyMap());
    }

    public JavaWriter emitAnnotation(Class<? extends Annotation> annotationType, Object value) throws IOException {
        return this.emitAnnotation(JavaWriter.type(annotationType, new String[0]), value);
    }

    public JavaWriter emitAnnotation(String annotation, Object value) throws IOException {
        this.indent();
        this.out.write("@");
        this.emitType(annotation);
        this.out.write("(");
        this.emitAnnotationValue(value);
        this.out.write(")");
        this.out.write("\n");
        return this;
    }

    public JavaWriter emitAnnotation(Class<? extends Annotation> annotationType, Map<String, ?> attributes) throws IOException {
        return this.emitAnnotation(JavaWriter.type(annotationType, new String[0]), attributes);
    }

    public JavaWriter emitAnnotation(String annotation, Map<String, ?> attributes) throws IOException {
        this.indent();
        this.out.write("@");
        this.emitType(annotation);
        if (!attributes.isEmpty()) {
            this.out.write("(");
            this.pushScope(Scope.ANNOTATION_ATTRIBUTE);
            boolean firstAttribute = true;
            for (Map.Entry<String, ?> entry : attributes.entrySet()) {
                if (firstAttribute) {
                    firstAttribute = false;
                    this.out.write("\n");
                } else {
                    this.out.write(",\n");
                }
                this.indent();
                this.out.write(entry.getKey());
                this.out.write(" = ");
                Object value = entry.getValue();
                this.emitAnnotationValue(value);
            }
            this.popScope(Scope.ANNOTATION_ATTRIBUTE);
            this.out.write("\n");
            this.indent();
            this.out.write(")");
        }
        this.out.write("\n");
        return this;
    }

    private JavaWriter emitAnnotationValue(Object value) throws IOException {
        if (value instanceof Object[]) {
            this.out.write("{");
            boolean firstValue = true;
            this.pushScope(Scope.ANNOTATION_ARRAY_VALUE);
            for (Object o : (Object[])value) {
                if (firstValue) {
                    firstValue = false;
                    this.out.write("\n");
                } else {
                    this.out.write(",\n");
                }
                this.indent();
                this.out.write(o.toString());
            }
            this.popScope(Scope.ANNOTATION_ARRAY_VALUE);
            this.out.write("\n");
            this.indent();
            this.out.write("}");
        } else {
            this.out.write(value.toString());
        }
        return this;
    }

    public JavaWriter emitStatement(String pattern, Object ... args) throws IOException {
        this.checkInMethod();
        String[] lines = String.format(pattern, args).split("\n", -1);
        this.indent();
        this.out.write(lines[0]);
        for (int i = 1; i < lines.length; ++i) {
            this.out.write("\n");
            this.hangingIndent();
            this.out.write(lines[i]);
        }
        this.out.write(";\n");
        return this;
    }

    public JavaWriter beginControlFlow(String controlFlow) throws IOException {
        this.checkInMethod();
        this.indent();
        this.out.write(controlFlow);
        this.out.write(" {\n");
        this.pushScope(Scope.CONTROL_FLOW);
        return this;
    }

    public JavaWriter nextControlFlow(String controlFlow) throws IOException {
        this.popScope(Scope.CONTROL_FLOW);
        this.indent();
        this.pushScope(Scope.CONTROL_FLOW);
        this.out.write("} ");
        this.out.write(controlFlow);
        this.out.write(" {\n");
        return this;
    }

    public JavaWriter endControlFlow() throws IOException {
        return this.endControlFlow(null);
    }

    public JavaWriter endControlFlow(String controlFlow) throws IOException {
        this.popScope(Scope.CONTROL_FLOW);
        this.indent();
        if (controlFlow != null) {
            this.out.write("} ");
            this.out.write(controlFlow);
            this.out.write(";\n");
        } else {
            this.out.write("}\n");
        }
        return this;
    }

    public JavaWriter endMethod() throws IOException {
        Scope popped = this.popScope();
        if (popped == Scope.NON_ABSTRACT_METHOD) {
            this.indent();
            this.out.write("}\n");
        } else if (popped != Scope.ABSTRACT_METHOD) {
            throw new IllegalStateException();
        }
        return this;
    }

    public static String stringLiteral(String data) {
        StringBuilder result = new StringBuilder();
        result.append('\"');
        block9: for (int i = 0; i < data.length(); ++i) {
            char c = data.charAt(i);
            switch (c) {
                case '\"': {
                    result.append("\\\"");
                    continue block9;
                }
                case '\\': {
                    result.append("\\\\");
                    continue block9;
                }
                case '\t': {
                    result.append("\\\t");
                    continue block9;
                }
                case '\b': {
                    result.append("\\\b");
                    continue block9;
                }
                case '\n': {
                    result.append("\\\n");
                    continue block9;
                }
                case '\r': {
                    result.append("\\\r");
                    continue block9;
                }
                case '\f': {
                    result.append("\\\f");
                    continue block9;
                }
                default: {
                    result.append(c);
                }
            }
        }
        result.append('\"');
        return result.toString();
    }

    public static String type(Class<?> raw, String ... parameters) {
        if (parameters.length == 0) {
            return raw.getCanonicalName();
        }
        if (raw.getTypeParameters().length != parameters.length) {
            throw new IllegalArgumentException();
        }
        StringBuilder result = new StringBuilder();
        result.append(raw.getCanonicalName());
        result.append("<");
        result.append(parameters[0]);
        for (int i = 1; i < parameters.length; ++i) {
            result.append(", ");
            result.append(parameters[i]);
        }
        result.append(">");
        return result.toString();
    }

    @Override
    public void close() throws IOException {
        this.out.close();
    }

    static String modifiers(int modifiers) {
        StringBuilder out = new StringBuilder();
        if ((modifiers & 1) != 0) {
            out.append("public ");
        }
        if ((modifiers & 2) != 0) {
            out.append("private ");
        }
        if ((modifiers & 4) != 0) {
            out.append("protected ");
        }
        if ((modifiers & 8) != 0) {
            out.append("static ");
        }
        if ((modifiers & 0x10) != 0) {
            out.append("final ");
        }
        if ((modifiers & 0x400) != 0) {
            out.append("abstract ");
        }
        if ((modifiers & 0x20) != 0) {
            out.append("synchronized ");
        }
        if ((modifiers & 0x80) != 0) {
            out.append("transient ");
        }
        if ((modifiers & 0x40) != 0) {
            out.append("volatile ");
        }
        return out.toString();
    }

    private void indent() throws IOException {
        int count = this.scopes.size();
        for (int i = 0; i < count; ++i) {
            this.out.write(INDENT);
        }
    }

    private void hangingIndent() throws IOException {
        int count = this.scopes.size() + 2;
        for (int i = 0; i < count; ++i) {
            this.out.write(INDENT);
        }
    }

    private void checkInMethod() {
        Scope scope = this.peekScope();
        if (scope != Scope.NON_ABSTRACT_METHOD && scope != Scope.CONTROL_FLOW) {
            throw new IllegalArgumentException();
        }
    }

    private void pushScope(Scope pushed) {
        this.scopes.add(pushed);
    }

    private Scope peekScope() {
        return this.scopes.get(this.scopes.size() - 1);
    }

    private Scope popScope() {
        return this.scopes.remove(this.scopes.size() - 1);
    }

    private void popScope(Scope expected) {
        if (this.scopes.remove(this.scopes.size() - 1) != expected) {
            throw new IllegalStateException();
        }
    }

    private static enum Scope {
        TYPE_DECLARATION,
        ABSTRACT_METHOD,
        NON_ABSTRACT_METHOD,
        CONTROL_FLOW,
        ANNOTATION_ATTRIBUTE,
        ANNOTATION_ARRAY_VALUE;

    }
}

