/*
 * Decompiled with CFR 0.152.
 */
package com.squareup.kotlinpoet;

import com.squareup.kotlinpoet.AnnotationSpec;
import com.squareup.kotlinpoet.ClassName;
import com.squareup.kotlinpoet.CodeBlock;
import com.squareup.kotlinpoet.CodeWriter;
import com.squareup.kotlinpoet.FunSpec$Builder$WhenMappings;
import com.squareup.kotlinpoet.KModifier;
import com.squareup.kotlinpoet.ParameterSpec;
import com.squareup.kotlinpoet.TypeName;
import com.squareup.kotlinpoet.TypeSpec;
import com.squareup.kotlinpoet.TypeVariableName;
import com.squareup.kotlinpoet.Util;
import java.io.IOException;
import java.io.StringWriter;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.lang.model.AnnotatedConstruct;
import javax.lang.model.SourceVersion;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.Modifier;
import javax.lang.model.element.TypeParameterElement;
import javax.lang.model.type.DeclaredType;
import javax.lang.model.type.ExecutableType;
import javax.lang.model.type.TypeMirror;
import javax.lang.model.type.TypeVariable;
import javax.lang.model.util.Types;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.Strictfp;
import kotlin.jvm.Synchronized;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import kotlin.jvm.internal.Reflection;
import kotlin.reflect.KClass;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 6}, bv={1, 0, 1}, k=1, d1={"\u0000p\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0010\b\n\u0002\b\u0006\u0018\u0000 ?2\u00020\u0001:\u0002>?B\u000f\b\u0002\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J-\u0010.\u001a\u00020/2\u0006\u00100\u001a\u0002012\b\u00102\u001a\u0004\u0018\u00010\u001e2\f\u00103\u001a\b\u0012\u0004\u0012\u00020\u001a0\u0019H\u0001\u00a2\u0006\u0002\b4J\u0015\u00105\u001a\u00020/2\u0006\u00100\u001a\u000201H\u0001\u00a2\u0006\u0002\b6J\u0013\u00107\u001a\u00020\u00142\b\u00108\u001a\u0004\u0018\u00010\u0001H\u0096\u0002J\b\u00109\u001a\u00020:H\u0016J\u0016\u0010;\u001a\u00020\u00142\f\u0010!\u001a\b\u0012\u0004\u0012\u00020\"0\u0006H\u0002J\u0006\u0010<\u001a\u00020\u0003J\b\u0010=\u001a\u00020\u001eH\u0016R\u0017\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0011\u0010\n\u001a\u00020\u000b\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0013\u0010\u000e\u001a\u0004\u0018\u00010\u000b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\rR\u0017\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00110\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\tR\u0011\u0010\u0013\u001a\u00020\u00148F\u00a2\u0006\u0006\u001a\u0004\b\u0013\u0010\u0015R\u0011\u0010\u0016\u001a\u00020\u000b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0017\u0010\rR\u0017\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\u001a0\u0019\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001b\u0010\u001cR\u0011\u0010\u001d\u001a\u00020\u001e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001f\u0010 R\u0017\u0010!\u001a\b\u0012\u0004\u0012\u00020\"0\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b#\u0010\tR\u0013\u0010$\u001a\u0004\u0018\u00010\u0011\u00a2\u0006\b\n\u0000\u001a\u0004\b%\u0010&R\u0013\u0010'\u001a\u0004\u0018\u00010\u0011\u00a2\u0006\b\n\u0000\u001a\u0004\b(\u0010&R\u0017\u0010)\u001a\b\u0012\u0004\u0012\u00020*0\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b+\u0010\tR\u0011\u0010,\u001a\u00020\u0014\u00a2\u0006\b\n\u0000\u001a\u0004\b-\u0010\u0015\u00a8\u0006@"}, d2={"Lcom/squareup/kotlinpoet/FunSpec;", "", "builder", "Lcom/squareup/kotlinpoet/FunSpec$Builder;", "(Lcom/squareup/kotlinpoet/FunSpec$Builder;)V", "annotations", "", "Lcom/squareup/kotlinpoet/AnnotationSpec;", "getAnnotations", "()Ljava/util/List;", "code", "Lcom/squareup/kotlinpoet/CodeBlock;", "getCode", "()Lcom/squareup/kotlinpoet/CodeBlock;", "defaultValue", "getDefaultValue", "exceptions", "Lcom/squareup/kotlinpoet/TypeName;", "getExceptions", "isConstructor", "", "()Z", "kdoc", "getKdoc", "modifiers", "", "Lcom/squareup/kotlinpoet/KModifier;", "getModifiers", "()Ljava/util/Set;", "name", "", "getName", "()Ljava/lang/String;", "parameters", "Lcom/squareup/kotlinpoet/ParameterSpec;", "getParameters", "receiverType", "getReceiverType", "()Lcom/squareup/kotlinpoet/TypeName;", "returnType", "getReturnType", "typeVariables", "Lcom/squareup/kotlinpoet/TypeVariableName;", "getTypeVariables", "varargs", "getVarargs", "emit", "", "codeWriter", "Lcom/squareup/kotlinpoet/CodeWriter;", "enclosingName", "implicitModifiers", "emit$kotlinpoet", "emitParameterList", "emitParameterList$kotlinpoet", "equals", "other", "hashCode", "", "lastParameterIsArray", "toBuilder", "toString", "Builder", "Companion", "kotlinpoet"})
public final class FunSpec {
    @NotNull
    private final String name;
    @NotNull
    private final CodeBlock kdoc;
    @NotNull
    private final List<AnnotationSpec> annotations;
    @NotNull
    private final Set<KModifier> modifiers;
    @NotNull
    private final List<TypeVariableName> typeVariables;
    @Nullable
    private final TypeName receiverType;
    @Nullable
    private final TypeName returnType;
    @NotNull
    private final List<ParameterSpec> parameters;
    private final boolean varargs;
    @NotNull
    private final List<TypeName> exceptions;
    @NotNull
    private final CodeBlock code;
    @Nullable
    private final CodeBlock defaultValue;
    @NotNull
    public static final String CONSTRUCTOR = "<init>";
    public static final Companion Companion = new Companion(null);

    @NotNull
    public final String getName() {
        return this.name;
    }

    @NotNull
    public final CodeBlock getKdoc() {
        return this.kdoc;
    }

    @NotNull
    public final List<AnnotationSpec> getAnnotations() {
        return this.annotations;
    }

    @NotNull
    public final Set<KModifier> getModifiers() {
        return this.modifiers;
    }

    @NotNull
    public final List<TypeVariableName> getTypeVariables() {
        return this.typeVariables;
    }

    @Nullable
    public final TypeName getReceiverType() {
        return this.receiverType;
    }

    @Nullable
    public final TypeName getReturnType() {
        return this.returnType;
    }

    @NotNull
    public final List<ParameterSpec> getParameters() {
        return this.parameters;
    }

    public final boolean getVarargs() {
        return this.varargs;
    }

    @NotNull
    public final List<TypeName> getExceptions() {
        return this.exceptions;
    }

    @NotNull
    public final CodeBlock getCode() {
        return this.code;
    }

    @Nullable
    public final CodeBlock getDefaultValue() {
        return this.defaultValue;
    }

    private final boolean lastParameterIsArray(List<ParameterSpec> parameters) {
        return !parameters.isEmpty() && TypeName.Companion.arrayComponent(parameters.get(parameters.size() - 1).getType()) != null;
    }

    public final void emit$kotlinpoet(@NotNull CodeWriter codeWriter, @Nullable String enclosingName, @NotNull Set<? extends KModifier> implicitModifiers) throws IOException {
        Intrinsics.checkParameterIsNotNull((Object)codeWriter, (String)"codeWriter");
        Intrinsics.checkParameterIsNotNull(implicitModifiers, (String)"implicitModifiers");
        codeWriter.emitKdoc(this.kdoc);
        codeWriter.emitAnnotations(this.annotations, false);
        codeWriter.emitModifiers(this.modifiers, implicitModifiers);
        if (!this.isConstructor()) {
            codeWriter.emit("fun ");
        }
        if (!this.typeVariables.isEmpty()) {
            codeWriter.emitTypeVariables(this.typeVariables);
            codeWriter.emit(" ");
        }
        if (this.isConstructor()) {
            codeWriter.emit("constructor", enclosingName);
        } else {
            if (this.receiverType != null) {
                codeWriter.emit("%T.", this.receiverType);
            }
            codeWriter.emit("%L", this.name);
        }
        this.emitParameterList$kotlinpoet(codeWriter);
        if (this.returnType != null) {
            codeWriter.emit(": %T", this.returnType);
        }
        if (this.defaultValue != null && !this.defaultValue.isEmpty()) {
            codeWriter.emit(" default ");
            codeWriter.emit(this.defaultValue);
        }
        if (!this.exceptions.isEmpty()) {
            codeWriter.emitWrappingSpace().emit("throws");
            boolean firstException = true;
            for (TypeName exception : this.exceptions) {
                if (!firstException) {
                    codeWriter.emit(",");
                }
                codeWriter.emitWrappingSpace().emit("%T", exception);
                firstException = false;
            }
        }
        if (this.modifiers.contains((Object)KModifier.ABSTRACT) || this.modifiers.contains((Object)KModifier.EXTERNAL)) {
            codeWriter.emit("\n");
        } else {
            codeWriter.emit(" {\n");
            CodeWriter.indent$default(codeWriter, 0, 1, null);
            codeWriter.emit(this.code);
            CodeWriter.unindent$default(codeWriter, 0, 1, null);
            codeWriter.emit("}\n");
        }
    }

    public final void emitParameterList$kotlinpoet(@NotNull CodeWriter codeWriter) throws IOException {
        Intrinsics.checkParameterIsNotNull((Object)codeWriter, (String)"codeWriter");
        codeWriter.emit("(");
        boolean firstParameter = true;
        Iterator<ParameterSpec> i = this.parameters.iterator();
        while (i.hasNext()) {
            ParameterSpec parameter = i.next();
            if (!firstParameter) {
                codeWriter.emit(",").emitWrappingSpace();
            }
            parameter.emit$kotlinpoet(codeWriter, !i.hasNext() && this.varargs);
            firstParameter = false;
        }
        codeWriter.emit(")");
    }

    public final boolean isConstructor() {
        return Intrinsics.areEqual((Object)this.name, (Object)CONSTRUCTOR);
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (other == null) {
            return false;
        }
        if (Intrinsics.areEqual(this.getClass(), other.getClass()) ^ true) {
            return false;
        }
        return Intrinsics.areEqual((Object)this.toString(), (Object)other.toString());
    }

    public int hashCode() {
        return this.toString().hashCode();
    }

    @NotNull
    public String toString() {
        StringWriter out = new StringWriter();
        try {
            CodeWriter codeWriter = new CodeWriter(out, null, null, null, 14, null);
            this.emit$kotlinpoet(codeWriter, "Constructor", TypeSpec.Kind.CLASS.getImplicitFunctionModifiers$kotlinpoet());
            String string = out.toString();
            Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"out.toString()");
            return string;
        }
        catch (IOException e) {
            throw (Throwable)((Object)new AssertionError());
        }
    }

    @NotNull
    public final Builder toBuilder() {
        Builder builder = new Builder(this.name);
        builder.getKdoc$kotlinpoet().add(this.kdoc);
        Collection collection = builder.getAnnotations$kotlinpoet();
        Iterable iterable = this.annotations;
        CollectionsKt.addAll((Collection)collection, (Iterable)iterable);
        collection = builder.getModifiers$kotlinpoet();
        iterable = this.modifiers;
        CollectionsKt.addAll((Collection)collection, (Iterable)iterable);
        collection = builder.getTypeVariables$kotlinpoet();
        iterable = this.typeVariables;
        CollectionsKt.addAll((Collection)collection, (Iterable)iterable);
        builder.setReturnType$kotlinpoet(this.returnType);
        collection = builder.getParameters$kotlinpoet();
        iterable = this.parameters;
        CollectionsKt.addAll((Collection)collection, (Iterable)iterable);
        collection = builder.getExceptions$kotlinpoet();
        iterable = this.exceptions;
        CollectionsKt.addAll((Collection)collection, (Iterable)iterable);
        builder.getCode$kotlinpoet().add(this.code);
        builder.setVarargs$kotlinpoet(this.varargs);
        builder.setDefaultValue$kotlinpoet(this.defaultValue);
        return builder;
    }

    private FunSpec(Builder builder) {
        boolean bl;
        CodeBlock code = builder.getCode$kotlinpoet().build();
        boolean bl2 = bl = code.isEmpty() || !builder.getModifiers$kotlinpoet().contains((Object)KModifier.ABSTRACT);
        if (!bl) {
            String string = "abstract function " + builder.getName$kotlinpoet() + " cannot have code";
            throw (Throwable)new IllegalArgumentException(string.toString());
        }
        boolean bl3 = bl = !builder.getVarargs$kotlinpoet() || this.lastParameterIsArray(builder.getParameters$kotlinpoet());
        if (!bl) {
            String string = "last parameter of varargs function " + builder.getName$kotlinpoet() + " must be an array";
            throw (Throwable)new IllegalArgumentException(string.toString());
        }
        this.name = builder.getName$kotlinpoet();
        this.kdoc = builder.getKdoc$kotlinpoet().build();
        List list = Util.immutableList((Collection)builder.getAnnotations$kotlinpoet());
        Intrinsics.checkExpressionValueIsNotNull(list, (String)"Util.immutableList(builder.annotations)");
        this.annotations = list;
        Set set = Util.immutableSet((Collection)builder.getModifiers$kotlinpoet());
        Intrinsics.checkExpressionValueIsNotNull(set, (String)"Util.immutableSet(builder.modifiers)");
        this.modifiers = set;
        List list2 = Util.immutableList((Collection)builder.getTypeVariables$kotlinpoet());
        Intrinsics.checkExpressionValueIsNotNull(list2, (String)"Util.immutableList(builder.typeVariables)");
        this.typeVariables = list2;
        this.returnType = builder.getReturnType$kotlinpoet();
        this.receiverType = builder.getReceiverType$kotlinpoet();
        List list3 = Util.immutableList((Collection)builder.getParameters$kotlinpoet());
        Intrinsics.checkExpressionValueIsNotNull(list3, (String)"Util.immutableList(builder.parameters)");
        this.parameters = list3;
        this.varargs = builder.getVarargs$kotlinpoet();
        List list4 = Util.immutableList((Collection)builder.getExceptions$kotlinpoet());
        Intrinsics.checkExpressionValueIsNotNull(list4, (String)"Util.immutableList(builder.exceptions)");
        this.exceptions = list4;
        this.code = code;
        this.defaultValue = builder.getDefaultValue$kotlinpoet();
    }

    public /* synthetic */ FunSpec(@NotNull Builder builder, DefaultConstructorMarker $constructor_marker) {
        this(builder);
    }

    @JvmStatic
    @NotNull
    public static final Builder builder(@NotNull String name) {
        Intrinsics.checkParameterIsNotNull((Object)name, (String)"name");
        return Companion.builder(name);
    }

    @JvmStatic
    @NotNull
    public static final Builder constructorBuilder() {
        return Companion.constructorBuilder();
    }

    @JvmStatic
    @NotNull
    public static final Builder overriding(@NotNull ExecutableElement method) {
        Intrinsics.checkParameterIsNotNull((Object)method, (String)"method");
        return Companion.overriding(method);
    }

    @JvmStatic
    @NotNull
    public static final Builder overriding(@NotNull ExecutableElement method, @NotNull DeclaredType enclosing, @NotNull Types types) {
        Intrinsics.checkParameterIsNotNull((Object)method, (String)"method");
        Intrinsics.checkParameterIsNotNull((Object)enclosing, (String)"enclosing");
        Intrinsics.checkParameterIsNotNull((Object)types, (String)"types");
        return Companion.overriding(method, enclosing, types);
    }

    @Metadata(mv={1, 1, 6}, bv={1, 0, 1}, k=1, d1={"\u0000\u009e\u0001\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010#\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u001c\n\u0002\b\u0004\n\u0002\u0010\u0011\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010$\n\u0002\b\u000f\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u00002\u00020\u0001B\u000f\b\u0000\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u000e\u00104\u001a\u00020\u00002\u0006\u00105\u001a\u00020\u0007J\u000e\u00104\u001a\u00020\u00002\u0006\u00106\u001a\u000207J\u0012\u00104\u001a\u00020\u00002\n\u00106\u001a\u0006\u0012\u0002\b\u000308J\u0012\u00104\u001a\u00020\u00002\n\u00106\u001a\u0006\u0012\u0002\b\u000309J\u0014\u0010:\u001a\u00020\u00002\f\u0010;\u001a\b\u0012\u0004\u0012\u00020\u00070<J\u000e\u0010=\u001a\u00020\u00002\u0006\u0010>\u001a\u00020\u000fJ'\u0010=\u001a\u00020\u00002\u0006\u0010?\u001a\u00020\u00032\u0012\u0010@\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00010A\"\u00020\u0001\u00a2\u0006\u0002\u0010BJ'\u0010C\u001a\u00020\u00002\u0006\u0010?\u001a\u00020\u00032\u0012\u0010@\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00010A\"\u00020\u0001\u00a2\u0006\u0002\u0010BJ\u000e\u0010D\u001a\u00020\u00002\u0006\u0010E\u001a\u00020\u0016J\u000e\u0010D\u001a\u00020\u00002\u0006\u0010E\u001a\u00020FJ\u0012\u0010D\u001a\u00020\u00002\n\u0010E\u001a\u0006\u0012\u0002\b\u000309J\u0014\u0010G\u001a\u00020\u00002\f\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u00160<J\u000e\u0010H\u001a\u00020\u00002\u0006\u0010I\u001a\u00020\u000fJ'\u0010H\u001a\u00020\u00002\u0006\u0010?\u001a\u00020\u00032\u0012\u0010@\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00010A\"\u00020\u0001\u00a2\u0006\u0002\u0010BJ\u001f\u0010J\u001a\u00020\u00002\u0012\u0010\u001b\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u001c0A\"\u00020\u001c\u00a2\u0006\u0002\u0010KJ\u0014\u0010J\u001a\u00020\u00002\f\u0010\u001b\u001a\b\u0012\u0004\u0012\u00020\u001c0<J \u0010L\u001a\u00020\u00002\u0006\u0010?\u001a\u00020\u00032\u0010\u0010@\u001a\f\u0012\u0004\u0012\u00020\u0003\u0012\u0002\b\u00030MJ\u000e\u0010N\u001a\u00020\u00002\u0006\u0010O\u001a\u00020!J/\u0010N\u001a\u00020\u00002\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010P\u001a\u00020\u00162\u0012\u0010\u001b\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u001c0A\"\u00020\u001c\u00a2\u0006\u0002\u0010QJ/\u0010N\u001a\u00020\u00002\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010P\u001a\u00020F2\u0012\u0010\u001b\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u001c0A\"\u00020\u001c\u00a2\u0006\u0002\u0010RJ3\u0010N\u001a\u00020\u00002\u0006\u0010\u0002\u001a\u00020\u00032\n\u0010P\u001a\u0006\u0012\u0002\b\u0003092\u0012\u0010\u001b\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u001c0A\"\u00020\u001c\u00a2\u0006\u0002\u0010SJ\u0014\u0010T\u001a\u00020\u00002\f\u0010U\u001a\b\u0012\u0004\u0012\u00020!0<J'\u0010V\u001a\u00020\u00002\u0006\u0010?\u001a\u00020\u00032\u0012\u0010@\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00010A\"\u00020\u0001\u00a2\u0006\u0002\u0010BJ\u000e\u0010W\u001a\u00020\u00002\u0006\u0010X\u001a\u00020,J\u0014\u0010Y\u001a\u00020\u00002\f\u0010+\u001a\b\u0012\u0004\u0012\u00020,0<J'\u0010Z\u001a\u00020\u00002\u0006\u0010[\u001a\u00020\u00032\u0012\u0010@\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00010A\"\u00020\u0001\u00a2\u0006\u0002\u0010BJ\u0006\u0010\\\u001a\u00020]J\u000e\u0010\u000e\u001a\u00020\u00002\u0006\u0010>\u001a\u00020\u000fJ'\u0010\u000e\u001a\u00020\u00002\u0006\u0010?\u001a\u00020\u00032\u0012\u0010@\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00010A\"\u00020\u0001\u00a2\u0006\u0002\u0010BJ\u0006\u0010^\u001a\u00020\u0000J\u0014\u0010_\u001a\u00020`2\f\u0010\u001b\u001a\b\u0012\u0004\u0012\u00020a0<J'\u0010b\u001a\u00020\u00002\u0006\u0010[\u001a\u00020\u00032\u0012\u0010@\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00010A\"\u00020\u0001\u00a2\u0006\u0002\u0010BJ\u000e\u0010c\u001a\u00020\u00002\u0006\u0010#\u001a\u00020\u0016J\u000e\u0010c\u001a\u00020\u00002\u0006\u0010#\u001a\u00020FJ\u0012\u0010c\u001a\u00020\u00002\n\u0010#\u001a\u0006\u0012\u0002\b\u000309J\u000e\u0010d\u001a\u00020\u00002\u0006\u0010(\u001a\u00020\u0016J\u000e\u0010d\u001a\u00020\u00002\u0006\u0010(\u001a\u00020FJ\u0012\u0010d\u001a\u00020\u00002\n\u0010(\u001a\u0006\u0012\u0002\b\u000309J\u0012\u0010.\u001a\u00020\u00002\b\b\u0002\u0010.\u001a\u00020/H\u0007R\u001a\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0014\u0010\n\u001a\u00020\u000bX\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u001c\u0010\u000e\u001a\u0004\u0018\u00010\u000fX\u0080\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0010\u0010\u0011\"\u0004\b\u0012\u0010\u0013R\u001a\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u00160\u0015X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0017\u0010\u0018R\u0014\u0010\u0019\u001a\u00020\u000bX\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001a\u0010\rR\u001a\u0010\u001b\u001a\b\u0012\u0004\u0012\u00020\u001c0\u0006X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001d\u0010\tR\u0014\u0010\u0002\u001a\u00020\u0003X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001e\u0010\u001fR\u001a\u0010 \u001a\b\u0012\u0004\u0012\u00020!0\u0006X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\"\u0010\tR\u001c\u0010#\u001a\u0004\u0018\u00010\u0016X\u0080\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b$\u0010%\"\u0004\b&\u0010'R\u001c\u0010(\u001a\u0004\u0018\u00010\u0016X\u0080\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b)\u0010%\"\u0004\b*\u0010'R\u001a\u0010+\u001a\b\u0012\u0004\u0012\u00020,0\u0006X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b-\u0010\tR\u001a\u0010.\u001a\u00020/X\u0080\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b0\u00101\"\u0004\b2\u00103\u00a8\u0006e"}, d2={"Lcom/squareup/kotlinpoet/FunSpec$Builder;", "", "name", "", "(Ljava/lang/String;)V", "annotations", "", "Lcom/squareup/kotlinpoet/AnnotationSpec;", "getAnnotations$kotlinpoet", "()Ljava/util/List;", "code", "Lcom/squareup/kotlinpoet/CodeBlock$Builder;", "getCode$kotlinpoet", "()Lcom/squareup/kotlinpoet/CodeBlock$Builder;", "defaultValue", "Lcom/squareup/kotlinpoet/CodeBlock;", "getDefaultValue$kotlinpoet", "()Lcom/squareup/kotlinpoet/CodeBlock;", "setDefaultValue$kotlinpoet", "(Lcom/squareup/kotlinpoet/CodeBlock;)V", "exceptions", "", "Lcom/squareup/kotlinpoet/TypeName;", "getExceptions$kotlinpoet", "()Ljava/util/Set;", "kdoc", "getKdoc$kotlinpoet", "modifiers", "Lcom/squareup/kotlinpoet/KModifier;", "getModifiers$kotlinpoet", "getName$kotlinpoet", "()Ljava/lang/String;", "parameters", "Lcom/squareup/kotlinpoet/ParameterSpec;", "getParameters$kotlinpoet", "receiverType", "getReceiverType$kotlinpoet", "()Lcom/squareup/kotlinpoet/TypeName;", "setReceiverType$kotlinpoet", "(Lcom/squareup/kotlinpoet/TypeName;)V", "returnType", "getReturnType$kotlinpoet", "setReturnType$kotlinpoet", "typeVariables", "Lcom/squareup/kotlinpoet/TypeVariableName;", "getTypeVariables$kotlinpoet", "varargs", "", "getVarargs$kotlinpoet", "()Z", "setVarargs$kotlinpoet", "(Z)V", "addAnnotation", "annotationSpec", "annotation", "Lcom/squareup/kotlinpoet/ClassName;", "Ljava/lang/Class;", "Lkotlin/reflect/KClass;", "addAnnotations", "annotationSpecs", "", "addCode", "codeBlock", "format", "args", "", "(Ljava/lang/String;[Ljava/lang/Object;)Lcom/squareup/kotlinpoet/FunSpec$Builder;", "addComment", "addException", "exception", "Ljava/lang/reflect/Type;", "addExceptions", "addKdoc", "block", "addModifiers", "([Lcom/squareup/kotlinpoet/KModifier;)Lcom/squareup/kotlinpoet/FunSpec$Builder;", "addNamedCode", "", "addParameter", "parameterSpec", "type", "(Ljava/lang/String;Lcom/squareup/kotlinpoet/TypeName;[Lcom/squareup/kotlinpoet/KModifier;)Lcom/squareup/kotlinpoet/FunSpec$Builder;", "(Ljava/lang/String;Ljava/lang/reflect/Type;[Lcom/squareup/kotlinpoet/KModifier;)Lcom/squareup/kotlinpoet/FunSpec$Builder;", "(Ljava/lang/String;Lkotlin/reflect/KClass;[Lcom/squareup/kotlinpoet/KModifier;)Lcom/squareup/kotlinpoet/FunSpec$Builder;", "addParameters", "parameterSpecs", "addStatement", "addTypeVariable", "typeVariable", "addTypeVariables", "beginControlFlow", "controlFlow", "build", "Lcom/squareup/kotlinpoet/FunSpec;", "endControlFlow", "jvmModifiers", "", "Ljavax/lang/model/element/Modifier;", "nextControlFlow", "receiver", "returns", "kotlinpoet"})
    public static final class Builder {
        @NotNull
        private final CodeBlock.Builder kdoc;
        @NotNull
        private final List<AnnotationSpec> annotations;
        @NotNull
        private final List<KModifier> modifiers;
        @NotNull
        private final List<TypeVariableName> typeVariables;
        @Nullable
        private TypeName returnType;
        @Nullable
        private TypeName receiverType;
        @NotNull
        private final List<ParameterSpec> parameters;
        @NotNull
        private final Set<TypeName> exceptions;
        @NotNull
        private final CodeBlock.Builder code;
        private boolean varargs;
        @Nullable
        private CodeBlock defaultValue;
        @NotNull
        private final String name;

        @NotNull
        public final CodeBlock.Builder getKdoc$kotlinpoet() {
            return this.kdoc;
        }

        @NotNull
        public final List<AnnotationSpec> getAnnotations$kotlinpoet() {
            return this.annotations;
        }

        @NotNull
        public final List<KModifier> getModifiers$kotlinpoet() {
            return this.modifiers;
        }

        @NotNull
        public final List<TypeVariableName> getTypeVariables$kotlinpoet() {
            return this.typeVariables;
        }

        @Nullable
        public final TypeName getReturnType$kotlinpoet() {
            return this.returnType;
        }

        public final void setReturnType$kotlinpoet(@Nullable TypeName typeName) {
            this.returnType = typeName;
        }

        @Nullable
        public final TypeName getReceiverType$kotlinpoet() {
            return this.receiverType;
        }

        public final void setReceiverType$kotlinpoet(@Nullable TypeName typeName) {
            this.receiverType = typeName;
        }

        @NotNull
        public final List<ParameterSpec> getParameters$kotlinpoet() {
            return this.parameters;
        }

        @NotNull
        public final Set<TypeName> getExceptions$kotlinpoet() {
            return this.exceptions;
        }

        @NotNull
        public final CodeBlock.Builder getCode$kotlinpoet() {
            return this.code;
        }

        public final boolean getVarargs$kotlinpoet() {
            return this.varargs;
        }

        public final void setVarargs$kotlinpoet(boolean bl) {
            this.varargs = bl;
        }

        @Nullable
        public final CodeBlock getDefaultValue$kotlinpoet() {
            return this.defaultValue;
        }

        public final void setDefaultValue$kotlinpoet(@Nullable CodeBlock codeBlock) {
            this.defaultValue = codeBlock;
        }

        @NotNull
        public final Builder addKdoc(@NotNull String format, Object ... args) {
            Intrinsics.checkParameterIsNotNull((Object)format, (String)"format");
            Intrinsics.checkParameterIsNotNull((Object)args, (String)"args");
            this.kdoc.add(format, Arrays.copyOf(args, args.length));
            return this;
        }

        @NotNull
        public final Builder addKdoc(@NotNull CodeBlock block) {
            Intrinsics.checkParameterIsNotNull((Object)block, (String)"block");
            this.kdoc.add(block);
            return this;
        }

        @NotNull
        public final Builder addAnnotations(@NotNull Iterable<AnnotationSpec> annotationSpecs) {
            Intrinsics.checkParameterIsNotNull(annotationSpecs, (String)"annotationSpecs");
            Collection collection = this.annotations;
            CollectionsKt.addAll((Collection)collection, annotationSpecs);
            return this;
        }

        @NotNull
        public final Builder addAnnotation(@NotNull AnnotationSpec annotationSpec) {
            Intrinsics.checkParameterIsNotNull((Object)annotationSpec, (String)"annotationSpec");
            Collection collection = this.annotations;
            collection.add(annotationSpec);
            return this;
        }

        @NotNull
        public final Builder addAnnotation(@NotNull ClassName annotation) {
            Intrinsics.checkParameterIsNotNull((Object)annotation, (String)"annotation");
            Collection collection = this.annotations;
            AnnotationSpec annotationSpec = AnnotationSpec.Companion.builder(annotation).build();
            collection.add(annotationSpec);
            return this;
        }

        @NotNull
        public final Builder addAnnotation(@NotNull Class<?> annotation) {
            Intrinsics.checkParameterIsNotNull(annotation, (String)"annotation");
            return this.addAnnotation(ClassName.Companion.get(annotation));
        }

        @NotNull
        public final Builder addAnnotation(@NotNull KClass<?> annotation) {
            Intrinsics.checkParameterIsNotNull(annotation, (String)"annotation");
            return this.addAnnotation(ClassName.Companion.get(annotation));
        }

        @NotNull
        public final Builder addModifiers(KModifier ... modifiers) {
            Intrinsics.checkParameterIsNotNull((Object)modifiers, (String)"modifiers");
            Collection collection = this.modifiers;
            CollectionsKt.addAll((Collection)collection, (Object[])((Object[])modifiers));
            return this;
        }

        @NotNull
        public final Builder addModifiers(@NotNull Iterable<? extends KModifier> modifiers) {
            Intrinsics.checkParameterIsNotNull(modifiers, (String)"modifiers");
            Collection collection = this.modifiers;
            CollectionsKt.addAll((Collection)collection, modifiers);
            return this;
        }

        public final void jvmModifiers(@NotNull Iterable<? extends Modifier> modifiers) {
            Intrinsics.checkParameterIsNotNull(modifiers, (String)"modifiers");
            KModifier visibility = KModifier.INTERNAL;
            block12: for (Modifier collection : modifiers) {
                switch (FunSpec$Builder$WhenMappings.$EnumSwitchMapping$0[collection.ordinal()]) {
                    case 1: {
                        visibility = KModifier.PUBLIC;
                        continue block12;
                    }
                    case 2: {
                        visibility = KModifier.PROTECTED;
                        continue block12;
                    }
                    case 3: {
                        visibility = KModifier.PRIVATE;
                        continue block12;
                    }
                    case 4: {
                        Collection collection2 = this.modifiers;
                        KModifier kModifier = KModifier.ABSTRACT;
                        collection2.add(kModifier);
                        continue block12;
                    }
                    case 5: {
                        Collection collection2 = this.modifiers;
                        KModifier kModifier = KModifier.FINAL;
                        collection2.add(kModifier);
                        continue block12;
                    }
                    case 6: {
                        Collection collection2 = this.modifiers;
                        KModifier kModifier = KModifier.EXTERNAL;
                        collection2.add(kModifier);
                        continue block12;
                    }
                    case 7: {
                        continue block12;
                    }
                    case 8: {
                        this.addAnnotation(Reflection.getOrCreateKotlinClass(JvmStatic.class));
                        continue block12;
                    }
                    case 9: {
                        this.addAnnotation(Reflection.getOrCreateKotlinClass(Synchronized.class));
                        continue block12;
                    }
                    case 10: {
                        this.addAnnotation(Reflection.getOrCreateKotlinClass(Strictfp.class));
                        continue block12;
                    }
                }
                throw (Throwable)new IllegalArgumentException("unexpected fun modifier " + (Object)((Object)collection));
            }
            Collection collection = this.modifiers;
            collection.add(visibility);
        }

        @NotNull
        public final Builder addTypeVariables(@NotNull Iterable<TypeVariableName> typeVariables) {
            Intrinsics.checkParameterIsNotNull(typeVariables, (String)"typeVariables");
            Collection collection = this.typeVariables;
            CollectionsKt.addAll((Collection)collection, typeVariables);
            return this;
        }

        @NotNull
        public final Builder addTypeVariable(@NotNull TypeVariableName typeVariable) {
            Intrinsics.checkParameterIsNotNull((Object)typeVariable, (String)"typeVariable");
            Collection collection = this.typeVariables;
            collection.add(typeVariable);
            return this;
        }

        @NotNull
        public final Builder returns(@NotNull TypeName returnType) {
            Intrinsics.checkParameterIsNotNull((Object)returnType, (String)"returnType");
            boolean bl = Intrinsics.areEqual((Object)this.name, (Object)FunSpec.CONSTRUCTOR) ^ true;
            if (!bl) {
                String string = "constructor cannot have return type.";
                throw (Throwable)new IllegalStateException(string.toString());
            }
            this.returnType = returnType;
            return this;
        }

        @NotNull
        public final Builder returns(@NotNull Type returnType) {
            Intrinsics.checkParameterIsNotNull((Object)returnType, (String)"returnType");
            return this.returns(TypeName.Companion.get$default(TypeName.Companion, returnType, null, 2, null));
        }

        @NotNull
        public final Builder returns(@NotNull KClass<?> returnType) {
            Intrinsics.checkParameterIsNotNull(returnType, (String)"returnType");
            return this.returns(TypeName.Companion.get(returnType));
        }

        @NotNull
        public final Builder receiver(@NotNull TypeName receiverType) {
            Intrinsics.checkParameterIsNotNull((Object)receiverType, (String)"receiverType");
            boolean bl = Intrinsics.areEqual((Object)this.name, (Object)FunSpec.CONSTRUCTOR) ^ true;
            if (!bl) {
                String string = "constructor cannot have return type.";
                throw (Throwable)new IllegalStateException(string.toString());
            }
            this.receiverType = receiverType;
            return this;
        }

        @NotNull
        public final Builder receiver(@NotNull Type receiverType) {
            Intrinsics.checkParameterIsNotNull((Object)receiverType, (String)"receiverType");
            return this.receiver(TypeName.Companion.get$default(TypeName.Companion, receiverType, null, 2, null));
        }

        @NotNull
        public final Builder receiver(@NotNull KClass<?> receiverType) {
            Intrinsics.checkParameterIsNotNull(receiverType, (String)"receiverType");
            return this.receiver(TypeName.Companion.get(receiverType));
        }

        @NotNull
        public final Builder addParameters(@NotNull Iterable<ParameterSpec> parameterSpecs) {
            Intrinsics.checkParameterIsNotNull(parameterSpecs, (String)"parameterSpecs");
            Collection collection = this.parameters;
            CollectionsKt.addAll((Collection)collection, parameterSpecs);
            return this;
        }

        @NotNull
        public final Builder addParameter(@NotNull ParameterSpec parameterSpec) {
            Intrinsics.checkParameterIsNotNull((Object)parameterSpec, (String)"parameterSpec");
            Collection collection = this.parameters;
            collection.add(parameterSpec);
            return this;
        }

        @NotNull
        public final Builder addParameter(@NotNull String name, @NotNull TypeName type, KModifier ... modifiers) {
            Intrinsics.checkParameterIsNotNull((Object)name, (String)"name");
            Intrinsics.checkParameterIsNotNull((Object)type, (String)"type");
            Intrinsics.checkParameterIsNotNull((Object)modifiers, (String)"modifiers");
            return this.addParameter(ParameterSpec.Companion.builder(name, type, Arrays.copyOf(modifiers, modifiers.length)).build());
        }

        @NotNull
        public final Builder addParameter(@NotNull String name, @NotNull Type type, KModifier ... modifiers) {
            Intrinsics.checkParameterIsNotNull((Object)name, (String)"name");
            Intrinsics.checkParameterIsNotNull((Object)type, (String)"type");
            Intrinsics.checkParameterIsNotNull((Object)modifiers, (String)"modifiers");
            return this.addParameter(name, TypeName.Companion.get$default(TypeName.Companion, type, null, 2, null), Arrays.copyOf(modifiers, modifiers.length));
        }

        @NotNull
        public final Builder addParameter(@NotNull String name, @NotNull KClass<?> type, KModifier ... modifiers) {
            Intrinsics.checkParameterIsNotNull((Object)name, (String)"name");
            Intrinsics.checkParameterIsNotNull(type, (String)"type");
            Intrinsics.checkParameterIsNotNull((Object)modifiers, (String)"modifiers");
            return this.addParameter(name, TypeName.Companion.get(type), Arrays.copyOf(modifiers, modifiers.length));
        }

        @JvmOverloads
        @NotNull
        public final Builder varargs(boolean varargs) {
            this.varargs = varargs;
            return this;
        }

        @JvmOverloads
        @NotNull
        public static /* bridge */ /* synthetic */ Builder varargs$default(Builder builder, boolean bl, int n, Object object) {
            if ((n & 1) != 0) {
                bl = true;
            }
            return builder.varargs(bl);
        }

        @JvmOverloads
        @NotNull
        public final Builder varargs() {
            return Builder.varargs$default(this, false, 1, null);
        }

        @NotNull
        public final Builder addExceptions(@NotNull Iterable<? extends TypeName> exceptions) {
            Intrinsics.checkParameterIsNotNull(exceptions, (String)"exceptions");
            Collection collection = this.exceptions;
            CollectionsKt.addAll((Collection)collection, exceptions);
            return this;
        }

        @NotNull
        public final Builder addException(@NotNull TypeName exception) {
            Intrinsics.checkParameterIsNotNull((Object)exception, (String)"exception");
            Collection collection = this.exceptions;
            collection.add(exception);
            return this;
        }

        @NotNull
        public final Builder addException(@NotNull Type exception) {
            Intrinsics.checkParameterIsNotNull((Object)exception, (String)"exception");
            return this.addException(TypeName.Companion.get$default(TypeName.Companion, exception, null, 2, null));
        }

        @NotNull
        public final Builder addException(@NotNull KClass<?> exception) {
            Intrinsics.checkParameterIsNotNull(exception, (String)"exception");
            return this.addException(TypeName.Companion.get(exception));
        }

        @NotNull
        public final Builder addCode(@NotNull String format, Object ... args) {
            Intrinsics.checkParameterIsNotNull((Object)format, (String)"format");
            Intrinsics.checkParameterIsNotNull((Object)args, (String)"args");
            this.code.add(format, Arrays.copyOf(args, args.length));
            return this;
        }

        @NotNull
        public final Builder addNamedCode(@NotNull String format, @NotNull Map<String, ?> args) {
            Intrinsics.checkParameterIsNotNull((Object)format, (String)"format");
            Intrinsics.checkParameterIsNotNull(args, (String)"args");
            this.code.addNamed(format, args);
            return this;
        }

        @NotNull
        public final Builder addCode(@NotNull CodeBlock codeBlock) {
            Intrinsics.checkParameterIsNotNull((Object)codeBlock, (String)"codeBlock");
            this.code.add(codeBlock);
            return this;
        }

        @NotNull
        public final Builder addComment(@NotNull String format, Object ... args) {
            Intrinsics.checkParameterIsNotNull((Object)format, (String)"format");
            Intrinsics.checkParameterIsNotNull((Object)args, (String)"args");
            this.code.add("// " + format + "\n", Arrays.copyOf(args, args.length));
            return this;
        }

        @NotNull
        public final Builder defaultValue(@NotNull String format, Object ... args) {
            Intrinsics.checkParameterIsNotNull((Object)format, (String)"format");
            Intrinsics.checkParameterIsNotNull((Object)args, (String)"args");
            return this.defaultValue(CodeBlock.Companion.of(format, Arrays.copyOf(args, args.length)));
        }

        @NotNull
        public final Builder defaultValue(@NotNull CodeBlock codeBlock) {
            boolean bl;
            Intrinsics.checkParameterIsNotNull((Object)codeBlock, (String)"codeBlock");
            boolean bl2 = bl = this.defaultValue == null;
            if (!bl) {
                String string = "defaultValue was already set";
                throw (Throwable)new IllegalStateException(string.toString());
            }
            this.defaultValue = codeBlock;
            return this;
        }

        @NotNull
        public final Builder beginControlFlow(@NotNull String controlFlow, Object ... args) {
            Intrinsics.checkParameterIsNotNull((Object)controlFlow, (String)"controlFlow");
            Intrinsics.checkParameterIsNotNull((Object)args, (String)"args");
            this.code.beginControlFlow(controlFlow, Arrays.copyOf(args, args.length));
            return this;
        }

        @NotNull
        public final Builder nextControlFlow(@NotNull String controlFlow, Object ... args) {
            Intrinsics.checkParameterIsNotNull((Object)controlFlow, (String)"controlFlow");
            Intrinsics.checkParameterIsNotNull((Object)args, (String)"args");
            this.code.nextControlFlow(controlFlow, Arrays.copyOf(args, args.length));
            return this;
        }

        @NotNull
        public final Builder endControlFlow() {
            this.code.endControlFlow();
            return this;
        }

        @NotNull
        public final Builder addStatement(@NotNull String format, Object ... args) {
            Intrinsics.checkParameterIsNotNull((Object)format, (String)"format");
            Intrinsics.checkParameterIsNotNull((Object)args, (String)"args");
            this.code.addStatement(format, Arrays.copyOf(args, args.length));
            return this;
        }

        @NotNull
        public final FunSpec build() {
            return new FunSpec(this, null);
        }

        @NotNull
        public final String getName$kotlinpoet() {
            return this.name;
        }

        public Builder(@NotNull String name) {
            boolean bl;
            Collection collection;
            Intrinsics.checkParameterIsNotNull((Object)name, (String)"name");
            this.name = name;
            this.kdoc = CodeBlock.Companion.builder();
            Builder builder = this;
            builder.annotations = collection = (List)new ArrayList();
            builder = this;
            builder.modifiers = collection = (List)new ArrayList();
            builder = this;
            builder.typeVariables = collection = (List)new ArrayList();
            builder = this;
            builder.parameters = collection = (List)new ArrayList();
            builder = this;
            collection = new LinkedHashSet();
            builder.exceptions = collection;
            this.code = CodeBlock.Companion.builder();
            boolean bl2 = bl = Intrinsics.areEqual((Object)this.name, (Object)FunSpec.CONSTRUCTOR) || SourceVersion.isName(this.name);
            if (!bl) {
                String string = "not a valid name: " + this.name;
                throw (Throwable)new IllegalArgumentException(string.toString());
            }
        }
    }

    @Metadata(mv={1, 1, 6}, bv={1, 0, 1}, k=1, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u0004H\u0007J\b\u0010\b\u001a\u00020\u0006H\u0007J\u0010\u0010\t\u001a\u00020\u00062\u0006\u0010\n\u001a\u00020\u000bH\u0007J \u0010\t\u001a\u00020\u00062\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0007R\u000e\u0010\u0003\u001a\u00020\u0004X\u0080T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0010"}, d2={"Lcom/squareup/kotlinpoet/FunSpec$Companion;", "", "()V", "CONSTRUCTOR", "", "builder", "Lcom/squareup/kotlinpoet/FunSpec$Builder;", "name", "constructorBuilder", "overriding", "method", "Ljavax/lang/model/element/ExecutableElement;", "enclosing", "Ljavax/lang/model/type/DeclaredType;", "types", "Ljavax/lang/model/util/Types;", "kotlinpoet"})
    public static final class Companion {
        @JvmStatic
        @NotNull
        public final Builder builder(@NotNull String name) {
            Intrinsics.checkParameterIsNotNull((Object)name, (String)"name");
            return new Builder(name);
        }

        @JvmStatic
        @NotNull
        public final Builder constructorBuilder() {
            return new Builder(FunSpec.CONSTRUCTOR);
        }

        /*
         * WARNING - void declaration
         */
        @JvmStatic
        @NotNull
        public final Builder overriding(@NotNull ExecutableElement method) {
            void modifiers;
            boolean bl;
            Intrinsics.checkParameterIsNotNull((Object)method, (String)"method");
            Ref.ObjectRef objectRef = new Ref.ObjectRef();
            Set<Modifier> set = method.getModifiers();
            Intrinsics.checkExpressionValueIsNotNull(set, (String)"method.modifiers");
            objectRef.element = set;
            boolean bl2 = bl = !((Set)modifiers.element).contains((Object)Modifier.PRIVATE) && !((Set)modifiers.element).contains((Object)Modifier.FINAL) && !((Set)modifiers.element).contains((Object)Modifier.STATIC);
            if (!bl) {
                String string = "cannot override method with modifiers: " + (Set)modifiers.element;
                throw (Throwable)new IllegalArgumentException(string.toString());
            }
            String methodName = method.getSimpleName().toString();
            Builder funBuilder = Companion.builder(methodName);
            funBuilder.addAnnotation(Reflection.getOrCreateKotlinClass(Override.class));
            modifiers.element = CollectionsKt.toMutableSet((Iterable)((Set)modifiers.element));
            ((Set)modifiers.element).remove((Object)Modifier.ABSTRACT);
            funBuilder.jvmModifiers((Set)modifiers.element);
            for (TypeParameterElement typeParameterElement : method.getTypeParameters()) {
                TypeMirror typeMirror = typeParameterElement.asType();
                if (typeMirror == null) {
                    throw new TypeCastException("null cannot be cast to non-null type javax.lang.model.type.TypeVariable");
                }
                TypeVariable typeVariable = (TypeVariable)typeMirror;
                funBuilder.addTypeVariable(TypeVariableName.Companion.get(typeVariable));
            }
            TypeMirror typeMirror = method.getReturnType();
            Intrinsics.checkExpressionValueIsNotNull((Object)typeMirror, (String)"method.returnType");
            funBuilder.returns(TypeName.Companion.get$default(TypeName.Companion, typeMirror, null, 2, null));
            funBuilder.addParameters((Iterable<ParameterSpec>)ParameterSpec.Companion.parametersOf(method));
            funBuilder.varargs(method.isVarArgs());
            Iterator<AnnotatedConstruct> iterator = method.getThrownTypes().iterator();
            while (iterator.hasNext()) {
                TypeMirror typeMirror2;
                TypeMirror typeMirror3 = typeMirror2 = (TypeMirror)iterator.next();
                Intrinsics.checkExpressionValueIsNotNull((Object)typeMirror3, (String)"thrownType");
                funBuilder.addException(TypeName.Companion.get$default(TypeName.Companion, typeMirror3, null, 2, null));
            }
            return funBuilder;
        }

        @JvmStatic
        @NotNull
        public final Builder overriding(@NotNull ExecutableElement method, @NotNull DeclaredType enclosing, @NotNull Types types) {
            Intrinsics.checkParameterIsNotNull((Object)method, (String)"method");
            Intrinsics.checkParameterIsNotNull((Object)enclosing, (String)"enclosing");
            Intrinsics.checkParameterIsNotNull((Object)types, (String)"types");
            TypeMirror typeMirror = types.asMemberOf(enclosing, method);
            if (typeMirror == null) {
                throw new TypeCastException("null cannot be cast to non-null type javax.lang.model.type.ExecutableType");
            }
            ExecutableType executableType = (ExecutableType)typeMirror;
            List<? extends TypeMirror> resolvedParameterTypes = executableType.getParameterTypes();
            TypeMirror resolvedReturnType = executableType.getReturnType();
            Builder builder = this.overriding(method);
            TypeMirror typeMirror2 = resolvedReturnType;
            Intrinsics.checkExpressionValueIsNotNull((Object)typeMirror2, (String)"resolvedReturnType");
            builder.returns(TypeName.Companion.get$default(TypeName.Companion, typeMirror2, null, 2, null));
            int size = builder.getParameters$kotlinpoet().size();
            for (int i = 0; i < size; ++i) {
                ParameterSpec parameter = builder.getParameters$kotlinpoet().get(i);
                TypeMirror typeMirror3 = resolvedParameterTypes.get(i);
                Intrinsics.checkExpressionValueIsNotNull((Object)typeMirror3, (String)"resolvedParameterTypes[i]");
                TypeName type = TypeName.Companion.get$default(TypeName.Companion, typeMirror3, null, 2, null);
                builder.getParameters$kotlinpoet().set(i, parameter.toBuilder(parameter.getName(), type).build());
            }
            return builder;
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

