/*
 * Decompiled with CFR 0.152.
 */
package com.squareup.kotlinpoet;

import com.squareup.kotlinpoet.ClassName;
import com.squareup.kotlinpoet.CodeBlock;
import com.squareup.kotlinpoet.CodeWriter;
import com.squareup.kotlinpoet.FunSpec;
import com.squareup.kotlinpoet.KModifier;
import com.squareup.kotlinpoet.KotlinFileKt;
import com.squareup.kotlinpoet.PropertySpec;
import com.squareup.kotlinpoet.TypeAliasSpec;
import com.squareup.kotlinpoet.TypeSpec;
import com.squareup.kotlinpoet.UtilKt;
import java.io.ByteArrayInputStream;
import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStreamWriter;
import java.net.URI;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import javax.lang.model.SourceVersion;
import javax.tools.JavaFileObject;
import javax.tools.SimpleJavaFileObject;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.reflect.KClass;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 6}, bv={1, 0, 1}, k=1, d1={"\u0000l\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0010\"\n\u0000\n\u0002\u0010 \n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u0000 .2\u00020\u0001:\u0002-.B\u000f\b\u0002\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0010\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\u001dH\u0003J\u0013\u0010\u001e\u001a\u00020\u00172\b\u0010\u001f\u001a\u0004\u0018\u00010\u0001H\u0096\u0002J\b\u0010 \u001a\u00020!H\u0016J\u0006\u0010\"\u001a\u00020\u0003J\u0006\u0010#\u001a\u00020$J\b\u0010%\u001a\u00020\nH\u0016J\u0010\u0010&\u001a\u00020\u001b2\u0006\u0010'\u001a\u00020(H\u0007J\u0010\u0010&\u001a\u00020\u001b2\u0006\u0010'\u001a\u00020)H\u0007J\u0014\u0010&\u001a\u00020\u001b2\n\u0010*\u001a\u00060+j\u0002`,H\u0007R\u0011\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0011\u0010\t\u001a\u00020\n\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u000e\u0010\r\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\n0\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0017\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00010\u0011\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013R\u0011\u0010\u0014\u001a\u00020\n\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\fR\u0011\u0010\u0016\u001a\u00020\u0017\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0018\u0010\u0019\u00a8\u0006/"}, d2={"Lcom/squareup/kotlinpoet/KotlinFile;", "", "builder", "Lcom/squareup/kotlinpoet/KotlinFile$Builder;", "(Lcom/squareup/kotlinpoet/KotlinFile$Builder;)V", "fileComment", "Lcom/squareup/kotlinpoet/CodeBlock;", "getFileComment", "()Lcom/squareup/kotlinpoet/CodeBlock;", "fileName", "", "getFileName", "()Ljava/lang/String;", "indent", "memberImports", "", "members", "", "getMembers", "()Ljava/util/List;", "packageName", "getPackageName", "skipJavaLangImports", "", "getSkipJavaLangImports", "()Z", "emit", "", "codeWriter", "Lcom/squareup/kotlinpoet/CodeWriter;", "equals", "other", "hashCode", "", "toBuilder", "toJavaFileObject", "Ljavax/tools/JavaFileObject;", "toString", "writeTo", "directory", "Ljava/io/File;", "Ljava/nio/file/Path;", "out", "Ljava/lang/Appendable;", "Lkotlin/text/Appendable;", "Builder", "Companion", "kotlinpoet"})
public final class KotlinFile {
    @NotNull
    private final CodeBlock fileComment;
    @NotNull
    private final String packageName;
    @NotNull
    private final String fileName;
    @NotNull
    private final List<Object> members;
    private final boolean skipJavaLangImports;
    private final Set<String> memberImports;
    private final String indent;
    public static final Companion Companion = new Companion(null);

    @NotNull
    public final CodeBlock getFileComment() {
        return this.fileComment;
    }

    @NotNull
    public final String getPackageName() {
        return this.packageName;
    }

    @NotNull
    public final String getFileName() {
        return this.fileName;
    }

    @NotNull
    public final List<Object> getMembers() {
        return this.members;
    }

    public final boolean getSkipJavaLangImports() {
        return this.skipJavaLangImports;
    }

    public final void writeTo(@NotNull Appendable out) throws IOException {
        Intrinsics.checkParameterIsNotNull((Object)out, (String)"out");
        CodeWriter importsCollector = new CodeWriter(KotlinFileKt.access$getNULL_APPENDABLE$p(), this.indent, this.memberImports, null, 8, null);
        this.emit(importsCollector);
        Map<String, ClassName> suggestedImports = importsCollector.suggestedImports();
        CodeWriter codeWriter = new CodeWriter(out, this.indent, this.memberImports, suggestedImports);
        this.emit(codeWriter);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void writeTo(@NotNull Path directory) throws IOException {
        boolean bl;
        Intrinsics.checkParameterIsNotNull((Object)directory, (String)"directory");
        boolean bl2 = bl = Files.notExists(directory, new LinkOption[0]) || Files.isDirectory(directory, new LinkOption[0]);
        if (!bl) {
            String string = "path " + directory + " exists but is not a directory.";
            throw (Throwable)new IllegalArgumentException(string.toString());
        }
        Path outputDirectory = directory;
        CharSequence $i$a$1$require = this.packageName;
        if ($i$a$1$require.length() > 0) {
            List list;
            List $receiver$iv = StringsKt.split$default((CharSequence)this.packageName, (char[])new char[]{'.'}, (boolean)false, (int)0, (int)6, null);
            if (!$receiver$iv.isEmpty()) {
                ListIterator iterator$iv = $receiver$iv.listIterator($receiver$iv.size());
                while (iterator$iv.hasPrevious()) {
                    String it = (String)iterator$iv.previous();
                    CharSequence charSequence = it;
                    if (charSequence.length() == 0) continue;
                    list = CollectionsKt.take((Iterable)$receiver$iv, (int)(iterator$iv.nextIndex() + 1));
                    break;
                }
            } else {
                list = CollectionsKt.emptyList();
            }
            for (String packageComponent : list) {
                Intrinsics.checkExpressionValueIsNotNull((Object)outputDirectory.resolve(packageComponent), (String)"outputDirectory.resolve(packageComponent)");
            }
            Files.createDirectories(outputDirectory, new FileAttribute[0]);
        }
        Path outputPath = outputDirectory.resolve(this.fileName + ".kt");
        Closeable closeable = new OutputStreamWriter(Files.newOutputStream(outputPath, new OpenOption[0]), StandardCharsets.UTF_8);
        boolean bl3 = false;
        try {
            OutputStreamWriter writer = (OutputStreamWriter)closeable;
            this.writeTo(writer);
            Unit unit = Unit.INSTANCE;
        }
        catch (Exception exception) {
            bl3 = true;
            try {
                closeable.close();
            }
            catch (Exception exception2) {
                // empty catch block
            }
            throw (Throwable)exception;
        }
        finally {
            if (!bl3) {
                closeable.close();
            }
        }
    }

    public final void writeTo(@NotNull File directory) throws IOException {
        Intrinsics.checkParameterIsNotNull((Object)directory, (String)"directory");
        Path path = directory.toPath();
        Intrinsics.checkExpressionValueIsNotNull((Object)path, (String)"directory.toPath()");
        this.writeTo(path);
    }

    private final void emit(CodeWriter codeWriter) throws IOException {
        ClassName it;
        Iterable $receiver$iv$iv;
        CharSequence charSequence;
        codeWriter.pushPackage(this.packageName);
        if (!this.fileComment.isEmpty()) {
            codeWriter.emitComment(this.fileComment);
        }
        if ((charSequence = (CharSequence)this.packageName).length() > 0) {
            codeWriter.emitCode("package %L\n", this.packageName);
            codeWriter.emit("\n");
        }
        Iterable $receiver$iv = codeWriter.importedTypes().values();
        Iterable iterable2 = $receiver$iv;
        Collection destination$iv$iv = new ArrayList();
        for (Object element$iv$iv : $receiver$iv$iv) {
            it = (ClassName)element$iv$iv;
            if (this.skipJavaLangImports && Intrinsics.areEqual((Object)it.packageName(), (Object)"java.lang")) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        $receiver$iv = (List)destination$iv$iv;
        $receiver$iv$iv = $receiver$iv;
        destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$receiver$iv, (int)10));
        for (Object item$iv$iv : $receiver$iv$iv) {
            it = (ClassName)item$iv$iv;
            Collection collection = destination$iv$iv;
            String string = it.getCanonicalName();
            collection.add(string);
        }
        List imports = CollectionsKt.plus((Collection)((List)destination$iv$iv), (Iterable)this.memberImports);
        int importedTypesCount = 0;
        for (String className : CollectionsKt.toSortedSet((Iterable)imports)) {
            codeWriter.emitCode("import %L\n", className);
            ++importedTypesCount;
        }
        if (importedTypesCount > 0) {
            codeWriter.emit("\n");
        }
        for (Iterable iterable2 : CollectionsKt.withIndex((Iterable)this.members)) {
            Object object;
            int i = iterable2.component1();
            Object member = iterable2.component2();
            if (i > 0) {
                codeWriter.emit("\n");
            }
            if ((object = member) instanceof TypeSpec) {
                ((TypeSpec)member).emit$kotlinpoet(codeWriter, null);
                continue;
            }
            if (object instanceof FunSpec) {
                ((FunSpec)member).emit$kotlinpoet(codeWriter, null, SetsKt.setOf((Object)((Object)KModifier.PUBLIC)));
                continue;
            }
            if (object instanceof PropertySpec) {
                PropertySpec.emit$kotlinpoet$default((PropertySpec)member, codeWriter, SetsKt.setOf((Object)((Object)KModifier.PUBLIC)), false, false, 12, null);
                continue;
            }
            if (object instanceof TypeAliasSpec) {
                ((TypeAliasSpec)member).emit$kotlinpoet(codeWriter);
                continue;
            }
            throw (Throwable)((Object)new AssertionError());
        }
        codeWriter.popPackage();
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (other == null) {
            return false;
        }
        if (Intrinsics.areEqual(this.getClass(), other.getClass()) ^ true) {
            return false;
        }
        return Intrinsics.areEqual((Object)this.toString(), (Object)other.toString());
    }

    public int hashCode() {
        return this.toString().hashCode();
    }

    @NotNull
    public String toString() {
        try {
            StringBuilder result = new StringBuilder();
            this.writeTo(result);
            String string = result.toString();
            Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"result.toString()");
            return string;
        }
        catch (IOException e) {
            throw (Throwable)((Object)new AssertionError());
        }
    }

    @NotNull
    public final JavaFileObject toJavaFileObject() {
        CharSequence charSequence = this.packageName;
        StringBuilder stringBuilder = new StringBuilder();
        boolean bl = charSequence.length() == 0;
        URI uri = URI.create(stringBuilder.append(bl ? this.fileName : StringsKt.replace$default((String)this.packageName, (char)'.', (char)'/', (boolean)false, (int)4, null) + '/' + this.fileName).append(".kt").toString());
        return new SimpleJavaFileObject(this, uri, uri, JavaFileObject.Kind.SOURCE){
            private final long lastModified;
            final /* synthetic */ KotlinFile this$0;
            final /* synthetic */ URI $uri;

            @NotNull
            public String getCharContent(boolean ignoreEncodingErrors) {
                return this.this$0.toString();
            }

            @NotNull
            public InputStream openInputStream() throws IOException {
                ByteArrayInputStream byteArrayInputStream;
                String string = this.getCharContent(true);
                Charset charset = StandardCharsets.UTF_8;
                Intrinsics.checkExpressionValueIsNotNull((Object)charset, (String)"UTF_8");
                Charset charset2 = charset;
                ByteArrayInputStream byteArrayInputStream2 = byteArrayInputStream;
                ByteArrayInputStream byteArrayInputStream3 = byteArrayInputStream;
                String string2 = string;
                if (string2 == null) {
                    throw new TypeCastException("null cannot be cast to non-null type java.lang.String");
                }
                byte[] byArray = string2.getBytes(charset2);
                Intrinsics.checkExpressionValueIsNotNull((Object)byArray, (String)"(this as java.lang.String).getBytes(charset)");
                byte[] byArray2 = byArray;
                byteArrayInputStream2(byArray2);
                return byteArrayInputStream3;
            }

            public long getLastModified() {
                return this.lastModified;
            }
            {
                this.this$0 = $outer;
                this.$uri = $captured_local_variable$1;
                super($super_call_param$2, $super_call_param$3);
                this.lastModified = System.currentTimeMillis();
            }
        };
    }

    @NotNull
    public final Builder toBuilder() {
        Builder builder = new Builder(this.packageName, this.fileName);
        builder.getFileComment$kotlinpoet().add(this.fileComment);
        builder.getMembers$kotlinpoet().addAll((Collection<Object>)this.members);
        builder.setSkipJavaLangImports$kotlinpoet(this.skipJavaLangImports);
        builder.setIndent$kotlinpoet(this.indent);
        return builder;
    }

    private KotlinFile(Builder builder) {
        this.fileComment = builder.getFileComment$kotlinpoet().build();
        this.packageName = builder.getPackageName$kotlinpoet();
        this.fileName = builder.getFileName$kotlinpoet();
        this.members = CollectionsKt.toList((Iterable)builder.getMembers$kotlinpoet());
        this.skipJavaLangImports = builder.getSkipJavaLangImports$kotlinpoet();
        this.memberImports = UtilKt.toImmutableSet((Collection)builder.getMemberImports$kotlinpoet());
        this.indent = builder.getIndent$kotlinpoet();
    }

    public /* synthetic */ KotlinFile(@NotNull Builder builder, DefaultConstructorMarker $constructor_marker) {
        this(builder);
    }

    @JvmStatic
    @NotNull
    public static final KotlinFile get(@NotNull String packageName, @NotNull TypeSpec typeSpec) {
        Intrinsics.checkParameterIsNotNull((Object)packageName, (String)"packageName");
        Intrinsics.checkParameterIsNotNull((Object)typeSpec, (String)"typeSpec");
        return Companion.get(packageName, typeSpec);
    }

    @JvmStatic
    @NotNull
    public static final Builder builder(@NotNull String packageName, @NotNull String fileName) {
        Intrinsics.checkParameterIsNotNull((Object)packageName, (String)"packageName");
        Intrinsics.checkParameterIsNotNull((Object)fileName, (String)"fileName");
        return Companion.builder(packageName, fileName);
    }

    @Metadata(mv={1, 1, 6}, bv={1, 0, 1}, k=1, d1={"\u0000~\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010!\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0002\b\u0007\n\u0002\u0010\u0011\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0010\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0017\b\u0000\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0005J'\u0010 \u001a\u00020\u00002\u0006\u0010!\u001a\u00020\u00032\u0012\u0010\"\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00010#\"\u00020\u0001\u00a2\u0006\u0002\u0010$J\u000e\u0010%\u001a\u00020\u00002\u0006\u0010&\u001a\u00020'J\u000e\u0010(\u001a\u00020\u00002\u0006\u0010)\u001a\u00020*J'\u0010+\u001a\u00020\u00002\u0006\u0010,\u001a\u00020-2\u0012\u0010.\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00030#\"\u00020\u0003\u00a2\u0006\u0002\u0010/J+\u0010+\u001a\u00020\u00002\n\u00100\u001a\u0006\u0012\u0002\b\u0003012\u0012\u0010.\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00030#\"\u00020\u0003\u00a2\u0006\u0002\u00102J\u0012\u0010+\u001a\u00020\u00002\n\u00103\u001a\u0006\u0012\u0002\b\u000304J+\u0010+\u001a\u00020\u00002\n\u00100\u001a\u0006\u0012\u0002\b\u0003052\u0012\u0010.\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00030#\"\u00020\u0003\u00a2\u0006\u0002\u00106J\u000e\u00107\u001a\u00020\u00002\u0006\u00108\u001a\u000209J\u000e\u0010:\u001a\u00020\u00002\u0006\u0010;\u001a\u00020<J\u0006\u0010=\u001a\u00020>J\u000e\u0010\f\u001a\u00020\u00002\u0006\u0010\f\u001a\u00020\u0003J\u000e\u0010\u001a\u001a\u00020\u00002\u0006\u0010\u001a\u001a\u00020\u001bR\u0014\u0010\u0006\u001a\u00020\u0007X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0014\u0010\u0004\u001a\u00020\u0003X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u001a\u0010\f\u001a\u00020\u0003X\u0080\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\r\u0010\u000b\"\u0004\b\u000e\u0010\u000fR$\u0010\u0010\u001a\u0012\u0012\u0004\u0012\u00020\u00030\u0011j\b\u0012\u0004\u0012\u00020\u0003`\u0012X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0014R\u001a\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u00010\u0016X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0017\u0010\u0018R\u0014\u0010\u0002\u001a\u00020\u0003X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0019\u0010\u000bR\u001a\u0010\u001a\u001a\u00020\u001bX\u0080\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001c\u0010\u001d\"\u0004\b\u001e\u0010\u001f\u00a8\u0006?"}, d2={"Lcom/squareup/kotlinpoet/KotlinFile$Builder;", "", "packageName", "", "fileName", "(Ljava/lang/String;Ljava/lang/String;)V", "fileComment", "Lcom/squareup/kotlinpoet/CodeBlock$Builder;", "getFileComment$kotlinpoet", "()Lcom/squareup/kotlinpoet/CodeBlock$Builder;", "getFileName$kotlinpoet", "()Ljava/lang/String;", "indent", "getIndent$kotlinpoet", "setIndent$kotlinpoet", "(Ljava/lang/String;)V", "memberImports", "Ljava/util/TreeSet;", "Lkotlin/collections/TreeSet;", "getMemberImports$kotlinpoet", "()Ljava/util/TreeSet;", "members", "", "getMembers$kotlinpoet", "()Ljava/util/List;", "getPackageName$kotlinpoet", "skipJavaLangImports", "", "getSkipJavaLangImports$kotlinpoet", "()Z", "setSkipJavaLangImports$kotlinpoet", "(Z)V", "addFileComment", "format", "args", "", "(Ljava/lang/String;[Ljava/lang/Object;)Lcom/squareup/kotlinpoet/KotlinFile$Builder;", "addFun", "funSpec", "Lcom/squareup/kotlinpoet/FunSpec;", "addProperty", "propertySpec", "Lcom/squareup/kotlinpoet/PropertySpec;", "addStaticImport", "className", "Lcom/squareup/kotlinpoet/ClassName;", "names", "(Lcom/squareup/kotlinpoet/ClassName;[Ljava/lang/String;)Lcom/squareup/kotlinpoet/KotlinFile$Builder;", "clazz", "Ljava/lang/Class;", "(Ljava/lang/Class;[Ljava/lang/String;)Lcom/squareup/kotlinpoet/KotlinFile$Builder;", "constant", "", "Lkotlin/reflect/KClass;", "(Lkotlin/reflect/KClass;[Ljava/lang/String;)Lcom/squareup/kotlinpoet/KotlinFile$Builder;", "addType", "typeSpec", "Lcom/squareup/kotlinpoet/TypeSpec;", "addTypeAlias", "typeAliasSpec", "Lcom/squareup/kotlinpoet/TypeAliasSpec;", "build", "Lcom/squareup/kotlinpoet/KotlinFile;", "kotlinpoet"})
    public static final class Builder {
        @NotNull
        private final CodeBlock.Builder fileComment;
        @NotNull
        private final TreeSet<String> memberImports;
        private boolean skipJavaLangImports;
        @NotNull
        private String indent;
        @NotNull
        private final List<Object> members;
        @NotNull
        private final String packageName;
        @NotNull
        private final String fileName;

        @NotNull
        public final CodeBlock.Builder getFileComment$kotlinpoet() {
            return this.fileComment;
        }

        @NotNull
        public final TreeSet<String> getMemberImports$kotlinpoet() {
            return this.memberImports;
        }

        public final boolean getSkipJavaLangImports$kotlinpoet() {
            return this.skipJavaLangImports;
        }

        public final void setSkipJavaLangImports$kotlinpoet(boolean bl) {
            this.skipJavaLangImports = bl;
        }

        @NotNull
        public final String getIndent$kotlinpoet() {
            return this.indent;
        }

        public final void setIndent$kotlinpoet(@NotNull String string) {
            Intrinsics.checkParameterIsNotNull((Object)string, (String)"<set-?>");
            this.indent = string;
        }

        @NotNull
        public final List<Object> getMembers$kotlinpoet() {
            return this.members;
        }

        @NotNull
        public final Builder addFileComment(@NotNull String format, Object ... args) {
            Builder builder;
            Intrinsics.checkParameterIsNotNull((Object)format, (String)"format");
            Intrinsics.checkParameterIsNotNull((Object)args, (String)"args");
            Builder $receiver = builder = this;
            $receiver.fileComment.add(format, Arrays.copyOf(args, args.length));
            return builder;
        }

        @NotNull
        public final Builder addType(@NotNull TypeSpec typeSpec) {
            Builder builder;
            Intrinsics.checkParameterIsNotNull((Object)typeSpec, (String)"typeSpec");
            Builder $receiver = builder = this;
            Collection collection = $receiver.members;
            TypeSpec typeSpec2 = typeSpec;
            collection.add(typeSpec2);
            return builder;
        }

        @NotNull
        public final Builder addFun(@NotNull FunSpec funSpec) {
            boolean bl;
            Builder builder;
            Intrinsics.checkParameterIsNotNull((Object)funSpec, (String)"funSpec");
            Builder $receiver = builder = this;
            boolean bl2 = bl = !funSpec.isConstructor() && !funSpec.isAccessor();
            if (!bl) {
                String string = "cannot add " + funSpec.getName() + " to file " + $receiver.fileName;
                throw (Throwable)new IllegalArgumentException(string.toString());
            }
            Collection collection = $receiver.members;
            FunSpec funSpec2 = funSpec;
            collection.add(funSpec2);
            return builder;
        }

        @NotNull
        public final Builder addProperty(@NotNull PropertySpec propertySpec) {
            Builder builder;
            Intrinsics.checkParameterIsNotNull((Object)propertySpec, (String)"propertySpec");
            Builder $receiver = builder = this;
            Collection collection = $receiver.members;
            PropertySpec propertySpec2 = propertySpec;
            collection.add(propertySpec2);
            return builder;
        }

        @NotNull
        public final Builder addTypeAlias(@NotNull TypeAliasSpec typeAliasSpec) {
            Builder builder;
            Intrinsics.checkParameterIsNotNull((Object)typeAliasSpec, (String)"typeAliasSpec");
            Builder $receiver = builder = this;
            Collection collection = $receiver.members;
            TypeAliasSpec typeAliasSpec2 = typeAliasSpec;
            collection.add(typeAliasSpec2);
            return builder;
        }

        @NotNull
        public final Builder addStaticImport(@NotNull Enum<?> constant) {
            Intrinsics.checkParameterIsNotNull(constant, (String)"constant");
            return this.addStaticImport(ClassName.Companion.get(constant.getDeclaringClass()), constant.name());
        }

        @NotNull
        public final Builder addStaticImport(@NotNull Class<?> clazz, String ... names) {
            Intrinsics.checkParameterIsNotNull(clazz, (String)"clazz");
            Intrinsics.checkParameterIsNotNull((Object)names, (String)"names");
            return this.addStaticImport(ClassName.Companion.get(clazz), Arrays.copyOf(names, names.length));
        }

        @NotNull
        public final Builder addStaticImport(@NotNull KClass<?> clazz, String ... names) {
            Intrinsics.checkParameterIsNotNull(clazz, (String)"clazz");
            Intrinsics.checkParameterIsNotNull((Object)names, (String)"names");
            return this.addStaticImport(ClassName.Companion.get(clazz), Arrays.copyOf(names, names.length));
        }

        @NotNull
        public final Builder addStaticImport(@NotNull ClassName className, String ... names) {
            boolean bl;
            Object[] objectArray;
            Builder builder;
            Intrinsics.checkParameterIsNotNull((Object)className, (String)"className");
            Intrinsics.checkParameterIsNotNull((Object)names, (String)"names");
            Builder $receiver = builder = this;
            Object[] objectArray2 = objectArray = (Object[])names;
            boolean bl2 = bl = !(objectArray2.length == 0);
            if (!bl) {
                String string = "names array is empty";
                throw (Throwable)new IllegalStateException(string.toString());
            }
            String[] stringArray = names;
            for (int i = 0; i < stringArray.length; ++i) {
                String name = stringArray[i];
                Collection collection = $receiver.memberImports;
                String string = className.getCanonicalName() + "." + name;
                collection.add(string);
            }
            return builder;
        }

        @NotNull
        public final Builder skipJavaLangImports(boolean skipJavaLangImports) {
            Builder builder;
            Builder $receiver = builder = this;
            $receiver.skipJavaLangImports = skipJavaLangImports;
            return builder;
        }

        @NotNull
        public final Builder indent(@NotNull String indent) {
            Builder builder;
            Intrinsics.checkParameterIsNotNull((Object)indent, (String)"indent");
            Builder $receiver = builder = this;
            $receiver.indent = indent;
            return builder;
        }

        @NotNull
        public final KotlinFile build() {
            return new KotlinFile(this, null);
        }

        @NotNull
        public final String getPackageName$kotlinpoet() {
            return this.packageName;
        }

        @NotNull
        public final String getFileName$kotlinpoet() {
            return this.fileName;
        }

        public Builder(@NotNull String packageName, @NotNull String fileName) {
            List list;
            Intrinsics.checkParameterIsNotNull((Object)packageName, (String)"packageName");
            Intrinsics.checkParameterIsNotNull((Object)fileName, (String)"fileName");
            this.packageName = packageName;
            this.fileName = fileName;
            this.fileComment = CodeBlock.Companion.builder();
            this.memberImports = SetsKt.sortedSetOf((Object[])new String[0]);
            this.indent = "  ";
            Builder builder = this;
            builder.members = list = (List)new ArrayList();
            boolean bl = SourceVersion.isName(this.fileName);
            if (!bl) {
                String string = "not a valid file name: " + this.fileName;
                throw (Throwable)new IllegalArgumentException(string.toString());
            }
        }
    }

    @Metadata(mv={1, 1, 6}, bv={1, 0, 1}, k=1, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u0006H\u0007J\u0018\u0010\b\u001a\u00020\t2\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\n\u001a\u00020\u000bH\u0007\u00a8\u0006\f"}, d2={"Lcom/squareup/kotlinpoet/KotlinFile$Companion;", "", "()V", "builder", "Lcom/squareup/kotlinpoet/KotlinFile$Builder;", "packageName", "", "fileName", "get", "Lcom/squareup/kotlinpoet/KotlinFile;", "typeSpec", "Lcom/squareup/kotlinpoet/TypeSpec;", "kotlinpoet"})
    public static final class Companion {
        @JvmStatic
        @NotNull
        public final KotlinFile get(@NotNull String packageName, @NotNull TypeSpec typeSpec) {
            Intrinsics.checkParameterIsNotNull((Object)packageName, (String)"packageName");
            Intrinsics.checkParameterIsNotNull((Object)typeSpec, (String)"typeSpec");
            String string = typeSpec.getName();
            if (string == null) {
                throw (Throwable)new IllegalArgumentException("file name required but type has no name");
            }
            String fileName = string;
            return this.builder(packageName, fileName).addType(typeSpec).build();
        }

        @JvmStatic
        @NotNull
        public final Builder builder(@NotNull String packageName, @NotNull String fileName) {
            Intrinsics.checkParameterIsNotNull((Object)packageName, (String)"packageName");
            Intrinsics.checkParameterIsNotNull((Object)fileName, (String)"fileName");
            return new Builder(packageName, fileName);
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

