/*
 * Decompiled with CFR 0.152.
 */
package com.squareup.kotlinpoet;

import com.squareup.kotlinpoet.KModifier;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.StringCompanionObject;
import kotlin.ranges.IntRange;
import kotlin.ranges.RangesKt;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 6}, bv={1, 0, 1}, k=2, d1={"\u0000:\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\f\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\b\u0004\n\u0002\u0010 \n\u0000\n\u0002\u0010\u001e\n\u0000\n\u0002\u0010$\n\u0002\b\u0005\u001a\u0010\u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u0003H\u0000\u001a/\u0010\u0004\u001a\u00020\u00052\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u00072\u0012\u0010\t\u001a\n\u0012\u0006\b\u0001\u0012\u00020\b0\n\"\u00020\bH\u0000\u00a2\u0006\u0002\u0010\u000b\u001a\u0010\u0010\f\u001a\u00020\u00012\u0006\u0010\r\u001a\u00020\u0001H\u0000\u001a\u001e\u0010\u000e\u001a\b\u0012\u0004\u0012\u0002H\u00100\u000f\"\u0004\b\u0000\u0010\u0010*\b\u0012\u0004\u0012\u0002H\u00100\u0011H\u0000\u001a0\u0010\u0012\u001a\u000e\u0012\u0004\u0012\u0002H\u0014\u0012\u0004\u0012\u0002H\u00150\u0013\"\u0004\b\u0000\u0010\u0014\"\u0004\b\u0001\u0010\u0015*\u000e\u0012\u0004\u0012\u0002H\u0014\u0012\u0004\u0012\u0002H\u00150\u0013H\u0000\u001a<\u0010\u0016\u001a\u0014\u0012\u0004\u0012\u0002H\u0014\u0012\n\u0012\b\u0012\u0004\u0012\u0002H\u00150\u000f0\u0013\"\u0004\b\u0000\u0010\u0014\"\u0004\b\u0001\u0010\u0015*\u0014\u0012\u0004\u0012\u0002H\u0014\u0012\n\u0012\b\u0012\u0004\u0012\u0002H\u00150\u000f0\u0013H\u0000\u001a\u001e\u0010\u0017\u001a\b\u0012\u0004\u0012\u0002H\u00100\u0007\"\u0004\b\u0000\u0010\u0010*\b\u0012\u0004\u0012\u0002H\u00100\u0011H\u0000\u00a8\u0006\u0018"}, d2={"characterLiteralWithoutSingleQuotes", "", "c", "", "requireExactlyOneOf", "", "modifiers", "", "Lcom/squareup/kotlinpoet/KModifier;", "mutuallyExclusive", "", "(Ljava/util/Set;[Lcom/squareup/kotlinpoet/KModifier;)V", "stringLiteralWithQuotes", "value", "toImmutableList", "", "T", "", "toImmutableMap", "", "K", "V", "toImmutableMultimap", "toImmutableSet", "kotlinpoet"})
public final class UtilKt {
    @NotNull
    public static final <K, V> Map<K, List<V>> toImmutableMultimap(@NotNull Map<K, ? extends List<? extends V>> $receiver) {
        Intrinsics.checkParameterIsNotNull($receiver, (String)"$receiver");
        LinkedHashMap result = new LinkedHashMap();
        Map<K, List<V>> map = $receiver;
        Iterator<Map.Entry<K, List<V>>> iterator = map.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry<K, List<List<List<List<List<List<List<List<V>>>>>>>>> entry;
            Map.Entry<K, List<List<List<List<List<List<List<List<V>>>>>>>>> entry2 = entry = iterator.next();
            K key = entry2.getKey();
            entry2 = entry;
            List<List<V>> value = entry2.getValue();
            if (value.isEmpty()) continue;
            result.put(key, UtilKt.toImmutableList((Collection)value));
        }
        Map map2 = Collections.unmodifiableMap(result);
        Intrinsics.checkExpressionValueIsNotNull(map2, (String)"Collections.unmodifiableMap(result)");
        return map2;
    }

    @NotNull
    public static final <K, V> Map<K, V> toImmutableMap(@NotNull Map<K, ? extends V> $receiver) {
        Intrinsics.checkParameterIsNotNull($receiver, (String)"$receiver");
        Map map = Collections.unmodifiableMap((Map)new LinkedHashMap<K, V>($receiver));
        Intrinsics.checkExpressionValueIsNotNull(map, (String)"Collections.unmodifiableMap(LinkedHashMap(this))");
        return map;
    }

    @NotNull
    public static final <T> List<T> toImmutableList(@NotNull Collection<? extends T> $receiver) {
        Intrinsics.checkParameterIsNotNull($receiver, (String)"$receiver");
        List list = Collections.unmodifiableList((List)new ArrayList<T>($receiver));
        Intrinsics.checkExpressionValueIsNotNull(list, (String)"Collections.unmodifiableList(ArrayList(this))");
        return list;
    }

    @NotNull
    public static final <T> Set<T> toImmutableSet(@NotNull Collection<? extends T> $receiver) {
        Intrinsics.checkParameterIsNotNull($receiver, (String)"$receiver");
        Set set = Collections.unmodifiableSet((Set)new LinkedHashSet<T>($receiver));
        Intrinsics.checkExpressionValueIsNotNull(set, (String)"Collections.unmodifiableSet(LinkedHashSet(this))");
        return set;
    }

    public static final void requireExactlyOneOf(@NotNull Set<? extends KModifier> modifiers, KModifier ... mutuallyExclusive) {
        boolean bl;
        Intrinsics.checkParameterIsNotNull(modifiers, (String)"modifiers");
        Intrinsics.checkParameterIsNotNull((Object)mutuallyExclusive, (String)"mutuallyExclusive");
        int count = 0;
        for (int i = 0; i < mutuallyExclusive.length; ++i) {
            KModifier modifier = mutuallyExclusive[i];
            if (!modifiers.contains((Object)modifier)) continue;
            ++count;
        }
        boolean bl2 = bl = count == 1;
        if (!bl) {
            String string = "modifiers " + modifiers + " must contain one of " + Arrays.toString((Object[])mutuallyExclusive);
            throw (Throwable)new IllegalArgumentException(string.toString());
        }
    }

    @NotNull
    public static final String characterLiteralWithoutSingleQuotes(char c) {
        String string;
        if (c == '\b') {
            string = "\\b";
        } else if (c == '\t') {
            string = "\\t";
        } else if (c == '\n') {
            string = "\\n";
        } else if (c == '\r') {
            string = "\\r";
        } else if (c == '\"') {
            string = "\"";
        } else if (c == '\'') {
            string = "\\'";
        } else if (c == '\\') {
            string = "\\\\";
        } else if (Character.isISOControl(c)) {
            StringCompanionObject stringCompanionObject = StringCompanionObject.INSTANCE;
            String string2 = "\\u%04x";
            Object[] objectArray = new Object[]{(int)c};
            String string3 = String.format(string2, Arrays.copyOf(objectArray, objectArray.length));
            string = string3;
            Intrinsics.checkExpressionValueIsNotNull((Object)string3, (String)"java.lang.String.format(format, *args)");
        } else {
            String string4 = Character.toString(c);
            string = string4;
            Intrinsics.checkExpressionValueIsNotNull((Object)string4, (String)"Character.toString(c)");
        }
        return string;
    }

    @NotNull
    public static final String stringLiteralWithQuotes(@NotNull String value) {
        Intrinsics.checkParameterIsNotNull((Object)value, (String)"value");
        if (StringsKt.contains$default((CharSequence)value, (CharSequence)"\n", (boolean)false, (int)2, null)) {
            StringBuilder result = new StringBuilder(value.length() + 32);
            result.append("\"\"\"\n|");
            for (int i = 0; i < value.length(); ++i) {
                char c = value.charAt(i);
                if (StringsKt.regionMatches$default((String)value, (int)i, (String)"\"\"\"", (int)0, (int)3, (boolean)false, (int)16, null)) {
                    result.append("\"\"${'\"'}");
                    i += 2;
                    continue;
                }
                if (c == '\n') {
                    result.append("\n|");
                    continue;
                }
                result.append(c);
            }
            if (!StringsKt.endsWith$default((String)value, (String)"\n", (boolean)false, (int)2, null)) {
                result.append("\n");
            }
            result.append("\"\"\".trimMargin()");
            String string = result.toString();
            Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"result.toString()");
            return string;
        }
        StringBuilder result = new StringBuilder(value.length() + 32);
        result.append('\"');
        IntRange intRange = RangesKt.until((int)0, (int)value.length());
        int i = intRange.getFirst();
        int n = intRange.getLast();
        if (i <= n) {
            while (true) {
                char c;
                if ((c = value.charAt(i)) == '\'') {
                    result.append("'");
                } else if (c == '\"') {
                    result.append("\\\"");
                } else {
                    result.append(UtilKt.characterLiteralWithoutSingleQuotes(c));
                }
                if (i == n) break;
                ++i;
            }
        }
        result.append('\"');
        String string = result.toString();
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"result.toString()");
        return string;
    }
}

