/*
 * Decompiled with CFR 0.152.
 */
package com.squareup.leakcanary;

import com.squareup.leakcanary.Exclusion;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Locale;

public final class LeakTraceElement
implements Serializable {
    public final String referenceName;
    public final Type type;
    public final Holder holder;
    public final String className;
    public final String extra;
    public final Exclusion exclusion;
    public final List<String> fields;

    LeakTraceElement(String referenceName, Type type, Holder holder, String className, String extra, Exclusion exclusion, List<String> fields) {
        this.referenceName = referenceName;
        this.type = type;
        this.holder = holder;
        this.className = className;
        this.extra = extra;
        this.exclusion = exclusion;
        this.fields = Collections.unmodifiableList(new ArrayList<String>(fields));
    }

    public String toString() {
        String string = "";
        if (this.type == Type.STATIC_FIELD) {
            string = string + "static ";
        }
        if (this.holder == Holder.ARRAY || this.holder == Holder.THREAD) {
            string = string + this.holder.name().toLowerCase(Locale.US) + " ";
        }
        string = string + this.className;
        string = this.referenceName != null ? string + "." + this.referenceName : string + " instance";
        if (this.extra != null) {
            string = string + " " + this.extra;
        }
        if (this.exclusion != null) {
            string = string + " , matching exclusion " + this.exclusion.matching;
        }
        return string;
    }

    public String toDetailedString() {
        String string = "* ";
        string = this.holder == Holder.ARRAY ? string + "Array of" : (this.holder == Holder.CLASS ? string + "Class" : string + "Instance of");
        string = string + " " + this.className + "\n";
        for (String field : this.fields) {
            string = string + "|   " + field + "\n";
        }
        return string;
    }

    public static enum Holder {
        OBJECT,
        CLASS,
        THREAD,
        ARRAY;

    }

    public static enum Type {
        INSTANCE_FIELD,
        STATIC_FIELD,
        LOCAL,
        ARRAY_ENTRY;

    }
}

