/*
 * Decompiled with CFR 0.152.
 */
package com.squareup.leakcanary;

import com.squareup.leakcanary.LeakTraceElement;
import com.squareup.leakcanary.Reachability;
import java.io.Serializable;
import java.util.List;

public final class LeakTrace
implements Serializable {
    public final List<LeakTraceElement> elements;
    public final List<Reachability> expectedReachability;

    LeakTrace(List<LeakTraceElement> elements, List<Reachability> expectedReachability) {
        this.elements = elements;
        this.expectedReachability = expectedReachability;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < this.elements.size(); ++i) {
            Reachability nextReachability;
            LeakTraceElement element = this.elements.get(i);
            sb.append("* ");
            if (i != 0) {
                sb.append("\u21b3 ");
            }
            boolean maybeLeakCause = false;
            Reachability currentReachability = this.expectedReachability.get(i);
            if (currentReachability == Reachability.UNKNOWN) {
                maybeLeakCause = true;
            } else if (currentReachability == Reachability.REACHABLE && (nextReachability = this.expectedReachability.get(i + 1)) != Reachability.REACHABLE) {
                maybeLeakCause = true;
            }
            sb.append(element.toString(maybeLeakCause)).append("\n");
        }
        return sb.toString();
    }

    public String toDetailedString() {
        String string = "";
        for (LeakTraceElement element : this.elements) {
            string = string + element.toDetailedString();
        }
        return string;
    }
}

