/*
 * Decompiled with CFR 0.152.
 */
package com.squareup.leakcanary;

import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import com.squareup.leakcanary.LeakTrace;
import com.squareup.leakcanary.LeakTraceElement;
import java.io.Serializable;

public final class AnalysisResult
implements Serializable {
    public static final long RETAINED_HEAP_SKIPPED = -1L;
    public final boolean leakFound;
    public final boolean excludedLeak;
    @Nullable
    public final String className;
    @Nullable
    public final LeakTrace leakTrace;
    @Nullable
    public final Throwable failure;
    public final long retainedHeapSize;
    public final long analysisDurationMs;

    @NonNull
    public static AnalysisResult noLeak(long analysisDurationMs) {
        return new AnalysisResult(false, false, null, null, null, 0L, analysisDurationMs);
    }

    @NonNull
    public static AnalysisResult leakDetected(boolean excludedLeak, @NonNull String className, @NonNull LeakTrace leakTrace, long retainedHeapSize, long analysisDurationMs) {
        return new AnalysisResult(true, excludedLeak, className, leakTrace, null, retainedHeapSize, analysisDurationMs);
    }

    @NonNull
    public static AnalysisResult failure(@NonNull Throwable failure, long analysisDurationMs) {
        return new AnalysisResult(false, false, null, null, failure, 0L, analysisDurationMs);
    }

    @NonNull
    public RuntimeException leakTraceAsFakeException() {
        if (!this.leakFound) {
            throw new UnsupportedOperationException("leakTraceAsFakeException() can only be called when leakFound is true");
        }
        LeakTraceElement firstElement = this.leakTrace.elements.get(0);
        String rootSimpleName = this.classSimpleName(firstElement.className);
        String leakSimpleName = this.classSimpleName(this.className);
        String exceptionMessage = leakSimpleName + " leak from " + rootSimpleName + " (holder=" + firstElement.holder + ", type=" + firstElement.type + ")";
        RuntimeException exception = new RuntimeException(exceptionMessage);
        StackTraceElement[] stackTrace = new StackTraceElement[this.leakTrace.elements.size()];
        int i = 0;
        for (LeakTraceElement element : this.leakTrace.elements) {
            String methodName = element.referenceName != null ? element.referenceName : "leaking";
            String file = this.classSimpleName(element.className) + ".java";
            stackTrace[i] = new StackTraceElement(element.className, methodName, file, 42);
            ++i;
        }
        exception.setStackTrace(stackTrace);
        return exception;
    }

    private AnalysisResult(boolean leakFound, boolean excludedLeak, String className, LeakTrace leakTrace, Throwable failure, long retainedHeapSize, long analysisDurationMs) {
        this.leakFound = leakFound;
        this.excludedLeak = excludedLeak;
        this.className = className;
        this.leakTrace = leakTrace;
        this.failure = failure;
        this.retainedHeapSize = retainedHeapSize;
        this.analysisDurationMs = analysisDurationMs;
    }

    private String classSimpleName(String className) {
        int separator = className.lastIndexOf(46);
        return separator == -1 ? className : className.substring(separator + 1);
    }
}

