/*
 * Decompiled with CFR 0.152.
 */
package com.squareup.leakcanary;

import android.os.Build;
import android.support.annotation.NonNull;
import com.squareup.haha.perflib.ArrayInstance;
import com.squareup.haha.perflib.ClassInstance;
import com.squareup.haha.perflib.ClassObj;
import com.squareup.haha.perflib.Field;
import com.squareup.haha.perflib.HprofParser;
import com.squareup.haha.perflib.Instance;
import com.squareup.haha.perflib.RootObj;
import com.squareup.haha.perflib.RootType;
import com.squareup.haha.perflib.Snapshot;
import com.squareup.haha.perflib.Type;
import com.squareup.haha.perflib.io.HprofBuffer;
import com.squareup.haha.perflib.io.MemoryMappedFileBuffer;
import com.squareup.leakcanary.AnalysisResult;
import com.squareup.leakcanary.AnalyzerProgressListener;
import com.squareup.leakcanary.ExcludedRefs;
import com.squareup.leakcanary.HahaHelper;
import com.squareup.leakcanary.KeyedWeakReference;
import com.squareup.leakcanary.LeakNode;
import com.squareup.leakcanary.LeakReference;
import com.squareup.leakcanary.LeakTrace;
import com.squareup.leakcanary.LeakTraceElement;
import com.squareup.leakcanary.Reachability;
import com.squareup.leakcanary.ShortestPathFinder;
import com.squareup.leakcanary.TrackedReference;
import gnu.trove.THashMap;
import gnu.trove.TObjectProcedure;
import java.io.File;
import java.lang.reflect.Constructor;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;

public final class HeapAnalyzer {
    private static final String ANONYMOUS_CLASS_NAME_PATTERN = "^.+\\$\\d+$";
    private final ExcludedRefs excludedRefs;
    private final AnalyzerProgressListener listener;
    private final List<Reachability.Inspector> reachabilityInspectors;

    @Deprecated
    public HeapAnalyzer(@NonNull ExcludedRefs excludedRefs) {
        this(excludedRefs, AnalyzerProgressListener.NONE, Collections.emptyList());
    }

    public HeapAnalyzer(@NonNull ExcludedRefs excludedRefs, @NonNull AnalyzerProgressListener listener, @NonNull List<Class<? extends Reachability.Inspector>> reachabilityInspectorClasses) {
        this.excludedRefs = excludedRefs;
        this.listener = listener;
        this.reachabilityInspectors = new ArrayList<Reachability.Inspector>();
        for (Class<? extends Reachability.Inspector> reachabilityInspectorClass : reachabilityInspectorClasses) {
            try {
                Constructor<? extends Reachability.Inspector> defaultConstructor = reachabilityInspectorClass.getDeclaredConstructor(new Class[0]);
                this.reachabilityInspectors.add(defaultConstructor.newInstance(new Object[0]));
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
    }

    @NonNull
    public List<TrackedReference> findTrackedReferences(@NonNull File heapDumpFile) {
        if (!heapDumpFile.exists()) {
            throw new IllegalArgumentException("File does not exist: " + heapDumpFile);
        }
        try {
            MemoryMappedFileBuffer buffer = new MemoryMappedFileBuffer(heapDumpFile);
            HprofParser parser = new HprofParser((HprofBuffer)buffer);
            Snapshot snapshot = parser.parse();
            this.deduplicateGcRoots(snapshot);
            ClassObj refClass = snapshot.findClass(KeyedWeakReference.class.getName());
            ArrayList<TrackedReference> references = new ArrayList<TrackedReference>();
            for (Instance weakRef : refClass.getInstancesList()) {
                String name;
                List<ClassInstance.FieldValue> values = HahaHelper.classInstanceValues(weakRef);
                String key = HahaHelper.asString(HahaHelper.fieldValue(values, "key"));
                String string = name = HahaHelper.hasField(values, "name") ? HahaHelper.asString(HahaHelper.fieldValue(values, "name")) : "(No name field)";
                Instance instance = (Instance)HahaHelper.fieldValue(values, "referent");
                if (instance == null) continue;
                String className = this.getClassName(instance);
                List<LeakReference> fields = this.describeFields(instance);
                references.add(new TrackedReference(key, name, className, fields));
            }
            return references;
        }
        catch (Throwable e) {
            throw new RuntimeException(e);
        }
    }

    @Deprecated
    @NonNull
    public AnalysisResult checkForLeak(@NonNull File heapDumpFile, @NonNull String referenceKey) {
        return this.checkForLeak(heapDumpFile, referenceKey, true);
    }

    @NonNull
    public AnalysisResult checkForLeak(@NonNull File heapDumpFile, @NonNull String referenceKey, boolean computeRetainedSize) {
        long analysisStartNanoTime = System.nanoTime();
        if (!heapDumpFile.exists()) {
            IllegalArgumentException exception = new IllegalArgumentException("File does not exist: " + heapDumpFile);
            return AnalysisResult.failure(exception, this.since(analysisStartNanoTime));
        }
        try {
            this.listener.onProgressUpdate(AnalyzerProgressListener.Step.READING_HEAP_DUMP_FILE);
            MemoryMappedFileBuffer buffer = new MemoryMappedFileBuffer(heapDumpFile);
            HprofParser parser = new HprofParser((HprofBuffer)buffer);
            this.listener.onProgressUpdate(AnalyzerProgressListener.Step.PARSING_HEAP_DUMP);
            Snapshot snapshot = parser.parse();
            this.listener.onProgressUpdate(AnalyzerProgressListener.Step.DEDUPLICATING_GC_ROOTS);
            this.deduplicateGcRoots(snapshot);
            this.listener.onProgressUpdate(AnalyzerProgressListener.Step.FINDING_LEAKING_REF);
            Instance leakingRef = this.findLeakingReference(referenceKey, snapshot);
            if (leakingRef == null) {
                return AnalysisResult.noLeak(this.since(analysisStartNanoTime));
            }
            return this.findLeakTrace(analysisStartNanoTime, snapshot, leakingRef, computeRetainedSize);
        }
        catch (Throwable e) {
            return AnalysisResult.failure(e, this.since(analysisStartNanoTime));
        }
    }

    void deduplicateGcRoots(Snapshot snapshot) {
        final THashMap uniqueRootMap = new THashMap();
        final Collection gcRoots = snapshot.getGCRoots();
        for (RootObj root : gcRoots) {
            String key = this.generateRootKey(root);
            if (uniqueRootMap.containsKey((Object)key)) continue;
            uniqueRootMap.put((Object)key, (Object)root);
        }
        gcRoots.clear();
        uniqueRootMap.forEach((TObjectProcedure)new TObjectProcedure<String>(){

            public boolean execute(String key) {
                return gcRoots.add(uniqueRootMap.get((Object)key));
            }
        });
    }

    private String generateRootKey(RootObj root) {
        return String.format("%s@0x%08x", root.getRootType().getName(), root.getId());
    }

    private Instance findLeakingReference(String key, Snapshot snapshot) {
        ClassObj refClass = snapshot.findClass(KeyedWeakReference.class.getName());
        if (refClass == null) {
            throw new IllegalStateException("Could not find the " + KeyedWeakReference.class.getName() + " class in the heap dump.");
        }
        ArrayList<String> keysFound = new ArrayList<String>();
        for (Instance instance : refClass.getInstancesList()) {
            List<ClassInstance.FieldValue> values = HahaHelper.classInstanceValues(instance);
            Object keyFieldValue = HahaHelper.fieldValue(values, "key");
            if (keyFieldValue == null) {
                keysFound.add(null);
                continue;
            }
            String keyCandidate = HahaHelper.asString(keyFieldValue);
            if (keyCandidate.equals(key)) {
                return (Instance)HahaHelper.fieldValue(values, "referent");
            }
            keysFound.add(keyCandidate);
        }
        throw new IllegalStateException("Could not find weak reference with key " + key + " in " + keysFound);
    }

    private AnalysisResult findLeakTrace(long analysisStartNanoTime, Snapshot snapshot, Instance leakingRef, boolean computeRetainedSize) {
        long retainedSize;
        this.listener.onProgressUpdate(AnalyzerProgressListener.Step.FINDING_SHORTEST_PATH);
        ShortestPathFinder pathFinder = new ShortestPathFinder(this.excludedRefs);
        ShortestPathFinder.Result result = pathFinder.findPath(snapshot, leakingRef);
        if (result.leakingNode == null) {
            return AnalysisResult.noLeak(this.since(analysisStartNanoTime));
        }
        this.listener.onProgressUpdate(AnalyzerProgressListener.Step.BUILDING_LEAK_TRACE);
        LeakTrace leakTrace = this.buildLeakTrace(result.leakingNode);
        String className = leakingRef.getClassObj().getClassName();
        if (computeRetainedSize) {
            this.listener.onProgressUpdate(AnalyzerProgressListener.Step.COMPUTING_DOMINATORS);
            snapshot.computeDominators();
            Instance leakingInstance = result.leakingNode.instance;
            retainedSize = leakingInstance.getTotalRetainedSize();
            if (Build.VERSION.SDK_INT <= 25) {
                this.listener.onProgressUpdate(AnalyzerProgressListener.Step.COMPUTING_BITMAP_SIZE);
                retainedSize += this.computeIgnoredBitmapRetainedSize(snapshot, leakingInstance);
            }
        } else {
            retainedSize = -1L;
        }
        return AnalysisResult.leakDetected(result.excludingKnownLeaks, className, leakTrace, retainedSize, this.since(analysisStartNanoTime));
    }

    private long computeIgnoredBitmapRetainedSize(Snapshot snapshot, Instance leakingInstance) {
        long bitmapRetainedSize = 0L;
        ClassObj bitmapClass = snapshot.findClass("android.graphics.Bitmap");
        for (Instance bitmapInstance : bitmapClass.getInstancesList()) {
            ArrayInstance mBufferInstance;
            if (!this.isIgnoredDominator(leakingInstance, bitmapInstance) || (mBufferInstance = (ArrayInstance)HahaHelper.fieldValue(HahaHelper.classInstanceValues(bitmapInstance), "mBuffer")) == null) continue;
            long bufferSize = mBufferInstance.getTotalRetainedSize();
            long bitmapSize = bitmapInstance.getTotalRetainedSize();
            if (bitmapSize < bufferSize) {
                bitmapSize += bufferSize;
            }
            bitmapRetainedSize += bitmapSize;
        }
        return bitmapRetainedSize;
    }

    private boolean isIgnoredDominator(Instance dominator, Instance instance) {
        boolean foundNativeRoot = false;
        do {
            Instance immediateDominator;
            if ((immediateDominator = instance.getImmediateDominator()) instanceof RootObj && ((RootObj)immediateDominator).getRootType() == RootType.UNKNOWN) {
                instance = instance.getNextInstanceToGcRoot();
                foundNativeRoot = true;
            } else {
                instance = immediateDominator;
            }
            if (instance != null) continue;
            return false;
        } while (instance != dominator);
        return foundNativeRoot;
    }

    private LeakTrace buildLeakTrace(LeakNode leakingNode) {
        ArrayList<LeakTraceElement> elements = new ArrayList<LeakTraceElement>();
        LeakNode node = new LeakNode(null, null, leakingNode, null);
        while (node != null) {
            LeakTraceElement element = this.buildLeakElement(node);
            if (element != null) {
                elements.add(0, element);
            }
            node = node.parent;
        }
        List<Reachability> expectedReachability = this.computeExpectedReachability(elements);
        return new LeakTrace(elements, expectedReachability);
    }

    private List<Reachability> computeExpectedReachability(List<LeakTraceElement> elements) {
        int lastElementIndex;
        int lastReachableElement = 0;
        int firstUnreachableElement = lastElementIndex = elements.size() - 1;
        block0: for (int i = 1; i < lastElementIndex; ++i) {
            LeakTraceElement element = elements.get(i);
            for (Reachability.Inspector reachabilityInspector : this.reachabilityInspectors) {
                Reachability reachability = reachabilityInspector.expectedReachability(element);
                if (reachability == Reachability.REACHABLE) {
                    lastReachableElement = i;
                    continue block0;
                }
                if (reachability != Reachability.UNREACHABLE) continue;
                firstUnreachableElement = i;
                break block0;
            }
        }
        ArrayList<Reachability> expectedReachability = new ArrayList<Reachability>();
        for (int i = 0; i < elements.size(); ++i) {
            Reachability status = i <= lastReachableElement ? Reachability.REACHABLE : (i >= firstUnreachableElement ? Reachability.UNREACHABLE : Reachability.UNKNOWN);
            expectedReachability.add(status);
        }
        return expectedReachability;
    }

    private LeakTraceElement buildLeakElement(LeakNode node) {
        LeakTraceElement.Holder holderType;
        ArrayList<String> classHierarchy;
        List<LeakReference> leakReferences;
        String extra;
        block17: {
            ClassObj classObj;
            if (node.parent == null) {
                return null;
            }
            Instance holder = node.parent.instance;
            if (holder instanceof RootObj) {
                return null;
            }
            extra = null;
            leakReferences = this.describeFields(holder);
            String className = this.getClassName(holder);
            classHierarchy = new ArrayList<String>();
            classHierarchy.add(className);
            String rootClassName = Object.class.getName();
            if (holder instanceof ClassInstance) {
                classObj = holder.getClassObj();
                while (!(classObj = classObj.getSuperClassObj()).getClassName().equals(rootClassName)) {
                    classHierarchy.add(classObj.getClassName());
                }
            }
            if (holder instanceof ClassObj) {
                holderType = LeakTraceElement.Holder.CLASS;
            } else if (holder instanceof ArrayInstance) {
                holderType = LeakTraceElement.Holder.ARRAY;
            } else {
                classObj = holder.getClassObj();
                if (HahaHelper.extendsThread(classObj)) {
                    holderType = LeakTraceElement.Holder.THREAD;
                    String threadName = HahaHelper.threadName(holder);
                    extra = "(named '" + threadName + "')";
                } else if (className.matches(ANONYMOUS_CLASS_NAME_PATTERN)) {
                    String parentClassName = classObj.getSuperClassObj().getClassName();
                    if (rootClassName.equals(parentClassName)) {
                        holderType = LeakTraceElement.Holder.OBJECT;
                        try {
                            Class<?> actualClass = Class.forName(classObj.getClassName());
                            Class<?>[] interfaces = actualClass.getInterfaces();
                            if (interfaces.length > 0) {
                                Class<?> implementedInterface = interfaces[0];
                                extra = "(anonymous implementation of " + implementedInterface.getName() + ")";
                                break block17;
                            }
                            extra = "(anonymous subclass of java.lang.Object)";
                        }
                        catch (ClassNotFoundException classNotFoundException) {}
                    } else {
                        holderType = LeakTraceElement.Holder.OBJECT;
                        extra = "(anonymous subclass of " + parentClassName + ")";
                    }
                } else {
                    holderType = LeakTraceElement.Holder.OBJECT;
                }
            }
        }
        return new LeakTraceElement(node.leakReference, holderType, classHierarchy, extra, node.exclusion, leakReferences);
    }

    private List<LeakReference> describeFields(Instance instance) {
        ArrayList<LeakReference> leakReferences;
        block5: {
            block6: {
                block4: {
                    leakReferences = new ArrayList<LeakReference>();
                    if (!(instance instanceof ClassObj)) break block4;
                    ClassObj classObj = (ClassObj)instance;
                    for (Map.Entry entry : classObj.getStaticFieldValues().entrySet()) {
                        String name = ((Field)entry.getKey()).getName();
                        String stringValue = HahaHelper.valueAsString(entry.getValue());
                        leakReferences.add(new LeakReference(LeakTraceElement.Type.STATIC_FIELD, name, stringValue));
                    }
                    break block5;
                }
                if (!(instance instanceof ArrayInstance)) break block6;
                ArrayInstance arrayInstance = (ArrayInstance)instance;
                if (arrayInstance.getArrayType() != Type.OBJECT) break block5;
                Object[] values = arrayInstance.getValues();
                for (int i = 0; i < values.length; ++i) {
                    String name = Integer.toString(i);
                    String stringValue = HahaHelper.valueAsString(values[i]);
                    leakReferences.add(new LeakReference(LeakTraceElement.Type.ARRAY_ENTRY, name, stringValue));
                }
                break block5;
            }
            ClassObj classObj = instance.getClassObj();
            for (Map.Entry entry : classObj.getStaticFieldValues().entrySet()) {
                String name = ((Field)entry.getKey()).getName();
                String stringValue = HahaHelper.valueAsString(entry.getValue());
                leakReferences.add(new LeakReference(LeakTraceElement.Type.STATIC_FIELD, name, stringValue));
            }
            ClassInstance classInstance = (ClassInstance)instance;
            for (ClassInstance.FieldValue field : classInstance.getValues()) {
                String name = field.getField().getName();
                String stringValue = HahaHelper.valueAsString(field.getValue());
                leakReferences.add(new LeakReference(LeakTraceElement.Type.INSTANCE_FIELD, name, stringValue));
            }
        }
        return leakReferences;
    }

    private String getClassName(Instance instance) {
        String className;
        if (instance instanceof ClassObj) {
            ClassObj classObj = (ClassObj)instance;
            className = classObj.getClassName();
        } else if (instance instanceof ArrayInstance) {
            ArrayInstance arrayInstance = (ArrayInstance)instance;
            className = arrayInstance.getClassObj().getClassName();
        } else {
            ClassObj classObj = instance.getClassObj();
            className = classObj.getClassName();
        }
        return className;
    }

    private long since(long analysisStartNanoTime) {
        return TimeUnit.NANOSECONDS.toMillis(System.nanoTime() - analysisStartNanoTime);
    }
}

