/*
 * Decompiled with CFR 0.152.
 */
package leakcanary;

import java.io.Closeable;
import java.lang.reflect.Constructor;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Pair;
import kotlin.Triple;
import kotlin.TuplesKt;
import kotlin.TypeCastException;
import kotlin.Unit;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.io.CloseableKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import kotlin.text.Regex;
import leakcanary.AnalyzerProgressListener;
import leakcanary.CanaryLog;
import leakcanary.GcRoot;
import leakcanary.HeapAnalysis;
import leakcanary.HeapAnalysisException;
import leakcanary.HeapAnalysisFailure;
import leakcanary.HeapAnalysisSuccess;
import leakcanary.HeapAnalyzer$WhenMappings;
import leakcanary.HeapDump;
import leakcanary.HeapDumpMemoryStore;
import leakcanary.HeapValue;
import leakcanary.HprofParser;
import leakcanary.HydratedClass;
import leakcanary.HydratedInstance;
import leakcanary.KeyedWeakReference;
import leakcanary.Labeler;
import leakcanary.LeakNode;
import leakcanary.LeakReference;
import leakcanary.LeakTrace;
import leakcanary.LeakTraceElement;
import leakcanary.LeakingInstance;
import leakcanary.NoPathToInstance;
import leakcanary.Reachability;
import leakcanary.Record;
import leakcanary.RetainedInstance;
import leakcanary.WeakReferenceCleared;
import leakcanary.WeakReferenceMissing;
import leakcanary.internal.KeyedWeakReferenceMirror;
import leakcanary.internal.ShortestPathFinder;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000\u00b8\u0001\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010%\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010!\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010#\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u0000 B2\u00020\u0001:\u0001BB\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J2\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\f\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u000b0\n2\u0012\u0010\f\u001a\u000e\u0012\u0004\u0012\u00020\u000e\u0012\u0004\u0012\u00020\u000f0\rH\u0002J&\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\b2\u0006\u0010\u0013\u001a\u00020\u00142\f\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u000e0\nH\u0002J.\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0012\u001a\u00020\b2\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u001b2\f\u0010\u001c\u001a\b\u0012\u0004\u0012\u00020\u001d0\nH\u0002JV\u0010\u001e\u001a\u00020\u00062\u0006\u0010\u0018\u001a\u00020\u00192\f\u0010\u001c\u001a\b\u0012\u0004\u0012\u00020\u001d0\n2\f\u0010\u001f\u001a\b\u0012\u0004\u0012\u00020 0\n2\u0006\u0010\u0012\u001a\u00020\b2\f\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u000b0!2\u0012\u0010\f\u001a\u000e\u0012\u0004\u0012\u00020\u000e\u0012\u0004\u0012\u00020\u000f0\rH\u0002J\u001c\u0010\"\u001a\u00020#2\u0006\u0010\u0018\u001a\u00020\u00192\f\u0010\u001c\u001a\b\u0012\u0004\u0012\u00020\u001d0\nJ,\u0010$\u001a\b\u0012\u0004\u0012\u00020%0\n2\u0006\u0010\u0012\u001a\u00020\b2\u0006\u0010\u0018\u001a\u00020\u00192\f\u0010&\u001a\b\u0012\u0004\u0012\u00020\u00110\nH\u0002J\u001e\u0010'\u001a\b\u0012\u0004\u0012\u00020(0\n2\u0006\u0010\u0012\u001a\u00020\b2\u0006\u0010)\u001a\u00020*H\u0002JN\u0010+\u001a\b\u0012\u0004\u0012\u00020\u000b0!2\u0006\u0010\u0012\u001a\u00020\b2\f\u0010,\u001a\b\u0012\u0004\u0012\u00020.0-2\u0012\u0010\f\u001a\u000e\u0012\u0004\u0012\u00020\u000e\u0012\u0004\u0012\u00020\u000f0\r2\f\u0010/\u001a\b\u0012\u0004\u0012\u0002000\n2\u0006\u00101\u001a\u00020.H\u0002J:\u00102\u001a\b\u0012\u0004\u0012\u00020 0\n2\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u0012\u001a\u00020\b2\f\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u000b0\n2\f\u00103\u001a\b\u0012\u0004\u0012\u00020.0!H\u0002J\u0010\u00104\u001a\u00020\u000e2\u0006\u00105\u001a\u000206H\u0002J&\u00107\u001a\u00020%2\u0006\u0010\u0012\u001a\u00020\b2\f\u00108\u001a\b\u0012\u0004\u0012\u0002090\n2\u0006\u0010:\u001a\u00020\u0011H\u0002J*\u0010;\u001a\u0014\u0012\n\u0012\b\u0012\u0004\u0012\u00020.0-\u0012\u0004\u0012\u00020.0<2\u0006\u0010\u0012\u001a\u00020\b2\u0006\u0010=\u001a\u00020.H\u0002J.\u0010>\u001a \u0012\n\u0012\b\u0012\u0004\u0012\u00020.0!\u0012\u0004\u0012\u00020.\u0012\n\u0012\b\u0012\u0004\u0012\u0002000\n0?2\u0006\u0010\u0012\u001a\u00020\bH\u0002J\u0010\u0010@\u001a\u00020.2\u0006\u0010A\u001a\u00020.H\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006C"}, d2={"Lleakcanary/HeapAnalyzer;", "", "listener", "Lleakcanary/AnalyzerProgressListener;", "(Lleakcanary/AnalyzerProgressListener;)V", "addRemainingInstancesWithNoPath", "", "hprofParser", "Lleakcanary/HprofParser;", "leakingWeakRefs", "", "Lleakcanary/internal/KeyedWeakReferenceMirror;", "analysisResults", "", "", "Lleakcanary/RetainedInstance;", "buildLeakElement", "Lleakcanary/LeakTraceElement;", "parser", "node", "Lleakcanary/LeakNode$ChildNode;", "labels", "buildLeakTrace", "Lleakcanary/LeakTrace;", "heapDump", "Lleakcanary/HeapDump;", "leakingNode", "Lleakcanary/LeakNode;", "labelers", "Lleakcanary/Labeler;", "buildLeakTraces", "pathResults", "Lleakcanary/internal/ShortestPathFinder$Result;", "", "checkForLeaks", "Lleakcanary/HeapAnalysis;", "computeExpectedReachability", "Lleakcanary/Reachability;", "elements", "describeFields", "Lleakcanary/LeakReference;", "record", "Lleakcanary/Record$HeapDumpRecord$ObjectRecord;", "findLeakingReferences", "retainedKeys", "", "", "keyedWeakReferenceInstances", "Lleakcanary/Record$HeapDumpRecord$ObjectRecord$InstanceDumpRecord;", "heapDumpUptimeMillis", "findShortestPaths", "gcRootIds", "heapValueAsString", "heapValue", "Lleakcanary/HeapValue;", "inspectElementReachability", "reachabilityInspectors", "Lleakcanary/Reachability$Inspector;", "element", "readHeapDumpMemoryStore", "Lkotlin/Pair;", "heapDumpMemoryStoreClassId", "scan", "Lkotlin/Triple;", "since", "analysisStartNanoTime", "Companion", "leakcanary-analyzer"})
public final class HeapAnalyzer {
    private final AnalyzerProgressListener listener;
    @NotNull
    public static final String ANONYMOUS_CLASS_NAME_PATTERN = "^.+\\$\\d+$";
    @NotNull
    private static final Regex ANONYMOUS_CLASS_NAME_PATTERN_REGEX;
    public static final Companion Companion;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    @NotNull
    public final HeapAnalysis checkForLeaks(@NotNull HeapDump heapDump, @NotNull List<? extends Labeler> labelers) {
        Intrinsics.checkParameterIsNotNull((Object)heapDump, (String)"heapDump");
        Intrinsics.checkParameterIsNotNull(labelers, (String)"labelers");
        long analysisStartNanoTime = System.nanoTime();
        if (!heapDump.getHeapDumpFile().exists()) {
            IllegalArgumentException exception = new IllegalArgumentException("File does not exist: " + heapDump + ".heapDumpFile");
            return (HeapAnalysis)new HeapAnalysisFailure(heapDump, System.currentTimeMillis(), this.since(analysisStartNanoTime), new HeapAnalysisException((Throwable)exception));
        }
        this.listener.onProgressUpdate(AnalyzerProgressListener.Step.READING_HEAP_DUMP_FILE);
        try {
            Closeable exception = (Closeable)HprofParser.Companion.open(heapDump.getHeapDumpFile());
            Throwable throwable = null;
            try {
                void gcRootIds;
                void retainedKeys;
                void heapDumpMemoryStoreClassId;
                HprofParser parser = (HprofParser)exception;
                boolean bl = false;
                this.listener.onProgressUpdate(AnalyzerProgressListener.Step.SCANNING_HEAP_DUMP);
                Triple<List<Long>, Long, List<Record.HeapDumpRecord.ObjectRecord.InstanceDumpRecord>> triple = this.scan(parser);
                List list = (List)triple.component1();
                long l = ((Number)triple.component2()).longValue();
                List keyedWeakReferenceInstances = (List)triple.component3();
                Map analysisResults = new LinkedHashMap();
                this.listener.onProgressUpdate(AnalyzerProgressListener.Step.FINDING_WATCHED_REFERENCES);
                Pair<Set<Long>, Long> pair = this.readHeapDumpMemoryStore(parser, (long)heapDumpMemoryStoreClassId);
                Set set = (Set)pair.component1();
                long heapDumpUptimeMillis = ((Number)pair.component2()).longValue();
                if (retainedKeys.isEmpty()) {
                    IllegalStateException exception2 = new IllegalStateException("No retained keys found in heap dump");
                    HeapAnalysis heapAnalysis = (HeapAnalysis)new HeapAnalysisFailure(heapDump, System.currentTimeMillis(), this.since(analysisStartNanoTime), new HeapAnalysisException((Throwable)exception2));
                    return heapAnalysis;
                }
                List<KeyedWeakReferenceMirror> leakingWeakRefs = this.findLeakingReferences(parser, (Set<Long>)retainedKeys, analysisResults, keyedWeakReferenceInstances, heapDumpUptimeMillis);
                List<ShortestPathFinder.Result> pathResults = this.findShortestPaths(heapDump, parser, leakingWeakRefs, (List<Long>)gcRootIds);
                this.buildLeakTraces(heapDump, labelers, pathResults, parser, leakingWeakRefs, analysisResults);
                this.addRemainingInstancesWithNoPath(parser, leakingWeakRefs, analysisResults);
                HeapAnalysis heapAnalysis = (HeapAnalysis)new HeapAnalysisSuccess(heapDump, System.currentTimeMillis(), this.since(analysisStartNanoTime), CollectionsKt.toList((Iterable)analysisResults.values()));
                return heapAnalysis;
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                CloseableKt.closeFinally((Closeable)exception, (Throwable)throwable);
            }
        }
        catch (Throwable exception) {
            return (HeapAnalysis)new HeapAnalysisFailure(heapDump, System.currentTimeMillis(), this.since(analysisStartNanoTime), new HeapAnalysisException(exception));
        }
    }

    /*
     * WARNING - void declaration
     */
    private final Triple<List<Long>, Long, List<Record.HeapDumpRecord.ObjectRecord.InstanceDumpRecord>> scan(HprofParser parser) {
        void heapDumpMemoryStoreClassId;
        void keyedWeakReferenceClassId;
        void heapDumpMemoryStoreStringId;
        void keyedWeakReferenceStringId;
        Ref.LongRef longRef = new Ref.LongRef();
        longRef.element = -1L;
        Ref.LongRef longRef2 = new Ref.LongRef();
        longRef2.element = -1L;
        Ref.LongRef longRef3 = new Ref.LongRef();
        longRef3.element = -1L;
        Ref.LongRef longRef4 = new Ref.LongRef();
        longRef4.element = -1L;
        List keyedWeakReferenceInstances = new ArrayList();
        List gcRootIds = new ArrayList();
        HprofParser.RecordCallbacks callbacks2 = new HprofParser.RecordCallbacks().on(Record.StringRecord.class, (Function1)new Function1<Record.StringRecord, Unit>((Ref.LongRef)keyedWeakReferenceStringId, (Ref.LongRef)heapDumpMemoryStoreStringId){
            final /* synthetic */ Ref.LongRef $keyedWeakReferenceStringId;
            final /* synthetic */ Ref.LongRef $heapDumpMemoryStoreStringId;

            public final void invoke(@NotNull Record.StringRecord it) {
                Intrinsics.checkParameterIsNotNull((Object)it, (String)"it");
                if (Intrinsics.areEqual((Object)it.getString(), (Object)KeyedWeakReference.class.getName())) {
                    this.$keyedWeakReferenceStringId.element = it.getId();
                } else if (Intrinsics.areEqual((Object)it.getString(), (Object)HeapDumpMemoryStore.class.getName())) {
                    this.$heapDumpMemoryStoreStringId.element = it.getId();
                }
            }
            {
                this.$keyedWeakReferenceStringId = longRef;
                this.$heapDumpMemoryStoreStringId = longRef2;
                super(1);
            }
        }).on(Record.LoadClassRecord.class, (Function1)new Function1<Record.LoadClassRecord, Unit>((Ref.LongRef)keyedWeakReferenceStringId, (Ref.LongRef)keyedWeakReferenceClassId, (Ref.LongRef)heapDumpMemoryStoreStringId, (Ref.LongRef)heapDumpMemoryStoreClassId){
            final /* synthetic */ Ref.LongRef $keyedWeakReferenceStringId;
            final /* synthetic */ Ref.LongRef $keyedWeakReferenceClassId;
            final /* synthetic */ Ref.LongRef $heapDumpMemoryStoreStringId;
            final /* synthetic */ Ref.LongRef $heapDumpMemoryStoreClassId;

            public final void invoke(@NotNull Record.LoadClassRecord it) {
                Intrinsics.checkParameterIsNotNull((Object)it, (String)"it");
                if (it.getClassNameStringId() == this.$keyedWeakReferenceStringId.element) {
                    this.$keyedWeakReferenceClassId.element = it.getId();
                } else if (it.getClassNameStringId() == this.$heapDumpMemoryStoreStringId.element) {
                    this.$heapDumpMemoryStoreClassId.element = it.getId();
                }
            }
            {
                this.$keyedWeakReferenceStringId = longRef;
                this.$keyedWeakReferenceClassId = longRef2;
                this.$heapDumpMemoryStoreStringId = longRef3;
                this.$heapDumpMemoryStoreClassId = longRef4;
                super(1);
            }
        }).on(Record.HeapDumpRecord.ObjectRecord.InstanceDumpRecord.class, (Function1)new Function1<Record.HeapDumpRecord.ObjectRecord.InstanceDumpRecord, Unit>((Ref.LongRef)keyedWeakReferenceClassId, keyedWeakReferenceInstances){
            final /* synthetic */ Ref.LongRef $keyedWeakReferenceClassId;
            final /* synthetic */ List $keyedWeakReferenceInstances;

            public final void invoke(@NotNull Record.HeapDumpRecord.ObjectRecord.InstanceDumpRecord it) {
                Intrinsics.checkParameterIsNotNull((Object)it, (String)"it");
                if (it.getClassId() == this.$keyedWeakReferenceClassId.element) {
                    this.$keyedWeakReferenceInstances.add(it);
                }
            }
            {
                this.$keyedWeakReferenceClassId = longRef;
                this.$keyedWeakReferenceInstances = list;
                super(1);
            }
        }).on(Record.HeapDumpRecord.GcRootRecord.class, (Function1)new Function1<Record.HeapDumpRecord.GcRootRecord, Unit>(gcRootIds){
            final /* synthetic */ List $gcRootIds;

            public final void invoke(@NotNull Record.HeapDumpRecord.GcRootRecord it) {
                Intrinsics.checkParameterIsNotNull((Object)it, (String)"it");
                GcRoot gcRoot = it.getGcRoot();
                if (gcRoot instanceof GcRoot.JniGlobal || gcRoot instanceof GcRoot.JniLocal || gcRoot instanceof GcRoot.JavaFrame || gcRoot instanceof GcRoot.NativeStack || gcRoot instanceof GcRoot.StickyClass || gcRoot instanceof GcRoot.ThreadBlock || gcRoot instanceof GcRoot.MonitorUsed || gcRoot instanceof GcRoot.ReferenceCleanup || gcRoot instanceof GcRoot.JniMonitor) {
                    this.$gcRootIds.add(it.getGcRoot().getId());
                }
            }
            {
                this.$gcRootIds = list;
                super(1);
            }
        });
        parser.scan(callbacks2);
        return new Triple((Object)gcRootIds, (Object)heapDumpMemoryStoreClassId.element, (Object)keyedWeakReferenceInstances);
    }

    private final Pair<Set<Long>, Long> readHeapDumpMemoryStore(HprofParser parser, long heapDumpMemoryStoreClassId) {
        HydratedClass storeClass = (HydratedClass)parser.hydrateClassHierarchy(heapDumpMemoryStoreClassId).get(0);
        Record.HeapDumpRecord.ObjectRecord objectRecord = parser.retrieveRecord((HeapValue.ObjectReference)storeClass.staticFieldValue("retainedKeysForHeapDump"));
        if (objectRecord == null) {
            throw new TypeCastException("null cannot be cast to non-null type leakcanary.Record.HeapDumpRecord.ObjectRecord.ObjectArrayDumpRecord");
        }
        Set retainedKeysForHeapDump = ArraysKt.toMutableSet((long[])((Record.HeapDumpRecord.ObjectRecord.ObjectArrayDumpRecord)objectRecord).getElementIds());
        long heapDumpUptimeMillis = ((HeapValue.LongValue)storeClass.staticFieldValue("heapDumpUptimeMillis")).getValue();
        return TuplesKt.to((Object)retainedKeysForHeapDump, (Object)heapDumpUptimeMillis);
    }

    private final List<KeyedWeakReferenceMirror> findLeakingReferences(HprofParser parser, Set<Long> retainedKeys, Map<String, RetainedInstance> analysisResults, List<Record.HeapDumpRecord.ObjectRecord.InstanceDumpRecord> keyedWeakReferenceInstances, long heapDumpUptimeMillis) {
        this.listener.onProgressUpdate(AnalyzerProgressListener.Step.FINDING_LEAKING_REFS);
        List leakingWeakRefs = new ArrayList();
        Iterable $receiver$iv = keyedWeakReferenceInstances;
        for (Object element$iv : $receiver$iv) {
            Record.HeapDumpRecord.ObjectRecord.InstanceDumpRecord record = (Record.HeapDumpRecord.ObjectRecord.InstanceDumpRecord)element$iv;
            boolean bl = false;
            KeyedWeakReferenceMirror weakRef = KeyedWeakReferenceMirror.Companion.fromInstance(parser.hydrateInstance(record), heapDumpUptimeMillis);
            boolean wasRetained = retainedKeys.remove(weakRef.getKey().getValue());
            if (!wasRetained) continue;
            if (weakRef.getHasReferent()) {
                leakingWeakRefs.add(weakRef);
                continue;
            }
            String key = parser.retrieveString(weakRef.getKey());
            String name = parser.retrieveString(weakRef.getName());
            String className = parser.retrieveString(weakRef.getClassName());
            WeakReferenceCleared noLeak = new WeakReferenceCleared(key, name, className, weakRef.getWatchDurationMillis());
            Map<String, RetainedInstance> map = analysisResults;
            WeakReferenceCleared weakReferenceCleared = noLeak;
            map.put(key, (RetainedInstance)weakReferenceCleared);
        }
        $receiver$iv = retainedKeys;
        for (Object element$iv : $receiver$iv) {
            long referenceKeyId = ((Number)element$iv).longValue();
            boolean bl = false;
            String referenceKey = parser.retrieveStringById(referenceKeyId);
            WeakReferenceMissing noLeak = new WeakReferenceMissing(referenceKey);
            Map<String, RetainedInstance> map = analysisResults;
            WeakReferenceMissing weakReferenceMissing = noLeak;
            map.put(referenceKey, (RetainedInstance)weakReferenceMissing);
        }
        return leakingWeakRefs;
    }

    private final List<ShortestPathFinder.Result> findShortestPaths(HeapDump heapDump, HprofParser parser, List<KeyedWeakReferenceMirror> leakingWeakRefs, List<Long> gcRootIds) {
        this.listener.onProgressUpdate(AnalyzerProgressListener.Step.FINDING_SHORTEST_PATHS);
        ShortestPathFinder pathFinder = new ShortestPathFinder(heapDump.getExcludedRefs());
        return pathFinder.findPaths(parser, leakingWeakRefs, gcRootIds);
    }

    private final void buildLeakTraces(HeapDump heapDump, List<? extends Labeler> labelers, List<ShortestPathFinder.Result> pathResults, HprofParser parser, List<KeyedWeakReferenceMirror> leakingWeakRefs, Map<String, RetainedInstance> analysisResults) {
        Collection collection;
        if (heapDump.getComputeRetainedHeapSize() && !(collection = (Collection)pathResults).isEmpty()) {
            this.listener.onProgressUpdate(AnalyzerProgressListener.Step.COMPUTING_DOMINATORS);
            CanaryLog.INSTANCE.d("Cannot compute retained heap size because dominators is not implemented yet", new Object[0]);
        }
        this.listener.onProgressUpdate(AnalyzerProgressListener.Step.BUILDING_LEAK_TRACES);
        Iterable $receiver$iv = pathResults;
        for (Object element$iv : $receiver$iv) {
            ShortestPathFinder.Result pathResult = (ShortestPathFinder.Result)element$iv;
            boolean bl = false;
            KeyedWeakReferenceMirror weakReference = pathResult.getWeakReference();
            boolean removed = leakingWeakRefs.remove(weakReference);
            if (!removed) {
                throw (Throwable)new IllegalStateException("ShortestPathFinder found an instance we didn't ask it to find: " + pathResult);
            }
            LeakTrace leakTrace = this.buildLeakTrace(parser, heapDump, pathResult.getLeakingNode(), labelers);
            Object retainedSize = null;
            String key = parser.retrieveString(weakReference.getKey());
            LeakingInstance leakDetected = new LeakingInstance(key, parser.retrieveString(weakReference.getName()), parser.retrieveString(weakReference.getClassName()), weakReference.getWatchDurationMillis(), pathResult.getExcludingKnownLeaks(), leakTrace, (Long)retainedSize);
            Map<String, RetainedInstance> map = analysisResults;
            LeakingInstance leakingInstance = leakDetected;
            map.put(key, (RetainedInstance)leakingInstance);
        }
    }

    private final void addRemainingInstancesWithNoPath(HprofParser hprofParser, List<KeyedWeakReferenceMirror> leakingWeakRefs, Map<String, RetainedInstance> analysisResults) {
        Iterable $receiver$iv = leakingWeakRefs;
        for (Object element$iv : $receiver$iv) {
            KeyedWeakReferenceMirror refWithNoPath = (KeyedWeakReferenceMirror)element$iv;
            boolean bl = false;
            String key = hprofParser.retrieveString(refWithNoPath.getKey());
            String name = hprofParser.retrieveString(refWithNoPath.getName());
            String className = hprofParser.retrieveString(refWithNoPath.getClassName());
            NoPathToInstance noLeak = new NoPathToInstance(key, name, className, refWithNoPath.getWatchDurationMillis());
            Map<String, RetainedInstance> map = analysisResults;
            NoPathToInstance noPathToInstance = noLeak;
            map.put(key, (RetainedInstance)noPathToInstance);
        }
    }

    private final LeakTrace buildLeakTrace(HprofParser parser, HeapDump heapDump, LeakNode leakingNode, List<? extends Labeler> labelers) {
        ArrayList<LeakTraceElement> elements = new ArrayList<LeakTraceElement>();
        long ignored = leakingNode.getInstance();
        LeakNode node = new LeakNode.ChildNode(ignored, null, leakingNode, null);
        while (node instanceof LeakNode.ChildNode) {
            List labels = new ArrayList();
            for (Labeler labeler : labelers) {
                labels.addAll((Collection)labeler.computeLabels(parser, (LeakNode.ChildNode)node));
            }
            elements.add(0, this.buildLeakElement(parser, (LeakNode.ChildNode)node, labels));
            node = ((LeakNode.ChildNode)node).getParent();
        }
        List<Reachability> expectedReachability = this.computeExpectedReachability(parser, heapDump, (List<LeakTraceElement>)elements);
        return new LeakTrace((List)elements, expectedReachability);
    }

    /*
     * WARNING - void declaration
     */
    private final List<Reachability> computeExpectedReachability(HprofParser parser, HeapDump heapDump, List<LeakTraceElement> elements) {
        int index;
        int lastElementIndex;
        int lastReachableElementIndex = 0;
        int firstUnreachableElementIndex = lastElementIndex = elements.size() - 1;
        ArrayList<Reachability> expectedReachability = new ArrayList<Reachability>();
        List reachabilityInspectors = new ArrayList();
        for (Class reachabilityInspectorClass : heapDump.getReachabilityInspectorClasses()) {
            try {
                Constructor defaultConstructor = reachabilityInspectorClass.getDeclaredConstructor(new Class[0]);
                Object t = defaultConstructor.newInstance(new Object[0]);
                Intrinsics.checkExpressionValueIsNotNull(t, (String)"defaultConstructor.newInstance()");
                reachabilityInspectors.add(t);
            }
            catch (Exception e) {
                throw (Throwable)new RuntimeException(e);
            }
        }
        boolean reachabilityInspectorClass = false;
        for (LeakTraceElement element : (Iterable)elements) {
            Reachability reachability = this.inspectElementReachability(parser, reachabilityInspectors, element);
            expectedReachability.add(reachability);
            if (reachability.getStatus() == Reachability.Status.REACHABLE) {
                lastReachableElementIndex = index;
                firstUnreachableElementIndex = lastElementIndex;
            } else if (firstUnreachableElementIndex == lastElementIndex && reachability.getStatus() == Reachability.Status.UNREACHABLE) {
                firstUnreachableElementIndex = index;
            }
            ++index;
        }
        if (((Reachability)expectedReachability.get(0)).getStatus() == Reachability.Status.UNKNOWN) {
            expectedReachability.set(0, Reachability.Companion.reachable("it's a GC root"));
        }
        switch (HeapAnalyzer$WhenMappings.$EnumSwitchMapping$0[((Reachability)expectedReachability.get(lastElementIndex)).getStatus().ordinal()]) {
            case 1: 
            case 2: {
                expectedReachability.set(lastElementIndex, Reachability.Companion.unreachable("RefWatcher was watching this"));
                if (lastReachableElementIndex != lastElementIndex) break;
                --lastReachableElementIndex;
            }
        }
        if (((Reachability)expectedReachability.get(lastElementIndex)).getStatus() == Reachability.Status.UNKNOWN) {
            expectedReachability.set(lastElementIndex, Reachability.Companion.unreachable("RefWatcher was watching this"));
        }
        index = 1;
        int n = lastElementIndex;
        while (index < n) {
            void i;
            Object e = expectedReachability.get((int)i);
            Intrinsics.checkExpressionValueIsNotNull(e, (String)"expectedReachability[i]");
            Reachability reachability = (Reachability)e;
            if (reachability.getStatus() == Reachability.Status.UNKNOWN) {
                if (i < lastReachableElementIndex) {
                    String nextReachableName = elements.get((int)(i + true)).getSimpleClassName();
                    expectedReachability.set((int)i, Reachability.Companion.reachable(nextReachableName + "\u2193 is not leaking"));
                } else if (i > firstUnreachableElementIndex) {
                    String previousUnreachableName = elements.get((int)(i - true)).getSimpleClassName();
                    expectedReachability.set((int)i, Reachability.Companion.unreachable(previousUnreachableName + "\u2191 is leaking"));
                }
            }
            ++i;
        }
        return expectedReachability;
    }

    private final Reachability inspectElementReachability(HprofParser parser, List<? extends Reachability.Inspector> reachabilityInspectors, LeakTraceElement element) {
        for (Reachability.Inspector inspector : reachabilityInspectors) {
            Reachability reachability = inspector.expectedReachability(element);
            if (reachability.getStatus() == Reachability.Status.UNKNOWN) continue;
            return reachability;
        }
        return Reachability.Companion.unknown();
    }

    /*
     * WARNING - void declaration
     */
    private final LeakTraceElement buildLeakElement(HprofParser parser, LeakNode.ChildNode node, List<String> labels) {
        LeakTraceElement.Holder holder;
        List list;
        long objectId = node.getParent().getInstance();
        Record.HeapDumpRecord.ObjectRecord record = parser.retrieveRecordById(objectId);
        List<LeakReference> leakReferences = this.describeFields(parser, record);
        Record.HeapDumpRecord.ObjectRecord objectRecord = record;
        if (objectRecord instanceof Record.HeapDumpRecord.ObjectRecord.ClassDumpRecord) {
            list = CollectionsKt.listOf((Object)parser.className(((Record.HeapDumpRecord.ObjectRecord.ClassDumpRecord)record).getId()));
        } else if (objectRecord instanceof Record.HeapDumpRecord.ObjectRecord.InstanceDumpRecord) {
            void $receiver$iv$iv;
            Iterable $receiver$iv;
            HydratedInstance instance = parser.hydrateInstance((Record.HeapDumpRecord.ObjectRecord.InstanceDumpRecord)record);
            Iterable iterable = $receiver$iv = (Iterable)instance.getClassHierarchy();
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$receiver$iv, (int)10));
            for (Object item$iv$iv : $receiver$iv$iv) {
                void it;
                HydratedClass hydratedClass = (HydratedClass)item$iv$iv;
                Collection collection = destination$iv$iv;
                boolean bl = false;
                String string = it.getClassName();
                collection.add(string);
            }
            list = (List)destination$iv$iv;
        } else if (objectRecord instanceof Record.HeapDumpRecord.ObjectRecord.ObjectArrayDumpRecord) {
            list = CollectionsKt.listOf((Object)parser.className(((Record.HeapDumpRecord.ObjectRecord.ObjectArrayDumpRecord)record).getArrayClassId()));
        } else {
            throw (Throwable)new IllegalStateException("Unexpected record type for " + record);
        }
        List classHierarchy = list;
        if (record instanceof Record.HeapDumpRecord.ObjectRecord.ClassDumpRecord) {
            holder = LeakTraceElement.Holder.CLASS;
        } else if (record instanceof Record.HeapDumpRecord.ObjectRecord.ObjectArrayDumpRecord) {
            holder = LeakTraceElement.Holder.ARRAY;
        } else {
            boolean bl;
            block14: {
                Iterable $receiver$iv = classHierarchy;
                if ($receiver$iv instanceof Collection && ((Collection)$receiver$iv).isEmpty()) {
                    bl = false;
                } else {
                    for (Object element$iv : $receiver$iv) {
                        String it = (String)element$iv;
                        boolean bl2 = false;
                        if (!Intrinsics.areEqual((Object)it, (Object)Thread.class.getName())) continue;
                        bl = true;
                        break block14;
                    }
                    bl = false;
                }
            }
            holder = bl ? LeakTraceElement.Holder.THREAD : LeakTraceElement.Holder.OBJECT;
        }
        LeakTraceElement.Holder holderType = holder;
        return new LeakTraceElement(node.getLeakReference(), holderType, classHierarchy, node.getExclusion(), leakReferences, labels);
    }

    /*
     * WARNING - void declaration
     */
    private final List<LeakReference> describeFields(HprofParser parser, Record.HeapDumpRecord.ObjectRecord record) {
        ArrayList<LeakReference> leakReferences = new ArrayList<LeakReference>();
        Record.HeapDumpRecord.ObjectRecord objectRecord = record;
        if (objectRecord instanceof Record.HeapDumpRecord.ObjectRecord.ClassDumpRecord) {
            List classHierarchy = parser.hydrateClassHierarchy(((Record.HeapDumpRecord.ObjectRecord.ClassDumpRecord)record).getId());
            HydratedClass hydratedClass = (HydratedClass)classHierarchy.get(0);
            Iterable $receiver$iv = hydratedClass.getStaticFieldNames();
            int index$iv = 0;
            for (Object item$iv : $receiver$iv) {
                void fieldName;
                int n;
                if ((n = index$iv++) < 0) {
                    CollectionsKt.throwIndexOverflow();
                }
                int n2 = n;
                String string = (String)item$iv;
                int index = n2;
                boolean bl = false;
                HeapValue heapValue = ((Record.HeapDumpRecord.ObjectRecord.ClassDumpRecord.StaticFieldRecord)hydratedClass.getRecord().getStaticFields().get(index)).getValue();
                leakReferences.add(new LeakReference(LeakTraceElement.Type.STATIC_FIELD, (String)fieldName, this.heapValueAsString(heapValue)));
            }
        } else if (objectRecord instanceof Record.HeapDumpRecord.ObjectRecord.ObjectArrayDumpRecord) {
            long[] $receiver$iv = ((Record.HeapDumpRecord.ObjectRecord.ObjectArrayDumpRecord)record).getElementIds();
            int index$iv = 0;
            for (long item$iv : $receiver$iv) {
                void objectId;
                String name;
                int n = index$iv++;
                long l = item$iv;
                int index = n;
                boolean bl = false;
                String string = name = Integer.toString(index);
                Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"name");
                leakReferences.add(new LeakReference(LeakTraceElement.Type.ARRAY_ENTRY, string, "object " + (long)objectId));
            }
        } else {
            List fieldName;
            int n;
            int n3;
            Record.HeapDumpRecord.ObjectRecord objectRecord2 = record;
            if (objectRecord2 == null) {
                throw new TypeCastException("null cannot be cast to non-null type leakcanary.Record.HeapDumpRecord.ObjectRecord.InstanceDumpRecord");
            }
            HydratedInstance instance = parser.hydrateInstance((Record.HeapDumpRecord.ObjectRecord.InstanceDumpRecord)objectRecord2);
            Iterable $receiver$iv = ((HydratedClass)instance.getClassHierarchy().get(0)).getStaticFieldNames();
            int index$iv = 0;
            for (Object item$iv : $receiver$iv) {
                if ((n3 = index$iv++) < 0) {
                    CollectionsKt.throwIndexOverflow();
                }
                n = n3;
                String objectId = (String)item$iv;
                int index = n;
                boolean bl = false;
                HeapValue heapValue = ((Record.HeapDumpRecord.ObjectRecord.ClassDumpRecord.StaticFieldRecord)((HydratedClass)instance.getClassHierarchy().get(0)).getRecord().getStaticFields().get(index)).getValue();
                leakReferences.add(new LeakReference(LeakTraceElement.Type.STATIC_FIELD, (String)((Object)fieldName), this.heapValueAsString(heapValue)));
            }
            $receiver$iv = instance.getFieldValues();
            index$iv = 0;
            for (Object item$iv : $receiver$iv) {
                void fieldValues;
                if ((n3 = index$iv++) < 0) {
                    CollectionsKt.throwIndexOverflow();
                }
                n = n3;
                fieldName = (List)item$iv;
                int classIndex = n;
                boolean bl = false;
                Iterable $receiver$iv2 = (Iterable)fieldValues;
                int index$iv2 = 0;
                for (Object item$iv2 : $receiver$iv2) {
                    void heapValue;
                    int n4;
                    if ((n4 = index$iv2++) < 0) {
                        CollectionsKt.throwIndexOverflow();
                    }
                    int n5 = n4;
                    HeapValue heapValue2 = (HeapValue)item$iv2;
                    int fieldIndex = n5;
                    boolean bl2 = false;
                    leakReferences.add(new LeakReference(LeakTraceElement.Type.INSTANCE_FIELD, (String)((HydratedClass)instance.getClassHierarchy().get(classIndex)).getFieldNames().get(fieldIndex), this.heapValueAsString((HeapValue)heapValue)));
                }
            }
        }
        return leakReferences;
    }

    private final String heapValueAsString(HeapValue heapValue) {
        String string;
        HeapValue heapValue2 = heapValue;
        if (heapValue2 instanceof HeapValue.ObjectReference) {
            string = ((HeapValue.ObjectReference)heapValue).getValue() == 0L ? "null" : "object " + ((HeapValue.ObjectReference)heapValue).getValue();
        } else if (heapValue2 instanceof HeapValue.BooleanValue) {
            string = String.valueOf(((HeapValue.BooleanValue)heapValue).getValue());
        } else if (heapValue2 instanceof HeapValue.CharValue) {
            string = String.valueOf(((HeapValue.CharValue)heapValue).getValue());
        } else if (heapValue2 instanceof HeapValue.FloatValue) {
            string = String.valueOf(((HeapValue.FloatValue)heapValue).getValue());
        } else if (heapValue2 instanceof HeapValue.DoubleValue) {
            string = String.valueOf(((HeapValue.DoubleValue)heapValue).getValue());
        } else if (heapValue2 instanceof HeapValue.ByteValue) {
            string = String.valueOf(((HeapValue.ByteValue)heapValue).getValue());
        } else if (heapValue2 instanceof HeapValue.ShortValue) {
            string = String.valueOf(((HeapValue.ShortValue)heapValue).getValue());
        } else if (heapValue2 instanceof HeapValue.IntValue) {
            string = String.valueOf(((HeapValue.IntValue)heapValue).getValue());
        } else if (heapValue2 instanceof HeapValue.LongValue) {
            string = String.valueOf(((HeapValue.LongValue)heapValue).getValue());
        } else {
            throw new NoWhenBranchMatchedException();
        }
        return string;
    }

    private final long since(long analysisStartNanoTime) {
        return TimeUnit.NANOSECONDS.toMillis(System.nanoTime() - analysisStartNanoTime);
    }

    public HeapAnalyzer(@NotNull AnalyzerProgressListener listener) {
        Intrinsics.checkParameterIsNotNull((Object)listener, (String)"listener");
        this.listener = listener;
    }

    static {
        Companion = new Companion(null);
        String string = ANONYMOUS_CLASS_NAME_PATTERN;
        ANONYMOUS_CLASS_NAME_PATTERN_REGEX = new Regex(string);
    }

    @Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0080T\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0005\u001a\u00020\u0006X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\b\u00a8\u0006\t"}, d2={"Lleakcanary/HeapAnalyzer$Companion;", "", "()V", "ANONYMOUS_CLASS_NAME_PATTERN", "", "ANONYMOUS_CLASS_NAME_PATTERN_REGEX", "Lkotlin/text/Regex;", "getANONYMOUS_CLASS_NAME_PATTERN_REGEX$leakcanary_analyzer", "()Lkotlin/text/Regex;", "leakcanary-analyzer"})
    public static final class Companion {
        @NotNull
        public final Regex getANONYMOUS_CLASS_NAME_PATTERN_REGEX$leakcanary_analyzer() {
            return ANONYMOUS_CLASS_NAME_PATTERN_REGEX;
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

