/*
 * Decompiled with CFR 0.152.
 */
package leakcanary;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import leakcanary.HeapAnalyzer;
import leakcanary.HeapValue;
import leakcanary.HprofParser;
import leakcanary.HydratedClass;
import leakcanary.HydratedInstance;
import leakcanary.LeakNode;
import leakcanary.Record;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\bf\u0018\u00002\u00020\u0001:\u0001\tJ\u001e\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u00032\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH&\u00a8\u0006\n"}, d2={"Lleakcanary/Labeler;", "", "computeLabels", "", "", "parser", "Lleakcanary/HprofParser;", "node", "Lleakcanary/LeakNode$ChildNode;", "InstanceDefaultLabeler", "leakcanary-analyzer"})
public interface Labeler {
    @NotNull
    public List<String> computeLabels(@NotNull HprofParser var1, @NotNull LeakNode.ChildNode var2);

    @Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u001e\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u00042\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0016\u00a8\u0006\n"}, d2={"Lleakcanary/Labeler$InstanceDefaultLabeler;", "Lleakcanary/Labeler;", "()V", "computeLabels", "", "", "parser", "Lleakcanary/HprofParser;", "node", "Lleakcanary/LeakNode$ChildNode;", "leakcanary-analyzer"})
    public static final class InstanceDefaultLabeler
    implements Labeler {
        public static final InstanceDefaultLabeler INSTANCE;

        @Override
        @NotNull
        public List<String> computeLabels(@NotNull HprofParser parser, @NotNull LeakNode.ChildNode node) {
            Intrinsics.checkParameterIsNotNull((Object)parser, (String)"parser");
            Intrinsics.checkParameterIsNotNull((Object)node, (String)"node");
            long objectId = node.getParent().getInstance();
            Record.HeapDumpRecord.ObjectRecord record = parser.retrieveRecordById(objectId);
            if (record instanceof Record.HeapDumpRecord.ObjectRecord.InstanceDumpRecord) {
                Object threadName;
                CharSequence nameField;
                Class<?>[] it;
                boolean bl;
                String className;
                HydratedInstance instance;
                List labels;
                block13: {
                    labels = new ArrayList();
                    instance = parser.hydrateInstance((Record.HeapDumpRecord.ObjectRecord.InstanceDumpRecord)record);
                    className = ((HydratedClass)instance.getClassHierarchy().get(0)).getClassName();
                    Iterable $receiver$iv = instance.getClassHierarchy();
                    if ($receiver$iv instanceof Collection && ((Collection)$receiver$iv).isEmpty()) {
                        bl = false;
                    } else {
                        for (Object element$iv : $receiver$iv) {
                            it = (Class<?>[])element$iv;
                            boolean bl2 = false;
                            if (!Intrinsics.areEqual((Object)it.getClassName(), (Object)Thread.class.getName())) continue;
                            bl = true;
                            break block13;
                        }
                        bl = false;
                    }
                }
                if (bl) {
                    nameField = (HeapValue.ObjectReference)instance.fieldValueOrNull("name");
                    threadName = nameField != null ? parser.retrieveString((HeapValue.ObjectReference)nameField) : "not available";
                    labels.add("Thread name: '" + (String)threadName + '\'');
                } else {
                    nameField = className;
                    threadName = HeapAnalyzer.Companion.getANONYMOUS_CLASS_NAME_PATTERN_REGEX$leakcanary_analyzer();
                    if (threadName.matches(nameField)) {
                        String parentClassName = ((HydratedClass)instance.getClassHierarchy().get(1)).getClassName();
                        if (Intrinsics.areEqual((Object)parentClassName, (Object)"java.lang.Object")) {
                            try {
                                String string;
                                boolean bl3;
                                Class<?> actualClass;
                                Class<?> clazz = actualClass = Class.forName(((HydratedClass)instance.getClassHierarchy().get(0)).getClassName());
                                Intrinsics.checkExpressionValueIsNotNull(clazz, (String)"actualClass");
                                Class<?>[] interfaces = clazz.getInterfaces();
                                Intrinsics.checkExpressionValueIsNotNull(interfaces, (String)"interfaces");
                                it = interfaces;
                                List list = labels;
                                Class<?>[] classArray = it;
                                boolean bl4 = bl3 = !(classArray.length == 0);
                                if (bl3) {
                                    Class<?> implementedInterface = interfaces[0];
                                    StringBuilder stringBuilder = new StringBuilder().append("Anonymous class implementing ");
                                    Class<?> clazz2 = implementedInterface;
                                    Intrinsics.checkExpressionValueIsNotNull(clazz2, (String)"implementedInterface");
                                    string = stringBuilder.append(clazz2.getName()).toString();
                                } else {
                                    string = "Anonymous subclass of java.lang.Object";
                                }
                                list.add(string);
                            }
                            catch (ClassNotFoundException classNotFoundException) {}
                        } else {
                            labels.add("Anonymous subclass of " + parentClassName);
                        }
                    }
                }
                return labels;
            }
            return CollectionsKt.emptyList();
        }

        private InstanceDefaultLabeler() {
        }

        static {
            InstanceDefaultLabeler instanceDefaultLabeler;
            INSTANCE = instanceDefaultLabeler = new InstanceDefaultLabeler();
        }
    }
}

