/*
 * Decompiled with CFR 0.152.
 */
package leakcanary.internal;

import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.Deque;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.TypeCastException;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.collections.SetsKt;
import kotlin.comparisons.ComparisonsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.RangesKt;
import leakcanary.ExcludedRefs;
import leakcanary.Exclusion;
import leakcanary.HeapValue;
import leakcanary.HprofParser;
import leakcanary.HydratedClass;
import leakcanary.HydratedInstance;
import leakcanary.LeakNode;
import leakcanary.LeakReference;
import leakcanary.LeakTraceElement;
import leakcanary.ObjectIdMetadata;
import leakcanary.Record;
import leakcanary.internal.KeyedWeakReferenceMirror;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000p\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\t\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010!\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0000\u0018\u0000 (2\u00020\u0001:\u0002()B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0010\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0007H\u0002J\b\u0010\u0011\u001a\u00020\u0012H\u0002J\u0018\u0010\u0013\u001a\u00020\u00122\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0010\u001a\u00020\u0007H\u0002J\u001e\u0010\u0016\u001a\u00020\u00122\u0006\u0010\u0014\u001a\u00020\u00152\f\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\n0\u0018H\u0002J0\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\u001a0\u00182\u0006\u0010\u001b\u001a\u00020\u00152\f\u0010\u001c\u001a\b\u0012\u0004\u0012\u00020\u001d0\u00182\f\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\n0\u001eJ \u0010\u001f\u001a\u00020\u00122\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010 \u001a\u00020!2\u0006\u0010\u0010\u001a\u00020\u0007H\u0002J \u0010\"\u001a\u00020\u00122\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010 \u001a\u00020#2\u0006\u0010$\u001a\u00020\u0007H\u0002J \u0010%\u001a\u00020\u00122\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010 \u001a\u00020&2\u0006\u0010'\u001a\u00020\u0007H\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\f\u001a\b\u0012\u0004\u0012\u00020\n0\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\r\u001a\b\u0012\u0004\u0012\u00020\n0\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006*"}, d2={"Lleakcanary/internal/ShortestPathFinder;", "", "excludedRefs", "Lleakcanary/ExcludedRefs;", "(Lleakcanary/ExcludedRefs;)V", "toVisitIfNoPathQueue", "Ljava/util/Deque;", "Lleakcanary/LeakNode;", "toVisitIfNoPathSet", "Ljava/util/LinkedHashSet;", "", "toVisitQueue", "toVisitSet", "visitedSet", "checkSeen", "", "node", "clearState", "", "enqueue", "hprofParser", "Lleakcanary/HprofParser;", "enqueueGcRoots", "gcRootIds", "", "findPaths", "Lleakcanary/internal/ShortestPathFinder$Result;", "parser", "leakingWeakRefs", "Lleakcanary/internal/KeyedWeakReferenceMirror;", "", "visitClassRecord", "record", "Lleakcanary/Record$HeapDumpRecord$ObjectRecord$ClassDumpRecord;", "visitInstanceRecord", "Lleakcanary/Record$HeapDumpRecord$ObjectRecord$InstanceDumpRecord;", "parent", "visitObjectArrayRecord", "Lleakcanary/Record$HeapDumpRecord$ObjectRecord$ObjectArrayDumpRecord;", "parentNode", "Companion", "Result", "leakcanary-analyzer"})
public final class ShortestPathFinder {
    private final Deque<LeakNode> toVisitQueue;
    private final Deque<LeakNode> toVisitIfNoPathQueue;
    private final LinkedHashSet<Long> toVisitSet;
    private final LinkedHashSet<Long> toVisitIfNoPathSet;
    private final LinkedHashSet<Long> visitedSet;
    private final ExcludedRefs excludedRefs;
    private static final Set<ObjectIdMetadata> SKIP_ENQUEUE;
    public static final Companion Companion;

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final List<Result> findPaths(@NotNull HprofParser parser, @NotNull List<KeyedWeakReferenceMirror> leakingWeakRefs, @NotNull List<Long> gcRootIds) {
        void $receiver$iv$iv;
        Intrinsics.checkParameterIsNotNull((Object)parser, (String)"parser");
        Intrinsics.checkParameterIsNotNull(leakingWeakRefs, (String)"leakingWeakRefs");
        Intrinsics.checkParameterIsNotNull(gcRootIds, (String)"gcRootIds");
        this.clearState();
        Iterable $receiver$iv = leakingWeakRefs;
        int capacity$iv = RangesKt.coerceAtLeast((int)MapsKt.mapCapacity((int)CollectionsKt.collectionSizeOrDefault((Iterable)$receiver$iv, (int)10)), (int)16);
        Iterable iterable = $receiver$iv;
        Map destination$iv$iv = new LinkedHashMap(capacity$iv);
        for (Object element$iv$iv : $receiver$iv$iv) {
            void it;
            KeyedWeakReferenceMirror keyedWeakReferenceMirror = (KeyedWeakReferenceMirror)element$iv$iv;
            Map map = destination$iv$iv;
            boolean bl = false;
            Long l = it.getReferent().getValue();
            map.put(l, element$iv$iv);
        }
        Map referentMap = destination$iv$iv;
        this.enqueueGcRoots(parser, gcRootIds);
        gcRootIds.clear();
        boolean excludingKnownLeaks = false;
        List results = new ArrayList();
        while (!this.toVisitQueue.isEmpty() || !this.toVisitIfNoPathQueue.isEmpty()) {
            Record.HeapDumpRecord.ObjectRecord record;
            LeakNode node = null;
            if (!this.toVisitQueue.isEmpty()) {
                LeakNode leakNode = this.toVisitQueue.poll();
                Intrinsics.checkExpressionValueIsNotNull((Object)leakNode, (String)"toVisitQueue.poll()");
                node = leakNode;
                this.toVisitSet.remove(node.getInstance());
            } else {
                LeakNode leakNode = this.toVisitIfNoPathQueue.poll();
                Intrinsics.checkExpressionValueIsNotNull((Object)leakNode, (String)"toVisitIfNoPathQueue.poll()");
                node = leakNode;
                this.toVisitIfNoPathSet.remove(node.getInstance());
                if (node instanceof LeakNode.RootNode || node instanceof LeakNode.ChildNode && ((LeakNode.ChildNode)node).getExclusion() == null) {
                    throw (Throwable)new IllegalStateException("Expected node to have an exclusion " + node);
                }
                excludingKnownLeaks = true;
            }
            if (this.checkSeen(node)) continue;
            KeyedWeakReferenceMirror weakReference = (KeyedWeakReferenceMirror)referentMap.get(node.getInstance());
            if (weakReference != null) {
                results.add(new Result(node, excludingKnownLeaks, weakReference));
                if (results.size() == leakingWeakRefs.size()) break;
            }
            if ((record = parser.retrieveRecordById(node.getInstance())) instanceof Record.HeapDumpRecord.ObjectRecord.ClassDumpRecord) {
                this.visitClassRecord(parser, (Record.HeapDumpRecord.ObjectRecord.ClassDumpRecord)record, node);
                continue;
            }
            if (record instanceof Record.HeapDumpRecord.ObjectRecord.InstanceDumpRecord) {
                this.visitInstanceRecord(parser, (Record.HeapDumpRecord.ObjectRecord.InstanceDumpRecord)record, node);
                continue;
            }
            if (record instanceof Record.HeapDumpRecord.ObjectRecord.ObjectArrayDumpRecord) {
                this.visitObjectArrayRecord(parser, (Record.HeapDumpRecord.ObjectRecord.ObjectArrayDumpRecord)record, node);
                continue;
            }
            throw (Throwable)new IllegalStateException("Unexpected type for " + record);
        }
        this.clearState();
        return results;
    }

    private final boolean checkSeen(LeakNode node) {
        boolean alreadySeen = this.visitedSet.add(node.getInstance());
        return !alreadySeen;
    }

    private final void clearState() {
        this.toVisitQueue.clear();
        this.toVisitIfNoPathQueue.clear();
        this.toVisitSet.clear();
        this.toVisitIfNoPathSet.clear();
        this.visitedSet.clear();
    }

    private final void enqueueGcRoots(HprofParser hprofParser, List<Long> gcRootIds) {
        Iterable $receiver$iv = gcRootIds;
        for (Object element$iv : $receiver$iv) {
            long it = ((Number)element$iv).longValue();
            boolean bl = false;
            this.enqueue(hprofParser, new LeakNode.RootNode(it));
        }
    }

    private final void visitClassRecord(HprofParser hprofParser, Record.HeapDumpRecord.ObjectRecord.ClassDumpRecord record, LeakNode node) {
        String className = hprofParser.className(record.getId());
        Map map = (Map)this.excludedRefs.getStaticFieldNameByClassName().get(className);
        if (map == null) {
            map = MapsKt.emptyMap();
        }
        Map ignoredStaticFields = map;
        for (Record.HeapDumpRecord.ObjectRecord.ClassDumpRecord.StaticFieldRecord staticField : record.getStaticFields()) {
            HeapValue heapValue = staticField.getValue();
            if (!(heapValue instanceof HeapValue.ObjectReference)) {
                heapValue = null;
            }
            HeapValue.ObjectReference objectReference = (HeapValue.ObjectReference)heapValue;
            if (objectReference == null) {
                continue;
            }
            long objectId = objectReference.getValue();
            String fieldName = hprofParser.hprofStringById(staticField.getNameStringId());
            if (Intrinsics.areEqual((Object)fieldName, (Object)"$staticOverhead")) continue;
            LeakReference leakReference = new LeakReference(LeakTraceElement.Type.STATIC_FIELD, fieldName, "object " + objectId);
            Exclusion exclusion = (Exclusion)ignoredStaticFields.get(fieldName);
            if (exclusion != null && exclusion.getAlwaysExclude()) continue;
            this.enqueue(hprofParser, new LeakNode.ChildNode(objectId, exclusion, node, leakReference));
        }
    }

    /*
     * WARNING - void declaration
     */
    private final void visitInstanceRecord(HprofParser hprofParser, Record.HeapDumpRecord.ObjectRecord.InstanceDumpRecord record, LeakNode parent) {
        Iterable $receiver$iv$iv;
        Object v1;
        Exclusion exclusion;
        Collection collection;
        HydratedInstance instance;
        block21: {
            Object object;
            List exclusions;
            block20: {
                Iterator $receiver$iv$iv2;
                Iterable $receiver$iv;
                instance = hprofParser.hydrateInstance(record);
                Iterable iterable = $receiver$iv = (Iterable)instance.getClassHierarchy();
                Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$receiver$iv, (int)10));
                Iterator iterator = $receiver$iv$iv2.iterator();
                while (iterator.hasNext()) {
                    void it;
                    Object item$iv$iv = iterator.next();
                    HydratedClass hydratedClass = (HydratedClass)item$iv$iv;
                    collection = destination$iv$iv;
                    boolean bl = false;
                    exclusion = (Exclusion)this.excludedRefs.getClassNames().get(it.getClassName());
                    collection.add(exclusion);
                }
                exclusions = (List)destination$iv$iv;
                $receiver$iv = exclusions;
                for (Object element$iv : $receiver$iv) {
                    Exclusion it = (Exclusion)element$iv;
                    boolean bl = false;
                    if (!(it != null && it.getAlwaysExclude())) continue;
                    object = element$iv;
                    break block20;
                }
                object = null;
            }
            if (object != null) {
                return;
            }
            Iterable $receiver$iv = exclusions;
            for (Object element$iv : $receiver$iv) {
                Exclusion it = (Exclusion)element$iv;
                boolean bl = false;
                if (!(it != null)) continue;
                v1 = element$iv;
                break block21;
            }
            v1 = null;
        }
        Exclusion classExclusion = v1;
        LinkedHashMap ignoredFields = new LinkedHashMap();
        Iterable $receiver$iv = instance.getClassHierarchy();
        for (Object element$iv : $receiver$iv) {
            HydratedClass it = (HydratedClass)element$iv;
            boolean bl = false;
            Map map = (Map)this.excludedRefs.getFieldNameByClassName().get(it.getClassName());
            if (map == null) {
                map = MapsKt.emptyMap();
            }
            ignoredFields.putAll(map);
        }
        List fieldNamesAndValues = new ArrayList();
        Iterable $receiver$iv2 = instance.getFieldValues();
        int index$iv3 = 0;
        for (Object item$iv : $receiver$iv2) {
            void classFieldValues;
            int $i$f$forEach;
            if (($i$f$forEach = index$iv3++) < 0) {
                CollectionsKt.throwIndexOverflow();
            }
            int $i$f$map = $i$f$forEach;
            List list = (List)item$iv;
            int classIndex = $i$f$map;
            boolean bl = false;
            Iterable $receiver$iv3 = (Iterable)classFieldValues;
            int index$iv2 = 0;
            for (Object item$iv2 : $receiver$iv3) {
                void fieldValue;
                int n;
                if ((n = index$iv2++) < 0) {
                    CollectionsKt.throwIndexOverflow();
                }
                int n2 = n;
                HeapValue heapValue = (HeapValue)item$iv2;
                int fieldIndex = n2;
                boolean bl2 = false;
                String fieldName = (String)((HydratedClass)instance.getClassHierarchy().get(classIndex)).getFieldNames().get(fieldIndex);
                fieldNamesAndValues.add(TuplesKt.to((Object)fieldName, (Object)fieldValue));
            }
        }
        $receiver$iv2 = fieldNamesAndValues;
        if ($receiver$iv2.size() > 1) {
            Iterable index$iv3 = $receiver$iv2;
            Comparator it = new Comparator<T>(){

                public final int compare(T a, T b) {
                    Pair $name_$_$ = (Pair)a;
                    boolean bl = false;
                    String name = (String)$name_$_$.component1();
                    $name_$_$ = (Pair)b;
                    Comparable comparable = (Comparable)((Object)name);
                    bl = false;
                    String string = name = (String)$name_$_$.component1();
                    return ComparisonsKt.compareValues((Comparable)comparable, (Comparable)((Comparable)((Object)string)));
                }
            };
            CollectionsKt.sortWith((List)index$iv3, (Comparator)it);
        }
        Iterable index$iv3 = $receiver$iv2 = (Iterable)fieldNamesAndValues;
        Collection destination$iv$iv = new ArrayList();
        for (Object element$iv$iv : $receiver$iv$iv) {
            Pair $$_$_value = (Pair)element$iv$iv;
            boolean bl = false;
            HeapValue value = (HeapValue)$$_$_value.component2();
            if (!(value instanceof HeapValue.ObjectReference)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        $receiver$iv2 = (List)destination$iv$iv;
        $receiver$iv$iv = $receiver$iv2;
        destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$receiver$iv2, (int)10));
        for (Object item$iv$iv : $receiver$iv$iv) {
            HeapValue reference;
            void $name_reference;
            Pair $$_$_value = (Pair)item$iv$iv;
            collection = destination$iv$iv;
            boolean bl = false;
            String name = (String)$name_reference.component1();
            HeapValue heapValue = reference = (HeapValue)$name_reference.component2();
            if (heapValue == null) {
                throw new TypeCastException("null cannot be cast to non-null type leakcanary.HeapValue.ObjectReference");
            }
            exclusion = TuplesKt.to((Object)name, (Object)((HeapValue.ObjectReference)heapValue).getValue());
            collection.add(exclusion);
        }
        $receiver$iv2 = (List)destination$iv$iv;
        for (Object element$iv : $receiver$iv2) {
            Exclusion exclusion2;
            Pair $fieldName_objectId = (Pair)element$iv;
            boolean bl = false;
            String fieldName = (String)$fieldName_objectId.component1();
            long objectId = ((Number)$fieldName_objectId.component2()).longValue();
            Exclusion fieldExclusion = (Exclusion)ignoredFields.get(fieldName);
            if (classExclusion != null && classExclusion.getAlwaysExclude()) {
                exclusion2 = classExclusion;
            } else if (fieldExclusion != null && fieldExclusion.getAlwaysExclude()) {
                exclusion2 = fieldExclusion;
            } else {
                exclusion2 = classExclusion;
                if (exclusion2 == null) {
                    exclusion2 = fieldExclusion;
                }
            }
            Exclusion exclusion3 = exclusion2;
            this.enqueue(hprofParser, new LeakNode.ChildNode(objectId, exclusion3, parent, new LeakReference(LeakTraceElement.Type.INSTANCE_FIELD, fieldName, "object " + objectId)));
        }
    }

    /*
     * WARNING - void declaration
     */
    private final void visitObjectArrayRecord(HprofParser hprofParser, Record.HeapDumpRecord.ObjectRecord.ObjectArrayDumpRecord record, LeakNode parentNode) {
        long[] $receiver$iv = record.getElementIds();
        int index$iv = 0;
        for (long item$iv : $receiver$iv) {
            void elementId;
            String name;
            int n = index$iv++;
            long l = item$iv;
            int index = n;
            boolean bl = false;
            String string = name = Integer.toString(index);
            Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"name");
            LeakReference reference = new LeakReference(LeakTraceElement.Type.ARRAY_ENTRY, string, "object " + (long)elementId);
            this.enqueue(hprofParser, new LeakNode.ChildNode((long)elementId, null, parentNode, reference));
        }
    }

    private final void enqueue(HprofParser hprofParser, LeakNode node) {
        boolean visitNow;
        if (node.getInstance() == 0L) {
            return;
        }
        if (this.toVisitSet.contains(node.getInstance())) {
            return;
        }
        if (this.visitedSet.contains(node.getInstance())) {
            return;
        }
        boolean bl = visitNow = node instanceof LeakNode.RootNode || node instanceof LeakNode.ChildNode && ((LeakNode.ChildNode)node).getExclusion() == null;
        if (!visitNow && this.toVisitIfNoPathSet.contains(node.getInstance())) {
            return;
        }
        ObjectIdMetadata objectIdMetadata = hprofParser.objectIdMetadata(node.getInstance());
        if (SKIP_ENQUEUE.contains(objectIdMetadata)) {
            return;
        }
        if (visitNow) {
            this.toVisitSet.add(node.getInstance());
            this.toVisitQueue.add(node);
        } else {
            this.toVisitIfNoPathSet.add(node.getInstance());
            this.toVisitIfNoPathQueue.add(node);
        }
    }

    public ShortestPathFinder(@NotNull ExcludedRefs excludedRefs) {
        Intrinsics.checkParameterIsNotNull((Object)excludedRefs, (String)"excludedRefs");
        this.excludedRefs = excludedRefs;
        this.toVisitQueue = new ArrayDeque();
        this.toVisitIfNoPathQueue = new ArrayDeque();
        this.toVisitSet = new LinkedHashSet();
        this.toVisitIfNoPathSet = new LinkedHashSet();
        this.visitedSet = new LinkedHashSet();
    }

    static {
        Companion = new Companion(null);
        SKIP_ENQUEUE = SetsKt.setOf((Object[])new ObjectIdMetadata[]{ObjectIdMetadata.PRIMITIVE_WRAPPER, ObjectIdMetadata.PRIMITIVE_ARRAY_OR_WRAPPER_ARRAY, ObjectIdMetadata.STRING, ObjectIdMetadata.EMPTY_INSTANCE});
    }

    @Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\b\b\u0000\u0018\u00002\u00020\u0001B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000e\u00a8\u0006\u000f"}, d2={"Lleakcanary/internal/ShortestPathFinder$Result;", "", "leakingNode", "Lleakcanary/LeakNode;", "excludingKnownLeaks", "", "weakReference", "Lleakcanary/internal/KeyedWeakReferenceMirror;", "(Lleakcanary/LeakNode;ZLleakcanary/internal/KeyedWeakReferenceMirror;)V", "getExcludingKnownLeaks", "()Z", "getLeakingNode", "()Lleakcanary/LeakNode;", "getWeakReference", "()Lleakcanary/internal/KeyedWeakReferenceMirror;", "leakcanary-analyzer"})
    public static final class Result {
        @NotNull
        private final LeakNode leakingNode;
        private final boolean excludingKnownLeaks;
        @NotNull
        private final KeyedWeakReferenceMirror weakReference;

        @NotNull
        public final LeakNode getLeakingNode() {
            return this.leakingNode;
        }

        public final boolean getExcludingKnownLeaks() {
            return this.excludingKnownLeaks;
        }

        @NotNull
        public final KeyedWeakReferenceMirror getWeakReference() {
            return this.weakReference;
        }

        public Result(@NotNull LeakNode leakingNode, boolean excludingKnownLeaks, @NotNull KeyedWeakReferenceMirror weakReference) {
            Intrinsics.checkParameterIsNotNull((Object)leakingNode, (String)"leakingNode");
            Intrinsics.checkParameterIsNotNull((Object)weakReference, (String)"weakReference");
            this.leakingNode = leakingNode;
            this.excludingKnownLeaks = excludingKnownLeaks;
            this.weakReference = weakReference;
        }
    }

    @Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000\u0016\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0014\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lleakcanary/internal/ShortestPathFinder$Companion;", "", "()V", "SKIP_ENQUEUE", "", "Lleakcanary/ObjectIdMetadata;", "leakcanary-analyzer"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

