/*
 * Decompiled with CFR 0.152.
 */
package leakcanary;

import android.os.SystemClock;
import java.io.File;
import java.util.Map;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import leakcanary.AndroidDetectLeaksInterceptor;
import leakcanary.AppWatcher;
import leakcanary.DetectLeaksAssert;
import leakcanary.DetectLeaksInterceptor;
import leakcanary.HeapAnalysisDecision;
import leakcanary.HeapAnalysisReporter;
import leakcanary.KeyedWeakReference;
import leakcanary.LeakCanary;
import leakcanary.NoLeakAssertionFailedError;
import leakcanary.SkipLeakDetection;
import leakcanary.TestDescriptionHolder;
import leakcanary.internal.HandlersKt;
import leakcanary.internal.InstrumentationHeapAnalyzer;
import leakcanary.internal.InstrumentationHeapDumpFileProvider;
import leakcanary.internal.RetryingHeapAnalyzer;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.junit.runner.Description;
import shark.HeapAnalysis;
import shark.HeapAnalysisFailure;
import shark.HeapAnalysisSuccess;
import shark.SharkLog;

@Metadata(mv={1, 4, 1}, bv={1, 0, 3}, k=1, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\t\n\u0002\b\u0002\u0018\u0000 \u000e2\u00020\u0001:\u0001\u000eB\u0019\u0012\b\b\u0002\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0010\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0016J\u0018\u0010\u000b\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\f\u001a\u00020\rH\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000f"}, d2={"Lleakcanary/AndroidDetectLeaksAssert;", "Lleakcanary/DetectLeaksAssert;", "detectLeaksInterceptor", "Lleakcanary/DetectLeaksInterceptor;", "heapAnalysisReporter", "Lleakcanary/HeapAnalysisReporter;", "(Lleakcanary/DetectLeaksInterceptor;Lleakcanary/HeapAnalysisReporter;)V", "assertNoLeaks", "", "tag", "", "runLeakChecks", "assertionStartUptimeMillis", "", "Companion", "leakcanary-android-instrumentation_release"})
public final class AndroidDetectLeaksAssert
implements DetectLeaksAssert {
    private final DetectLeaksInterceptor detectLeaksInterceptor;
    private final HeapAnalysisReporter heapAnalysisReporter;
    private static final String ASSERTION_TAG = "assertionTag";
    private static final String WAIT_FOR_RETAINED = "waitForRetainedDurationMillis";
    private static final String TOTAL_DURATION = "totalDurationMillis";
    private static long totalVmDurationMillis;
    @NotNull
    public static final Companion Companion;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void assertNoLeaks(@NotNull String tag) {
        Intrinsics.checkParameterIsNotNull((Object)tag, (String)"tag");
        long assertionStartUptimeMillis = SystemClock.uptimeMillis();
        try {
            this.runLeakChecks(tag, assertionStartUptimeMillis);
        }
        finally {
            long totalDurationMillis = SystemClock.uptimeMillis() - assertionStartUptimeMillis;
            totalVmDurationMillis += totalDurationMillis;
            SharkLog this_$iv = SharkLog.INSTANCE;
            boolean $i$f$d = false;
            SharkLog.Logger logger = this_$iv.getLogger();
            if (logger == null) {
            } else {
                SharkLog.Logger logger$iv;
                SharkLog.Logger logger2 = logger$iv = logger;
                boolean bl = false;
                String string = "Spent " + totalDurationMillis + " ms detecting leaks on " + tag + ", VM total so far: " + totalVmDurationMillis + " ms";
                logger2.d(string);
            }
        }
    }

    private final void runLeakChecks(String tag, long assertionStartUptimeMillis) {
        HeapAnalysis heapAnalysis;
        Description testDescription;
        if (TestDescriptionHolder.INSTANCE.isEvaluating() && SkipLeakDetection.Companion.shouldSkipTest(testDescription = TestDescriptionHolder.INSTANCE.getTestDescription(), tag)) {
            return;
        }
        boolean $i$f$checkNotMainThread = false;
        HandlersKt.checkNotMainThread();
        boolean $i$f$measureDurationMillis = false;
        boolean $i$f$measureDurationMillis2 = false;
        long start$iv$iv = SystemClock.uptimeMillis();
        boolean bl = false;
        HeapAnalysisDecision yesNo = this.detectLeaksInterceptor.waitUntilReadyForHeapAnalysis();
        if (yesNo instanceof HeapAnalysisDecision.NoHeapAnalysis) {
            SharkLog this_$iv = SharkLog.INSTANCE;
            boolean $i$f$d = false;
            SharkLog.Logger logger = this_$iv.getLogger();
            if (logger == null) {
            } else {
                SharkLog.Logger logger$iv;
                SharkLog.Logger logger2 = logger$iv = logger;
                boolean bl2 = false;
                String string = "Test can keep going: no heap dump performed (" + ((HeapAnalysisDecision.NoHeapAnalysis)yesNo).getReason() + ')';
                logger2.d(string);
            }
            return;
        }
        long waitForRetainedDurationMillis = SystemClock.uptimeMillis() - start$iv$iv;
        File heapDumpFile = new InstrumentationHeapDumpFileProvider(null, 1, null).newHeapDumpFile();
        LeakCanary.Config config = LeakCanary.getConfig();
        KeyedWeakReference.Companion.setHeapDumpUptimeMillis(SystemClock.uptimeMillis());
        boolean $i$f$measureDurationMillis3 = false;
        boolean $i$f$measureDurationMillis4 = false;
        long start$iv$iv2 = SystemClock.uptimeMillis();
        boolean bl3 = false;
        config.getHeapDumper().dumpHeap(heapDumpFile);
        long heapDumpDurationMillis = SystemClock.uptimeMillis() - start$iv$iv2;
        long heapDumpUptimeMillis = KeyedWeakReference.Companion.getHeapDumpUptimeMillis();
        AppWatcher.INSTANCE.getObjectWatcher().clearObjectsWatchedBefore(heapDumpUptimeMillis);
        RetryingHeapAnalyzer heapAnalyzer2 = new RetryingHeapAnalyzer(new InstrumentationHeapAnalyzer(config.getLeakingObjectFinder(), config.getReferenceMatchers(), config.getComputeRetainedHeapSize(), config.getMetadataExtractor(), config.getObjectInspectors(), null));
        HeapAnalysis analysisResult = heapAnalyzer2.analyze(heapDumpFile);
        long totalDurationMillis = SystemClock.uptimeMillis() - assertionStartUptimeMillis;
        HeapAnalysis heapAnalysis2 = analysisResult;
        boolean bl4 = false;
        boolean bl5 = false;
        HeapAnalysis it = heapAnalysis2;
        boolean bl6 = false;
        HeapAnalysis heapAnalysis3 = it;
        if (heapAnalysis3 instanceof HeapAnalysisSuccess) {
            heapAnalysis = (HeapAnalysis)HeapAnalysisSuccess.copy$default((HeapAnalysisSuccess)((HeapAnalysisSuccess)it), null, (long)0L, (long)heapDumpDurationMillis, (long)0L, (Map)MapsKt.plus((Map)((HeapAnalysisSuccess)it).getMetadata(), (Map)MapsKt.mapOf((Pair[])new Pair[]{TuplesKt.to((Object)ASSERTION_TAG, (Object)tag), TuplesKt.to((Object)WAIT_FOR_RETAINED, (Object)String.valueOf(waitForRetainedDurationMillis)), TuplesKt.to((Object)TOTAL_DURATION, (Object)String.valueOf(totalDurationMillis))})), null, null, null, (int)235, null);
        } else if (heapAnalysis3 instanceof HeapAnalysisFailure) {
            heapAnalysis = (HeapAnalysis)HeapAnalysisFailure.copy$default((HeapAnalysisFailure)((HeapAnalysisFailure)it), null, (long)0L, (long)heapDumpDurationMillis, (long)0L, null, (int)27, null);
        } else {
            throw new NoWhenBranchMatchedException();
        }
        HeapAnalysis heapAnalysisWithExtraDetails = heapAnalysis;
        this.heapAnalysisReporter.reportHeapAnalysis(heapAnalysisWithExtraDetails);
    }

    public AndroidDetectLeaksAssert(@NotNull DetectLeaksInterceptor detectLeaksInterceptor, @NotNull HeapAnalysisReporter heapAnalysisReporter) {
        Intrinsics.checkParameterIsNotNull((Object)detectLeaksInterceptor, (String)"detectLeaksInterceptor");
        Intrinsics.checkParameterIsNotNull((Object)heapAnalysisReporter, (String)"heapAnalysisReporter");
        this.detectLeaksInterceptor = detectLeaksInterceptor;
        this.heapAnalysisReporter = heapAnalysisReporter;
    }

    public /* synthetic */ AndroidDetectLeaksAssert(DetectLeaksInterceptor detectLeaksInterceptor, HeapAnalysisReporter heapAnalysisReporter, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 1) != 0) {
            detectLeaksInterceptor = new AndroidDetectLeaksInterceptor(null, null, 0L, 7, null);
        }
        if ((n & 2) != 0) {
            heapAnalysisReporter = NoLeakAssertionFailedError.Companion.throwOnApplicationLeaks();
        }
        this(detectLeaksInterceptor, heapAnalysisReporter);
    }

    public AndroidDetectLeaksAssert() {
        this(null, null, 3, null);
    }

    static {
        Companion = new Companion(null);
    }

    @Metadata(mv={1, 4, 1}, bv={1, 0, 3}, k=1, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0005\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0017\u0010\t\u001a\u0004\u0018\u00010\u0004*\u00020\n8F\u00a2\u0006\u0006\u001a\u0004\b\u000b\u0010\fR\u0017\u0010\r\u001a\u0004\u0018\u00010\u000e*\u00020\n8F\u00a2\u0006\u0006\u001a\u0004\b\u000f\u0010\u0010R\u0017\u0010\u0011\u001a\u0004\u0018\u00010\u000e*\u00020\n8F\u00a2\u0006\u0006\u001a\u0004\b\u0012\u0010\u0010\u00a8\u0006\u0013"}, d2={"Lleakcanary/AndroidDetectLeaksAssert$Companion;", "", "()V", "ASSERTION_TAG", "", "TOTAL_DURATION", "WAIT_FOR_RETAINED", "totalVmDurationMillis", "", "assertionTag", "Lshark/HeapAnalysisSuccess;", "getAssertionTag", "(Lshark/HeapAnalysisSuccess;)Ljava/lang/String;", "totalDurationMillis", "", "getTotalDurationMillis", "(Lshark/HeapAnalysisSuccess;)Ljava/lang/Integer;", "waitForRetainedDurationMillis", "getWaitForRetainedDurationMillis", "leakcanary-android-instrumentation_release"})
    public static final class Companion {
        @Nullable
        public final String getAssertionTag(@NotNull HeapAnalysisSuccess $this$assertionTag) {
            Intrinsics.checkParameterIsNotNull((Object)$this$assertionTag, (String)"$this$assertionTag");
            return (String)$this$assertionTag.getMetadata().get(AndroidDetectLeaksAssert.ASSERTION_TAG);
        }

        @Nullable
        public final Integer getWaitForRetainedDurationMillis(@NotNull HeapAnalysisSuccess $this$waitForRetainedDurationMillis) {
            Integer n;
            Intrinsics.checkParameterIsNotNull((Object)$this$waitForRetainedDurationMillis, (String)"$this$waitForRetainedDurationMillis");
            String string = (String)$this$waitForRetainedDurationMillis.getMetadata().get(AndroidDetectLeaksAssert.WAIT_FOR_RETAINED);
            if (string != null) {
                String string2 = string;
                boolean bl = false;
                n = Integer.parseInt(string2);
            } else {
                n = null;
            }
            return n;
        }

        @Nullable
        public final Integer getTotalDurationMillis(@NotNull HeapAnalysisSuccess $this$totalDurationMillis) {
            Integer n;
            Intrinsics.checkParameterIsNotNull((Object)$this$totalDurationMillis, (String)"$this$totalDurationMillis");
            String string = (String)$this$totalDurationMillis.getMetadata().get(AndroidDetectLeaksAssert.TOTAL_DURATION);
            if (string != null) {
                String string2 = string;
                boolean bl = false;
                n = Integer.parseInt(string2);
            } else {
                n = null;
            }
            return n;
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

