/*
 * Decompiled with CFR 0.152.
 */
package leakcanary;

import android.app.Instrumentation;
import android.os.SystemClock;
import androidx.test.platform.app.InstrumentationRegistry;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import leakcanary.AppWatcher;
import leakcanary.DetectLeaksInterceptor;
import leakcanary.GcTrigger;
import leakcanary.HeapAnalysisDecision;
import leakcanary.ObjectWatcher;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 4, 1}, bv={1, 0, 3}, k=1, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B#\u0012\b\b\u0002\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0005\u0012\b\b\u0002\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\b\u0010\t\u001a\u00020\nH\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000b"}, d2={"Lleakcanary/AndroidDetectLeaksInterceptor;", "Lleakcanary/DetectLeaksInterceptor;", "instrumentation", "Landroid/app/Instrumentation;", "objectWatcher", "Lleakcanary/ObjectWatcher;", "retainedDelayMillis", "", "(Landroid/app/Instrumentation;Lleakcanary/ObjectWatcher;J)V", "waitUntilReadyForHeapAnalysis", "Lleakcanary/HeapAnalysisDecision;", "leakcanary-android-instrumentation_release"})
public final class AndroidDetectLeaksInterceptor
implements DetectLeaksInterceptor {
    private final Instrumentation instrumentation;
    private final ObjectWatcher objectWatcher;
    private final long retainedDelayMillis;

    @Override
    @NotNull
    public HeapAnalysisDecision waitUntilReadyForHeapAnalysis() {
        long leakDetectionTime = SystemClock.uptimeMillis();
        if (!this.objectWatcher.getHasWatchedObjects()) {
            return new HeapAnalysisDecision.NoHeapAnalysis("No watched objects.");
        }
        this.instrumentation.waitForIdleSync();
        if (!this.objectWatcher.getHasWatchedObjects()) {
            return new HeapAnalysisDecision.NoHeapAnalysis("No watched objects after waiting for idle sync.");
        }
        GcTrigger.Default.INSTANCE.runGc();
        if (!this.objectWatcher.getHasWatchedObjects()) {
            return new HeapAnalysisDecision.NoHeapAnalysis("No watched objects after triggering an explicit GC.");
        }
        SystemClock.sleep((long)2000L);
        if (!this.objectWatcher.getHasWatchedObjects()) {
            return new HeapAnalysisDecision.NoHeapAnalysis("No watched objects after delayed UI post is cleared.");
        }
        SystemClock.sleep((long)2000L);
        long endOfWatchDelay = this.retainedDelayMillis - (SystemClock.uptimeMillis() - leakDetectionTime);
        if (endOfWatchDelay > 0L) {
            SystemClock.sleep((long)endOfWatchDelay);
        }
        GcTrigger.Default.INSTANCE.runGc();
        if (!this.objectWatcher.getHasRetainedObjects()) {
            return new HeapAnalysisDecision.NoHeapAnalysis("No retained objects after waiting for retained delay.");
        }
        return HeapAnalysisDecision.AnalyzeHeap.INSTANCE;
    }

    public AndroidDetectLeaksInterceptor(@NotNull Instrumentation instrumentation, @NotNull ObjectWatcher objectWatcher, long retainedDelayMillis) {
        Intrinsics.checkParameterIsNotNull((Object)instrumentation, (String)"instrumentation");
        Intrinsics.checkParameterIsNotNull((Object)objectWatcher, (String)"objectWatcher");
        this.instrumentation = instrumentation;
        this.objectWatcher = objectWatcher;
        this.retainedDelayMillis = retainedDelayMillis;
    }

    public /* synthetic */ AndroidDetectLeaksInterceptor(Instrumentation instrumentation, ObjectWatcher objectWatcher, long l, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 1) != 0) {
            Instrumentation instrumentation2 = InstrumentationRegistry.getInstrumentation();
            Intrinsics.checkExpressionValueIsNotNull((Object)instrumentation2, (String)"InstrumentationRegistry.getInstrumentation()");
            instrumentation = instrumentation2;
        }
        if ((n & 2) != 0) {
            objectWatcher = AppWatcher.INSTANCE.getObjectWatcher();
        }
        if ((n & 4) != 0) {
            l = AppWatcher.INSTANCE.getRetainedDelayMillis();
        }
        this(instrumentation, objectWatcher, l);
    }

    public AndroidDetectLeaksInterceptor() {
        this(null, null, 0L, 7, null);
    }
}

