/*
 * Decompiled with CFR 0.152.
 */
package leakcanary.internal;

import android.os.SystemClock;
import java.io.Closeable;
import java.io.File;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.TypeCastException;
import kotlin.collections.MapsKt;
import kotlin.io.CloseableKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import shark.CloseableHeapGraph;
import shark.ConstantMemoryMetricsDualSourceProvider;
import shark.DualSourceProvider;
import shark.FileSourceProvider;
import shark.HeapAnalysis;
import shark.HeapAnalysisException;
import shark.HeapAnalysisFailure;
import shark.HeapAnalysisSuccess;
import shark.HeapAnalyzer;
import shark.HeapGraph;
import shark.HprofHeapGraph;
import shark.LeakingObjectFinder;
import shark.MetadataExtractor;
import shark.ObjectInspector;
import shark.OnAnalysisProgressListener;
import shark.ProguardMapping;
import shark.ReferenceMatcher;
import shark.SharkLog;

@Metadata(mv={1, 4, 1}, bv={1, 0, 3}, k=1, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\r\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0000\u0018\u00002\u00020\u0001BC\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\u0006\u0010\t\u001a\u00020\n\u0012\f\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\f0\u0005\u0012\b\u0010\r\u001a\u0004\u0018\u00010\u000e\u00a2\u0006\u0002\u0010\u000fJ\u000e\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u001d\u001a\u00020\u001eR\u0011\u0010\u0007\u001a\u00020\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013R\u0011\u0010\t\u001a\u00020\n\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0015R\u0017\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\f0\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0016\u0010\u0017R\u0013\u0010\r\u001a\u0004\u0018\u00010\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0018\u0010\u0019R\u0017\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001a\u0010\u0017\u00a8\u0006\u001f"}, d2={"Lleakcanary/internal/InstrumentationHeapAnalyzer;", "", "leakingObjectFinder", "Lshark/LeakingObjectFinder;", "referenceMatchers", "", "Lshark/ReferenceMatcher;", "computeRetainedHeapSize", "", "metadataExtractor", "Lshark/MetadataExtractor;", "objectInspectors", "Lshark/ObjectInspector;", "proguardMapping", "Lshark/ProguardMapping;", "(Lshark/LeakingObjectFinder;Ljava/util/List;ZLshark/MetadataExtractor;Ljava/util/List;Lshark/ProguardMapping;)V", "getComputeRetainedHeapSize", "()Z", "getLeakingObjectFinder", "()Lshark/LeakingObjectFinder;", "getMetadataExtractor", "()Lshark/MetadataExtractor;", "getObjectInspectors", "()Ljava/util/List;", "getProguardMapping", "()Lshark/ProguardMapping;", "getReferenceMatchers", "analyze", "Lshark/HeapAnalysis;", "heapDumpFile", "Ljava/io/File;", "leakcanary-android-instrumentation_release"})
public final class InstrumentationHeapAnalyzer {
    @NotNull
    private final LeakingObjectFinder leakingObjectFinder;
    @NotNull
    private final List<ReferenceMatcher> referenceMatchers;
    private final boolean computeRetainedHeapSize;
    @NotNull
    private final MetadataExtractor metadataExtractor;
    @NotNull
    private final List<ObjectInspector> objectInspectors;
    @Nullable
    private final ProguardMapping proguardMapping;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    @NotNull
    public final HeapAnalysis analyze(@NotNull File heapDumpFile) {
        HeapAnalysis heapAnalysis;
        Object object;
        void lastStepUptimeMs;
        Intrinsics.checkParameterIsNotNull((Object)heapDumpFile, (String)"heapDumpFile");
        Ref.LongRef longRef = new Ref.LongRef();
        longRef.element = -1L;
        HeapAnalyzer heapAnalyzer2 = new HeapAnalyzer(new OnAnalysisProgressListener((Ref.LongRef)lastStepUptimeMs){
            final /* synthetic */ Ref.LongRef $lastStepUptimeMs;

            public final void onAnalysisProgress(@NotNull OnAnalysisProgressListener.Step newStep) {
                String string;
                Intrinsics.checkParameterIsNotNull((Object)newStep, (String)"newStep");
                long now = SystemClock.uptimeMillis();
                if (this.$lastStepUptimeMs.element != -1L) {
                    long lastStepDurationMs = now - this.$lastStepUptimeMs.element;
                    OnAnalysisProgressListener.Step lastStep = OnAnalysisProgressListener.Step.values()[newStep.ordinal() - 1];
                    string = lastStep.getHumanReadableName() + " took " + lastStepDurationMs + " ms, now ";
                } else {
                    string = "";
                }
                String lastStepString = string;
                SharkLog this_$iv = SharkLog.INSTANCE;
                boolean $i$f$d = false;
                SharkLog.Logger logger = this_$iv.getLogger();
                if (logger == null) {
                } else {
                    SharkLog.Logger logger$iv;
                    SharkLog.Logger logger2 = logger$iv = logger;
                    boolean bl = false;
                    String string2 = lastStepString + "working on " + newStep.getHumanReadableName();
                    logger2.d(string2);
                }
                this.$lastStepUptimeMs.element = now;
            }
            {
                this.$lastStepUptimeMs = longRef;
            }
        });
        ConstantMemoryMetricsDualSourceProvider sourceProvider = new ConstantMemoryMetricsDualSourceProvider((DualSourceProvider)new FileSourceProvider(heapDumpFile));
        try {
            object = HprofHeapGraph.Companion.openHeapGraph$default((HprofHeapGraph.Companion)HprofHeapGraph.Companion, (DualSourceProvider)((DualSourceProvider)sourceProvider), (ProguardMapping)this.proguardMapping, null, (int)2, null);
        }
        catch (Throwable throwable) {
            return (HeapAnalysis)new HeapAnalysisFailure(heapDumpFile, System.currentTimeMillis(), 0L, 0L, new HeapAnalysisException(throwable), 4, null);
        }
        CloseableHeapGraph closeableGraph = object;
        object = (Closeable)closeableGraph;
        boolean bl = false;
        boolean bl2 = false;
        Throwable throwable = null;
        try {
            HeapAnalysis heapAnalysis2;
            Object graph = object;
            boolean bl3 = false;
            HeapAnalysis result = heapAnalyzer2.analyze(heapDumpFile, (HeapGraph)graph, this.leakingObjectFinder, this.referenceMatchers, this.computeRetainedHeapSize, this.objectInspectors, this.metadataExtractor);
            if (result instanceof HeapAnalysisSuccess) {
                Object object2 = graph;
                if (object2 == null) {
                    throw new TypeCastException("null cannot be cast to non-null type shark.HprofHeapGraph");
                }
                String lruCacheStats = ((HprofHeapGraph)object2).lruCacheStats();
                String randomAccessStats = "RandomAccess[" + "bytes=" + sourceProvider.getRandomAccessByteReads() + ',' + "reads=" + sourceProvider.getRandomAccessReadCount() + ',' + "travel=" + sourceProvider.getRandomAccessByteTravel() + ',' + "range=" + sourceProvider.getByteTravelRange() + ',' + "size=" + heapDumpFile.length() + "]";
                String stats = lruCacheStats + ' ' + randomAccessStats;
                heapAnalysis2 = (HeapAnalysis)HeapAnalysisSuccess.copy$default((HeapAnalysisSuccess)((HeapAnalysisSuccess)result), null, (long)0L, (long)0L, (long)0L, (Map)MapsKt.plus((Map)((HeapAnalysisSuccess)result).getMetadata(), (Pair)TuplesKt.to((Object)"Stats", (Object)stats)), null, null, null, (int)239, null);
            } else {
                heapAnalysis2 = result;
            }
            heapAnalysis = heapAnalysis2;
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            CloseableKt.closeFinally((Closeable)object, (Throwable)throwable);
        }
        return heapAnalysis;
    }

    @NotNull
    public final LeakingObjectFinder getLeakingObjectFinder() {
        return this.leakingObjectFinder;
    }

    @NotNull
    public final List<ReferenceMatcher> getReferenceMatchers() {
        return this.referenceMatchers;
    }

    public final boolean getComputeRetainedHeapSize() {
        return this.computeRetainedHeapSize;
    }

    @NotNull
    public final MetadataExtractor getMetadataExtractor() {
        return this.metadataExtractor;
    }

    @NotNull
    public final List<ObjectInspector> getObjectInspectors() {
        return this.objectInspectors;
    }

    @Nullable
    public final ProguardMapping getProguardMapping() {
        return this.proguardMapping;
    }

    public InstrumentationHeapAnalyzer(@NotNull LeakingObjectFinder leakingObjectFinder, @NotNull List<? extends ReferenceMatcher> referenceMatchers, boolean computeRetainedHeapSize, @NotNull MetadataExtractor metadataExtractor, @NotNull List<? extends ObjectInspector> objectInspectors, @Nullable ProguardMapping proguardMapping) {
        Intrinsics.checkParameterIsNotNull((Object)leakingObjectFinder, (String)"leakingObjectFinder");
        Intrinsics.checkParameterIsNotNull(referenceMatchers, (String)"referenceMatchers");
        Intrinsics.checkParameterIsNotNull((Object)metadataExtractor, (String)"metadataExtractor");
        Intrinsics.checkParameterIsNotNull(objectInspectors, (String)"objectInspectors");
        this.leakingObjectFinder = leakingObjectFinder;
        this.referenceMatchers = referenceMatchers;
        this.computeRetainedHeapSize = computeRetainedHeapSize;
        this.metadataExtractor = metadataExtractor;
        this.objectInspectors = objectInspectors;
        this.proguardMapping = proguardMapping;
    }
}

