/*
 * Decompiled with CFR 0.152.
 */
package leakcanary.internal;

import android.os.SystemClock;
import android.util.Log;
import java.io.File;
import java.util.Map;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.MapsKt;
import kotlin.io.FilesKt;
import kotlin.jvm.internal.Intrinsics;
import leakcanary.internal.InstrumentationHeapAnalyzer;
import org.jetbrains.annotations.NotNull;
import shark.HeapAnalysis;
import shark.HeapAnalysisFailure;
import shark.HeapAnalysisSuccess;
import shark.SharkLog;

@Metadata(mv={1, 4, 1}, bv={1, 0, 3}, k=1, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0000\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u000e\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bR\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\t"}, d2={"Lleakcanary/internal/RetryingHeapAnalyzer;", "", "heapAnalyzer", "Lleakcanary/internal/InstrumentationHeapAnalyzer;", "(Lleakcanary/internal/InstrumentationHeapAnalyzer;)V", "analyze", "Lshark/HeapAnalysis;", "heapDumpFile", "Ljava/io/File;", "leakcanary-android-instrumentation_release"})
public final class RetryingHeapAnalyzer {
    private final InstrumentationHeapAnalyzer heapAnalyzer;

    /*
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @NotNull
    public final HeapAnalysis analyze(@NotNull File heapDumpFile) {
        HeapAnalysis heapAnalysis;
        Intrinsics.checkParameterIsNotNull((Object)heapDumpFile, (String)"heapDumpFile");
        File heapDumpCopyFile = new File(heapDumpFile.getParent(), "copy-" + heapDumpFile.getName());
        FilesKt.copyTo$default((File)heapDumpFile, (File)heapDumpCopyFile, (boolean)false, (int)0, (int)6, null);
        SystemClock.sleep((long)2000L);
        HeapAnalysis heapAnalysis2 = this.heapAnalyzer.analyze(heapDumpFile);
        if (heapAnalysis2 instanceof HeapAnalysisFailure) {
            void this_$iv;
            SharkLog sharkLog = SharkLog.INSTANCE;
            Throwable throwable$iv = (Throwable)((HeapAnalysisFailure)heapAnalysis2).getException();
            boolean $i$f$d = false;
            SharkLog.Logger logger = this_$iv.getLogger();
            if (logger == null) {
            } else {
                SharkLog.Logger logger$iv = logger;
                Throwable throwable = throwable$iv;
                SharkLog.Logger logger2 = logger$iv;
                boolean bl = false;
                String string = "Heap Analysis failed, retrying in 10s in case the heap dump was not fully baked yet. " + "Copy of original heap dump available at " + heapDumpCopyFile.getAbsolutePath();
                logger2.d(throwable, string);
            }
            SystemClock.sleep((long)10000L);
            sharkLog = this.heapAnalyzer.analyze(heapDumpFile);
            boolean bl = false;
            boolean bl2 = false;
            SharkLog it = sharkLog;
            boolean bl3 = false;
            SharkLog sharkLog2 = it;
            if (sharkLog2 instanceof HeapAnalysisSuccess) {
                heapAnalysis = (HeapAnalysis)HeapAnalysisSuccess.copy$default((HeapAnalysisSuccess)((HeapAnalysisSuccess)it), null, (long)0L, (long)0L, (long)0L, (Map)MapsKt.plus((Map)((HeapAnalysisSuccess)it).getMetadata(), (Map)MapsKt.mapOf((Pair[])new Pair[]{TuplesKt.to((Object)"previousFailureHeapDumpCopy", (Object)heapDumpCopyFile.getAbsolutePath()), TuplesKt.to((Object)"previousFailureStacktrace", (Object)Log.getStackTraceString((Throwable)((Throwable)((HeapAnalysisFailure)heapAnalysis2).getException())))})), null, null, null, (int)239, null);
                return heapAnalysis;
            } else {
                if (!(sharkLog2 instanceof HeapAnalysisFailure)) throw new NoWhenBranchMatchedException();
                heapAnalysis = it;
            }
            return heapAnalysis;
        } else {
            heapDumpCopyFile.delete();
            heapAnalysis = heapAnalysis2;
        }
        return heapAnalysis;
    }

    public RetryingHeapAnalyzer(@NotNull InstrumentationHeapAnalyzer heapAnalyzer2) {
        Intrinsics.checkParameterIsNotNull((Object)heapAnalyzer2, (String)"heapAnalyzer");
        this.heapAnalyzer = heapAnalyzer2;
    }
}

