/*
 * Decompiled with CFR 0.152.
 */
package leakcanary;

import android.app.ActivityManager;
import android.app.Service;
import android.content.ComponentName;
import android.content.Context;
import android.content.pm.PackageInfo;
import android.content.pm.PackageManager;
import android.content.pm.ServiceInfo;
import android.os.Process;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import leakcanary.internal.RemoteLeakCanaryWorkerService;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import shark.SharkLog;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0006\u001a\u00020\u0007J \u0010\b\u001a\u00020\u00042\u0006\u0010\u0006\u001a\u00020\u00072\u000e\u0010\t\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u000b0\nH\u0002R\u0012\u0010\u0003\u001a\u0004\u0018\u00010\u0004X\u0082\u000e\u00a2\u0006\u0004\n\u0002\u0010\u0005\u00a8\u0006\f"}, d2={"Lleakcanary/LeakCanaryProcess;", "", "()V", "isInAnalyzerProcess", "", "Ljava/lang/Boolean;", "context", "Landroid/content/Context;", "isInServiceProcess", "serviceClass", "Ljava/lang/Class;", "Landroid/app/Service;", "leakcanary-android-process_release"})
@SourceDebugExtension(value={"SMAP\nLeakCanaryProcess.kt\nKotlin\n*S Kotlin\n*F\n+ 1 LeakCanaryProcess.kt\nleakcanary/LeakCanaryProcess\n+ 2 SharkLog.kt\nshark/SharkLog\n*L\n1#1,102:1\n46#2,3:103\n34#2,3:106\n34#2,3:109\n34#2,3:112\n34#2,3:115\n*S KotlinDebug\n*F\n+ 1 LeakCanaryProcess.kt\nleakcanary/LeakCanaryProcess\n*L\n49#1:103,3\n66#1:106,3\n69#1:109,3\n82#1:112,3\n95#1:115,3\n*E\n"})
public final class LeakCanaryProcess {
    @NotNull
    public static final LeakCanaryProcess INSTANCE = new LeakCanaryProcess();
    @Nullable
    private static volatile Boolean isInAnalyzerProcess;

    private LeakCanaryProcess() {
    }

    public final boolean isInAnalyzerProcess(@NotNull Context context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Boolean isInAnalyzerProcess = LeakCanaryProcess.isInAnalyzerProcess;
        if (isInAnalyzerProcess == null) {
            LeakCanaryProcess.isInAnalyzerProcess = isInAnalyzerProcess = Boolean.valueOf(this.isInServiceProcess(context, RemoteLeakCanaryWorkerService.class));
        }
        return isInAnalyzerProcess;
    }

    private final boolean isInServiceProcess(Context context, Class<? extends Service> serviceClass) {
        PackageManager packageManager = context.getPackageManager();
        PackageInfo packageInfo = null;
        try {
            PackageInfo packageInfo2 = packageManager.getPackageInfo(context.getPackageName(), 4);
            Intrinsics.checkNotNullExpressionValue((Object)packageInfo2, (String)"packageManager.getPackag\u2026kageManager.GET_SERVICES)");
            packageInfo = packageInfo2;
        }
        catch (Exception e) {
            SharkLog this_$iv = SharkLog.INSTANCE;
            boolean $i$f$d = false;
            SharkLog.Logger logger = this_$iv.getLogger();
            if (logger != null) {
                SharkLog.Logger logger$iv = logger;
                Throwable throwable = e;
                SharkLog.Logger logger2 = logger$iv;
                boolean bl = false;
                String string = "Could not get package info for " + context.getPackageName();
                logger2.d(throwable, string);
            }
            return false;
        }
        String mainProcess = packageInfo.applicationInfo.processName;
        ComponentName component = new ComponentName(context, serviceClass);
        ServiceInfo serviceInfo = null;
        try {
            ServiceInfo serviceInfo2 = packageManager.getServiceInfo(component, 512);
            Intrinsics.checkNotNullExpressionValue((Object)serviceInfo2, (String)"packageManager.getServic\u2026.GET_DISABLED_COMPONENTS)");
            serviceInfo = serviceInfo2;
        }
        catch (PackageManager.NameNotFoundException ignored) {
            return false;
        }
        if (serviceInfo.processName == null) {
            SharkLog this_$iv = SharkLog.INSTANCE;
            boolean $i$f$d = false;
            SharkLog.Logger logger = this_$iv.getLogger();
            if (logger != null) {
                SharkLog.Logger logger$iv;
                SharkLog.Logger logger3 = logger$iv = logger;
                boolean bl = false;
                logger3.d("Did not expect service " + serviceClass + " to have a null process name");
            }
            return false;
        }
        if (Intrinsics.areEqual((Object)serviceInfo.processName, (Object)mainProcess)) {
            SharkLog this_$iv = SharkLog.INSTANCE;
            boolean $i$f$d = false;
            SharkLog.Logger logger = this_$iv.getLogger();
            if (logger != null) {
                SharkLog.Logger logger$iv;
                SharkLog.Logger logger4 = logger$iv = logger;
                boolean bl = false;
                logger4.d("Did not expect service " + serviceClass + " to run in main process " + mainProcess);
            }
            return false;
        }
        int myPid = Process.myPid();
        Object object = context.getSystemService("activity");
        Intrinsics.checkNotNull((Object)object, (String)"null cannot be cast to non-null type android.app.ActivityManager");
        ActivityManager activityManager = (ActivityManager)object;
        ActivityManager.RunningAppProcessInfo myProcess = null;
        List runningProcesses = null;
        try {
            runningProcesses = activityManager.getRunningAppProcesses();
        }
        catch (SecurityException exception) {
            SharkLog this_$iv = SharkLog.INSTANCE;
            boolean $i$f$d = false;
            SharkLog.Logger logger = this_$iv.getLogger();
            if (logger != null) {
                SharkLog.Logger logger$iv;
                SharkLog.Logger logger5 = logger$iv = logger;
                boolean bl = false;
                logger5.d("Could not get running app processes " + exception);
            }
            return false;
        }
        if (runningProcesses != null) {
            for (ActivityManager.RunningAppProcessInfo process : runningProcesses) {
                if (process.pid != myPid) continue;
                myProcess = process;
                break;
            }
        }
        if (myProcess == null) {
            SharkLog this_$iv = SharkLog.INSTANCE;
            boolean $i$f$d = false;
            SharkLog.Logger logger = this_$iv.getLogger();
            if (logger != null) {
                SharkLog.Logger logger$iv;
                SharkLog.Logger logger6 = logger$iv = logger;
                boolean bl = false;
                logger6.d("Could not find running process for " + myPid);
            }
            return false;
        }
        return Intrinsics.areEqual((Object)myProcess.processName, (Object)serviceInfo.processName);
    }
}

