/*
 * Decompiled with CFR 0.152.
 */
package leakcanary;

import android.app.Application;
import android.content.Context;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import leakcanary.HeapAnalysisInterceptor;
import leakcanary.HeapAnalysisJob;
import leakcanary.ProcessInfo;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 4, 1}, bv={1, 0, 3}, k=1, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B!\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0005\u0012\b\b\u0002\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\u0010\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\r"}, d2={"Lleakcanary/MinimumMemoryInterceptor;", "Lleakcanary/HeapAnalysisInterceptor;", "application", "Landroid/app/Application;", "minimumRequiredAvailableMemoryBytes", "", "processInfo", "Lleakcanary/ProcessInfo;", "(Landroid/app/Application;JLleakcanary/ProcessInfo;)V", "intercept", "Lleakcanary/HeapAnalysisJob$Result;", "chain", "Lleakcanary/HeapAnalysisInterceptor$Chain;", "leakcanary-android-release_release"})
public final class MinimumMemoryInterceptor
implements HeapAnalysisInterceptor {
    private final Application application;
    private final long minimumRequiredAvailableMemoryBytes;
    private final ProcessInfo processInfo;

    @Override
    @NotNull
    public HeapAnalysisJob.Result intercept(@NotNull HeapAnalysisInterceptor.Chain chain) {
        block1: {
            ProcessInfo.AvailableRam memory;
            block2: {
                block0: {
                    Intrinsics.checkParameterIsNotNull((Object)chain, (String)"chain");
                    memory = this.processInfo.availableRam((Context)this.application);
                    if (!Intrinsics.areEqual((Object)memory, (Object)ProcessInfo.AvailableRam.LowRamDevice.INSTANCE)) break block0;
                    chain.getJob().cancel("low ram device");
                    break block1;
                }
                if (!Intrinsics.areEqual((Object)memory, (Object)ProcessInfo.AvailableRam.BelowThreshold.INSTANCE)) break block2;
                chain.getJob().cancel("low memory");
                break block1;
            }
            if (!(memory instanceof ProcessInfo.AvailableRam.Memory) || ((ProcessInfo.AvailableRam.Memory)memory).getBytes() >= this.minimumRequiredAvailableMemoryBytes) break block1;
            chain.getJob().cancel("not enough free memory: available " + ((ProcessInfo.AvailableRam.Memory)memory).getBytes() + " < min " + this.minimumRequiredAvailableMemoryBytes);
        }
        return chain.proceed();
    }

    public MinimumMemoryInterceptor(@NotNull Application application, long minimumRequiredAvailableMemoryBytes, @NotNull ProcessInfo processInfo) {
        Intrinsics.checkParameterIsNotNull((Object)application, (String)"application");
        Intrinsics.checkParameterIsNotNull((Object)processInfo, (String)"processInfo");
        this.application = application;
        this.minimumRequiredAvailableMemoryBytes = minimumRequiredAvailableMemoryBytes;
        this.processInfo = processInfo;
    }

    public /* synthetic */ MinimumMemoryInterceptor(Application application, long l, ProcessInfo processInfo, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 2) != 0) {
            l = 100000000L;
        }
        if ((n & 4) != 0) {
            processInfo = ProcessInfo.Real.INSTANCE;
        }
        this(application, l, processInfo);
    }
}

