/*
 * Decompiled with CFR 0.152.
 */
package leakcanary;

import android.annotation.SuppressLint;
import android.app.ActivityManager;
import android.content.Context;
import android.os.Build;
import android.os.Process;
import android.os.SystemClock;
import android.system.Os;
import android.system.OsConstants;
import java.io.BufferedReader;
import java.io.Closeable;
import java.io.File;
import java.io.FileReader;
import java.io.Reader;
import java.util.List;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.io.CloseableKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.RangesKt;
import kotlin.text.StringsKt;
import leakcanary.ProcessInfo;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 4, 1}, bv={1, 0, 3}, k=1, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\t\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\bf\u0018\u00002\u00020\u0001:\u0002\u0010\u0011J\u0010\u0010\t\u001a\u00020\u00032\u0006\u0010\n\u001a\u00020\u000bH&J\u0010\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fH&R\u0012\u0010\u0002\u001a\u00020\u0003X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0004\u0010\u0005R\u0012\u0010\u0006\u001a\u00020\u0007X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0006\u0010\b\u00a8\u0006\u0012"}, d2={"Lleakcanary/ProcessInfo;", "", "elapsedMillisSinceStart", "", "getElapsedMillisSinceStart", "()J", "isImportanceBackground", "", "()Z", "availableDiskSpaceBytes", "path", "Ljava/io/File;", "availableRam", "Lleakcanary/ProcessInfo$AvailableRam;", "context", "Landroid/content/Context;", "AvailableRam", "Real", "leakcanary-android-release_release"})
public interface ProcessInfo {
    public boolean isImportanceBackground();

    public long getElapsedMillisSinceStart();

    public long availableDiskSpaceBytes(@NotNull File var1);

    @NotNull
    public AvailableRam availableRam(@NotNull Context var1);

    @Metadata(mv={1, 4, 1}, bv={1, 0, 3}, k=1, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b6\u0018\u00002\u00020\u0001:\u0003\u0003\u0004\u0005B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002\u0082\u0001\u0003\u0006\u0007\b\u00a8\u0006\t"}, d2={"Lleakcanary/ProcessInfo$AvailableRam;", "", "()V", "BelowThreshold", "LowRamDevice", "Memory", "Lleakcanary/ProcessInfo$AvailableRam$LowRamDevice;", "Lleakcanary/ProcessInfo$AvailableRam$BelowThreshold;", "Lleakcanary/ProcessInfo$AvailableRam$Memory;", "leakcanary-android-release_release"})
    public static abstract class AvailableRam {
        private AvailableRam() {
        }

        public /* synthetic */ AvailableRam(DefaultConstructorMarker $constructor_marker) {
            this();
        }

        @Metadata(mv={1, 4, 1}, bv={1, 0, 3}, k=1, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002\u00a8\u0006\u0003"}, d2={"Lleakcanary/ProcessInfo$AvailableRam$LowRamDevice;", "Lleakcanary/ProcessInfo$AvailableRam;", "()V", "leakcanary-android-release_release"})
        public static final class LowRamDevice
        extends AvailableRam {
            @NotNull
            public static final LowRamDevice INSTANCE;

            private LowRamDevice() {
                super(null);
            }

            static {
                LowRamDevice lowRamDevice;
                INSTANCE = lowRamDevice = new LowRamDevice();
            }
        }

        @Metadata(mv={1, 4, 1}, bv={1, 0, 3}, k=1, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002\u00a8\u0006\u0003"}, d2={"Lleakcanary/ProcessInfo$AvailableRam$BelowThreshold;", "Lleakcanary/ProcessInfo$AvailableRam;", "()V", "leakcanary-android-release_release"})
        public static final class BelowThreshold
        extends AvailableRam {
            @NotNull
            public static final BelowThreshold INSTANCE;

            private BelowThreshold() {
                super(null);
            }

            static {
                BelowThreshold belowThreshold;
                INSTANCE = belowThreshold = new BelowThreshold();
            }
        }

        @Metadata(mv={1, 4, 1}, bv={1, 0, 3}, k=1, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0002\b\u0004\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u0007"}, d2={"Lleakcanary/ProcessInfo$AvailableRam$Memory;", "Lleakcanary/ProcessInfo$AvailableRam;", "bytes", "", "(J)V", "getBytes", "()J", "leakcanary-android-release_release"})
        public static final class Memory
        extends AvailableRam {
            private final long bytes;

            public final long getBytes() {
                return this.bytes;
            }

            public Memory(long bytes) {
                super(null);
                this.bytes = bytes;
            }
        }
    }

    @Metadata(mv={1, 4, 1}, bv={1, 0, 3}, k=1, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\t\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0000\b\u00c7\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0015\u001a\u00020\u00042\u0006\u0010\u0016\u001a\u00020\u0017H\u0017J\u0010\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u001bH\u0016J\b\u0010\u001c\u001a\u00020\u0004H\u0002J\u0010\u0010\u001d\u001a\u00020\u00042\u0006\u0010\u001e\u001a\u00020\u001fH\u0002R\u0014\u0010\u0003\u001a\u00020\u00048VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0005\u0010\u0006R\u0014\u0010\u0007\u001a\u00020\b8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0007\u0010\tR\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001b\u0010\u000e\u001a\u00020\u00048BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0010\u0010\u0011\u001a\u0004\b\u000f\u0010\u0006R\u001b\u0010\u0012\u001a\u00020\u00048BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0014\u0010\u0011\u001a\u0004\b\u0013\u0010\u0006\u00a8\u0006 "}, d2={"Lleakcanary/ProcessInfo$Real;", "Lleakcanary/ProcessInfo;", "()V", "elapsedMillisSinceStart", "", "getElapsedMillisSinceStart", "()J", "isImportanceBackground", "", "()Z", "memoryInfo", "Landroid/app/ActivityManager$MemoryInfo;", "memoryOutState", "Landroid/app/ActivityManager$RunningAppProcessInfo;", "processForkRealtimeMillis", "getProcessForkRealtimeMillis", "processForkRealtimeMillis$delegate", "Lkotlin/Lazy;", "processStartUptimeMillis", "getProcessStartUptimeMillis", "processStartUptimeMillis$delegate", "availableDiskSpaceBytes", "path", "Ljava/io/File;", "availableRam", "Lleakcanary/ProcessInfo$AvailableRam;", "context", "Landroid/content/Context;", "readProcessForkRealtimeMillis", "readProcessStartTicks", "pid", "", "leakcanary-android-release_release"})
    @SuppressLint(value={"NewApi"})
    public static final class Real
    implements ProcessInfo {
        private static final ActivityManager.RunningAppProcessInfo memoryOutState;
        private static final ActivityManager.MemoryInfo memoryInfo;
        private static final Lazy processStartUptimeMillis$delegate;
        private static final Lazy processForkRealtimeMillis$delegate;
        @NotNull
        public static final Real INSTANCE;

        private final long getProcessStartUptimeMillis() {
            Lazy lazy = processStartUptimeMillis$delegate;
            Real real = this;
            Object var3_3 = null;
            boolean bl = false;
            return ((Number)lazy.getValue()).longValue();
        }

        private final long getProcessForkRealtimeMillis() {
            Lazy lazy = processForkRealtimeMillis$delegate;
            Real real = this;
            Object var3_3 = null;
            boolean bl = false;
            return ((Number)lazy.getValue()).longValue();
        }

        @Override
        public boolean isImportanceBackground() {
            ActivityManager.getMyMemoryState((ActivityManager.RunningAppProcessInfo)memoryOutState);
            return Real.memoryOutState.importance >= 400;
        }

        @Override
        public long getElapsedMillisSinceStart() {
            return Build.VERSION.SDK_INT >= 24 ? SystemClock.uptimeMillis() - this.getProcessStartUptimeMillis() : SystemClock.elapsedRealtime() - this.getProcessForkRealtimeMillis();
        }

        @Override
        @SuppressLint(value={"UsableSpace"})
        public long availableDiskSpaceBytes(@NotNull File path) {
            Intrinsics.checkParameterIsNotNull((Object)path, (String)"path");
            return path.getUsableSpace();
        }

        @Override
        @NotNull
        public AvailableRam availableRam(@NotNull Context context) {
            AvailableRam availableRam;
            Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
            Object object = context.getSystemService("activity");
            if (object == null) {
                throw new TypeCastException("null cannot be cast to non-null type android.app.ActivityManager");
            }
            ActivityManager activityManager = (ActivityManager)object;
            if (Build.VERSION.SDK_INT >= 19 && activityManager.isLowRamDevice()) {
                return AvailableRam.LowRamDevice.INSTANCE;
            }
            activityManager.getMemoryInfo(memoryInfo);
            if (Real.memoryInfo.lowMemory || Real.memoryInfo.availMem <= Real.memoryInfo.threshold) {
                availableRam = AvailableRam.BelowThreshold.INSTANCE;
            } else {
                long systemAvailableMemory = Real.memoryInfo.availMem - Real.memoryInfo.threshold;
                Runtime runtime = Runtime.getRuntime();
                long appUsedMemory = runtime.totalMemory() - runtime.freeMemory();
                long appAvailableMemory = runtime.maxMemory() - appUsedMemory;
                long availableMemory = RangesKt.coerceAtMost((long)systemAvailableMemory, (long)appAvailableMemory);
                availableRam = new AvailableRam.Memory(availableMemory);
            }
            return availableRam;
        }

        private final long readProcessForkRealtimeMillis() {
            long l;
            int myPid = Process.myPid();
            long ticksAtProcessStart = this.readProcessStartTicks(myPid);
            if (Build.VERSION.SDK_INT >= 21) {
                l = Os.sysconf((int)OsConstants._SC_CLK_TCK);
            } else {
                int n;
                try {
                    n = Class.forName("android.system.OsConstants").getField("_SC_CLK_TCK").getInt(null);
                }
                catch (ClassNotFoundException e) {
                    n = Class.forName("libcore.io.OsConstants").getField("_SC_CLK_TCK").getInt(null);
                }
                int tckConstant = n;
                Object object = Class.forName("libcore.io.Libcore").getField("os").get(null);
                if (object == null) {
                    Intrinsics.throwNpe();
                }
                Object os = object;
                Object object2 = os.getClass().getMethod("sysconf", Integer.TYPE).invoke(os, tckConstant);
                if (object2 == null) {
                    throw new TypeCastException("null cannot be cast to non-null type kotlin.Long");
                }
                l = (Long)object2;
            }
            long ticksPerSecond = l;
            return ticksAtProcessStart * (long)1000 / ticksPerSecond;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private final long readProcessStartTicks(int pid) {
            String stat;
            String string;
            String path = "/proc/" + pid + "/stat";
            Closeable closeable = new FileReader(path);
            int n = 8192;
            boolean bl = false;
            closeable = closeable instanceof BufferedReader ? (BufferedReader)closeable : new BufferedReader((Reader)closeable, n);
            n = 0;
            Throwable throwable = null;
            try {
                BufferedReader reader = (BufferedReader)closeable;
                boolean bl2 = false;
                string = reader.readLine();
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
            }
            String string2 = stat = string;
            Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"stat");
            List fields = StringsKt.split$default((CharSequence)StringsKt.substringAfter$default((String)string2, (String)") ", null, (int)2, null), (char[])new char[]{' '}, (boolean)false, (int)0, (int)6, null);
            String string3 = (String)fields.get(19);
            boolean bl3 = false;
            return Long.parseLong(string3);
        }

        private Real() {
        }

        static {
            Real real;
            INSTANCE = real = new Real();
            memoryOutState = new ActivityManager.RunningAppProcessInfo();
            memoryInfo = new ActivityManager.MemoryInfo();
            processStartUptimeMillis$delegate = LazyKt.lazy((Function0)processStartUptimeMillis.2.INSTANCE);
            processForkRealtimeMillis$delegate = LazyKt.lazy((Function0)processForkRealtimeMillis.2.INSTANCE);
        }

        public static final /* synthetic */ long access$readProcessForkRealtimeMillis(Real $this) {
            return $this.readProcessForkRealtimeMillis();
        }
    }
}

