/*
 * Decompiled with CFR 0.152.
 */
package leakcanary.internal;

import android.os.Debug;
import android.os.SystemClock;
import java.io.Closeable;
import java.io.File;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.lang.reflect.Field;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.TypeCastException;
import kotlin.collections.MapsKt;
import kotlin.io.CloseableKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import leakcanary.HeapAnalysisConfig;
import leakcanary.HeapAnalysisInterceptor;
import leakcanary.HeapAnalysisJob;
import leakcanary.JobContext;
import okio.BufferedSink;
import okio.BufferedSource;
import okio.Okio;
import okio.Sink;
import org.jetbrains.annotations.NotNull;
import shark.CloseableHeapGraph;
import shark.ConstantMemoryMetricsDualSourceProvider;
import shark.DualSourceProvider;
import shark.HeapAnalysis;
import shark.HeapAnalysisException;
import shark.HeapAnalysisFailure;
import shark.HeapAnalysisSuccess;
import shark.HeapAnalyzer;
import shark.HeapGraph;
import shark.HprofHeapGraph;
import shark.HprofPrimitiveArrayStripper;
import shark.OnAnalysisProgressListener;
import shark.RandomAccessSource;
import shark.SharkLog;
import shark.StreamingSourceProvider;
import shark.ThrowingCancelableFileSourceProvider;

@Metadata(mv={1, 4, 1}, bv={1, 0, 3}, k=1, d1={"\u0000\u0098\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\t\n\u0002\b\u0006\b\u0000\u0018\u0000 E2\u00020\u00012\u00020\u0002:\u0002EFB1\u0012\f\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\f\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\t\u0012\u0006\u0010\u000b\u001a\u00020\f\u00a2\u0006\u0002\u0010\rJ\u0018\u0010)\u001a\u00020*2\u0006\u0010+\u001a\u00020\u00052\u0006\u0010,\u001a\u00020-H\u0002J\u001c\u0010.\u001a\u000e\u0012\u0004\u0012\u00020*\u0012\u0004\u0012\u0002000/2\u0006\u00101\u001a\u00020\u0005H\u0002J\u0010\u00102\u001a\u0002032\u0006\u00104\u001a\u000200H\u0016J\u0010\u00105\u001a\u0002032\u0006\u00106\u001a\u000200H\u0002J\b\u00107\u001a\u000208H\u0002J\u0010\u00109\u001a\u0002032\u0006\u00101\u001a\u00020\u0005H\u0002J\b\u0010:\u001a\u000203H\u0002J\b\u0010;\u001a\u00020<H\u0016J\b\u0010=\u001a\u00020<H\u0016J\b\u0010>\u001a\u000203H\u0002J\u0010\u0010?\u001a\u0002032\u0006\u0010@\u001a\u00020AH\u0002J\u0018\u0010B\u001a\u0002032\u0006\u0010C\u001a\u00020\u00052\u0006\u0010D\u001a\u00020\u0005H\u0002R\u0016\u0010\u000e\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00100\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0011\u001a\u00020\u0012X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0013\u001a\u0004\u0018\u00010\u0014X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0015\u001a\u00020\u00168VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0017\u0010\u0018R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u000b\u001a\u00020\fX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0019\u0010\u001aR\u0014\u0010\u001b\u001a\u00020\u00168VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001c\u0010\u0018R\u000e\u0010\u001d\u001a\u00020\u001eX\u0082.\u00a2\u0006\u0002\n\u0000R\u001b\u0010\u001f\u001a\u00020\u00058BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\"\u0010#\u001a\u0004\b \u0010!R\u0014\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010$\u001a\u00020%X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010&\u001a\u00020\u00018VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b'\u0010(\u00a8\u0006G"}, d2={"Lleakcanary/internal/RealHeapAnalysisJob;", "Lleakcanary/HeapAnalysisJob;", "Lleakcanary/HeapAnalysisInterceptor$Chain;", "heapDumpDirectoryProvider", "Lkotlin/Function0;", "Ljava/io/File;", "config", "Lleakcanary/HeapAnalysisConfig;", "interceptors", "", "Lleakcanary/HeapAnalysisInterceptor;", "context", "Lleakcanary/JobContext;", "(Lkotlin/jvm/functions/Function0;Lleakcanary/HeapAnalysisConfig;Ljava/util/List;Lleakcanary/JobContext;)V", "_canceled", "Ljava/util/concurrent/atomic/AtomicReference;", "Lleakcanary/HeapAnalysisJob$Result$Canceled;", "_executed", "Ljava/util/concurrent/atomic/AtomicBoolean;", "analysisStep", "Lshark/OnAnalysisProgressListener$Step;", "canceled", "", "getCanceled", "()Z", "getContext", "()Lleakcanary/JobContext;", "executed", "getExecuted", "executionThread", "Ljava/lang/Thread;", "heapDumpDirectory", "getHeapDumpDirectory", "()Ljava/io/File;", "heapDumpDirectory$delegate", "Lkotlin/Lazy;", "interceptorIndex", "", "job", "getJob", "()Lleakcanary/HeapAnalysisJob;", "analyzeHeap", "Lshark/HeapAnalysis;", "analyzedHeapDumpFile", "graph", "Lshark/CloseableHeapGraph;", "analyzeHeapWithStats", "Lkotlin/Pair;", "", "heapDumpFile", "cancel", "", "cancelReason", "checkStopAnalysis", "step", "dumpAndAnalyzeHeap", "Lleakcanary/HeapAnalysisJob$Result$Done;", "dumpHeap", "enqueueReferences", "execute", "Lleakcanary/HeapAnalysisJob$Result;", "proceed", "runGc", "saveHeapDumpTime", "heapDumpUptimeMillis", "", "stripHeapDump", "sourceHeapDumpFile", "strippedHeapDumpFile", "Companion", "StopAnalysis", "leakcanary-android-release_release"})
public final class RealHeapAnalysisJob
implements HeapAnalysisJob,
HeapAnalysisInterceptor.Chain {
    private final Lazy heapDumpDirectory$delegate;
    private final AtomicReference<HeapAnalysisJob.Result.Canceled> _canceled;
    private final AtomicBoolean _executed;
    private Thread executionThread;
    private int interceptorIndex;
    private OnAnalysisProgressListener.Step analysisStep;
    private final Function0<File> heapDumpDirectoryProvider;
    private final HeapAnalysisConfig config;
    private final List<HeapAnalysisInterceptor> interceptors;
    @NotNull
    private final JobContext context;
    @NotNull
    public static final String HPROF_PREFIX = "heap-";
    @NotNull
    public static final String HPROF_SUFFIX = ".hprof";
    @NotNull
    public static final Companion Companion = new Companion(null);

    private final File getHeapDumpDirectory() {
        Lazy lazy = this.heapDumpDirectory$delegate;
        RealHeapAnalysisJob realHeapAnalysisJob = this;
        Object var3_3 = null;
        boolean bl = false;
        return (File)lazy.getValue();
    }

    @Override
    public boolean getExecuted() {
        return this._executed.get();
    }

    @Override
    public boolean getCanceled() {
        return this._canceled.get() != null;
    }

    @Override
    @NotNull
    public HeapAnalysisJob getJob() {
        return this;
    }

    @Override
    @NotNull
    public HeapAnalysisJob.Result execute() {
        boolean bl = this._executed.compareAndSet(false, true);
        boolean bl2 = false;
        boolean bl3 = false;
        if (!bl) {
            boolean bl4 = false;
            String string = "HeapAnalysisJob can only be executed once";
            throw (Throwable)new IllegalStateException(string.toString());
        }
        SharkLog this_$iv = SharkLog.INSTANCE;
        boolean $i$f$d = false;
        SharkLog.Logger logger = this_$iv.getLogger();
        if (logger == null) {
        } else {
            SharkLog.Logger logger$iv;
            SharkLog.Logger logger2 = logger$iv = logger;
            boolean bl5 = false;
            String string = "Starting heap analysis job";
            logger2.d(string);
        }
        Thread thread = Thread.currentThread();
        Intrinsics.checkExpressionValueIsNotNull((Object)thread, (String)"Thread.currentThread()");
        this.executionThread = thread;
        return this.proceed();
    }

    @Override
    public void cancel(@NotNull String cancelReason) {
        Intrinsics.checkParameterIsNotNull((Object)cancelReason, (String)"cancelReason");
        this._canceled.compareAndSet(null, new HeapAnalysisJob.Result.Canceled(cancelReason));
    }

    @Override
    @NotNull
    public HeapAnalysisJob.Result proceed() {
        Throwable cause;
        Thread thread = Thread.currentThread();
        Thread thread2 = this.executionThread;
        if (thread2 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"executionThread");
        }
        boolean bl = Intrinsics.areEqual((Object)thread, (Object)thread2);
        int n = 0;
        boolean bl2 = false;
        if (!bl) {
            boolean bl3 = false;
            StringBuilder stringBuilder = new StringBuilder().append("Interceptor.Chain.proceed() called from unexpected thread ").append(Thread.currentThread()).append(" instead of ");
            Thread thread3 = this.executionThread;
            if (thread3 == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"executionThread");
            }
            String string = stringBuilder.append(thread3).toString();
            throw (Throwable)new IllegalStateException(string.toString());
        }
        bl = this.interceptorIndex <= this.interceptors.size();
        n = 0;
        bl2 = false;
        if (!bl) {
            boolean bl4 = false;
            String string = "Interceptor.Chain.proceed() should be called max once per interceptor";
            throw (Throwable)new IllegalStateException(string.toString());
        }
        HeapAnalysisJob.Result.Canceled canceled = this._canceled.get();
        if (canceled != null) {
            HeapAnalysisJob.Result.Canceled canceled2 = canceled;
            n = 0;
            bl2 = false;
            HeapAnalysisJob.Result.Canceled it = canceled2;
            boolean bl5 = false;
            this.interceptorIndex = this.interceptors.size() + 1;
            return it;
        }
        if (this.interceptorIndex < this.interceptors.size()) {
            HeapAnalysisInterceptor currentInterceptor = this.interceptors.get(this.interceptorIndex);
            n = this.interceptorIndex;
            this.interceptorIndex = n + 1;
            return currentInterceptor.intercept(this);
        }
        int currentInterceptor = this.interceptorIndex;
        this.interceptorIndex = currentInterceptor + 1;
        HeapAnalysisJob.Result.Done result = this.dumpAndAnalyzeHeap();
        HeapAnalysis analysis = result.getAnalysis();
        analysis.getHeapDumpFile().delete();
        if (analysis instanceof HeapAnalysisFailure && (cause = ((HeapAnalysisFailure)analysis).getException().getCause()) instanceof StopAnalysis) {
            HeapAnalysisJob.Result.Canceled canceled3 = this._canceled.get();
            if (canceled3 == null) {
                Intrinsics.throwNpe();
            }
            HeapAnalysisJob.Result.Canceled canceled4 = canceled3;
            boolean bl6 = false;
            boolean bl7 = false;
            HeapAnalysisJob.Result.Canceled $this$run = canceled4;
            boolean bl8 = false;
            return $this$run.copy($this$run.getCancelReason() + " (stopped at " + ((StopAnalysis)cause).getStep() + ')');
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    private final HeapAnalysisJob.Result.Done dumpAndAnalyzeHeap() {
        File filesDir = this.getHeapDumpDirectory();
        filesDir.mkdirs();
        String fileNameBase = HPROF_PREFIX + UUID.randomUUID();
        File file = new File(filesDir, fileNameBase + HPROF_SUFFIX);
        boolean bl = false;
        boolean bl2 = false;
        File $this$apply = file;
        boolean bl3 = false;
        $this$apply.deleteOnExit();
        File sensitiveHeapDumpFile = file;
        long heapDumpStart = SystemClock.uptimeMillis();
        this.saveHeapDumpTime(heapDumpStart);
        long dumpDurationMillis = -1L;
        long analysisDurationMillis = -1L;
        Object heapDumpFile = sensitiveHeapDumpFile;
        try {
            HeapAnalysisJob.Result.Done done;
            void heapAnalysis;
            Long l;
            Object object;
            this.runGc();
            this.dumpHeap(sensitiveHeapDumpFile);
            dumpDurationMillis = SystemClock.uptimeMillis() - heapDumpStart;
            if (this.config.getStripHeapDump()) {
                Object strippedHeapDumpFile;
                boolean $i$f$measureDurationMillis = false;
                boolean $i$f$measureDurationMillis2 = false;
                long start$iv$iv = SystemClock.uptimeMillis();
                boolean bl4 = false;
                object = new File(filesDir, fileNameBase + "-stripped.hprof");
                boolean bl5 = false;
                boolean bl6 = false;
                Object $this$apply2 = object;
                boolean bl7 = false;
                ((File)$this$apply2).deleteOnExit();
                heapDumpFile = strippedHeapDumpFile = object;
                try {
                    this.stripHeapDump(sensitiveHeapDumpFile, (File)strippedHeapDumpFile);
                }
                finally {
                    sensitiveHeapDumpFile.delete();
                }
                l = SystemClock.uptimeMillis() - start$iv$iv;
            } else {
                l = null;
            }
            Long stripDurationMillis = l;
            Pair<HeapAnalysis, String> pair = this.analyzeHeapWithStats((File)heapDumpFile);
            boolean bl8 = false;
            boolean bl9 = false;
            Pair<HeapAnalysis, String> $dstr$heapAnalysis$stats = pair;
            boolean bl10 = false;
            object = (HeapAnalysis)$dstr$heapAnalysis$stats.component1();
            String stats = (String)$dstr$heapAnalysis$stats.component2();
            void var18_24 = heapAnalysis;
            if (var18_24 instanceof HeapAnalysisSuccess) {
                Map metadata = MapsKt.toMutableMap((Map)((HeapAnalysisSuccess)heapAnalysis).getMetadata());
                metadata.put("Stats", stats);
                if (this.config.getStripHeapDump()) {
                    metadata.put("Hprof stripping duration", stripDurationMillis + " ms");
                }
                done = new HeapAnalysisJob.Result.Done((HeapAnalysis)HeapAnalysisSuccess.copy$default((HeapAnalysisSuccess)((HeapAnalysisSuccess)heapAnalysis), null, (long)0L, (long)dumpDurationMillis, (long)0L, (Map)metadata, null, null, null, (int)235, null), stripDurationMillis);
            } else if (var18_24 instanceof HeapAnalysisFailure) {
                done = new HeapAnalysisJob.Result.Done((HeapAnalysis)HeapAnalysisFailure.copy$default((HeapAnalysisFailure)((HeapAnalysisFailure)heapAnalysis), null, (long)0L, (long)dumpDurationMillis, (long)(SystemClock.uptimeMillis() - heapDumpStart - dumpDurationMillis), null, (int)19, null), stripDurationMillis);
            } else {
                throw new NoWhenBranchMatchedException();
            }
            return done;
        }
        catch (Throwable throwable) {
            if (dumpDurationMillis == -1L) {
                dumpDurationMillis = SystemClock.uptimeMillis() - heapDumpStart;
            }
            if (analysisDurationMillis == -1L) {
                analysisDurationMillis = SystemClock.uptimeMillis() - heapDumpStart - dumpDurationMillis;
            }
            return new HeapAnalysisJob.Result.Done((HeapAnalysis)new HeapAnalysisFailure((File)heapDumpFile, System.currentTimeMillis(), dumpDurationMillis, analysisDurationMillis, new HeapAnalysisException(throwable)), null, 2, null);
        }
    }

    private final void runGc() {
        Runtime.getRuntime().gc();
        this.enqueueReferences();
        System.runFinalization();
    }

    private final void enqueueReferences() {
        try {
            Thread.sleep(100L);
        }
        catch (InterruptedException e) {
            throw (Throwable)((Object)new AssertionError());
        }
    }

    private final void saveHeapDumpTime(long heapDumpUptimeMillis) {
        try {
            Field field = Class.forName("leakcanary.KeyedWeakReference").getDeclaredField("heapDumpUptimeMillis");
            boolean bl = false;
            boolean bl2 = false;
            Field $this$apply = field;
            boolean bl3 = false;
            $this$apply.setAccessible(true);
            field.set(null, heapDumpUptimeMillis);
        }
        catch (Throwable ignored) {
            SharkLog this_$iv = SharkLog.INSTANCE;
            boolean $i$f$d = false;
            SharkLog.Logger logger = this_$iv.getLogger();
            if (logger == null) {
            }
            SharkLog.Logger logger$iv = logger;
            Throwable throwable = ignored;
            SharkLog.Logger logger2 = logger$iv;
            boolean bl = false;
            String string = "KeyedWeakReference.heapDumpUptimeMillis not updated";
            logger2.d(throwable, string);
        }
    }

    private final void dumpHeap(File heapDumpFile) {
        Debug.dumpHprofData((String)heapDumpFile.getAbsolutePath());
        boolean bl = heapDumpFile.exists();
        boolean bl2 = false;
        boolean bl3 = false;
        if (!bl) {
            boolean bl4 = false;
            String string = "File does not exist after dump";
            throw (Throwable)new IllegalStateException(string.toString());
        }
        bl = heapDumpFile.length() > 0L;
        bl2 = false;
        bl3 = false;
        if (!bl) {
            boolean bl5 = false;
            String string = "File has length " + heapDumpFile.length() + " after dump";
            throw (Throwable)new IllegalStateException(string.toString());
        }
    }

    /*
     * WARNING - void declaration
     */
    private final void stripHeapDump(File sourceHeapDumpFile, File strippedHeapDumpFile) {
        void openCalls;
        ThrowingCancelableFileSourceProvider sensitiveSourceProvider2 = new ThrowingCancelableFileSourceProvider(sourceHeapDumpFile, new Runnable(this){
            final /* synthetic */ RealHeapAnalysisJob this$0;

            public final void run() {
                RealHeapAnalysisJob.access$checkStopAnalysis(this.this$0, "stripping heap dump");
            }
            {
                this.this$0 = realHeapAnalysisJob;
            }
        });
        Ref.IntRef intRef = new Ref.IntRef();
        intRef.element = 0;
        StreamingSourceProvider deletingFileSourceProvider2 = new StreamingSourceProvider((Ref.IntRef)openCalls, sensitiveSourceProvider2, sourceHeapDumpFile){
            final /* synthetic */ Ref.IntRef $openCalls;
            final /* synthetic */ ThrowingCancelableFileSourceProvider $sensitiveSourceProvider;
            final /* synthetic */ File $sourceHeapDumpFile;

            @NotNull
            public final BufferedSource openStreamingSource() {
                int n = this.$openCalls.element;
                this.$openCalls.element = n + 1;
                BufferedSource bufferedSource = this.$sensitiveSourceProvider.openStreamingSource();
                boolean bl = false;
                boolean bl2 = false;
                BufferedSource $this$apply = bufferedSource;
                boolean bl3 = false;
                if (this.$openCalls.element == 2) {
                    SharkLog this_$iv = SharkLog.INSTANCE;
                    boolean $i$f$d = false;
                    SharkLog.Logger logger = this_$iv.getLogger();
                    if (logger == null) {
                    } else {
                        SharkLog.Logger logger$iv;
                        SharkLog.Logger logger2 = logger$iv = logger;
                        boolean bl4 = false;
                        String string = "Deleting " + this.$sourceHeapDumpFile + " eagerly";
                        logger2.d(string);
                    }
                    this.$sourceHeapDumpFile.delete();
                }
                return bufferedSource;
            }
            {
                this.$openCalls = intRef;
                this.$sensitiveSourceProvider = throwingCancelableFileSourceProvider;
                this.$sourceHeapDumpFile = file;
            }
        };
        File file = strippedHeapDumpFile;
        boolean bl = false;
        BufferedSink strippedHprofSink = Okio.buffer((Sink)Okio.sink((OutputStream)new FileOutputStream(file)));
        HprofPrimitiveArrayStripper stripper = new HprofPrimitiveArrayStripper();
        stripper.stripPrimitiveArrays(deletingFileSourceProvider2, strippedHprofSink);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final Pair<HeapAnalysis, String> analyzeHeapWithStats(File heapDumpFile) {
        Pair pair;
        long fileLength = heapDumpFile.length();
        ConstantMemoryMetricsDualSourceProvider analysisSourceProvider2 = new ConstantMemoryMetricsDualSourceProvider((DualSourceProvider)new ThrowingCancelableFileSourceProvider(heapDumpFile, new Runnable(this){
            final /* synthetic */ RealHeapAnalysisJob this$0;

            public final void run() {
                Object object = RealHeapAnalysisJob.access$getAnalysisStep$p(this.this$0);
                if (object == null || (object = object.name()) == null) {
                    object = "Reading heap dump";
                }
                RealHeapAnalysisJob.access$checkStopAnalysis(this.this$0, (String)object);
            }
            {
                this.this$0 = realHeapAnalysisJob;
            }
        }));
        DualSourceProvider deletingFileSourceProvider2 = new DualSourceProvider(analysisSourceProvider2, heapDumpFile){
            final /* synthetic */ ConstantMemoryMetricsDualSourceProvider $analysisSourceProvider;
            final /* synthetic */ File $heapDumpFile;

            @NotNull
            public BufferedSource openStreamingSource() {
                return this.$analysisSourceProvider.openStreamingSource();
            }

            @NotNull
            public RandomAccessSource openRandomAccessSource() {
                SharkLog this_$iv = SharkLog.INSTANCE;
                boolean $i$f$d = false;
                SharkLog.Logger logger = this_$iv.getLogger();
                if (logger == null) {
                } else {
                    SharkLog.Logger logger$iv;
                    SharkLog.Logger logger2 = logger$iv = logger;
                    boolean bl = false;
                    String string = "Deleting " + this.$heapDumpFile + " eagerly";
                    logger2.d(string);
                }
                RandomAccessSource randomAccessSource = this.$analysisSourceProvider.openRandomAccessSource();
                boolean bl = false;
                boolean bl2 = false;
                RandomAccessSource $this$apply = randomAccessSource;
                boolean bl3 = false;
                this.$heapDumpFile.delete();
                return randomAccessSource;
            }
            {
                this.$analysisSourceProvider = $captured_local_variable$0;
                this.$heapDumpFile = $captured_local_variable$1;
            }
        };
        Closeable closeable = (Closeable)HprofHeapGraph.Companion.openHeapGraph$default((HprofHeapGraph.Companion)HprofHeapGraph.Companion, (DualSourceProvider)deletingFileSourceProvider2, null, null, (int)3, null);
        boolean bl = false;
        Throwable throwable = null;
        try {
            CloseableHeapGraph graph = (CloseableHeapGraph)closeable;
            boolean bl2 = false;
            HeapAnalysis heapAnalysis = this.analyzeHeap(heapDumpFile, graph);
            CloseableHeapGraph closeableHeapGraph = graph;
            if (closeableHeapGraph == null) {
                throw new TypeCastException("null cannot be cast to non-null type shark.HprofHeapGraph");
            }
            String lruCacheStats = ((HprofHeapGraph)closeableHeapGraph).lruCacheStats();
            String randomAccessStats = "RandomAccess[" + "bytes=" + analysisSourceProvider2.getRandomAccessByteReads() + ',' + "reads=" + analysisSourceProvider2.getRandomAccessReadCount() + ',' + "travel=" + analysisSourceProvider2.getRandomAccessByteTravel() + ',' + "range=" + analysisSourceProvider2.getByteTravelRange() + ',' + "size=" + fileLength + "]";
            String stats = lruCacheStats + ' ' + randomAccessStats;
            pair = TuplesKt.to((Object)heapAnalysis, (Object)stats);
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
        }
        return pair;
    }

    private final HeapAnalysis analyzeHeap(File analyzedHeapDumpFile, CloseableHeapGraph graph) {
        OnAnalysisProgressListener stepListener2 = new OnAnalysisProgressListener(this){
            final /* synthetic */ RealHeapAnalysisJob this$0;

            public final void onAnalysisProgress(@NotNull OnAnalysisProgressListener.Step step) {
                Intrinsics.checkParameterIsNotNull((Object)step, (String)"step");
                RealHeapAnalysisJob.access$setAnalysisStep$p(this.this$0, step);
                RealHeapAnalysisJob.access$checkStopAnalysis(this.this$0, step.name());
                SharkLog this_$iv = SharkLog.INSTANCE;
                boolean $i$f$d = false;
                SharkLog.Logger logger = this_$iv.getLogger();
                if (logger == null) {
                } else {
                    SharkLog.Logger logger$iv;
                    SharkLog.Logger logger2 = logger$iv = logger;
                    boolean bl = false;
                    String string = "Analysis in progress, working on: " + step.name();
                    logger2.d(string);
                }
            }
            {
                this.this$0 = realHeapAnalysisJob;
            }
        };
        HeapAnalyzer heapAnalyzer = new HeapAnalyzer(stepListener2);
        return heapAnalyzer.analyze(analyzedHeapDumpFile, (HeapGraph)graph, this.config.getLeakingObjectFinder(), this.config.getReferenceMatchers(), this.config.getComputeRetainedHeapSize(), this.config.getObjectInspectors(), this.config.getMetadataExtractor());
    }

    private final void checkStopAnalysis(String step) {
        if (this._canceled.get() != null) {
            throw (Throwable)new StopAnalysis(step);
        }
    }

    @Override
    @NotNull
    public JobContext getContext() {
        return this.context;
    }

    public RealHeapAnalysisJob(@NotNull Function0<? extends File> heapDumpDirectoryProvider, @NotNull HeapAnalysisConfig config, @NotNull List<? extends HeapAnalysisInterceptor> interceptors, @NotNull JobContext context) {
        Intrinsics.checkParameterIsNotNull(heapDumpDirectoryProvider, (String)"heapDumpDirectoryProvider");
        Intrinsics.checkParameterIsNotNull((Object)config, (String)"config");
        Intrinsics.checkParameterIsNotNull(interceptors, (String)"interceptors");
        Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
        this.heapDumpDirectoryProvider = heapDumpDirectoryProvider;
        this.config = config;
        this.interceptors = interceptors;
        this.context = context;
        this.heapDumpDirectory$delegate = LazyKt.lazy((Function0)((Function0)new Function0<File>(this){
            final /* synthetic */ RealHeapAnalysisJob this$0;

            @NotNull
            public final File invoke() {
                return (File)RealHeapAnalysisJob.access$getHeapDumpDirectoryProvider$p(this.this$0).invoke();
            }
            {
                this.this$0 = realHeapAnalysisJob;
                super(0);
            }
        }));
        this._canceled = new AtomicReference();
        this._executed = new AtomicBoolean(false);
    }

    public static final /* synthetic */ void access$checkStopAnalysis(RealHeapAnalysisJob $this, String step) {
        $this.checkStopAnalysis(step);
    }

    public static final /* synthetic */ OnAnalysisProgressListener.Step access$getAnalysisStep$p(RealHeapAnalysisJob $this) {
        return $this.analysisStep;
    }

    public static final /* synthetic */ void access$setAnalysisStep$p(RealHeapAnalysisJob $this, OnAnalysisProgressListener.Step step) {
        $this.analysisStep = step;
    }

    public static final /* synthetic */ Function0 access$getHeapDumpDirectoryProvider$p(RealHeapAnalysisJob $this) {
        return $this.heapDumpDirectoryProvider;
    }

    @Metadata(mv={1, 4, 1}, bv={1, 0, 3}, k=1, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0010\u0003\n\u0000\u0018\u00002\u00060\u0001j\u0002`\u0002B\r\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\u0005J\b\u0010\b\u001a\u00020\tH\u0016R\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\n"}, d2={"Lleakcanary/internal/RealHeapAnalysisJob$StopAnalysis;", "Ljava/lang/Exception;", "Lkotlin/Exception;", "step", "", "(Ljava/lang/String;)V", "getStep", "()Ljava/lang/String;", "fillInStackTrace", "", "leakcanary-android-release_release"})
    public static final class StopAnalysis
    extends Exception {
        @NotNull
        private final String step;

        @Override
        @NotNull
        public Throwable fillInStackTrace() {
            return this;
        }

        @NotNull
        public final String getStep() {
            return this.step;
        }

        public StopAnalysis(@NotNull String step) {
            Intrinsics.checkParameterIsNotNull((Object)step, (String)"step");
            this.step = step;
        }
    }

    @Metadata(mv={1, 4, 1}, bv={1, 0, 3}, k=1, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lleakcanary/internal/RealHeapAnalysisJob$Companion;", "", "()V", "HPROF_PREFIX", "", "HPROF_SUFFIX", "leakcanary-android-release_release"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

