/*
 * Decompiled with CFR 0.152.
 */
package leakcanary;

import android.app.Application;
import java.util.concurrent.Executor;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.jvm.internal.SourceDebugExtension;
import leakcanary.BackgroundTrigger;
import leakcanary.HeapAnalysisClient;
import leakcanary.HeapAnalysisJob;
import leakcanary.JobContext;
import leakcanary.ProcessInfo;
import leakcanary.internal.BackgroundListener;
import leakcanary.internal.HandlersKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u0001B=\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\b\b\u0002\u0010\b\u001a\u00020\t\u0012\u0014\b\u0002\u0010\n\u001a\u000e\u0012\u0004\u0012\u00020\f\u0012\u0004\u0012\u00020\r0\u000b\u00a2\u0006\u0002\u0010\u000eJ\u0006\u0010\u0013\u001a\u00020\rJ\u0006\u0010\u0014\u001a\u00020\rR\u001a\u0010\n\u001a\u000e\u0012\u0004\u0012\u00020\f\u0012\u0004\u0012\u00020\r0\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0011\u001a\u0004\u0018\u00010\u0012X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0015"}, d2={"Lleakcanary/BackgroundTrigger;", "", "application", "Landroid/app/Application;", "analysisClient", "Lleakcanary/HeapAnalysisClient;", "analysisExecutor", "Ljava/util/concurrent/Executor;", "processInfo", "Lleakcanary/ProcessInfo;", "analysisCallback", "Lkotlin/Function1;", "Lleakcanary/HeapAnalysisJob$Result;", "", "(Landroid/app/Application;Lleakcanary/HeapAnalysisClient;Ljava/util/concurrent/Executor;Lleakcanary/ProcessInfo;Lkotlin/jvm/functions/Function1;)V", "backgroundListener", "Lleakcanary/internal/BackgroundListener;", "currentJob", "Lleakcanary/HeapAnalysisJob;", "start", "stop", "leakcanary-android-release_release"})
@SourceDebugExtension(value={"SMAP\nBackgroundTrigger.kt\nKotlin\n*S Kotlin\n*F\n+ 1 BackgroundTrigger.kt\nleakcanary/BackgroundTrigger\n+ 2 Friendly.kt\nleakcanary/internal/friendly/leakcanary-android-release_Friendly\n*L\n1#1,65:1\n9#2:66\n9#2:67\n*S KotlinDebug\n*F\n+ 1 BackgroundTrigger.kt\nleakcanary/BackgroundTrigger\n*L\n57#1:66\n62#1:67\n*E\n"})
public final class BackgroundTrigger {
    @NotNull
    private final Application application;
    @NotNull
    private final HeapAnalysisClient analysisClient;
    @NotNull
    private final Executor analysisExecutor;
    @NotNull
    private final Function1<HeapAnalysisJob.Result, Unit> analysisCallback;
    @Nullable
    private volatile HeapAnalysisJob currentJob;
    @NotNull
    private final BackgroundListener backgroundListener;

    public BackgroundTrigger(@NotNull Application application, @NotNull HeapAnalysisClient analysisClient, @NotNull Executor analysisExecutor, @NotNull ProcessInfo processInfo, @NotNull Function1<? super HeapAnalysisJob.Result, Unit> analysisCallback) {
        Intrinsics.checkNotNullParameter((Object)application, (String)"application");
        Intrinsics.checkNotNullParameter((Object)analysisClient, (String)"analysisClient");
        Intrinsics.checkNotNullParameter((Object)analysisExecutor, (String)"analysisExecutor");
        Intrinsics.checkNotNullParameter((Object)processInfo, (String)"processInfo");
        Intrinsics.checkNotNullParameter(analysisCallback, (String)"analysisCallback");
        this.application = application;
        this.analysisClient = analysisClient;
        this.analysisExecutor = analysisExecutor;
        this.analysisCallback = analysisCallback;
        this.backgroundListener = new BackgroundListener(processInfo, (Function1<? super Boolean, Unit>)((Function1)new Function1<Boolean, Unit>(this){
            final /* synthetic */ BackgroundTrigger this$0;
            {
                this.this$0 = $receiver;
                super(1);
            }

            public final void invoke(boolean appInBackgroundNow) {
                if (appInBackgroundNow) {
                    if (!(BackgroundTrigger.access$getCurrentJob$p(this.this$0) == null)) {
                        boolean bl = false;
                        String string = "Current job set to null when leaving background";
                        throw new IllegalStateException(string.toString());
                    }
                    HeapAnalysisJob job = BackgroundTrigger.access$getAnalysisClient$p(this.this$0).newJob(new JobContext(Reflection.getOrCreateKotlinClass(BackgroundTrigger.class)));
                    BackgroundTrigger.access$setCurrentJob$p(this.this$0, job);
                    BackgroundTrigger.access$getAnalysisExecutor$p(this.this$0).execute(() -> backgroundListener.1.invoke$lambda$1(job, this.this$0));
                } else {
                    HeapAnalysisJob heapAnalysisJob = BackgroundTrigger.access$getCurrentJob$p(this.this$0);
                    if (heapAnalysisJob != null) {
                        heapAnalysisJob.cancel("app left background");
                    }
                    BackgroundTrigger.access$setCurrentJob$p(this.this$0, null);
                }
            }

            private static final void invoke$lambda$1(HeapAnalysisJob $job, BackgroundTrigger this$0) {
                Intrinsics.checkNotNullParameter((Object)$job, (String)"$job");
                Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
                HeapAnalysisJob.Result result = $job.execute();
                BackgroundTrigger.access$setCurrentJob$p(this$0, null);
                BackgroundTrigger.access$getAnalysisCallback$p(this$0).invoke((Object)result);
            }
        }));
    }

    public /* synthetic */ BackgroundTrigger(Application application, HeapAnalysisClient heapAnalysisClient, Executor executor, ProcessInfo processInfo, Function1 function1, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 8) != 0) {
            processInfo = ProcessInfo.Real.INSTANCE;
        }
        if ((n & 0x10) != 0) {
            function1 = 1.INSTANCE;
        }
        this(application, heapAnalysisClient, executor, processInfo, (Function1<? super HeapAnalysisJob.Result, Unit>)function1);
    }

    public final void start() {
        boolean $i$f$checkMainThread = false;
        HandlersKt.checkMainThread();
        this.backgroundListener.install(this.application);
    }

    public final void stop() {
        boolean $i$f$checkMainThread = false;
        HandlersKt.checkMainThread();
        this.backgroundListener.uninstall(this.application);
    }

    public static final /* synthetic */ HeapAnalysisJob access$getCurrentJob$p(BackgroundTrigger $this) {
        return $this.currentJob;
    }

    public static final /* synthetic */ HeapAnalysisClient access$getAnalysisClient$p(BackgroundTrigger $this) {
        return $this.analysisClient;
    }

    public static final /* synthetic */ void access$setCurrentJob$p(BackgroundTrigger $this, HeapAnalysisJob heapAnalysisJob) {
        $this.currentJob = heapAnalysisJob;
    }

    public static final /* synthetic */ Executor access$getAnalysisExecutor$p(BackgroundTrigger $this) {
        return $this.analysisExecutor;
    }

    public static final /* synthetic */ Function1 access$getAnalysisCallback$p(BackgroundTrigger $this) {
        return $this.analysisCallback;
    }
}

