/*
 * Decompiled with CFR 0.152.
 */
package leakcanary;

import android.app.Application;
import android.content.res.Resources;
import java.io.File;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import leakcanary.GoodAndroidVersionInterceptor;
import leakcanary.HeapAnalysisConfig;
import leakcanary.HeapAnalysisInterceptor;
import leakcanary.HeapAnalysisJob;
import leakcanary.JobContext;
import leakcanary.MinimumDiskSpaceInterceptor;
import leakcanary.MinimumElapsedSinceStartInterceptor;
import leakcanary.MinimumMemoryInterceptor;
import leakcanary.OncePerPeriodInterceptor;
import leakcanary.SaveResourceIdsInterceptor;
import leakcanary.internal.RealHeapAnalysisJob;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 \u00112\u00020\u0001:\u0001\u0011B)\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\f\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\b\u00a2\u0006\u0002\u0010\nJ\u0006\u0010\u000b\u001a\u00020\fJ\u0010\u0010\r\u001a\u00020\u000e2\b\b\u0002\u0010\u000f\u001a\u00020\u0010R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0012"}, d2={"Lleakcanary/HeapAnalysisClient;", "", "heapDumpDirectoryProvider", "Lkotlin/Function0;", "Ljava/io/File;", "config", "Lleakcanary/HeapAnalysisConfig;", "interceptors", "", "Lleakcanary/HeapAnalysisInterceptor;", "(Lkotlin/jvm/functions/Function0;Lleakcanary/HeapAnalysisConfig;Ljava/util/List;)V", "deleteHeapDumpFiles", "", "newJob", "Lleakcanary/HeapAnalysisJob;", "context", "Lleakcanary/JobContext;", "Companion", "leakcanary-android-release_release"})
@SourceDebugExtension(value={"SMAP\nHeapAnalysisClient.kt\nKotlin\n*S Kotlin\n*F\n+ 1 HeapAnalysisClient.kt\nleakcanary/HeapAnalysisClient\n+ 2 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n*L\n1#1,52:1\n13579#2,2:53\n*S KotlinDebug\n*F\n+ 1 HeapAnalysisClient.kt\nleakcanary/HeapAnalysisClient\n*L\n36#1:53,2\n*E\n"})
public final class HeapAnalysisClient {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Function0<File> heapDumpDirectoryProvider;
    @NotNull
    private final HeapAnalysisConfig config;
    @NotNull
    private final List<HeapAnalysisInterceptor> interceptors;

    public HeapAnalysisClient(@NotNull Function0<? extends File> heapDumpDirectoryProvider, @NotNull HeapAnalysisConfig config, @NotNull List<? extends HeapAnalysisInterceptor> interceptors) {
        Intrinsics.checkNotNullParameter(heapDumpDirectoryProvider, (String)"heapDumpDirectoryProvider");
        Intrinsics.checkNotNullParameter((Object)config, (String)"config");
        Intrinsics.checkNotNullParameter(interceptors, (String)"interceptors");
        this.heapDumpDirectoryProvider = heapDumpDirectoryProvider;
        this.config = config;
        this.interceptors = interceptors;
    }

    @NotNull
    public final HeapAnalysisJob newJob(@NotNull JobContext context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        return new RealHeapAnalysisJob(this.heapDumpDirectoryProvider, this.config, this.interceptors, context);
    }

    public static /* synthetic */ HeapAnalysisJob newJob$default(HeapAnalysisClient heapAnalysisClient, JobContext jobContext, int n, Object object) {
        if ((n & 1) != 0) {
            jobContext = new JobContext(null, 1, null);
        }
        return heapAnalysisClient.newJob(jobContext);
    }

    public final void deleteHeapDumpFiles() {
        block1: {
            File[] heapDumpFiles;
            if (heapDumpFiles == null) break block1;
            File[] $this$forEach$iv = heapDumpFiles = ((File)this.heapDumpDirectoryProvider.invoke()).listFiles(HeapAnalysisClient::deleteHeapDumpFiles$lambda$0);
            boolean $i$f$forEach = false;
            int n = $this$forEach$iv.length;
            for (int i = 0; i < n; ++i) {
                File element$iv;
                File it = element$iv = $this$forEach$iv[i];
                boolean bl = false;
                it.delete();
            }
        }
    }

    private static final boolean deleteHeapDumpFiles$lambda$0(File file, String name) {
        Intrinsics.checkNotNullExpressionValue((Object)name, (String)"name");
        return StringsKt.startsWith$default((String)name, (String)"heap-", (boolean)false, (int)2, null) && StringsKt.endsWith$default((String)name, (String)".hprof", (boolean)false, (int)2, null);
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0014\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u00042\u0006\u0010\u0006\u001a\u00020\u0007\u00a8\u0006\b"}, d2={"Lleakcanary/HeapAnalysisClient$Companion;", "", "()V", "defaultInterceptors", "", "Lleakcanary/HeapAnalysisInterceptor;", "application", "Landroid/app/Application;", "leakcanary-android-release_release"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final List<HeapAnalysisInterceptor> defaultInterceptors(@NotNull Application application) {
            Intrinsics.checkNotNullParameter((Object)application, (String)"application");
            Object[] objectArray = new HeapAnalysisInterceptor[6];
            objectArray[0] = new GoodAndroidVersionInterceptor();
            objectArray[1] = new MinimumDiskSpaceInterceptor(application, 0L, null, 6, null);
            objectArray[2] = new MinimumMemoryInterceptor(application, 0L, null, 6, null);
            objectArray[3] = new MinimumElapsedSinceStartInterceptor(0L, null, 3, null);
            objectArray[4] = new OncePerPeriodInterceptor(application, 0L, 2, null);
            Resources resources = application.getResources();
            Intrinsics.checkNotNullExpressionValue((Object)resources, (String)"application.resources");
            objectArray[5] = new SaveResourceIdsInterceptor(resources);
            return CollectionsKt.listOf((Object[])objectArray);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

