/*
 * Decompiled with CFR 0.152.
 */
package leakcanary;

import android.app.Application;
import java.io.File;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import leakcanary.HeapAnalysisInterceptor;
import leakcanary.HeapAnalysisJob;
import leakcanary.ProcessInfo;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B!\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0005\u0012\b\b\u0002\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\u0010\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\r"}, d2={"Lleakcanary/MinimumDiskSpaceInterceptor;", "Lleakcanary/HeapAnalysisInterceptor;", "application", "Landroid/app/Application;", "minimumDiskSpaceBytes", "", "processInfo", "Lleakcanary/ProcessInfo;", "(Landroid/app/Application;JLleakcanary/ProcessInfo;)V", "intercept", "Lleakcanary/HeapAnalysisJob$Result;", "chain", "Lleakcanary/HeapAnalysisInterceptor$Chain;", "leakcanary-android-release_release"})
public final class MinimumDiskSpaceInterceptor
implements HeapAnalysisInterceptor {
    @NotNull
    private final Application application;
    private final long minimumDiskSpaceBytes;
    @NotNull
    private final ProcessInfo processInfo;

    public MinimumDiskSpaceInterceptor(@NotNull Application application, long minimumDiskSpaceBytes, @NotNull ProcessInfo processInfo) {
        Intrinsics.checkNotNullParameter((Object)application, (String)"application");
        Intrinsics.checkNotNullParameter((Object)processInfo, (String)"processInfo");
        this.application = application;
        this.minimumDiskSpaceBytes = minimumDiskSpaceBytes;
        this.processInfo = processInfo;
    }

    public /* synthetic */ MinimumDiskSpaceInterceptor(Application application, long l, ProcessInfo processInfo, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 2) != 0) {
            l = 200000000L;
        }
        if ((n & 4) != 0) {
            processInfo = ProcessInfo.Real.INSTANCE;
        }
        this(application, l, processInfo);
    }

    @Override
    @NotNull
    public HeapAnalysisJob.Result intercept(@NotNull HeapAnalysisInterceptor.Chain chain) {
        Intrinsics.checkNotNullParameter((Object)chain, (String)"chain");
        File file = this.application.getFilesDir();
        Intrinsics.checkNotNull((Object)file);
        long availableDiskSpace = this.processInfo.availableDiskSpaceBytes(file);
        if (availableDiskSpace < this.minimumDiskSpaceBytes) {
            chain.getJob().cancel("availableDiskSpace " + availableDiskSpace + " < minimumDiskSpaceBytes " + this.minimumDiskSpaceBytes);
        }
        return chain.proceed();
    }
}

